<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
<form name="propertiesModal" class="form-horizontal edit-users-grid-form" data-cv-submit="archCtrl.ok()" novalidate autocomplete="off">
	<div class="setup-title">
		<h1>{{archCtrl.heading}}</h1>
	</div>
	<div class="modal-body">
		<div class="form-group" data-ng-if="archCtrl.type=='plan'">
			<label class="col-xs-12 col-lg-5" for="archivePlan"><cv:msg
					key="label.plan" bundle="archiving" /></label>
			<div class="col-xs-12 col-lg-7">
				<select id="archivePlan" name="archivePlan" data-ng-model="archCtrl.selectedPlan" required>
					<option value=""><cv:msg key="placeholder.plan"
							bundle="archiving" /></option>
					<option ng-repeat="plan in archCtrl.plans" value="{{plan.planSummary.plan.planId}}">{{plan.planSummary.plan.planName}}</option>
				</select>
				<div class="help-block" data-ng-show="cv.propertiesModal.needsAttention(propertiesModal.archivePlan)">
										<i class="ion-alert-circled"></i>
										<cv:msg key="error.plan" bundle="archiving" />
			</div>
			</div>
			
		</div>
		<div class="form-group" data-ng-if="archCtrl.type=='accessnode'">
			<label class="col-xs-12 col-lg-5" for="plans"><cv:msg
					key="placeholder.selectAccessNode" bundle="archiving" /></label>
			<div class="col-xs-12 col-lg-7">
				<select id="accessnode" name="accessnode"
					data-ng-model="archCtrl.selectedAccessnode" required>
					<option value=""><cv:msg key="label.accessNode"
							bundle="archiving" /></option>
					<option ng-repeat="accessnode in archCtrl.accessNodes" value="{{accessnode.mediaAgentId}}">{{accessnode.mediaAgentName}}</option>		
				</select>
			<div class="help-block" data-ng-show="cv.propertiesModal.needsAttention(propertiesModal.accessnode)">
							
										<i class="ion-alert-circled"></i>
										<cv:msg key="error.accessNode" bundle="archiving" />
			</div>
		</div>
			
		</div>
		<div class="form-group" data-ng-if="archCtrl.type=='ownerInfo'">
			<label class="col-lg-5 col-lg-offset-3" for="collectOwnerInfo1"><cv:msg key="label.collectOwnerInfo" bundle="archiving" /></label>
			<input class="col-lg-5 col-lg-offset-6" id="collectOwnerInfo" type="checkbox" ng-model="archCtrl.ownerInfo"/>
			<label for="collectOwnerInfo"></label>
		</div>
		
	</div>
	<div class="modal-footer">
		<button id="archivingPropertiesModal_button_#5825" type="button" class="btn btn-default cvBusyOnAjax" 
			data-ng-click="archCtrl.cancel()">
			<cv:msg key="action.cancel" bundle="profiles" />
		</button>
		<button id="archivingPropertiesModal_button_#4764" type="submit" class="btn btn-primary cvBusyOnAjax"> 
			<cv:msg key="action.save" bundle="profiles" />
		</button>
	</div>
</form>
</div>
