<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
	<cv:cvMessages bundle="localization.nas"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<jsp:include page="archiveTemplates.jsp" />
<div class="setup-title">
	<h1><cv:msg key="label.addDataSource" bundle="archiving" /></h1>
</div>
<div class="setup-content archive-add-server archive-setup" ng-controller="archiveController as archCtrl">
	<span
		class="{{ archCtrl.serverMessage.type }}"
		ng-bind="archCtrl.serverMessage.message"
		ng-if="archCtrl.serverMessage"
	></span>
	<form
		name="setUpArchiving"
		autocomplete="off"
		cv-submit="archCtrl.addFileServer()"
		class="form-horizontal bootstrap-wrapper"
		novalidate
	>
		<uib-tabset active="archCtrl.activeTab">
			<uib-tab
				index="0"
				select="archCtrl.isCreateNewFileServer = true; archCtrl.clearFolderPaths(true);"
				heading='<cv:msg key="header.addNewServer" bundle="archiving" />'
			>
				<div ng-if="archCtrl.isCreateNewFileServer">
					<h4 class="text-left padding-left-20"><cv:msg key="header.serverConfiguration" bundle="archiving" /></h4>
					<ng-include src="'archivingServerTypeConfiguration.html'"></ng-include>
					<ng-include src="'archivingFileServerConfiguration.html'"></ng-include>
					<ng-include src="'archivingCredentialConfiguration.html'" ng-if="archCtrl._serverType !== 'nas'"></ng-include>
					<ng-include src="'archivingNdmpConfiguration.html'"></ng-include>
					<ng-include src="'archivingShareTypeConfiguration.html'"></ng-include>
					<ng-include src="'archivingAccessNodesConfiguration.html'"></ng-include>
				</div>
			</uib-tab>
			<uib-tab
				index="1"
				select="archCtrl.isCreateNewFileServer = false; archCtrl.clearFolderPaths(true);"
				heading='<cv:msg key="label.archiving.existingFileServer" bundle="archiving" />'
			>
				<div ng-if="!archCtrl.isCreateNewFileServer">
					<h4 class="text-left padding-left-20"><cv:msg key="header.serverConfiguration" bundle="archiving" /></h4>
					<ng-include src="'archivingServerTypeConfiguration.html'"></ng-include>
					<ng-include src="'archivingCredentialConfiguration.html'" ng-if="archCtrl._serverType !== 'nas'"></ng-include>
					<ng-include src="'archivingShareTypeConfiguration.html'"></ng-include>
					<ng-include src="'archivingExistingServerConfiguration.html'"></ng-include>
					<ng-include src="'archivingAccessNodesConfiguration.html'"></ng-include>
				</div>
			</uib-tab>
		</uib-tabset>
		<!-- // Install directory // -->
	    <div class="form-group margin-top-10" ng-if="archCtrl._serverType !== 'nas'">
	        <label class="col-lg-4 padding-right-0" for="installLocation"><cv:msg key="label.installLocation" bundle="serversJs" /> <span class="optional-text"><cv:msg key="label.optional" bundle="restore" /></span></label></label>
	        <div class="col-xs-12 col-lg-5" ng-class="{'col-lg-7': archCtrl.dialogMode}">
	            <input type="text" name="installLocation" id="installLocation" ng-model="archCtrl.installLocation" ng-change="archCtrl.validateInstallPath()" autocomplete="off"/>
	            <div class="help-block" ng-show="archCtrl.validations.installLocationErr">
	                <i class="ion-alert-circled"></i>
	                <cv:msg key="error.installLocation" bundle="serversJs" />
	            </div>
	        </div>
	    </div>
		<!-- // SSH port -->
		<div ng-if="archCtrl.isCreateNewFileServer && archCtrl._serverType === 'unix'">
			<div class="form-group margin-left-0">
				<cv-toggle
					toggle-name="enableSSHPort"
					toggle-label="label.userSSHPortNumber"
					value="archCtrl.enableSSHPort"
				></cv-toggle>
			</div>
			<div class="form-group" ng-if="archCtrl.enableSSHPort">
				<label class="col-lg-4" for="sshPortNumber"><cv:msg key="label.sshPortNumber" bundle="serversJs" /></label>
				<div class="col-xs-12 col-lg-5 text-left" ng-class="{ 'col-lg-7': archCtrl.dialogMode }">
					<input type="number" min="1" name="sshPortNumber" id="sshPortNumber" ng-model="archCtrl.sshPortNumber" />
				</div>
			</div>
		</div>
		<!-- // Reboot rquired -->
		<div class="form-group margin-left-0" ng-if="archCtrl._serverType !== 'nas' && archCtrl.isCreateNewFileServer">
			<cv-toggle
				toggle-name="rebootRequired"
				toggle-label="label.rebootRequired"
				value="archCtrl.rebootRequired"
			></cv-toggle>
		</div>
		<!-- // Install driver for file archiver -->
		<div class="form-group margin-left-0" ng-if="archCtrl._serverType === 'windows'">
			<cv-toggle
				toggle-name="installDriverForFileArchiver"
				toggle-label="label.installDriverForFileArchiver"
				help-time="archCtrl.popupDelay"
				help-template="'installArchiveFileDriver.html'"
				value="archCtrl.installDriverForFileArchiver"
			></cv-toggle>
		</div>
		<h4 class="text-left padding-left-20"><cv:msg key="header.archiveConfiguration" bundle="archiving" /></h4>
		<ng-include src="'archivingConfiguration.html'"></ng-include>
		<ng-include src="'archivingFilerMigration.html'"></ng-include>
		<div class="button-container">
			<button
				id="archivingAddFileServer_button_#01"
				type="button"
				class="btn btn-default cvBusyOnAjax setup-btn--hidden"
				ng-click="archCtrl.closeModal()"
			>
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="archivingAddFileServer_button_#02" type="submit" class="btn btn-primary cvBusyOnAjax">
				<cv:msg key="label.save" bundle="archiving" />
			</button>
		</div>
	</form>
</div>
