<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
	<cv:cvMessages bundle="localization.nas"></cv:cvMessages>
</script>
<script type="text/ng-template" id="archivingCredentialConfiguration.html">
	<div ng-if="archCtrl.showCredential">
	    <!-- // Username // -->
	    <div class="form-group margin-top-10">
	        <label class="col-lg-4" for="Username"><cv:msg key="label.userName" bundle="archiving" /> <span class="optional-text" ng-if="!archCtrl._serverType || archCtrl._serverType === 'nas'"><cv:msg key="label.forShareAccess" bundle="archiving" /></span></label>
	        <div class="col-xs-12 col-lg-5" ng-class="{'col-lg-7': archCtrl.dialogMode}">
	            <input type="text" name="Username" id="Username" ng-model="archCtrl.username" ng-change="archCtrl.setContentOptions()" ng-model-options="{ debounce: 350 }" placeholder="{{archCtrl.userNameHelpText}}" required/>
	            <div class="help-block" ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.Username) || archCtrl.validations.userNameErr">
	                <i class="ion-alert-circled"></i>
	                <cv:msg key="error.userName" bundle="archiving" />
	            </div>
	        </div>
	    </div>
	    <!-- // Password // -->
	    <div class="form-group">
	        <label class="col-lg-4" for="password"><cv:msg key="label.password" bundle="archiving" /> <span class="optional-text" ng-if="!archCtrl._serverType || archCtrl._serverType === 'nas'"><cv:msg key="label.forShareAccess" bundle="archiving" /></span></label>
	        <div class="col-xs-12 col-lg-5" ng-class="{'col-lg-7': archCtrl.dialogMode}">
	            <input type="password" name="password" id="password"
	                            ng-model="archCtrl.archivingpasssword" ng-change="archCtrl.setContentOptions()" ng-model-options="{ debounce: 350 }" maxlength="128" required/>
	            <div class="help-block" ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.password) || archCtrl.validations.passwordErr">
	                <i class="ion-alert-circled"></i>
	                <cv:msg key="error.password" bundle="archiving" />
	            </div>
	        </div>
	    </div>
	    <!-- // Confirm Password // -->
	    <div class="form-group margin-bottom-10">
	        <label class="col-lg-4" for="confirmPassword"><cv:msg key="label.confirmPassword" bundle="archiving" /></label>
	        <div class="col-xs-12 col-lg-5" ng-class="{'col-lg-7': archCtrl.dialogMode}">
	            <input type="password" name="confirmPassword" id="confirmPassword"
	                            ng-model="archCtrl.archivingConfirmPasssword" maxlength="128" ng-change="archCtrl.setContentOptions()" ng-model-options="{ debounce: 350 }" required/>
	            <div class="help-block" ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.confirmPassword) || (archCtrl.archivingConfirmPasssword && archCtrl.archivingpasssword !== archCtrl.archivingConfirmPasssword) || archCtrl.validations.confirmPasswordErr">
	                <i class="ion-alert-circled"></i>
	                <span ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.confirmPassword) || archCtrl.validations.confirmPasswordErr"><cv:msg key="error.confirmPassword" bundle="archiving" /></span>
	                <span ng-show="archCtrl.archivingConfirmPasssword && archCtrl.archivingpasssword !== archCtrl.archivingConfirmPasssword"><cv:msg key="error.confirmPasswordNotMatched" bundle="archiving" /></span>
	            </div>
	        </div>
	    </div>
	</div>
</script>
<script type="text/ng-template" id="archivingNdmpConfiguration.html">
	  <div ng-if="archCtrl.showNdmpCredentials">
	      <!-- // Enable NDMP credentials -->
	<div class="form-group margin-left-0">
		<cv-toggle toggle-name="enableNDMPCredentials" toggle-label="label.arrayCredentials" help-text="archCtrl.arrayCredentialsText" value="archCtrl.enableNdmpCred"></cv-toggle>
	</div>
	      <div ng-if="archCtrl.enableNdmpCred">
	          <!-- //NDMP Login // -->
	          <div class="form-group"  ng-if="archCtrl.isCreateNewFileServer">
	              <label class="col-lg-4" for="ndmpLogin"><cv:msg key="label.login" bundle="archiving" />
	              </label>
	              <div class="col-xs-12 col-lg-5" ng-class="{'col-lg-7': archCtrl.dialogMode}">
	                  <input type="text" name="ndmpLogin" id="ndmpLogin" ng-model="archCtrl.ndmpLogin" required/>
	                  <div class="help-block" ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.ndmpLogin)">
	                      <i class="ion-alert-circled"></i>
	                      <cv:msg key="error.userName" bundle="archiving" />
	                  </div>
	              </div>
	          </div>
	          <!-- //NDMP Password // -->
	          <div class="form-group"  ng-if="archCtrl.isCreateNewFileServer">
	              <label class="col-lg-4" for="ndmpPassword"><cv:msg key="label.password" bundle="archiving" /></label>
	              <div class="col-xs-12 col-lg-5" ng-class="{'col-lg-7': archCtrl.dialogMode}">
	                  <input type="password" name="ndmpPassword" id="ndmpPassword"
	                                  ng-model="archCtrl.ndmpPassword" maxlength="128" required/>
	                  <div class="help-block" ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.ndmpPassword)">
	                      <i class="ion-alert-circled"></i>
	                      <cv:msg key="error.password" bundle="archiving" />
	                  </div>
	              </div>
	          </div>
	          <!-- //NDMP Listen port // -->
	          <div class="form-group"  ng-if="archCtrl.isCreateNewFileServer && archCtrl.selectedVendorType && archCtrl.selectedVendorType[0].vendorType === 2">
	              <label class="col-lg-4" for="ndmpPort"><cv:msg key="label.ndmpListenPort" bundle="nas" /></label>
	              <div class="col-xs-12 col-lg-5 text-left" ng-class="{'col-lg-7': archCtrl.dialogMode}">
	                  <input type="number" name="ndmpPort" id="ndmpPort"
	                                  ng-model="archCtrl.ndmpPort" min="0" required/>
	                  <div class="help-block" ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.ndmpPort)">
	                      <i class="ion-alert-circled"></i>
	                      <cv:msg key="placeHolder.enterNDMPListenPortHelpText" bundle="nas" />
	                  </div>
	              </div>
	          </div>
	      </div>
	  </div>
</script>
<script type="text/ng-template" id="archivingFileServerConfiguration.html">
	<div  ng-if="archCtrl.isCreateNewFileServer">
	    <!-- //Display name -->
	    <div class="form-group margin-top-10">
	        <label class="col-lg-4" for="displayName"><cv:msg key="label.serverDisplayName" bundle="nas" />
	        </label>
	        <div class="col-xs-12 col-lg-5" ng-class="{'col-lg-7': archCtrl.dialogMode}">
	            <input type="text" name="displayName" id="displayName" ng-model="archCtrl.displayName" placeholder='<cv:msg key="label.enterDisplayName" bundle="archiving"/>' autofocus required/>
	            <div class="help-block" ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.displayName)">
	                <i class="ion-alert-circled"></i>
	                <cv:msg key="error.clientName" bundle="serversJs" />
	            </div>
	        </div>
	    </div>
	    <!-- // File server name // -->
	    <div class="form-group margin-top-10">
	        <label class="col-lg-4" for="archiveHostName"><cv:msg key="label.hostName" bundle="clients" />
	        </label>
	        <div class="col-xs-12 col-lg-5" ng-class="{'col-lg-7': archCtrl.dialogMode}">
	            <input type="text" name="archiveHostName" id="archiveHostName" ng-model="archCtrl.archiveHostName"  ng-change="archCtrl.setContentOptions()" ng-model-options="{ debounce: 350 }" placeholder='<cv:msg key="label.enterHostName" bundle="serversJs"/>' required/>
	            <div class="help-block" ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.archiveHostName) || archCtrl.validations.hostNameErr">
	                <i class="ion-alert-circled"></i>
	                <cv:msg key="error.hostName" bundle="serversJs" />
	            </div>
	        </div>
	    </div>
	    <div ng-if="!archCtrl._serverType || archCtrl._serverType === 'nas'">
	        <!-- // Vendor types //-->
	        <div class="form-group">
	            <label class="col-lg-4" ng-bind="'label.vendorType' | cvLoc"></label>
	            <div class="col-xs-12 col-lg-5" ng-class="{'col-lg-7': archCtrl.dialogMode}">
	                <isteven-multi-select id="setUpFileArchiving_isteven-multi-select_#6837"
	                    directive-id="setUpFileArchiving_isteven-multi-select_#6837"
	                    input-model="archCtrl.vendorTypes"
	                    output-model="archCtrl.selectedVendorType"
	                    button-label="displayName"
	                    item-label="displayName"
	                    selection-mode="single"
	                    tick-property="checked"
	                    class="isteven-multi-select user-group-select"
	                    translation="archCtrl.localLang">
	                </isteven-multi-select>
	            </div>
	        </div>
	        <!-- //Offline recall path -->
	        <div class="form-group margin-top-10"  ng-if="archCtrl.selectedVendorType && archCtrl.selectedVendorType[0].vendorType === 1">
	            <label class="col-lg-4" for="offlineRecallPath"><cv-help-text help-label="label.offlineRecallPath" help-text="info.offlineRecallPath" />
	            </label>
	            <div class="col-xs-12 col-lg-5" ng-class="{'col-lg-7': archCtrl.dialogMode}">
	                <input type="text" name="offlineRecallPath" id="offlineRecallPath" ng-model="archCtrl.offlineRecallPath" required/>
	                <div class="help-block" ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.offlineRecallPath)">
	                    <i class="ion-alert-circled"></i>
	                    <cv:msg key="error.offlineRecallPath" bundle="archiving" />
	                </div>
	            </div>
			</div>
			<!-- //NAS HTTP port NUM // -->
			<div class="form-group"  ng-if="archCtrl.isCreateNewFileServer && archCtrl.selectedVendorType && archCtrl.selectedVendorType[0].vendorType === 1">
				<label class="col-lg-4" for="nasHttpPortNum"><cv:msg key="label.nasHttpPortNum" bundle="archiving" /></label>
				<div class="col-xs-12 col-lg-5 text-left" ng-class="{'col-lg-7': archCtrl.dialogMode}">
					<input type="number" name="nasHttpPortNum" id="nasHttpPortNum"
									ng-model="archCtrl.nasHttpPortNum" min="0" required/>
					<div class="help-block" ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.nasHttpPortNum)">
						<i class="ion-alert-circled"></i>
						<cv:msg key="error.nasHttpPortNum" bundle="archiving" />
					</div>
				</div>
			</div>
	    </div>
	</div>
</script>
<script type="text/ng-template" id="archivingConfiguration.html">
	<!-- // Plan // -->
	<div class="form-group">
	    <label class="col-lg-4" for="plan"><cv:msg key="label.plan" bundle="archiving" /></label>
	    <div class="col-xs-12 col-lg-5" ng-class="{'col-lg-7': archCtrl.dialogMode}">
	        <cv-plan-summary-dropdown
	            input-model="archCtrl.archivalPlans"
	            output-model="archCtrl.selectedPlanList"
	            item-label="'planName'"
	            button-label="'planName'"
	            tick-property="'selected'"
	            selection-mode="'single'"
	            directive-id="'setUpFileArchiving_isteven-multi-select_#6885'"
	            class="full-width" on-close="archCtrl.parseIStevenOutput()">
	        </cv-plan-summary-dropdown>
	        <input type="text" name="plan" id="plan" ng-model="archCtrl.selectedPlan" ng-hide="true" required/>
	        <div class="help-block" ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.plan)">
	            <i class="ion-alert-circled"></i>
	            <span ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.plan)"><cv:msg key="error.plan" bundle="archiving" /></span>
	        </div>
	    </div>
	</div>
	<cv-archiving-rules cv-disk-cleanup-rules="archCtrl.diskCleanupRules" cv-output-model="archCtrl.savedDiskCleanupRules" cv-enable-toggle-override-archiving-rules="'true'" cv-enable-preview-mode="'true'" ng-if="archCtrl.diskCleanupRules"></cv-archiving-rules>
	<ng-include src="'archivingCredentialConfiguration.html'" ng-if="!archCtrl._serverType || archCtrl._serverType === 'nas'"></ng-include>
	<!-- Folder paths -->
	<div class="form-group">
		<cv-content-selection class="col-lg-12"  ng-if="archCtrl.contentOptions && archCtrl.contentEntities" data-options="archCtrl.contentOptions"
	                   data-content-entities="archCtrl.contentEntities">
		</cv-content-selection>
		<div class="help-block padding-top-10 padding-left-10" ng-show="archCtrl.validations.contentErr">
			<i class="ion-alert-circled"></i>
			<span><cv:msg key="error.addArchiveFolderPath" bundle="archiving" /></span>
		</div>
	</div>
</script>
<script type="text/ng-template" id="archivingShareTypeConfiguration.html">
	<!-- // Share type // -->
	<div class="form-group margin-bottom-10" ng-class="{'share-type': archCtrl.dialogMode}" ng-hide="archCtrl.dialogMode && archCtrl._serverType !== 'nas'">
	    <label for="accessNode" class="col-lg-4"><cv:msg key="info.shareType" bundle="nas"/></label>
	    <div class="col-lg-3" ng-class="{'padding-left-0': archCtrl.dialogMode, 'share-type-nfs': archCtrl.dialogMode}">
	        <input id="nfsShareType" type="radio" ng-model="archCtrl.shareType" ng-disabled="archCtrl.dialogMode && archCtrl._serverType === 'windows'" ng-change="archCtrl.updateNodesList()" value="nfs" >
	        <label for="nfsShareType" class="inline-block" style="clear:both"><cv:msg key="label.nfs" bundle="archiving" /></label>
	    </div>
	    <div class="col-lg-4">
	        <input id="cifsShareType" type="radio" ng-model="archCtrl.shareType" ng-disabled="archCtrl.dialogMode && archCtrl._serverType === 'unix'" ng-change="archCtrl.updateNodesList()" value="cifs">
	        <label for="cifsShareType" class="inline-block" style="clear:both"><cv:msg key="label.cifs" bundle="archiving" /></label>
	    </div>
	</div>
</script>
<script type="text/ng-template" id="archivingAccessNodesConfiguration.html">
	<!-- // Access node // -->
	<div class="form-group" ng-if="archCtrl.showAccessNodes">
	    <label for="accessNode" class="col-lg-4"> <cv:msg key="label.accessNodes" bundle="servers" /> </label>
	    <div class="col-xs-12 col-lg-5" ng-class="{'col-lg-7': archCtrl.dialogMode}">
	        <isteven-multi-select id="setUpFileArchiving_isteven-multi-select_#6887"
	            directive-id="setUpFileArchiving_isteven-multi-select_#6887"
	            input-model="archCtrl.accessNodes"
	            output-model="archCtrl.selectedAccessNode"
	            button-label="clientName"
	            item-label="clientName"
	            selection-mode="multiple"
	            tick-property="checked"
	            class="isteven-multi-select user-group-select"
	            translation="archCtrl.localLang" on-close="archCtrl.setContentOptions()">
	        </isteven-multi-select>
	        <input type="text" name="accessNode" id="accessNode" ng-model="archCtrl.selectedAccessNode" ng-hide="true" required/>
	        <div class="help-block" ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.accessNode) || archCtrl.validations.accessNodeErr">
	            <i class="ion-alert-circled"></i>
	            <cv:msg key="error.accessNode" bundle="archiving" />
	        </div>
	    </div>
	    <a href class="cursor-pointer create-new-link margin-top-15 inline-block" ng-click="archCtrl.addAccessNode()" ng-if="!archCtrl.hideAddNewAccessNode"><cv:msg key="string.createNew" bundle="archiving" /> </label></a>
	</div>
</script>
<script type="text/ng-template" id="archivingServerTypeConfiguration.html">
	<!-- // Server type// -->
	<div class="form-group">
	    <label for="serverType" class="col-lg-4"> <cv:msg key="label.serverType" bundle="archiving" /> </label>
	    <div class="col-xs-12 col-lg-5" ng-class="{'col-lg-7': archCtrl.dialogMode}">
	        <isteven-multi-select id="setUpFileArchiving_isteven-multi-select_#6888"
	            directive-id="setUpFileArchiving_isteven-multi-select_#6888"
	            input-model="archCtrl.serverTypes"
	            output-model="archCtrl.selectedServerType"
	            button-label="label"
	            item-label="label"
	            selection-mode="single"
	            tick-property="checked"
	            on-item-click="archCtrl.toggleServerType()"
	            class="isteven-multi-select user-group-select"
	            translation="archCtrl.localLang">
	        </isteven-multi-select>
	        <input type="text" name="serverType" id="serverType" ng-model="archCtrl.selectedServerType" ng-hide="true" required/>
	    </div>
	</div>
</script>
<script type="text/ng-template" id="archivingExistingServerConfiguration.html">
	<!-- // Existing client selection // -->
	<div class="form-group" ng-if="!archCtrl.isCreateNewFileServer">
	    <label class="col-lg-4" for="existingClient" ng-bind="'label.servers' | cvLoc"></label>
	    <div class="col-xs-12 col-lg-5" ng-class="{'col-lg-7': archCtrl.dialogMode}">
	        <isteven-multi-select id="setUpFileArchiving_isteven-multi-select_#6867"
	            directive-id="setUpFileArchiving_isteven-multi-select_#6867"
	            input-model="archCtrl.existingClients"
	            output-model="archCtrl.selectedExistingClient"
	            button-label="displayName"
	            item-label="displayName"
	            selection-mode="single"
	            tick-property="checked"
	            class="isteven-multi-select user-group-select"
	            translation="archCtrl.localLang" ng-if="!archCtrl._serverType || archCtrl._serverType === 'nas'" on-close="archCtrl.setContentOptions()">
	        </isteven-multi-select>
	        <isteven-multi-select id="setUpFileArchiving_isteven-multi-select_#6858"
	            directive-id="setUpFileArchiving_isteven-multi-select_#6867"
	            input-model="archCtrl.existingClients"
	            output-model="archCtrl.selectedExistingClient"
	            button-label="displayName"
	            item-label="displayName"
	            selection-mode="multiple"
	            tick-property="checked"
	            class="isteven-multi-select user-group-select"
	            translation="archCtrl.localLang"  ng-if="archCtrl._serverType && archCtrl._serverType !== 'nas'" on-close="archCtrl.checkAndSetBrowse()">
	        </isteven-multi-select>
	        <input type="text" name="existingClient" id="existingClient" ng-model="archCtrl.selectedExistingClient" ng-hide="true" required/>
	        <div class="help-block" ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.existingClient) || archCtrl.validations.existingServerError">
	            <i class="ion-alert-circled"></i>
	            <cv:msg key="error.existingFileServers" bundle="archiving" />
	        </div>
	    </div>
	</div>
</script>
<script type="text/ng-template" id="installArchiveFileDriver.html">
	<span class="text-left"><cv:msg key="info.installFileDriver" bundle="archiving" />&nbsp;&nbsp;<a ng-click="$parent.$parent.$parent.$parent.$parent.$parent.archCtrl.viewRecallArticle($event)"><cv:msg key="label.endUserRecallWindows" bundle="archiving" /></a></span>
</script>
<script type="text/ng-template" id="archivingFilerMigration.html">
	<div class="form-group margin-left-0 margin-top-10" ng-if="archCtrl.isNasFilerMigrationFeatEnabled && archCtrl.isCreateNewFileServer && archCtrl.dialogMode && archCtrl._serverType === 'nas'">
		<cv-toggle toggle-name="enableFilerMigration" toggle-label="label.nasServerMigration" toggle-model="archCtrl.isMigrationEnabled" value="archCtrl.isMigrationEnabled" on-click="archCtrl.toggleMigration(data)"></cv-toggle>
		<a href="" data-ng-if="archCtrl.showMigrationConfigEditButton()" data-ng-click="archCtrl.openMigrationConfigModal()" class="pull-right btn-edit-migration-config">
			<cv:msg key="action.edit" bundle="collections" />
		</a>
		<div class="help-block margin-left-20" ng-if="archCtrl.attemptedEnablingFilerMigration && archCtrl.migrationPrerequisitesNotMet()">
			<cv:msg key="error.missingPrerequisitesArchiving" bundle="nas" />
		</div>
	</div>
	<div ng-if="archCtrl.isMigrationEnabled && archCtrl.showMigrationConfig">
		<cv-nas-migration-preview migration-config="archCtrl.migrationConfig"></cv-nas-migration-preview>
	</div>
</script>
