<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>
	<div class="row">
		<span class="server-message {{azureADSettingsCtrl.pageMessage.type}}">{{azureADSettingsCtrl.pageMessage.message}}</span>
	</div>
	<div class="row">
		<div class="col-md-6">
			<cv-tile-component  data-title='<cv:msg key="label.general" bundle="activeDirectory" />' loader="azureADSettingsCtrl.tileLoadFlags.subclientDetails">
				<ul class="list-style-secondary">
					<!--Cloud Region-->
					<li class="group" data-ng-if="azureADSettingsCtrl.showMSCloudRegions">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.region" bundle="activeDirectory"/></span>
						<span class="pageDetailColumn width-60-percentage">
							<span class="pageDetailColumn">  <span data-ng-bind="azureADSettingsCtrl.azureADCloudRegionDisp"></span> </span>
							<span class="float-right tile-content-link"  data-ng-if="!azureADSettingsCtrl.isOffice365SaaSTenant" >
								<a data-ng-click="azureADSettingsCtrl.editMSCloudRegions(true)">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
						</span>
					</li>
					<li class="group" data-ng-if="!azureADSettingsCtrl.showMSCloudRegions">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.region" bundle="activeDirectory"/></span>
						<span class="pageDetailColumn width-60-percentage inline-editor">
							<isteven-multi-select id="azureADEditConnectionSettings_isteven-multi-select_#2667" 
										input-model="azureADSettingsCtrl.msCloudRegions"
										output-model="azureADSettingsCtrl.selectedRegionList"
										button-label="region"
										item-label="region"
										directive-id="'cloudRegions'"
										selection-mode="single"
										helper-elements="filter"
										max-labels="1"
										tick-property="selected"
										translation="azureADSettingsCtrl.localLang">
									</isteven-multi-select>
									<span class="cv-help-block" data-ng-show="azureADSettingsCtrl.validationStatusFlags.regionRequired">
										<cv:msg key="error.regionRequired" bundle="activeDirectory" /></span>
							<span class="inline-editor-buttons">
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="azureADSettingsCtrl.updateMSCloudRegions()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="azureADSettingsCtrl.editMSCloudRegions(false)"><span class="k-icon k-i-x"></span></a>
							</span>
						</span>
					</li>

					<!--Global Admin Account ... On Edit ..open small-window dialog-->
					<li class="group">
						<span class="pageDetailColumn width-40-percentage"><cv-help-text help-label="label.globalAdministrator" help-text="help.globalAdmin"/></span>
						<span class="pageDetailColumn width-60-percentage" data-ng-if="azureADSettingsCtrl.infraStructureSettings.hasGlobalAdminAccount">
							<span data-ng-bind="azureADSettingsCtrl.infraStructureSettings.globalAdminAccountDetails.userAccount.userName"></span>
							<span class="float-right tile-content-link" >
								<a data-ng-click="azureADSettingsCtrl.openAddEditGlobalAdminAccount(azureADSettingsCtrl.infraStructureSettings.globalAdminAccountDetails)"><cv:msg key="label.edit" bundle="clients" /></a>
								<a class="margin-left-10" data-ng-click="azureADSettingsCtrl.deleteAccountConfirmation(azureADSettingsCtrl.infraStructureSettings.globalAdminAccountDetails)"><cv:msg key="label.delete" bundle="ediscovery" /></a>
							</span>
						</span>
						<!--Add new Global Administrator-->
						<span class="pageDetailColumn width-60-percentage" data-ng-if="!azureADSettingsCtrl.infraStructureSettings.hasGlobalAdminAccount">
							<label class="restore-help-text italic"><cv:msg key="label.app.not.configured" bundle="office365" /></label>			
							<a class="float-right tile-content-link" 
								data-ng-click="azureADSettingsCtrl.openAddEditGlobalAdminAccount()"><cv:msg key="label.add" bundle="exchange" /></a>
						</span>
					</li>
					<li class="group" data-ng-if="azureADSettingsCtrl.showAzureDirectoryId && azureADSettingsCtrl.infraStructureSettings.azureDirectoryId">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.azureDirectoryID" bundle="exchange" /></span>
						<span class="pageDetailColumn width-60-percentage">
							<span title="{{azureADSettingsCtrl.infraStructureSettings.azureDirectoryId}}" data-ng-bind="azureADSettingsCtrl.infraStructureSettings.azureDirectoryId"></span>
						</span>
					</li>
					<!--Modern authentication-->	
					<li class="group">
						<span class="pageDetailColumn width-40-percentage"><cv-help-text help-label="label.useModernAuthentication" help-text="help.modernAuth"/></span>
						<span class="pageDetailColumn width-60-percentage">
							<toggle-control status="true"></toggle-control>
						</span>
					</li>
					<!--Modern authentication-->
				</ul>
			</cv-tile-component>
			
			
			 <!-- Begin Azure AD Connection Settings -->
			 <cv-tile-component data-title='<cv:msg key="label.connectionSettings" bundle="activeDirectory" />' loader="azureADSettingsCtrl.tileLoadFlags.connSettLoaded">
				<ul class="list-style-secondary">
					<li class="group">
						<cv-tabset-component control='azureADSettingsCtrl.tabControls' element="cvtile" ng-if="azureADSettingsCtrl.azureADAzureAppsGridOptions">
							<cv-tab tabname='<cv:msg key="label.azureApps" bundle="office365" />'>
								<cv-kendo-grid data-cv-grid-options="azureADSettingsCtrl.azureADAzureAppsGridOptions"></cv-kendo-grid>
							</cv-tab>
						</cv-tabset-component>
					<li>
				</ul>
			</cv-tile-component>
			<!-- End Azure AD Connection Settings-->
		  
		</div>
		<div class="col-md-6" >
			<!-- Begin AD infrastructureSettings -->
			<cv-tile-component data-title='<cv:msg key="label.infrastructureSettings" bundle="activeDirectory" />'	loader="azureADSettingsCtrl.tileLoadFlags.infraSettLoaded"> 
				<ul class="list-style-secondary">
					<!-- Start Server Plan -->
					<li class="group" data-ng-if="azureADSettingsCtrl.showPlan">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.serverPlan" bundle="exchange"/></span>
						<span class="pageDetailColumn width-60-percentage">
							<span class="pageDetailColumn"> <a href="#profileDetails/{{azureADSettingsCtrl.planId}}" data-ng-bind="azureADSettingsCtrl.planName"></a></span>
							<span class="float-right tile-content-link"  data-ng-if="!azureADSettingsCtrl.isOffice365SaaSTenant" >
								<a data-ng-click="azureADSettingsCtrl.editServerPlan(true)">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
						</span>
						<div class="text-muted pageDetailColumn width-60-percentage float-right tile-content-link" data-ng-if="azureADSettingsCtrl.infraStructureSettings.isInfrastructureConfigured">
							<cv:msg key="label.infrastructureInheritedFromPlan" bundle="exchange" />
						</div>
					</li>
					<li class="group" data-ng-if="!azureADSettingsCtrl.showPlan">
						<span class="pageDetailColumn width-40-percentage margin-top-10"><cv:msg key="label.serverPlan" bundle="exchange"/></span>
						<span class="pageDetailColumn width-60-percentage inline-editor">
							<cv-plan-summary-dropdown
								class="full-width"
								input-model="azureADSettingsCtrl.serverPlanList"
								output-model="azureADSettingsCtrl.selectedPlanList"
								button-label="'planName'"
								item-label="'planName'"
								tick-property="'selected'"
								selection-mode="'single'"
								directive-id="'plans'"
								max-labels="1"
								helper-elements="'filter'"
								translation="azureADSettingsCtrl.localLang"
								disable-property="'disabled'">
							</cv-plan-summary-dropdown>
							<span class="inline-editor-buttons">
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="azureADSettingsCtrl.updateServerPlan()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="azureADSettingsCtrl.editServerPlan(false)"><span class="k-icon k-i-x"></span></a>
							</span>
						</span>
					</li>
					<!-- End Server Plan -->
					<div data-ng-if="azureADSettingsCtrl.infrastructureSettingsLoaded && (!azureADSettingsCtrl.infraStructureSettings.isInfrastructureConfigured && !azureADSettingsCtrl.isOffice365SaaSTenant)">
						<!-- Start Index Server -->
						<li class="group" data-ng-if="azureADSettingsCtrl.showIndexServer">
							<cv-help-text class="pageDetailColumn width-40-percentage" help-label="label.indexServer" help-text="info.indexServerCvSolr" />
							<span class="pageDetailColumn width-60-percentage inline-editor">
								<span class="inline-editor-text" title="{{azureADSettingsCtrl.infraStructureSettings.indexServer.clientName}}" data-ng-bind="azureADSettingsCtrl.infraStructureSettings.indexServer.clientName"></span>
								<span class="float-right tile-content-link" >
									<a data-ng-click="azureADSettingsCtrl.editIndexServer(true)">
										<cv:msg key="label.edit" bundle="clients" />
									</a>
								</span>
							</span>
						</li>

						<li class="group"  data-ng-if="!azureADSettingsCtrl.showIndexServer">
							<cv-help-text class="pageDetailColumn width-40-percentage" help-label="label.indexServer" help-text="info.indexServerCvSolr" />
							<span class="pageDetailColumn width-60-percentage inline-editor">
								<isteven-multi-select id="indexServer" input-model="azureADSettingsCtrl.indexServersList"
									output-model="azureADSettingsCtrl.selectedIndexList" button-label="clientName"
									item-label="clientName" tick-property="selected" class="isteven-multi-select user-group-select"
									helper-elements="filter" selection-mode="single" translation="azureADSettingsCtrl.localLang" on-item-click="azureADSettingsCtrl.processIndexServerSelection(data)">
								</isteven-multi-select>

								<span class="inline-editor-buttons">
									<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="azureADSettingsCtrl.updateIndexServer()"><span class="k-icon k-i-check"></span></a>
									<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="azureADSettingsCtrl.editIndexServer(false)"><span class="k-icon k-i-x"></span></a>
								</span>
							</span>
						</li>
						<!-- End Index Server -->

						<!-- Start Access Nodes -->
						<li class="group" data-ng-if="azureADSettingsCtrl.showAccessNodes">
							<cv-help-text class="pageDetailColumn width-40-percentage" help-label="label.accessNodes" help-text="info.accessNode" />
							<span class="pageDetailColumn width-60-percentage">
								<span class="float-right tile-content-link" >
									<a data-ng-click="azureADSettingsCtrl.editAccessNodes(true)">
										<cv:msg key="label.edit" bundle="clients" />
									</a>
								</span>
								<span class="pageDetailColumn">
									<a ng-repeat="an in azureADSettingsCtrl.infraStructureSettings.accessNodeArray" href="#/clientDetails/{{an.clientId}}" data-ng-bind="an.clientName"></a>
								</span>
							</span>
						</li>
						<li class="group"  data-ng-if="!azureADSettingsCtrl.showAccessNodes">
							<cv-help-text class="pageDetailColumn width-40-percentage" help-label="label.accessNodes" help-text="info.accessNode" />
							<span class="pageDetailColumn width-60-percentage inline-editor">
								<isteven-multi-select id="memberServer" input-model="azureADSettingsCtrl.memberServers" output-model="azureADSettingsCtrl.selectedMemberServers"
									button-label="clientName" item-label="clientName" tick-property="selected" class="isteven-multi-select user-group-select"
									helper-elements="filter" selection-mode="single" >
								</isteven-multi-select>

								<span class="inline-editor-buttons">
									<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="azureADSettingsCtrl.updateAccessNodes()"><span class="k-icon k-i-check"></span></a>
									<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="azureADSettingsCtrl.editAccessNodes(false)"><span class="k-icon k-i-x"></span></a>
								</span>
							</span>
						</li>
						<!-- End Access Nodes -->

						<!--  Check Readiness -->
						<li class="group" ng-if="azureADSettingsCtrl.infraStructureSettings.accessNode">
							<span class="pageDetailColumn width-40-percentage">
								<cv:msg key="label.clientReadiness" bundle="clients" />
							</span>
							<span class="pageDetailColumn width-60-percentage client-readiness">
								<span data-ng-if="azureADSettingsCtrl.readinessStatus" >
									<span data-ng-bind="azureADSettingsCtrl.readinessStatus"></span>
									<span data-ng-if="azureADSettingsCtrl.clientReadinessLastCheckedText" class="parenthetical-text last-checked" data-ng-bind="azureADSettingsCtrl.clientReadinessLastCheckedText"></span>
								</span>
								<span data-ng-if="!azureADSettingsCtrl.readinessStatus">
									<cv:msg key="label.notAvailable" bundle="servers" />
								</span>	
								<span class="float-right tile-content-link" >
									<a data-ng-click="azureADSettingsCtrl.onClickShowDetailedReport()" uib-tooltip="<cv:msg key='label.showDetailedClientReadinessReport' bundle='clients' />" tooltip-placement="top"><cv:msg key='label.showDetails' bundle='clients' /></a>
								</span>
							</span>
						</li>
						<!--  End Check Readiness -->
					</div>

				</ul>
			</cv-tile-component>
			<!-- End AD infrastructureSettings-->
			
			<!-- Begin Activity Control -->
			<cv-activity-control-component data-ac-params="azureADSettingsCtrl.acParams"></cv-activity-control-component>
			<!-- End Activity Control -->

			<!-- Begin Security Control -->
			<cv-security-component data-ng-if="azureADSettingsCtrl.entityType" entity-type='azureADSettingsCtrl.entityType' generic-entity='azureADSettingsCtrl.genericEntity' associations='azureADSettingsCtrl.formattedSecurityAssociations' associations-loaded='azureADSettingsCtrl.tileLoadFlags.associationsLoaded'>
			</cv-security-component>
			<!-- End Security Control -->
			
		</div>
	</div>
</div>
