<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.activeDirectory"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1><cv:msg key="label.infrastructureSettings" bundle="activeDirectory" /></h1>
	</div>
	<div class="setup-content">
                <div class="panel">
                    <div class="cv-modal-wrapper">
                <label class="cv-label">
                            <cv:msg key="label.profile" bundle="profiles" /></label>
                        <div class="cv-inline-wrapper">
                            <div class="padding-right-20">
                                <isteven-multi-select id="plan" input-model="azureADEditInfraCtrl.plans" output-model="azureADEditInfraCtrl.selectedPlan"
                                    button-label="planName" item-label="planName" tick-property="selected" class="isteven-multi-select single-select"
                                    helper-elements="none" selection-mode="single">
                                </isteven-multi-select>
                        <span class="cv-help-block" data-ng-show="azureADEditInfraCtrl.validationStatusFlags.planRequired">
                                <cv:msg key="error.selectPlan" bundle="profiles" /></span>
                            </div>
                        </div>
                
                    </div>
                    <div class="cv-modal-wrapper">
                <label class="cv-label">
                    <cv-help-text id="accessNodes" help-label="label.accessNodes" help-text="info.accessNode" />
                        </label>
                        <div class="cv-inline-wrapper">
                            <div class="padding-right-20">
                                <isteven-multi-select id="memberServer" input-model="azureADEditInfraCtrl.memberServers" output-model="azureADEditInfraCtrl.selectedMemberServers"
                                button-label="clientName" item-label="clientName" tick-property="selected" class="isteven-multi-select user-group-select"
                                helper-elements="filter" selection-mode="single" >
                                </isteven-multi-select>
                        <span class="cv-help-block" data-ng-show="azureADEditInfraCtrl.validationStatusFlags.memberServersRequired">
                                <cv:msg key="error.selectMemberServer" bundle="activeDirectory" /></span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="cv-modal-wrapper">
                        <label class="cv-label">
                        <cv-help-text id="indexServerCloud" help-label="label.indexServer" help-text="info.indexServerCloud" data-ng-show="azureADEditInfraCtrl.SupportAzureADInSolrCloud" />
                        <cv-help-text id="indexServerCvSolr" help-label="label.indexServer" help-text="info.indexServerCvSolr" data-ng-hide="azureADEditInfraCtrl.SupportAzureADInSolrCloud" />
                        </label>
                        <div class="cv-inline-wrapper">
                            <div>
                                <div class="padding-right-20">
                                    <isteven-multi-select id="indexServer" input-model="azureADEditInfraCtrl.indexServers"
                                        output-model="azureADEditInfraCtrl.selectedIndexServers" button-label="clientName"
                                        item-label="clientName" tick-property="selected" class="isteven-multi-select user-group-select"
                                        helper-elements="filter" selection-mode="single" on-item-click="azureADEditInfraCtrl.onIndexServerChange(data)">
                                    </isteven-multi-select>
                            <span class="cv-help-block" data-ng-show="azureADEditInfraCtrl.validationStatusFlags.indexServersRequired">
                                    <cv:msg key="error.selectIndexServer" bundle="activeDirectory" /></span>
                            </div>
                        </div>
                    </div>
                            </div>
                </div>
        <div class="button-container">
            <span class="help-block" data-ng-show="azureADEditInfraCtrl.validationStatusFlags.noAzurePropChanged">
                    <cv:msg key="error.noAzurePropChanged" bundle="activeDirectory" /></span>
			<button id="azureADEditInfrastructureSettings_button_#1926" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="azureADEditInfraCtrl.cancel()"> 
				<cv:msg key="Cancel" bundle="messages" /></button>
			<button id="azureADEditInfrastructureSettings_button_#6414" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click="azureADEditInfraCtrl.saveAzureADInfra()"> 
				<cv:msg key="Save" bundle="messages" /></button>
		</div>
	</div>
</div>
