<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.activeDirectory"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1><cv:msg key="label.connectionSettings" bundle="activeDirectory" /></h1>
	</div>
	<div class="setup-content">
        <div class="panel">
            <br>
            <div class="cv-modal-wrapper">
                <label class="cv-label"><cv:msg key="label.region" bundle="activeDirectory" /></label>
                <div class="cv-inline-wrapper">
                    <div class="padding-right-20">
                            <isteven-multi-select id="azureADEditConnectionSettings_isteven-multi-select_#2667" 
                                input-model="azureADEditConnCtrl.msCloudRegions"
                                output-model="azureADEditConnCtrl.selectedRegionList"
                                button-label="region"
                                item-label="region"
                                directive-id="'cloudRegions'"
                                selection-mode="single"
                                helper-elements="filter"
                                max-labels="1"
                                tick-property="selected"
                                translation="azureADEditConnCtrl.localLang">
                            </isteven-multi-select>
                        <span class="cv-help-block" data-ng-show="azureADEditConnCtrl.validationStatusFlags.regionRequired">
                            <cv:msg key="error.regionRequired" bundle="activeDirectory" /></span>
                    </div>
                </div>
            </div>
        </div>
            
        <div class="panel">
            <h4 class="text-left padding-left-20"> <cv:msg key="label.addAzureApp" bundle="activeDirectory" /></h4>
            <div class="cv-modal-wrapper">
                <label class="cv-label"><cv:msg key="label.azureAppId" bundle="activeDirectory" /></label>
                <div class="cv-inline-wrapper">
                    <input data-ng-model="azureADEditConnCtrl.azureDetails.azureAppId" class="" type="text"
                     placeholder='<cv:msg key="label.help.azureAppId" bundle="activeDirectory"/>'  
                     data-ng-change="azureADEditConnCtrl.isAzureAppDetailsDirty()"/>
                    <span class="cv-help-block" data-ng-show="azureADEditConnCtrl.validationStatusFlags.azureAppId">
                    <cv:msg key="error.azureAppIdRequired" bundle="activeDirectory" /></span>
                </div>
            </div>
            <div class="cv-modal-wrapper">
                <label class="cv-label"><cv:msg key="label.azureAppKeyValue" bundle="activeDirectory" /></label>
                <div class="cv-inline-wrapper">
                    <input data-ng-model="azureADEditConnCtrl.azureDetails.azureAppKeyValue" class="" type="text" 
                    placeholder='{{azureADEditConnCtrl.azureAppKeyValuePlaceHolder}}' />
                    <span class="cv-help-block" data-ng-show="azureADEditConnCtrl.validationStatusFlags.azureAppKeyValue">
                    <cv:msg key="error.azureAppKeyValueRequired" bundle="activeDirectory" /></span>
                </div>                
            </div>
            <div class="cv-modal-wrapper">
                <label class="cv-label"><cv:msg key="label.azureDirectoryId" bundle="activeDirectory" /></label>
                <div class="cv-inline-wrapper">
                    <input data-ng-model="azureADEditConnCtrl.azureDetails.azureDirectoryId" class="" type="text" 
                    placeholder='<cv:msg key="label.help.azureDirectoryId" bundle="activeDirectory"/>' 
                    data-ng-change="azureADEditConnCtrl.isAzureAppDetailsDirty()" />
                    <span class="cv-help-block" data-ng-show="azureADEditConnCtrl.validationStatusFlags.azureDirectoryId">
                    <cv:msg key="error.azureDirectoryIdRequired" bundle="activeDirectory" /></span>
                </div>                
            </div>
        </div>
        <div class="button-container">
            <span class="help-block" data-ng-show="azureADEditConnCtrl.validationStatusFlags.noAzurePropChanged">
                <cv:msg key="error.noAzurePropChanged" bundle="activeDirectory" /></span>
			<button id="azureADEditConnectionSettings_button_#6574" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="azureADEditConnCtrl.cancel()"> 
				<cv:msg key="Cancel" bundle="messages" /></button>
			<button id="azureADEditConnectionSettings_button_#8757" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click="azureADEditConnCtrl.saveAzureADConnSet()"> 
				<cv:msg key="Save" bundle="messages" /></button>
		</div>
	</div>
</div>
