<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.activeDirectory"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div data-ng-class="{ 'set-up-page2 col-xs-12  col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2 col-xl-6 col-xl-offset-3' : !azureADAddClntCtrl.isSetup }">
	<div class="setup-title" data-ng-if="azureADAddClntCtrl.isSetup">
		<h1><cv:msg key="label.addAzureADClient" bundle="activeDirectory" /></h1>
	</div>
	<div class="row bootstrap-wrapper" data-ng-class="{'medium-width' : azureADAddClntCtrl.isSetup }">
		<h1 data-ng-if="!azureADAddClntCtrl.isSetup" class="text-left">
			<cv:msg key="label.azureAD" bundle="activeDirectory" />
		</h1>
		<form data-cv-submit="azureADAddClntCtrl.createAzurePseudoClient()" name="azrueADADDClnt" class="form-horizontal">
			<div class="panel" data-ng-if="azureADAddClntCtrl.isOffice365SaaSTenant">
				<div class="panel-body">
				<div  data-ng-show="azureADAddClntCtrl.showAppNameInput"> 
					<div class="form-group">
						<label class="col-xs-12 col-md-3" for="appName"><cv:msg key="label.name" bundle="exchange" /></label>
						<div class="col-xs-12 col-md-9">
							<div class="input-group">
								<span class="input-group-addon" style="background-color:transparent; padding:0px; border:none;"
									data-ng-bind="azureADAddClntCtrl.office365AppPrefix"></span>
								<input class="" type="text" name="azureAppName" id="azureAppName" 
									placeholder='<cv:msg key="label.exchAppNamePlaceholder" bundle="exchange"/>'
									data-ng-pattern="/^[a-zA-Z0-9_-]*$/"
									data-ng-required="true"
									data-ng-model="azureADAddClntCtrl.azureADCrClntProp.clientName"
									required />
							</div>
							<span class="cv-help-block" data-ng-show="cv.azrueADADDClnt.needsAttention(azrueADADDClnt.azureAppName) || azureADAddClntCtrl.validationStatusFlags.selectClient">
								<cv:msg key="error.selectClient" bundle="activeDirectory" /></span>
						</div>
					</div>
				</div>
				</div>
			</div>
		<div data-ng-if="!azureADAddClntCtrl.isOffice365SaaSTenant">
			<div class="panel">
				<div class="panel-body">
					<div class="form-group">
						<label class="col-xs-12 col-md-3" for="appName"><cv:msg key="label.name" bundle="exchange" /></label>
						<div class="col-xs-12 col-md-9">
							<input data-ng-model="azureADAddClntCtrl.azureADCrClntProp.clientName" class="" type="text" name="azureAppName" id="azureAppName" 
							data-ng-pattern="/^[a-zA-Z0-9_-]*$/" data-ng-required="true" placeholder='<cv:msg key="label.exchAppNamePlaceholder" bundle="exchange"/>' />
							<span class="cv-help-block" data-ng-show="cv.azrueADADDClnt.needsAttention(azrueADADDClnt.azureAppName) || azureADAddClntCtrl.validationStatusFlags.selectClient">
									<cv:msg key="error.selectClient" bundle="activeDirectory" /></span>
						</div>
					</div>
					<div class="form-group" >
						<label class="col-xs-12 col-md-3">
							<cv:msg key="label.serverPlan" bundle="profiles" /></label>
						<div class="col-xs-12 col-md-9">
							<cv-plan-summary-dropdown
								data-ng-if="azureADAddClntCtrl.plansLoaded"
								input-model="azureADAddClntCtrl.azureADCrClntProp.plans"
								output-model="azureADAddClntCtrl.azureADCrClntProp.selectedPlan"
								button-label="'planName'"
								item-label="'planName'"
								tick-property="'selected'"
								selection-mode="'single'"
								directive-id="'plans'"
								max-labels="1"
								helper-elements="'filter'"
								translation="azureADAddClntCtrl.localLang"
								disable-property="'disabled'"
								on-item-clicked="azureADAddClntCtrl.processServerPlanSelection()">
							</cv-plan-summary-dropdown>
							<span class="cv-help-block" data-ng-show="azureADAddClntCtrl.validationStatusFlags.planRequired">
								<cv:msg key="error.selectPlan" bundle="profiles" /></span>
						</div>
					</div>
				</div>
			</div>
			<uib-accordion class="text-left">
				<div uib-accordion-group data-is-open="azureADAddClntCtrl.isInfaSettingAcordianOpen" data-is-disabled="azureADAddClntCtrl.isInfraSettingDisable" class="azureADInfraAccordion-panel">
					<uib-accordion-heading class="panel-info" >
						<span><cv:msg key="label.infrastructureSettings" bundle="activeDirectory" /> </span>
						<span data-ng-if="azureADAddClntCtrl.isInfrastructurePoolConfigured" class="restore-help-text margin-left-10"><cv:msg key="label.infrastructureInherited" bundle="exchange" /></span>
						<i class="float-right glyphicon" data-ng-class="azureADAddClntCtrl.isInfaSettingAcordianOpen ? 'glyphicon-chevron-down' : 'glyphicon-chevron-right' "></i>
					</uib-accordion-heading>
					<div>
						<div class="form-group" data-ng-if="!azureADAddClntCtrl.azureADCrClntProp.createNewindexServer">
							<cv-help-text id="indexServerCloud" class="col-xs-12 col-md-3 margin-top-10" help-label="label.indexServer" help-text="info.indexServerCloud" data-ng-show="azureADAddClntCtrl.SupportAzureADInSolrCloud" />
							<cv-help-text id="indexServerCvSolr" class="col-xs-12 col-md-3 margin-top-10" help-label="label.indexServer" help-text="info.indexServerCvSolr" data-ng-hide="azureADAddClntCtrl.SupportAzureADInSolrCloud" />
							<div class="col-xs-12 col-md-9">
								<div>
									<div class="padding-left-10">
										<isteven-multi-select id="indexServer" input-model="azureADAddClntCtrl.azureADCrClntProp.indexServers"
											output-model="azureADAddClntCtrl.azureADCrClntProp.selectedIndexServers" button-label="clientName"
											item-label="clientName" tick-property="selected" class="isteven-multi-select user-group-select" translation="azureADAddClntCtrl.localLang"
											helper-elements="filter" selection-mode="single" on-item-click="azureADAddClntCtrl.onIndexServerChange(data)">
										</isteven-multi-select>
										<span class="cv-help-block" data-ng-show="azureADAddClntCtrl.validationStatusFlags.indexServersRequired">
										<cv:msg key="error.selectIndexServer" bundle="activeDirectory" /></span>
									</div>
								</div>
							</div>
						</div>
						<!-- <div class="form-group" data-ng-if="azureADAddClntCtrl.azureADCrClntProp.createNewindexServer">
							<label class="col-xs-12 col-md-3">
								<cv-help-text id="indexServerNode" help-label="label.indexServerNode" help-text="info.indexServerNode" />
							</label>
							<div class="col-xs-12 col-md-9" >
								<div>
									<div class="padding-right-20">
										<isteven-multi-select id="createNewIndexServer" input-model="azureADAddClntCtrl.azureADCrClntProp.cloudClients"
											output-model="azureADAddClntCtrl.azureADCrClntProp.selectedCloudClients" button-label="clientName"
											item-label="clientName" tick-property="selected" class="isteven-multi-select user-group-select"
											helper-elements="none" selection-mode="single">
										</isteven-multi-select>
										<span class="cv-help-block" data-ng-show="azureADAddClntCtrl.validationStatusFlags.newIndexServersNodeRequired">
										<cv:msg key="error.selectIndexServerNode" bundle="activeDirectory" /></span>
									</div>
								</div>
								<a class="float-right margin-right-20 margin-top-20"  data-ng-click="azureADAddClntCtrl.useExistingIndexServer()"> <cv:msg key="label.existingExchangeIndexServer" bundle="activeDirectory" /> </a>
							</div>
						</div> -->
						<div class="form-group">
							<cv-help-text id="accessNodes" class="col-xs-12 col-md-3 margin-top-10" help-label="label.accessNodes" help-text="info.accessNode"  />
							<div class="col-xs-12 col-md-9">
								<div class="padding-left-10">
									<isteven-multi-select id="memberServer" input-model="azureADAddClntCtrl.azureADCrClntProp.memberServers"
										output-model="azureADAddClntCtrl.azureADCrClntProp.selectedMemberServers" button-label="clientName" item-label="clientName"
										tick-property="selected" class="isteven-multi-select user-group-select" helper-elements="filter" translation="azureADAddClntCtrl.localLang"
										selection-mode="single">
									</isteven-multi-select>
									<span class="cv-help-block" data-ng-show="azureADAddClntCtrl.validationStatusFlags.memberServersRequired">
										<cv:msg key="error.selectMemberServer" bundle="activeDirectory" /></span>
								</div>
							</div>
						
						</div>
					</div>
				</div>
			</uib-accordion>
		</div>
		<div>
			<div class="panel">
				<div class="panel-body">
				<h4 class="text-left"> <cv:msg key="label.connectionSettings" bundle="activeDirectory" /></h4>
				<div class="form-group">
					<label class="col-xs-12 col-md-3"><cv:msg key="label.region" bundle="activeDirectory" /></label>
					<div class="col-xs-12 col-md-9">
						<div class="padding-right-20">
								<isteven-multi-select id="azureADCreateClient_isteven-multi-select_#6764" 
									input-model="azureADAddClntCtrl.azureADCrClntProp.msCloudRegions"
									output-model="azureADAddClntCtrl.azureADCrClntProp.selectedRegionList"
									button-label="region"
									item-label="region"
									directive-id="'cloudRegions'"
									selection-mode="single"
									helper-elements="filter"
									max-labels="1"
									tick-property="selected"
									translation="azureADAddClntCtrl.localLang">
								</isteven-multi-select>
							<span class="cv-help-block" data-ng-show="azureADAddClntCtrl.validationStatusFlags.regionRequired">
								<cv:msg key="error.regionRequired" bundle="activeDirectory" /></span>
						</div>
					</div>
				</div>

				<div class="form-group">
					<label class="col-xs-12 col-md-3" for="connectionDetails"><cv:msg key="label.connectionDetails" bundle="exchange" /></label>
					<div class="col-xs-12 col-md-9">
						<cv-radio-group
							is-vertical="true" 
							radio-model="azureADAddClntCtrl.azureAccountCreationOptionsVal" 
							radio-obj="azureADAddClntCtrl.azureAccountCreationOptions"
							is-disabled="azureADAddClntCtrl.azureAppCreationInProgress"
							on-click="azureADAddClntCtrl.azureAccountCreationOptionsValChange(data)">
						</cv-radio-group>
					</div>
				</div>
				<div class="text-left margin-top-10 padding-left-20 margin-left-5">
					<div ng-if="!azureADAddClntCtrl.flagAzureByAppCr">
						<div class="panel">
							<div class="row">
								<div class="col-md-3 col-md-offset-3"><label>
									<cv:msg key="label.azureAppId" bundle="activeDirectory" /></label></div>
								<div class="col-md-6">
									<input data-ng-model="azureADAddClntCtrl.azureADCrClntProp.azureDetails.azureAppId" class="full-width margin-right-10" type="text"
									placeholder='<cv:msg key="placeholder.azureAppId" bundle="office365"/>' />
									<span class="cv-help-block" data-ng-show="azureADAddClntCtrl.validationStatusFlags.azureAppId">
									<cv:msg key="error.azureAppIdRequired" bundle="activeDirectory" /></span>
								</div>
							</div>
							<div class="row">
								<div class="col-md-3 col-md-offset-3"><label>
									<cv:msg key="label.azureAppSecret" bundle="office365" /></label></div>
								<div class="col-md-6">
									<input data-ng-model="azureADAddClntCtrl.azureADCrClntProp.azureDetails.azureAppKeyValue" class="full-width margin-right-10" type="text"
									placeholder='<cv:msg key="placeholder.azureAppSecret" bundle="office365"/>' />
									<span class="cv-help-block" data-ng-show="azureADAddClntCtrl.validationStatusFlags.azureAppKeyValue">
									<cv:msg key="error.azureAppKeyValueRequired" bundle="activeDirectory" /></span>
								</div>
							</div>
							<div class="row">
								<div class="col-md-3 col-md-offset-3"><label>
									<cv:msg key="label.azureDirectoryId" bundle="activeDirectory" /></label></div>
								<div class="col-md-6">
									<input data-ng-model="azureADAddClntCtrl.azureADCrClntProp.azureDetails.azureDirectoryId" class="full-width margin-right-10" type="text" 
									placeholder='<cv:msg key="label.help.azureDirectoryId" bundle="activeDirectory"/>' />
									<span class="cv-help-block" data-ng-show="azureADAddClntCtrl.validationStatusFlags.azureDirectoryId">
									<cv:msg key="error.azureDirectoryIdRequired" bundle="activeDirectory" /></span>
								</div>
							</div>
						</div>
					</div>
					<div ng-if="azureADAddClntCtrl.flagAzureByAppCr">
						<div ng-if="!azureADAddClntCtrl.isAzureAppCreated">
							<div class="panel">
								<div class="row">
									<cv-call-out
										class="col-md-3 col-md-offset-3 margin-top-20"
										html-template="azureADAddClntCtrl.globalAdminUserNameCallOutTemplate"
										label='<cv:msg key="label.globalAdministrator" bundle="office365" />'
										placement="right"
										trigger="mouseenter"
									/>
									<div class="col-md-6">
										<input type="text" id="globalUserName" name="globalUserName" class="longPlaceholderInp full-width margin-right-10"
											data-ng-model="azureADAddClntCtrl.azureADCrClntProp.globalAdminAccount.adminCredential.userName"
											placeholder='<cv:msg key="label.gadmin.example" bundle="office365"/>' autocomplete="off" />
										<span class="cv-help-block" data-ng-show="azureADAddClntCtrl.validationStatusFlags.globalUserNameRequired">
												<cv:msg key="error.globalAppUsernameError" bundle="activeDirectory" /></span>
									</div>
								</div>
								<div class="row">
									<div class="col-md-3 col-md-offset-3"><span><cv:msg key="label.globalAdministrator.password" bundle="office365" /></span></div>
									<div class="col-md-6">
										<input type="password" id="globalPassword" name="globalPassword" class="full-width margin-right-10"
											data-ng-model="azureADAddClntCtrl.azureADCrClntProp.globalAdminAccount.adminCredential.password"
											placeholder='<cv:msg key="label.password" bundle="activeDirectory"/>' autocomplete="off" />
										<span class="cv-help-block" data-ng-show="azureADAddClntCtrl.validationStatusFlags.globalPasswordRequired">
											<cv:msg key="error.password" bundle="activeDirectory" /></span>
									</div>
								</div>
								
								<div class="row">
									<div class="col-md-3 col-md-offset-3"><label class="col-xs-12 col-md-3"></label></div>
									<div class="col-md-6 text-left">
											<div>
												<button id="azureADCreateClient_button_#1242" class="btn btn-default margin-top-10" type="button" 
													data-ng-disabled="azureADAddClntCtrl.azureAppCreationInProgress || azureADAddClntCtrl.azureADCrClntProp.globalAdminAccount.adminCredential.userName < 1 || azureADAddClntCtrl.azureADCrClntProp.globalAdminAccount.adminCredential.password < 1 "
													data-ng-click="azureADAddClntCtrl.createAzureAppFromGlobalLogin()">
													<cv:msg key="label.createApp" bundle="exchange" />
													<i data-ng-if="azureADAddClntCtrl.azureAppCreationInProgress"
														class="fa fa-spinner fa-spin"></i>
												</button>
												<div class="error margin-top-10"
												data-ng-if="azureADAddClntCtrl.globalLoginFailure " 
												ng-bind-html="azureADAddClntCtrl.appCreationErrorResponse"></div>
												
												<div class="cv-help-block margin-top-10" data-ng-if="azureADAddClntCtrl.validationStatusFlags.azureAppIdCreate">
														<cv:msg key="error.azureAppIdCreate" bundle="activeDirectory" /></div>
												
											</div>
									</div>
								</div>
							</div>
						</div>
						<!-- Azure AD App Details After Create-->
						<div ng-if="azureADAddClntCtrl.isAzureAppCreated">
							<div class="form-group">
								<label class="col-xs-12 col-md-3">
									<cv-help-text help-label="label.globalAdministrator" help-text="help.globalAdmin" /></label>
								<div class="col-xs-12 col-md-9">
										<div id="globalAdminUsername" name="globalAdminUsername"
										class="float-left margin-top-10" ng-bind="azureADAddClntCtrl.azureADCrClntProp.globalAdminAccount.adminCredential.userName"></div>				
								</div>
							</div>
							<div class="form-group">
									<label class="col-xs-12 col-md-3">
											<cv:msg key="label.azureApp" bundle="office365" /></label>
									<div class="col-xs-12 col-md-9">
											<div id="globalAppId" name="globalAppId"
											class="float-left margin-top-10" ng-bind="azureADAddClntCtrl.azureLoginInfo.azureDetails.azureAppDisplayName"></div>
									</div>
							</div>
						</div>
						<div class="form-group margin-bottom-20">
							<div class="col-xs-12 col-md-12 margin-top-10">
								<cv-progress-stepper 
									input-model="azureADAddClntCtrl.azureAppStepperModel" 
									progress="azureADAddClntCtrl.appCreationProgress">
								</cv-progress-stepper>
							</div>
							<div class="margin-top-30 col-xs-12 col-md-3" data-ng-show="azureADAddClntCtrl.isAzureAppCreated">
								<a class="small italic float-left" data-ng-click="azureADAddClntCtrl.toggleAzureAppCreationDetails()" data-ng-bind="azureADAddClntCtrl.showHideAzureAppCreationDetails"></a>
							</div>
							<div class="col-xs-12 col-md-12 margin-top-20" data-ng-show="azureADAddClntCtrl.showAzureAppCreationDetails">
								<table class="table table-striped margin-top-10">
									<tbody>
										<!-- App Created --Start -->
										<tr  data-ng-if="azureADAddClntCtrl.isAzureAppCreated">
											<td class="restore-help-text ">
												<cv:msg key="label.appCreatedSuccess" bundle="exchange" />
												<br>
												<span id="globalAppId" name="globalAppId" class="italic font-weight-bold" ng-bind="azureADAddClntCtrl.azureLoginInfo.azureDetails.azureAppDisplayName"></span>
											</td>
											<td class="text-align-center">
												<i class="k-icon k-i-check green-font"></i>
											</td>
										</tr>
										<!-- App Created --Start -->

										<!-- Sync Azure AD App --Start -->
										<tr>
											<td class="restore-help-text">
												<cv:msg key="label.azureSync" bundle="exchange" />
												<div class="orange-font" data-ng-if="azureADAddClntCtrl.azureADAppSyncFailure">
													<br>
													<cv:msg key="label.syncFailureNote" bundle="exchange" />
												</div>
											</td>
											<td class="text-align-center">
												<div data-ng-if="!azureADAddClntCtrl.azureADAppSyncFailure">
													<i data-ng-class="azureADAddClntCtrl.isAzureAppSynced ? 'k-icon k-i-check green-font' : (!azureADAddClntCtrl.startAzureAppSync ? 'k-icon k-i-clock' : 'fa fa-spinner fa-spin')"></i>
												</div>
												<div data-ng-if="azureADAddClntCtrl.azureADAppSyncFailure">
													<i class="k-icon k-i-info"></i>
												</div>
											</td>
										</tr>
										<!-- Sync Azure AD App --End -->

										<!-- Authorize Azure AD App --Start -->
										<tr>
											<td class="restore-help-text ">
												<div data-ng-if="!azureADAddClntCtrl.isAzureAppAuthorized">
													<cv:msg key="label.appPermissions" bundle="exchange" />
												</div>
												<div data-ng-if="azureADAddClntCtrl.isAzureAppAuthorized">
													<cv:msg key="label.permissionsGranted" bundle="exchange" />
												</div>
											</td>
											<td class="text-align-center">
												<div
													data-ng-if="!azureADAddClntCtrl.isAzureAppSynced && !azureADAddClntCtrl.isAzureAppAuthorized && !azureADAddClntCtrl.azureADAppSyncFailure">
													<i class="k-icon k-i-clock"></i>
												</div>
												<div
													data-ng-if="azureADAddClntCtrl.isAzureAppSynced && azureADAddClntCtrl.isAzureAppAuthorized && !azureADAddClntCtrl.azureADAppSyncFailure">
													<i class="k-icon k-i-check green-font"></i>
												</div>
												<div data-ng-if="azureADAddClntCtrl.azureADAppSyncFailure">
													<button id="createAzure365App_button_#1670" class="btn btn-link btn-xs" type="button"
														data-ng-click="azureADAddClntCtrl.authenticateAzureADApp()">
														<cv:msg key="label.authorizeApp" bundle="exchange" />
													</button>
												</div>
												<div data-ng-if="azureADAddClntCtrl.isAzureAppSynced && !azureADAddClntCtrl.isAzureAppAuthorized">
													<button id="createAzure365App_button_#1691" class="btn btn-link btn-xs" type="button"
														data-ng-click="azureADAddClntCtrl.authenticateAzureADApp()">
														<cv:msg key="label.authorizeApp" bundle="exchange" />
													</button>
												</div>
											</td>
										</tr>
										<!-- Authorize Azure AD App --End -->
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
				</div>
			</div>
		</div>
		<div class="button-container">
			<button id="azureADCreateClient_button_#4529"  class="btn btn-primary cvBusyOnAjax" data-ng-disabled=" !( !azureADAddClntCtrl.flagAzureByAppCr || azureADAddClntCtrl.isAzureAppCreated )"> 
				<cv:msg key="action.save" bundle="profiles" /></button>
		</div>
		</form>
	</div>
</div>