<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.activeDirectory"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.devicesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages> 
	<cv:cvMessages bundle="localization.browse"></cv:cvMessages> // for Browse Backup history
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages> // for activity controller
</script>
<div>
	<div class="row">
		<span class="server-message {{azureADClientDetCtrl.pageMessage.type}}">{{azureADClientDetCtrl.pageMessage.message}}</span>
		<div class="col-md-12">
			<h1 class="page-title">
				{{azureADClientDetCtrl.serverName}}
			</h1>
			<span data-ng-if="azureADClientDetCtrl.agentDetails"><a href="" class="page-action-item"  data-ng-click="azureADClientDetCtrl.serverJobs()"><cv:msg key="header.jobs" bundle="activeDirectory" /></a></span>
			<span ng-if="azureADClientDetCtrl.tileLoadFlags.subclientDetails" ><a href="" class="page-action-item"  data-ng-click="azureADClientDetCtrl.backupAzureADClient()"><cv:msg key="action.backup" bundle="serversJs" /></a></span>
		</div>
	</div>
	<div class="row">
		<div class="col-md-6">
			<cv-tile-component  data-title='<cv:msg key="label.general" bundle="activeDirectory" />' loader="azureADClientDetCtrl.tileLoadFlags.subclientDetails">
				<ul class="list-style-secondary">
					<li class="group">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="header.ad.backupSize" bundle="activeDirectory" /></span>
						<span class="pageDetailColumn width-60-percentage">
							<span data-ng-if="!azureADClientDetCtrl.subClientInfo.lastBackupSize" class="text-muted italic" ><cv:msg key="label.notAvailable" bundle="exchange"/> </span>
							<span data-ng-if="azureADClientDetCtrl.subClientInfo.lastBackupSize" data-ng-bind="azureADClientDetCtrl.subClientInfo.lastBackupSize"></span>
						</span>
					</li>
					<li class="group">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.totalbackup.size" bundle="collections" /></span>
						<span class="pageDetailColumn width-60-percentage">
							<span data-ng-if="!azureADClientDetCtrl.subClientInfo.totalBackupSize" class="text-muted italic" ><cv:msg key="label.notAvailable" bundle="exchange"/> </span>
							<span data-ng-if="azureADClientDetCtrl.subClientInfo.totalBackupSize" data-ng-bind="azureADClientDetCtrl.subClientInfo.totalBackupSize"></span>
						</span>
					</li>
					<li class="group">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="header.lastBackup" bundle="devicesJs" /></span>
						<span class="pageDetailColumn width-60-percentage">
							<span data-ng-if="!azureADClientDetCtrl.subClientInfo.lastBackupTime" class="text-muted italic" ><cv:msg key="label.notAvailable" bundle="exchange"/> </span>
							<span data-ng-if="azureADClientDetCtrl.subClientInfo.lastBackupTime" data-ng-bind="azureADClientDetCtrl.subClientInfo.lastBackupTime"></span>
						</span>
					</li>
					<li class="group">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="header.nextBackup" bundle="devicesJs" /></span>
						<span class="pageDetailColumn width-60-percentage">
							<span data-ng-if="!azureADClientDetCtrl.subClientInfo.nextBackupTime" class="text-muted italic" ><cv:msg key="label.notAvailable" bundle="exchange"/> </span>
							<span data-ng-if="azureADClientDetCtrl.subClientInfo.nextBackupTime" data-ng-bind="azureADClientDetCtrl.subClientInfo.nextBackupTime"></span>
						</span>
					</li>
				</ul>
			</cv-tile-component>

			<!-- Begin AD infrastructureSettings -->
			<cv-tile-component data-title='<cv:msg key="label.infrastructureSettings" bundle="activeDirectory" />'	loader="azureADClientDetCtrl.tileLoadFlags.infraSettLoaded"> 
				<ul class="list-style-secondary">
					<!-- Start Server Plan -->
					<li class="group" data-ng-if="azureADClientDetCtrl.showPlan">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.serverPlan" bundle="exchange"/></span>
						<span class="pageDetailColumn width-60-percentage">
							<span class="pageDetailColumn"> <a href="#profileDetails/{{azureADClientDetCtrl.planId}}" data-ng-bind="azureADClientDetCtrl.planName"></a></span>
							<span class="float-right tile-content-link"  data-ng-if="!azureADClientDetCtrl.isOffice365SaaSTenant" >
								<a data-ng-click="azureADClientDetCtrl.editServerPlan(true)">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
						</span>
						<div class="text-muted pageDetailColumn width-60-percentage float-right tile-content-link" data-ng-if="azureADClientDetCtrl.infraStructureSettings.isInfrastructureConfigured">
							<cv:msg key="label.infrastructureInheritedFromPlan" bundle="exchange" />
						</div>
					</li>
					<li class="group" data-ng-if="!azureADClientDetCtrl.showPlan">
						<span class="pageDetailColumn width-40-percentage margin-top-10"><cv:msg key="label.serverPlan" bundle="exchange"/></span>
						<span class="pageDetailColumn width-60-percentage inline-editor">
							<cv-plan-summary-dropdown
								class="full-width"
								input-model="azureADClientDetCtrl.serverPlanList"
								output-model="azureADClientDetCtrl.selectedPlanList"
								button-label="'planName'"
								item-label="'planName'"
								tick-property="'selected'"
								selection-mode="'single'"
								directive-id="'plans'"
								max-labels="1"
								helper-elements="'filter'"
								translation="azureADClientDetCtrl.localLang"
								disable-property="'disabled'">
							</cv-plan-summary-dropdown>
							<span class="inline-editor-buttons">
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="azureADClientDetCtrl.updateServerPlan()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="azureADClientDetCtrl.editServerPlan(false)"><span class="k-icon k-i-x"></span></a>
							</span>
						</span>
					</li>
					<!-- End Server Plan -->
					<div data-ng-if="azureADClientDetCtrl.infrastructureSettingsLoaded && (!azureADClientDetCtrl.infraStructureSettings.isInfrastructureConfigured && !azureADClientDetCtrl.isOffice365SaaSTenant)">
						<!-- Start Index Server -->
						<li class="group" data-ng-if="azureADClientDetCtrl.showIndexServer">
							<cv-help-text  class="pageDetailColumn width-40-percentage" id="indexServerCvSolr" help-label="label.indexServer" help-text="info.indexServerCvSolr" />
							<span class="pageDetailColumn width-60-percentage inline-editor">
								<span class="inline-editor-text" title="{{azureADClientDetCtrl.infraStructureSettings.indexServer.clientName}}" data-ng-bind="azureADClientDetCtrl.infraStructureSettings.indexServer.clientName"></span>
								<span class="float-right tile-content-link" >
									<a data-ng-click="azureADClientDetCtrl.editIndexServer(true)">
										<cv:msg key="label.edit" bundle="clients" />
									</a>
								</span>
							</span>
						</li>

						<li class="group"  data-ng-if="!azureADClientDetCtrl.showIndexServer">
							<cv-help-text  class="pageDetailColumn width-40-percentage" id="indexServerCvSolr" help-label="label.indexServer" help-text="info.indexServerCvSolr" />
							<span class="pageDetailColumn width-60-percentage inline-editor">
								<isteven-multi-select id="indexServer" input-model="azureADClientDetCtrl.indexServersList"
									output-model="azureADClientDetCtrl.selectedIndexList" button-label="clientName"
									item-label="clientName" tick-property="selected" class="isteven-multi-select user-group-select"
									helper-elements="filter" selection-mode="single" translation="azureADClientDetCtrl.localLang" on-item-click="azureADClientDetCtrl.processIndexServerSelection(data)">
								</isteven-multi-select>

								<span class="inline-editor-buttons">
									<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="azureADClientDetCtrl.updateIndexServer()"><span class="k-icon k-i-check"></span></a>
									<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="azureADClientDetCtrl.editIndexServer(false)"><span class="k-icon k-i-x"></span></a>
								</span>
							</span>
						</li>
						<!-- End Index Server -->

						<!-- Start Access Nodes -->
						<li class="group" data-ng-if="azureADClientDetCtrl.showAccessNodes">
							<cv-help-text class="pageDetailColumn width-40-percentage" id="accessNodes" help-label="label.accessNodes" help-text="info.accessNode" />
							<span class="pageDetailColumn width-60-percentage">
								<span class="float-right tile-content-link" >
									<a data-ng-click="azureADClientDetCtrl.editAccessNodes(true)">
										<cv:msg key="label.edit" bundle="clients" />
									</a>
								</span>
								<span class="pageDetailColumn">
									<a ng-repeat="an in azureADClientDetCtrl.infraStructureSettings.accessNodeArray" href="#/clientDetails/{{an.clientId}}" data-ng-bind="an.clientName"></a>
								</span>
							</span>
						</li>
						<li class="group"  data-ng-if="!azureADClientDetCtrl.showAccessNodes">
							<cv-help-text class="pageDetailColumn width-40-percentage" id="accessNodes" help-label="label.accessNodes" help-text="info.accessNode" />
							<span class="pageDetailColumn width-60-percentage inline-editor">
								<isteven-multi-select id="memberServer" input-model="azureADClientDetCtrl.memberServers" output-model="azureADClientDetCtrl.selectedMemberServers"
									button-label="clientName" item-label="clientName" tick-property="selected" class="isteven-multi-select user-group-select"
									helper-elements="filter" selection-mode="single" >
								</isteven-multi-select>

								<span class="inline-editor-buttons">
									<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="azureADClientDetCtrl.updateAccessnodes()"><span class="k-icon k-i-check"></span></a>
									<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="azureADClientDetCtrl.editAccessNodes(false)"><span class="k-icon k-i-x"></span></a>
								</span>
							</span>
						</li>
						<!-- End Access Nodes -->

						<!--  Check Readiness -->
						<li class="group" ng-if="azureADClientDetCtrl.infraStructureSettings.accessNode">
							<span class="pageDetailColumn width-40-percentage">
								<cv:msg key="label.clientReadiness" bundle="clients" />
							</span>
							<span class="pageDetailColumn width-60-percentage client-readiness">
								<span data-ng-if="azureADClientDetCtrl.readinessStatus" >
									<span data-ng-bind="azureADClientDetCtrl.readinessStatus"></span>
									<span data-ng-if="azureADClientDetCtrl.clientReadinessLastCheckedText" class="parenthetical-text last-checked" data-ng-bind="azureADClientDetCtrl.clientReadinessLastCheckedText"></span>
								</span>
								<span data-ng-if="!azureADClientDetCtrl.readinessStatus">
									<cv:msg key="label.notAvailable" bundle="servers" />
								</span>	
								<span class="float-right tile-content-link" >
									<a data-ng-click="azureADClientDetCtrl.onClickShowDetailedReport()" uib-tooltip="<cv:msg key='label.showDetailedClientReadinessReport' bundle='clients' />" tooltip-placement="top"><cv:msg key='label.showDetails' bundle='clients' /></a>
								</span>
							</span>
						</li>
						<!--  End Check Readiness -->
					</div>

				</ul>
			</cv-tile-component>
			<!-- End AD infrastructureSettings-->
		
			<!-- Begin Azure AD Connection Settings -->
			<cv-tile-component data-title='<cv:msg key="label.connectionSettings" bundle="activeDirectory" />' loader="azureADClientDetCtrl.tileLoadFlags.connSettLoaded">
			 <ul class="list-style-secondary">
				 <li class="group" >
					 <span class="pageDetailColumn width-40-percentage"><cv:msg key="label.region" bundle="activeDirectory" /></span>
					 <span class="pageDetailColumn width-60-percentage" data-ng-bind="azureADClientDetCtrl.msCloudRegionsStrDisp"></span>
				 </li>
				 <!-- service accounts not reuired. <li class="group" >
					 <span class="pageDetailColumn"><cv:msg key="label.addServiceAccount" bundle="activeDirectory" /></span>
					 <span class="pageDetailColumn" data-ng-bind="azureADClientDetCtrl.serviceAccountUserName"></span>
				 </li> -->
				 <li class="group" >
					 <span class="pageDetailColumn width-40-percentage"><cv:msg key="label.azureAppId" bundle="activeDirectory" /></span>
					 <span class="pageDetailColumn width-60-percentage" data-ng-bind="azureADClientDetCtrl.azureDetails.azureAppId"></span>
				 </li>
				 <li class="group" >
					 <span class="pageDetailColumn width-40-percentage"><cv:msg key="label.azureDirectoryId" bundle="activeDirectory" /></span>
					 <span class="pageDetailColumn width-60-percentage" data-ng-bind="azureADClientDetCtrl.azureDetails.azureDirectoryId"></span>
				 </li>
			 </ul>
			 <div class="page-details-box-links">
				 <a href="" data-ng-click="azureADClientDetCtrl.openAzureEditConnSet()"><cv:msg
						 key="action.edit" bundle="activeDirectory" /> </a>
			 </div>
		 </cv-tile-component>
		 <!-- End Azure AD Connection Settings-->
		  <!-- Begin Activity Control -->
		  <cv-activity-control-component data-ac-params="azureADClientDetCtrl.acParams"></cv-activity-control-component>
		  <!-- End Activity Control -->
		</div>
		<div class="col-md-6">
			<cv-backup-history entity="azureADClientDetCtrl.backupEntity" show-legend="'true'" params="azureADClientDetCtrl.historyParams"  on-restore="azureADClientDetCtrl.restoreAzureADClient(job, fromTimeStr, toTimeStr)" ></cv-backup-history>
			<span>
				<cv-security-component entity-type='azureADClientDetCtrl.entityType' generic-entity='azureADClientDetCtrl.genericEntity' associations='azureADClientDetCtrl.formattedSecurityAssociations' associations-loaded='azureADClientDetCtrl.tileLoadFlags.associationsLoaded'>
				</cv-security-component>
			</span>
			
			
		</div>
	</div>
</div>
