<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.activeDirectory"></cv:cvMessages>
    <cv:cvMessages bundle="localization.restore"></cv:cvMessages>
    <cv:cvMessages bundle="localization.browseJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.browse"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="row">
    <div class="col-xs-12">
        <h1 class="page-title margin-bottom-0">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 18 18" width="30px" height="30px" style="vertical-align:middle;">
                <defs>
                    <linearGradient id="azureADBrowseCtrla" x1="13.25" y1="13.02" x2="8.62" y2="4.25" gradientUnits="userSpaceOnUse">
                        <stop offset="0" stop-color="#1988d9"/>
                        <stop offset=".9" stop-color="#54aef0"/>
                    </linearGradient>
                    <linearGradient id="azureADBrowseCtrlb" x1="11.26" y1="10.47" x2="14.46" y2="15.99" gradientUnits="userSpaceOnUse">
                        <stop offset=".1" stop-color="#54aef0"/>
                        <stop offset=".29" stop-color="#4fabee"/>
                        <stop offset=".51" stop-color="#41a2e9"/>
                        <stop offset=".74" stop-color="#2a93e0"/>
                        <stop offset=".88" stop-color="#1988d9"/>
                    </linearGradient>
                </defs>
                <path fill="#50e6ff" d="M1.01 10.19l7.92 5.14 8.06-5.16L18 11.35l-9.07 5.84L0 11.35l1.01-1.16z"/>
                <path fill="#fff" d="M1.61 9.53L8.93.81l7.47 8.73-7.47 4.72-7.32-4.73z"/>
                <path fill="#50e6ff" d="M8.93.81v13.45L1.61 9.53 8.93.81z"/>
                <path fill="url(#azureADBrowseCtrla)" d="M8.93.81v13.45l7.47-4.72L8.93.81z"/>
                <path fill="#53b1e0" d="M8.93 7.76l7.47 1.78-7.47 4.72v-6.5z"/>
                <path fill="#9cebff" d="M8.93 14.26L1.61 9.53l7.32-1.77v6.5z"/>
                <path fill="url(#azureADBrowseCtrlb)" d="M8.93 17.19L18 11.35l-1.01-1.18-8.06 5.16v1.86z"/>
            </svg>
            <cv:msg key="label.backupContent" bundle="restore" />
        </h1>

        <div class="uib-dropdown browseFolderDropDown dropdown cv-k-header-dropdown" data-uib-dropdown="" data-ng-show="azureADBrowseCtrl.azureADAppObjs.length > 0"> 
            <a id="browseFolderDropdownId" class="uib-dropdown-toggle dropdown-toggle" data-uib-dropdown-toggle="" aria-haspopup="true" aria-expanded="false">
                <span ng-bind="azureADBrowseCtrl.activeAzureADObjName"></span> <span class="dropdownArrow right"></span>
            </a>
            <ul class="dropdown-menu cv-dropdown-style-2 margin-top-5" uib-dropdown-menu aria-labelledby="browseFolderDropdownId">
                <li ng-repeat="adObj in azureADBrowseCtrl.azureADAppObjs" class="server-list" data-ng-if="adObj.NonRestorable == false || azureADBrowseCtrl.toggleShowNonRestoreItem" data-ng-click="azureADBrowseCtrl._performBrowse($index)" data-ng-class="{selected:  $index != azureADBrowseCtrl.fetchADObjIndex}" ng-bind-html="adObj.template" compile-template>
                </li>
            </ul>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-sm-12 col-xs-12 col-md-12 col-lg-12">
            <div class="margin-bottom-10" data-ng-show="azureADBrowseCtrl.showAfterGridInit">
                <div ng-class="azureADBrowseCtrl.showPropPan?  'col-md-7 col-sm-12' : 'col-md-7 col-sm-12'">
                    <div>
                        <div class="inline-block margin-top-20"  data-ng-if="!azureADBrowseCtrl.flagForRestoreAllMatching" ng-disabled="azureADBrowseCtrl.disableRestoreBtn || azureADBrowseCtrl.restoreInProgress" >
                            <a href id="restoreDropdown"  ng-click="azureADBrowseCtrl._onRestore()"  ng-disabled="azureADBrowseCtrl.disableRestoreBtn || azureADBrowseCtrl.restoreInProgress">
                                <svg version="1.1" class="svg-primary-fill" width="15" height="15" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 448 448" xml:space="preserve" style="vertical-align: middle;">
                                    <g>
                                        <path d="M256,32C149.973,32,64,117.973,64,224H0l85.333,85.333L170.667,224h-64c0-82.453,66.88-149.333,149.333-149.333S405.333,141.547,405.333,224S338.453,373.333,256,373.333c-32.32,0-62.08-10.347-86.613-27.84L139.2,376.107C171.627,401.067,212.053,416,256,416c106.027,0,192-85.973,192-192S362.027,32,256,32z"></path>
                                        <path d="M298.667,224c0-23.573-19.093-42.667-42.667-42.667S213.333,200.427,213.333,224s19.093,42.667,42.667,42.667S298.667,247.573,298.667,224z"></path>
                                    </g>
                                </svg> <cv:msg key="label.restore" bundle="activeDirectory" />  <i data-ng-if="azureADBrowseCtrl.restoreInProgress" 
                                class="fa fa-spinner fa-spin"></i>
                            </a>
                        </div>

                        <div class="inline-block margin-top-20" uib-dropdown data-ng-if="azureADBrowseCtrl.flagForRestoreAllMatching" >
                            <a href id="restoreDropdown" uib-dropdown-toggle>
                                <svg version="1.1" class="svg-primary-fill" width="15" height="15" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 448 448" xml:space="preserve" style="vertical-align: middle;">
                                    <g>
                                        <path d="M256,32C149.973,32,64,117.973,64,224H0l85.333,85.333L170.667,224h-64c0-82.453,66.88-149.333,149.333-149.333S405.333,141.547,405.333,224S338.453,373.333,256,373.333c-32.32,0-62.08-10.347-86.613-27.84L139.2,376.107C171.627,401.067,212.053,416,256,416c106.027,0,192-85.973,192-192S362.027,32,256,32z"></path>
                                        <path d="M298.667,224c0-23.573-19.093-42.667-42.667-42.667S213.333,200.427,213.333,224s19.093,42.667,42.667,42.667S298.667,247.573,298.667,224z"></path>
                                    </g>
                                </svg> <cv:msg key="label.restore" bundle="activeDirectory" /> <span class="caret"></span>
                            </a>
                            <ul class="dropdown-menu-right cv-dropdown-style-2 margin-top-5" uib-dropdown-menu aria-labelledby="restoreDropdown"   data-ng-if="azureADBrowseCtrl.flagForRestoreAllMatching">
                                <li><a ng-click="azureADBrowseCtrl._onRestore()"><cv:msg key="label.restoreSelectedItems" bundle="activeDirectory" /></a></li>
                                <li><a ng-click="azureADBrowseCtrl._onRestore(true)"><cv:msg key="label.restoreItemsAcrossPages" bundle="activeDirectory" /></a></li>                
                            </ul>
                        </div>

                        <div class="azurebrowseAction inline-block float-right margin-top-20" data-ng-show="azureADBrowseCtrl.azureADAppObjs.length > 0">
                            <span data-uib-dropdown class="uib-dropdown">
                                <a href id="azurebrowseActionDropdown" class="uib-dropdown-toggle" data-uib-dropdown-toggle>
                                    <svg width="20" height="20" fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M10.1 0C4.6-.1.1 4.4 0 9.9s4.4 10 9.9 10.1 10-4.4 10.1-9.9v-.2C19.9 4.5 15.5.1 10.1 0zm0 18.9c-5 0-9-4-9-9s4-9 9-9 9 4 9 9-4 9-9 9z"></path><path d="M6.1 8.8h2v2h-2zM9.1 8.8h2v2h-2zM12.1 8.8h2v2h-2z"></path></svg>
                                </a>
                                <ul class="dropdown-menu cv-dropdown-style-2 margin-top-5" uib-dropdown-menu aria-labelledby="azurebrowseActionDropdown">
                                    <li data-ng-if="azureADBrowseCtrl.toggleShowDeletedItemsOnly == false"><a href="" data-ng-click="azureADBrowseCtrl._showHideDeletedFiles()">
                                        <span data-ng-hide="azureADBrowseCtrl.toggleShowDeletedFiles"> <cv:msg key="label.showDeletedFiles" bundle="activeDirectory" /> </span>
                                        <span data-ng-show="azureADBrowseCtrl.toggleShowDeletedFiles"> <cv:msg key="label.hideDeletedFiles" bundle="activeDirectory" /> </span></a>
                                    </li>
                                    
                                    <li>
                                        <a href="" data-ng-click="azureADBrowseCtrl._showHideOnlyDeletedItems();">
                                            <span data-ng-hide="azureADBrowseCtrl.toggleShowDeletedItemsOnly"><cv:msg key="label.showOnlyDeletedItems" bundle="activeDirectory" /></span>
                                            <span data-ng-show="azureADBrowseCtrl.toggleShowDeletedItemsOnly"><cv:msg key="label.hideOnlyDeletedItems" bundle="activeDirectory" /></span>
                                        </a>
                                    </li>

                                    <li data-ng-if="azureADBrowseCtrl.showMenuIncludeNonRestoreItem">
                                        <a href="" data-ng-click="azureADBrowseCtrl._showHideIncludeFiles()">
                                            <span data-ng-hide="azureADBrowseCtrl.toggleShowNonRestoreItem"> <cv:msg key="label.includeNonRestoreItem" bundle="activeDirectory" /></span>
                                            <span data-ng-show="azureADBrowseCtrl.toggleShowNonRestoreItem"><cv:msg key="label.hideNonRestoreItem" bundle="activeDirectory" /></span>
                                        </a>
                                    </li>
                                </ul>
                            </span>
                        </div>
                        <div class="inline-block float-right margin-top-20 margin-right-15" uib-dropdown>
                            <a href id="azureADTimeRangeDropdown" uib-dropdown-toggle>
                                <span ng-bind="azureADBrowseCtrl.timeRangeLabel"></span> <span class="caret"></span>
                            </a>
                            <ul class="dropdown-menu cv-dropdown-style-2 azureADBrowseTimeRangeDropdown margin-top-5" uib-dropdown-menu aria-labelledby="azureADTimeRangeDropdown">
                                <li><a href=""
                                    data-ng-click="azureADBrowseCtrl._resetTimeRange()"><cv:msg
                                            key="Show_latest_backups" bundle="browse" /></a></li>
                                <li data-cv-date-time
                                    data-heading-label='<cv:msg key="label.toTime" bundle="messages"></cv:msg>'
                                    data-show-from-time="false"
                                    data-result-function="azureADBrowseCtrl._updateTimeRange"><a
                                    href=""><cv:msg key="Show_backups_specific_date"
                                            bundle="browse" /></a></li>
                                <li data-cv-date-time
                                    data-heading-label='<cv:msg key="label.toTime" bundle="messages"></cv:msg>'
                                    data-show-from-time="true"
                                    data-result-function="azureADBrowseCtrl._updateTimeRange"><a
                                    href=""><cv:msg key="Show_backups_date_range" bundle="browse" /></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div ng-class="azureADBrowseCtrl.showPropPan?  'col-md-5 col-sm-12' : 'col-md-5 col-sm-12'">
                    <form ng-submit="azureADBrowseCtrl._filterGrid();">
                        <div uib-dropdown auto-close="disabled" is-open="azureADBrowseCtrl.azureSearchBoxIsOpen" class="azureSearchBox search-widget-wrapper" on-toggle="azureADBrowseCtrl._getInputFocus(open);">
                            <div class="azureSearchBox-icon">
                                <i class="fa fa-search" aria-hidden="true"></i>
                            </div>
                            <input type="text" class="azureSearch-field"
                                ng-model-options="{ updateOn: 'blur' }"
                                data-uib-dropdown-toggle 
                                ng-model="azureADBrowseCtrl.filterQueryStr"
                                placeholder="{{azureADBrowseCtrl.searchForFolderName}}" readonly />
                            <span class="form-control-clear fa fa-times fa-lg text-danger text-danger" ng-click="azureADBrowseCtrl._clearSearchField();" data-uib-tooltip="<cv:msg key='label.clear' bundle='search'></cv:msg>" ng-show="azureADBrowseCtrl.filterQueryStr.length" ></span>
                            <div class="dropdown-menu margin-top-5" uib-dropdown-menu>
                                <!-- this is start -->
                                <div class="panel margin-10">
                                        <div class="row">
                                            <div class="azureSearchBox-label col-md-3">
                                                <i class="fa fa-search icon" aria-hidden="true"></i> <cv:msg key="label.searchAll" bundle="activeDirectory" /> 
                                            </div>
                                            <div class="col-md-9">
                                                <input id="searchAllInp" data-ng-model="azureADBrowseCtrl.browserFilterArr.Contains_File" type="text" name="Contains_File" id="Contains_File" ng-change="azureADBrowseCtrl._updateFilterQuery();" autofocus />
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="azureSearchBox-label col-md-3">
                                                <i class="fa fa-tag icon" aria-hidden="true"></i> <cv:msg key="label.azureADId" bundle="activeDirectory" />
                                            </div>
                                            <div class="col-md-9">
                                                <input data-ng-model="azureADBrowseCtrl.browserFilterArr.AzureADId" type="text" name="azureADId" id="azureADId" ng-change="azureADBrowseCtrl._updateFilterQuery();" />
                                            </div>
                                        </div>
                                         <!-- Hidden on request of patrick.  
                                        <div>  
                                            <label>
                                                <cv:msg key="label.azureADDisplayName" bundle="activeDirectory" /> </label>
                                            <div>
                                                <div>
                                                    <input data-ng-model="azureADBrowseCtrl.browserFilterArr.AzureADDisplayName" class="" type="text" name="AzureADDisplayName" id="AzureADDisplayName"  ng-change="azureADBrowseCtrl._updateFilterQuery();" />
                                                </div>
                                            </div>
                                        </div>
                                        <div ng-if="(azureADBrowseCtrl.azureADBrowseObjectType ==azureADBrowseCtrl.AD_CONSTANTS.AzureADObjectType.USER) || (azureADBrowseCtrl.azureADBrowseObjectType ==azureADBrowseCtrl.AD_CONSTANTS.AzureADObjectType.GROUP )"> 
                                        <label>
                                            <cv:msg key="label.azureADMail" bundle="activeDirectory" /> </label>
                                            <div>
                                                <div>
                                                    <input data-ng-model="azureADBrowseCtrl.browserFilterArr.AzureADMail" class="" type="text" name="AzureADMail" id="AzureADMail" ng-change="azureADBrowseCtrl._updateFilterQuery();" />
                                                </div>
                                            </div>
                                        
                                        </div> -->
                                        <div class="row" ng-if="(azureADBrowseCtrl.azureADBrowseObjectType ==azureADBrowseCtrl.AD_CONSTANTS.AzureADObjectType.USER )|| (azureADBrowseCtrl.azureADBrowseObjectType ==azureADBrowseCtrl.AD_CONSTANTS.AzureADObjectType.GROUP) ">
                                            <div class="azureSearchBox-label col-md-3">
                                                <i class="fa fa-map-marker icon" aria-hidden="true"></i> <cv:msg key="label.azureADSourceType" bundle="activeDirectory" />
                                            </div>
                                            <div class="col-md-9">
                                                <isteven-multi-select  html-template="true" id="azureADSourceType" input-model="azureADBrowseCtrl.azureADSourceTypeInput" output-model="azureADBrowseCtrl.azureADSourceTypeOutput"
                                                button-label="sourceType" item-label="template" tick-property="selected" class="isteven-multi-select single-select isteven-summary-dropdown"
                                                helper-elements="none" selection-mode="single" on-item-click="azureADBrowseCtrl._updateFilterQuery();">
                                            </isteven-multi-select>
                                            </div>
                                        </div>

                                <!-- this is end -->
                                <div class="col-md-12 col-xs-12 margin-top-10 ">
                                    <div class="azureSearchBox-buttons">
                                        <a id="reset" class="reset" data-ng-click="azureADBrowseCtrl._clearSearchField();">
                                            <cv:msg key="label.reset" bundle="messages" />
                                        </a>
                                        <button id="submit" class="submit btn-primary cvBusyOnAjax"  data-ng-class="{'busy':loading}" type="submit">
                                            <cv:msg key="label.search" bundle="messages" />
                                        </button>
                                    </div>
                                </div>
                            </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            
            <div ng-class="azureADBrowseCtrl.showPropPan?  'col-md-7' : 'col-md-12'">
                <div data-ng-show="azureADBrowseCtrl.showAfterGridInit || azureADBrowseCtrl.showEmptyGrid">
                    <cv-kendo-grid data-cv-grid-options="azureADBrowseCtrl.gridOptions"></cv-kendo-grid>
                </div>
                <div data-ng-hide="azureADBrowseCtrl.showAfterGridInit || azureADBrowseCtrl.showEmptyGrid" class="text-center">
                    <h3>  <cv:msg key="label.loading" bundle="activeDirectory" /> </h3>
                </div>
            </div>
            <div ng-class="azureADBrowseCtrl.showPropPan? 'col-md-5': 'hide'" style="border-left: 1px solid #ddd;">
                <uib-tabset active="azureADBrowseCtrl.showPropPanTabs" justified="true">
                    <uib-tab index="0" heading='<cv:msg key="label.objectProperties" bundle="activeDirectory" />'>
                        <cv-kendo-grid data-cv-grid-options="azureADBrowseCtrl.azureADPropgridOptions" ng-show="azureADBrowseCtrl.showPropPan"></cv-kendo-grid>
                        <div class="margin-top-15">
                            <a data-ng-if="!azureADBrowseCtrl.flagLoadMoreData" data-ng-click="azureADBrowseCtrl._copyBrowsePropToClip();"> <i class="fa fa-copy" aria-hidden="true"></i> <cv:msg key="label.copytoClipboard" bundle="activeDirectory" ></cv:msg> </a>
                            <span class="float-right ">
                                <a data-ng-click="azureADBrowseCtrl._getAzureADPropMore()" class="margin-right-10"> <i class="fa fa-eye" aria-hidden="true"></i> <cv:msg key="label.viewProperties" bundle="activeDirectory" /></a> <a ng-href="{{azureADBrowseCtrl.downloadOption}}"> <i class="fa fa-download" aria-hidden="true"></i> <cv:msg key="label.downloadProperties" bundle="activeDirectory" /> </a>
                            </span>
                        </div>
                        <div class="azureADBrowseViewProperties">
                            <pre ng-bind-html="azureADBrowseCtrl.azurePropMoreDataToDisp" data-ng-if="!azureADBrowseCtrl.flagLoadMoreData" ></pre>
                        </div>
                    </uib-tab>
                    <!-- <uib-tab index="1" heading="Membership" select="azureADBrowseCtrl._getMembershipDetails()">
                        <cv-advanced-tree cvparams="azureADBrowseCtrl.treeInput" class="advanced-tree"></cv-advanced-tree> 
                        <cv-kendo-grid data-cv-grid-options="azureADBrowseCtrl.azureADMembergridOptions" class="azureADBrowseMemberDetails"></cv-kendo-grid>
                    </uib-tab> -->
                </uib-tabset>
            </div>
    </div>
</div>