<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.activeDirectory"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.ad.settings.header" bundle="activeDirectory"/></h1>
</div>
<div class="setup-content schedule bootstrap-wrapper">
	<div class="{{adCredentialsController.adCredentialsControllerMessage.type}} serverMessage">{{adCredentialsController.adCredentialsControllerMessage.message}}</div>
	<form name="editCredentials" data-cv-submit="adCredentialsController.saveInfo()" novalidate autocomplete="off" class="form-horizontal">
		<div class="panel">
			<div class="panel-body">
				<div class="form-group">
					<label id="userAccountLbl" for="adUserAccount" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.userAccount" bundle="activeDirectory" /></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input type="text" name="adUserAccount" id="adUserAccount" data-ng-class="text-right" autofocus data-ng-model="adCredentialsController.credentialsForBackup.accountName" required/>
						<span class="help-block" data-ng-show="cv.editCredentials.needsAttention(editCredentials.adUserAccount)"><cv:msg key="error.ad.user.account" bundle="activeDirectory" /></span>
					</div>
				</div>
				<div class="form-group">
					<label id="userPasswordLbl" for="userPassword" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.password" bundle="users"/></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input type="password" name="userPassword" id="userPassword" data-ng-class="text-right" data-ng-model="adCredentialsController.credentialsForBackup.userPassword" required/>
						<span class="help-block" data-ng-show="cv.editCredentials.needsAttention(editCredentials.userPassword)" ><cv:msg key="error.password" bundle="users"/></span>
					</div>
				</div>
				<div class="form-group">
					<label id="adUserConfirmPasswordLbl" for="adUserConfirmPassword" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.confirmPassword" bundle="users"/></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input type="password" name="adUserConfirmPassword" id="adUserConfirmPassword" data-ng-class="text-right"
							data-ng-model="adCredentialsController.credentialsForBackup.adUserConfirmPassword"
							data-cv-equals="{{adCredentialsController.credentialsForBackup.userPassword}}" required/>
						<span class="help-block" data-ng-show="editCredentials.adUserConfirmPassword.$error.required && cv.editCredentials.needsAttention(editCredentials.adUserConfirmPassword)">
							<cv:msg key="error.confirmPassword" bundle="users" />
						</span>
						<span class="help-block" data-ng-show="!editCredentials.adUserConfirmPassword.$error.required && editCredentials.adUserConfirmPassword.$error.cvEquals && cv.editCredentials.needsAttention(editCredentials.adUserConfirmPassword)">
							<cv:msg key="error.mismatchedPassword" bundle="users" />
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="adCredentialsController.showPlanEdit">
					<label id="plan" for="plan" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.profile" bundle="profiles"/></label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<isteven-multi-select
								id="plan"
								input-model="adCredentialsController.planList"
								output-model="adCredentialsController.selectedPlan"
								button-label="planName"
								item-label="planName"
								tick-property="selected"
								class="isteven-multi-select user-group-select"
								helper-elements="none"
								selection-mode="single"
								translation="adCredentialsController.localLang"
								group-property="msGroup">
							</isteven-multi-select>
						</div>
						<span class="help-block" data-ng-show="adCredentialsController.validationStatusFlags.planRequired"><cv:msg key="error.selectPlan" bundle="profiles" /></span>
					</label>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button id="adCredentials_button_#0368" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="adCredentialsController.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
			<button id="adCredentials_button_#9977" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" bundle="messages"/></button> 
		</div>
	</form>
</div>