<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
    <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
    <cv:cvMessages bundle="localization.storage"></cv:cvMessages>
      <cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.activeDirectory"></cv:cvMessages>
    <cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
    <cv:cvMessages bundle="localization.devicesJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.collections"></cv:cvMessages>
</script>
<div data-ng-controller="adClientDetailsController as adClientDetCtrl">
    <div class="row">
        <%-- This is the page message to display any error --%>
    	<span class="server-message {{adClientDetCtrl.pageMessage.type}}">{{adClientDetCtrl.pageMessage.message}}</span>
        <div class="col-md-12">
        	<h1 class="page-title">
                {{adClientDetCtrl.serverName}}
            </h1>
            <span data-ng-if="adClientDetCtrl.agentDetails"><a href="" class="page-action-item"  data-ng-click="adClientDetCtrl.serverJobs()"><cv:msg key="header.jobs" bundle="exchange" /></a></span>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <!-- Begin Activity Control -->
                <cv-activity-control-component data-ac-params="adClientDetCtrl.acParams"></cv-activity-control-component>
            <!-- End Activity Control -->
            <!-- Begin AD Credentials -->
			<cv-tile-component data-ac-id="activeDirectoryDetails-account" data-title='<cv:msg key="header.ad.settings" bundle="activeDirectory"/>' data-loader="!adClientDetCtrl.showLoaderADClientInfo">
				<div>
					<ul class="list-style-secondary">
						<li class="group"><span class="pageDetailColumn"><cv:msg key="label.userAccount" bundle="activeDirectory" /></span>
							<span class="pageDetailColumn" data-ng-bind="adClientDetCtrl.agentDetails.granularADProperties.granularADAccount.userName"></span></li>
					</ul>
					<ul class="list-style-secondary">
						<li class="group"><span class="pageDetailColumn"><cv:msg key="header.ad.Plan" bundle="activeDirectory" /></span>
							<span class="pageDetailColumn" data-ng-bind="adClientDetCtrl.selectedPlan.planName"></span></li>
					</ul>
					<div class="page-details-box-links">
	  				 	<a href="" data-ng-click="adClientDetCtrl.changeADCredentials()"><cv:msg key="action.change.account" bundle="activeDirectory" /></a>
	 				</div>
				</div>
			</cv-tile-component>
			<!-- End AD Credentials-->
        </div>
        <div class="col-md-6">
			<span data-ng-if="adClientDetCtrl.associationsLoaded">
                <cv-security-component entity-type='adClientDetCtrl.entityType' generic-entity='adClientDetCtrl.genericEntity' associations='adClientDetCtrl.formattedSecurityAssociations' associations-loaded='adClientDetCtrl.associationsLoaded' data-show-Owners='true'>
                </cv-security-component>
            </span>
        </div>
    </div>
	<div class="row">
        <div class="col-md-12" data-ng-if="adClientDetCtrl.loadSCList" >
            <cv-kendo-grid data-cv-grid-options="gridOptions"></cv-kendo-grid>
        </div>
    </div>
</div>