/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import com.oracle.truffle.js.runtime.JSRealm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ForeignObjectPrototypeNode.class)
public final class ForeignObjectPrototypeNodeGen
extends ForeignObjectPrototypeNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_;
    @Node.Child
    private TruffleObject0Data truffleObject0_cache;

    private ForeignObjectPrototypeNodeGen() {
    }

    @Override
    @ExplodeLoop
    public DynamicObject executeDynamicObject(Object arg0Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0) {
                TruffleObject0Data s1_ = this.truffleObject0_cache;
                while (s1_ != null) {
                    if (s1_.interop_.accepts(arg0Value)) {
                        TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                        JSRealm realm__ = (JSRealm)javaScriptLanguageContextReference__.get();
                        return this.doTruffleObject(arg0Value, realm__, s1_.interop_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                return this.truffleObject1Boundary(state, arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private DynamicObject truffleObject1Boundary(int state, Object arg0Value) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
            JSRealm truffleObject1_realm__ = (JSRealm)javaScriptLanguageContextReference__1.get();
            InteropLibrary truffleObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
            DynamicObject dynamicObject = this.doTruffleObject(arg0Value, truffleObject1_realm__, truffleObject1_interop__);
            return dynamicObject;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObject executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            DynamicObject dynamicObject;
            JSRealm realm__ = null;
            if (exclude == 0) {
                TruffleLanguage.ContextReference javaScriptLanguageContextReference__3;
                int count1_ = 0;
                TruffleObject0Data s1_ = this.truffleObject0_cache;
                if ((state & 1) != 0) {
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(arg0Value)) {
                            TruffleLanguage.ContextReference javaScriptLanguageContextReference__2 = this.javaScriptLanguageContextReference_;
                            if (javaScriptLanguageContextReference__2 == null) {
                                this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__2 = super.lookupContextReference(JavaScriptLanguage.class);
                            }
                            realm__ = (JSRealm)javaScriptLanguageContextReference__2.get();
                            break;
                        }
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && count1_ < 3) {
                    s1_ = (TruffleObject0Data)super.insert((Node)new TruffleObject0Data(this.truffleObject0_cache));
                    javaScriptLanguageContextReference__3 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__3 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__3 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    realm__ = (JSRealm)javaScriptLanguageContextReference__3.get();
                    s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create(arg0Value));
                    this.truffleObject0_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    javaScriptLanguageContextReference__3 = this.doTruffleObject(arg0Value, realm__, s1_.interop_);
                    return javaScriptLanguageContextReference__3;
                }
            }
            InteropLibrary truffleObject1_interop__ = null;
            JSRealm truffleObject1_realm__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                TruffleLanguage.ContextReference javaScriptLanguageContextReference__4 = this.javaScriptLanguageContextReference_;
                if (javaScriptLanguageContextReference__4 == null) {
                    this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__4 = super.lookupContextReference(JavaScriptLanguage.class);
                }
                truffleObject1_realm__ = (JSRealm)javaScriptLanguageContextReference__4.get();
                truffleObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                this.exclude_ = exclude |= 1;
                this.truffleObject0_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                dynamicObject = this.doTruffleObject(arg0Value, truffleObject1_realm__, truffleObject1_interop__);
            }
            catch (Throwable throwable) {
                encapsulating_.set(prev_);
                throw throwable;
            }
            encapsulating_.set(prev_);
            return dynamicObject;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        TruffleObject0Data s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.truffleObject0_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[3];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doTruffleObject";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            TruffleObject0Data s1_ = this.truffleObject0_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.interop_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doTruffleObject";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new Object[0]));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static ForeignObjectPrototypeNode create() {
        return new ForeignObjectPrototypeNodeGen();
    }

    @GeneratedBy(value=ForeignObjectPrototypeNode.class)
    private static final class TruffleObject0Data
    extends Node {
        @Node.Child
        TruffleObject0Data next_;
        @Node.Child
        InteropLibrary interop_;

        TruffleObject0Data(TruffleObject0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

