/*
 * Decompiled with CFR 0.152.
 */
package net.sf.packtag.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileFetcher {
    private final boolean includeSubdirectories;
    private final String resourceExtension;
    private final String contextPath;

    public FileFetcher(boolean includeSubdirectories, String resourceExtension, String contextPath) {
        this.includeSubdirectories = includeSubdirectories;
        this.resourceExtension = resourceExtension;
        this.contextPath = contextPath;
    }

    private void determineFiles(File contextRootDirectory, File directory, List resources) {
        File[] files = directory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith("." + FileFetcher.this.getResourceExtension()) || pathname.isDirectory();
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory() && this.isIncludeSubdirectories()) {
                    this.determineFiles(contextRootDirectory, files[i], resources);
                    continue;
                }
                if (!files[i].isFile()) continue;
                String fileAbsolute = files[i].getAbsolutePath();
                String fileContextless = fileAbsolute.substring(contextRootDirectory.getAbsolutePath().length(), fileAbsolute.length());
                fileContextless = fileContextless.replaceAll("\\\\", "/");
                resources.add(this.getContextPath() + fileContextless);
            }
        }
    }

    public List fetchFiles(File contextRootDirectory, File startDirectory) {
        ArrayList files = new ArrayList();
        this.determineFiles(contextRootDirectory, startDirectory, files);
        Collections.sort(files);
        return files;
    }

    public boolean isIncludeSubdirectories() {
        return this.includeSubdirectories;
    }

    public String getResourceExtension() {
        return this.resourceExtension;
    }

    public String getContextPath() {
        return this.contextPath;
    }
}

