/*
 * Decompiled with CFR 0.152.
 */
package net.sf.packtag.tag;

import javax.servlet.jsp.JspWriter;
import net.sf.packtag.implementation.JsminPackStrategy;
import net.sf.packtag.strategy.PackStrategy;
import net.sf.packtag.tag.PackTag;

public class ScriptTag
extends PackTag {
    private static final long serialVersionUID = -5324074433734258409L;
    private static final String STRATEGY_NAME_JAVASCRIPT = "script";
    private static final String SCRIPT_START = "<script type=\"text/javascript\" src=\"";
    private static final String SCRIPT_END_SOLO = "</script>";
    private static final String SCRIPT_SRC_END = "\"";
    private static final String ATTRIBUTE_ASYNC = "async";
    private static final String ATTRIBUTE_DEFER = "defer";
    private static final String OUTPUT_CHARSET = " charset=\"utf-8\"";
    private static final String OUTPUT_ASYNC_XHTML = " async=\"async\"";
    private static final String OUTPUT_DEFER_XHTML = " defer=\"defer\"";
    private static final String OUTPUT_ASYNC_HTML5 = " async";
    private static final String OUTPUT_DEFER_HTML5 = " defer";
    private static final String SCRIPT_END = "></script>";
    private static final String MIME_TYPE_JAVASCRIPT = "text/javascript";
    private static final String EXTENSION_JAVASCRIPT = "js";
    private Boolean async = Boolean.FALSE;
    private Boolean defer = Boolean.FALSE;

    protected void writeResouce(JspWriter writer, String path) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append(SCRIPT_START);
        buffer.append(path);
        buffer.append(SCRIPT_SRC_END);
        if (this.isEnabled()) {
            buffer.append(OUTPUT_CHARSET);
        }
        if (Boolean.TRUE.equals(this.isAsync())) {
            if (this.isScriptAsyncdeferXhtml()) {
                buffer.append(OUTPUT_ASYNC_XHTML);
            } else {
                buffer.append(OUTPUT_ASYNC_HTML5);
            }
        }
        if (Boolean.TRUE.equals(this.isDefer())) {
            if (this.isScriptAsyncdeferXhtml()) {
                buffer.append(OUTPUT_DEFER_XHTML);
            } else {
                buffer.append(OUTPUT_DEFER_HTML5);
            }
        }
        buffer.append(SCRIPT_END);
        writer.write(buffer.toString());
    }

    public Boolean isAsync() {
        return this.async;
    }

    public void setAsync(String async) {
        this.async = this.isStandardTaglibAvailable() ? new Boolean((String)this.evaluate(ATTRIBUTE_ASYNC, async, String.class)) : new Boolean(async);
    }

    public Boolean isDefer() {
        return this.defer;
    }

    public void setDefer(String defer) {
        this.defer = this.isStandardTaglibAvailable() ? new Boolean((String)this.evaluate(ATTRIBUTE_DEFER, defer, String.class)) : new Boolean(defer);
    }

    protected String getStrategyName() {
        return STRATEGY_NAME_JAVASCRIPT;
    }

    protected PackStrategy getResourceDefaultStrategy() {
        return new JsminPackStrategy();
    }

    protected String getResourceExtension() {
        return EXTENSION_JAVASCRIPT;
    }

    protected String getMimeType() {
        return MIME_TYPE_JAVASCRIPT;
    }
}

