/*
 * Decompiled with CFR 0.152.
 */
package net.sf.packtag.tag;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import net.sf.packtag.util.ContextConfiguration;
import net.sf.packtag.util.SafeLogger;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;

public abstract class BaseTag
extends BodyTagSupport {
    private static final long serialVersionUID = -6185105963103670264L;
    protected static final String EMPTY_STRING = "";
    protected static final String SLASH = "/";
    protected static final String UTF_8 = "UTF-8";
    private static final String SRC_TAG_START = "<src>";
    private static final String SRC_TAG_END = "</src>";
    protected static final String PROTOCOLL_HTTP = "http://";
    protected static final String PROTOCOLL_HTTPS = "https://";
    private static final String REQUEST_RESOURCES = "packtagRequestResources";
    private static final String ATTRIBUTE_SRC = "src";
    private static final String ATTRIBUTE_MINIFY = "minify";
    private static Boolean standardTaglibAvailable = null;
    private String src;
    private Boolean minify = Boolean.TRUE;
    private boolean enabled = true;
    private String prefix;

    protected String determineAbsolutePath(String source) {
        String result = source;
        if (result != null) {
            if ((result = result.trim()).startsWith(SLASH)) {
                result = this.getContextPath() + result;
            } else if (!this.isExternalResource(result)) {
                HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
                String uri = request.getRequestURI();
                String partPath = uri.substring(0, uri.lastIndexOf(SLASH) + 1);
                result = partPath + result;
            }
        }
        return result;
    }

    protected List getRequestResources() {
        ArrayList requestResources = (ArrayList)this.pageContext.getRequest().getAttribute(REQUEST_RESOURCES);
        if (requestResources == null) {
            requestResources = new ArrayList();
            this.pageContext.getRequest().setAttribute(REQUEST_RESOURCES, requestResources);
        }
        return requestResources;
    }

    protected boolean isResourceDelivered(String absolutePath) {
        return this.getRequestResources().contains(absolutePath);
    }

    protected boolean areResourcesDelivered(List absolutePathes) {
        return this.getRequestResources().containsAll(absolutePathes);
    }

    protected void addDeliveredResource(String absolutePath) {
        this.getRequestResources().add(absolutePath);
    }

    protected void addDeliveredResources(List absolutePathes) {
        this.getRequestResources().addAll(absolutePathes);
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = this.isStandardTaglibAvailable() ? (String)this.evaluate(ATTRIBUTE_SRC, src, String.class) : src;
    }

    public Boolean isMinify() {
        return this.minify;
    }

    public void setMinify(String minify) {
        this.minify = this.isStandardTaglibAvailable() ? new Boolean((String)this.evaluate(ATTRIBUTE_MINIFY, minify, String.class)) : new Boolean(minify);
    }

    public boolean isEnabled() {
        return this.enabled && !this.isCachetypeDisabled();
    }

    public void setEnabled(Boolean enabled) {
        if (enabled != null) {
            this.enabled = enabled;
        }
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean hasPrefix() {
        return this.getPrefix() != null && this.getPrefix().length() > 0;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected String getCacheFilePath() {
        return ContextConfiguration.getCacheFilePath(this.pageContext.getServletContext());
    }

    protected String getCacheServletCombinedPath(String strategyName) {
        return ContextConfiguration.getCacheServletCombinedPath(this.pageContext.getServletContext(), strategyName);
    }

    protected boolean isCachetypeDisabled() {
        return ContextConfiguration.isCachetypeDisabled(this.pageContext.getServletContext());
    }

    protected boolean isCachetypeServlet() {
        return ContextConfiguration.isCachetypeServlet(this.pageContext.getServletContext());
    }

    protected boolean isCachetypeFile() {
        return ContextConfiguration.isCachetypeFile(this.pageContext.getServletContext());
    }

    protected boolean isScriptAsyncdeferXhtml() {
        return ContextConfiguration.isScriptAsyncDeferXhtml(this.pageContext.getServletContext());
    }

    protected boolean isScriptAsyncdeferHtml5() {
        return ContextConfiguration.isScriptAsyncDeferHtml5(this.pageContext.getServletContext());
    }

    protected boolean isFileCheckTimestamps() {
        return ContextConfiguration.isFileCheckTimestamps(this.pageContext.getServletContext());
    }

    protected boolean isHideErros() {
        return ContextConfiguration.isHideErros(this.pageContext.getServletContext());
    }

    protected boolean isTrackingResources() {
        return ContextConfiguration.isTrackingResources(this.pageContext.getServletContext());
    }

    protected boolean isExternalResourcesEnabled() {
        return ContextConfiguration.isExternalResourcesEnabled(this.pageContext.getServletContext());
    }

    protected String getPackStrategyClassName(String resourceType) {
        return ContextConfiguration.getPackStrategyClassName(this.pageContext.getServletContext(), resourceType);
    }

    protected Charset getCharset() {
        return ContextConfiguration.getCharset(this.pageContext.getServletContext());
    }

    protected boolean isUrlRewriteEnabled() {
        return ContextConfiguration.isUrlRewriteEnabled(this.pageContext.getServletContext());
    }

    protected void promoteError(String message, Exception ex) throws JspTagException {
        if (this.isHideErros()) {
            try {
                this.pageContext.getOut().write("<!-- ");
                this.pageContext.getOut().write(message);
                this.pageContext.getOut().write(" -->");
            }
            catch (IOException iOException) {}
        } else {
            throw new JspTagException(message);
        }
        SafeLogger.error(((Object)((Object)this)).getClass(), message, ex);
    }

    protected byte[] gzipString(String text, String charsetName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream zos = new GZIPOutputStream(baos);
        byte[] bytes = text.getBytes(charsetName);
        zos.write(bytes, 0, bytes.length);
        zos.finish();
        return baos.toByteArray();
    }

    protected String getContextPath() {
        String contextPath = null;
        contextPath = HttpServletRequest.class.isAssignableFrom(this.pageContext.getRequest().getClass()) ? ((HttpServletRequest)this.pageContext.getRequest()).getContextPath() : BaseTag.getContextPath(this.pageContext.getServletContext());
        return contextPath;
    }

    private static String getContextPath(ServletContext context) {
        String contextPath = EMPTY_STRING;
        try {
            String path = context.getResource(SLASH).getPath();
            contextPath = path.substring(0, path.lastIndexOf(SLASH));
            contextPath = contextPath.substring(contextPath.lastIndexOf(SLASH) + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return SLASH + contextPath;
    }

    protected Object evaluate(String attributeName, String expression, Class expectedType) {
        Object result = null;
        try {
            result = ExpressionEvaluatorManager.evaluate((String)attributeName, (String)expression, (Class)expectedType, (Tag)this, (PageContext)this.pageContext);
        }
        catch (JspException je) {
            try {
                this.pageContext.getOut().write("<!-- ");
                je.printStackTrace(new PrintWriter((Writer)this.pageContext.getOut()));
                this.pageContext.getOut().write(" -->");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected List parseBody(String bodyString) {
        int bodyIndex = 0;
        ArrayList<String> resources = new ArrayList<String>();
        while (bodyIndex < bodyString.length() - 1) {
            int indexSrcStart = bodyString.indexOf(SRC_TAG_START, bodyIndex);
            if (indexSrcStart == -1) {
                return resources;
            }
            int indexSrcEnd = bodyString.indexOf(SRC_TAG_END, bodyIndex);
            if (indexSrcEnd == -1) {
                return resources;
            }
            String source = bodyString.substring(indexSrcStart + 5, indexSrcEnd).trim();
            resources.add(this.determineAbsolutePath(source));
            bodyIndex = indexSrcEnd + 6;
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isStandardTaglibAvailable() {
        if (standardTaglibAvailable == null) {
            Class clazz = BaseTag.class;
            synchronized (clazz) {
                if (standardTaglibAvailable == null) {
                    try {
                        standardTaglibAvailable = new Boolean(Class.forName("org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager") != null);
                    }
                    catch (ClassNotFoundException e) {
                        standardTaglibAvailable = Boolean.FALSE;
                    }
                }
            }
        }
        return standardTaglibAvailable;
    }

    protected boolean isExternalResource(String source) {
        if (source == null) {
            return false;
        }
        return source.startsWith(PROTOCOLL_HTTP) || source.startsWith(PROTOCOLL_HTTPS);
    }

    protected ServletContext getServletContext() {
        return this.pageContext.getServletContext();
    }
}

