/*
 * Decompiled with CFR 0.152.
 */
package net.sf.packtag.strategy;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.packtag.strategy.AbstractPackStrategy;
import net.sf.packtag.util.URIUtils;

public abstract class CssRewritePackStrategy
extends AbstractPackStrategy {
    private static final String REGEX_URLS = "((href|src)\\s*=|@import|url)\\s*(\\(\\s*\"|\\(\\s*'|\\(|'|\")+([\\w#/_%\\.&\\-\\?\\+]+)('\\s*\\)|\"\\s*\\)|\"|\\))+";
    private static final Pattern urlRegexPattern = Pattern.compile("((href|src)\\s*=|@import|url)\\s*(\\(\\s*\"|\\(\\s*'|\\(|'|\")+([\\w#/_%\\.&\\-\\?\\+]+)('\\s*\\)|\"\\s*\\)|\"|\\))+");

    protected String rewritePath(String resource, String path) {
        String result = resource;
        if (path != null && path.length() > 0) {
            StringBuffer sb = new StringBuffer();
            String cssBasePath = URIUtils.cleanRelativePath(path);
            int idxRoot = cssBasePath.lastIndexOf("/");
            if (idxRoot != -1) {
                cssBasePath = cssBasePath.substring(0, idxRoot + 1);
            }
            if ((idxRoot = cssBasePath.indexOf("/", 0)) > 0) {
                cssBasePath = cssBasePath.substring(idxRoot);
            }
            Matcher m = urlRegexPattern.matcher(result);
            while (m.find()) {
                String rewrittenUrl = URIUtils.cleanRelativePath(cssBasePath + m.group(4));
                m.appendReplacement(sb, "$1$2$3" + rewrittenUrl + "$5");
            }
            m.appendTail(sb);
            result = sb.toString();
        }
        return result;
    }
}

