/*
 * Decompiled with CFR 0.152.
 */
package net.sf.packtag.implementation.yui;

import net.sf.packtag.util.SafeLogger;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class JavaScriptErrorReporter
implements ErrorReporter {
    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.reportMessage(message, sourceName, line, lineSource, lineOffset);
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.error(message, sourceName, line, lineSource, lineOffset);
        return new EvaluatorException(message);
    }

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.reportMessage(message, sourceName, line, lineSource, lineOffset);
    }

    private void reportMessage(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (line < 0) {
            if (message.length() == 0) {
                SafeLogger.error(JavaScriptErrorReporter.class, "An unknown error occurred while checking:" + sourceName);
            } else {
                SafeLogger.error(JavaScriptErrorReporter.class, message);
            }
        } else {
            SafeLogger.error(JavaScriptErrorReporter.class, line + ":" + lineOffset + ":" + message);
        }
    }
}

