/*
 * Decompiled with CFR 0.152.
 */
package net.sf.packtag.implementation;

import java.io.InputStream;
import java.nio.charset.Charset;
import net.sf.packtag.strategy.CssRewritePackStrategy;
import net.sf.packtag.strategy.PackException;

public class IBloomCssPackStrategy
extends CssRewritePackStrategy {
    private static final String IBLOOM_REGEX_COMMENTS = "/\\*[^*]*\\*+([^/][^*]*\\*+)*/";
    private static final String IBLOOM_REGEX_CONTROL = "(\r\n)|(\r)|(\n)|(\t)";
    private static final String REGEX_SPACES = "(  +)";
    private static final String EMPTY_STRING = "";
    private static final String SINGLE_SPACE = " ";

    public String pack(InputStream resourceAsStream, Charset charset, String path) throws PackException {
        String resourceAsString = this.resourceToString(resourceAsStream, charset);
        String result = resourceAsString.replaceAll(IBLOOM_REGEX_COMMENTS, EMPTY_STRING);
        result = result.replaceAll(IBLOOM_REGEX_CONTROL, EMPTY_STRING);
        result = result.replaceAll(REGEX_SPACES, SINGLE_SPACE);
        result = this.rewritePath(result, path);
        return result.trim();
    }
}

