/*
 * Decompiled with CFR 0.152.
 */
package net.sf.packtag.cache.provider;

import java.util.Hashtable;
import java.util.Set;
import net.sf.packtag.cache.Resource;
import net.sf.packtag.cache.provider.AbstractCacheProvider;

public class DefaultCacheProvider
extends AbstractCacheProvider {
    private final Hashtable resourcesAbsolutePath = new Hashtable();
    private final Hashtable resourcesMappedPath = new Hashtable();

    public Resource getResourceByAbsolutePath(String absolutePath) {
        return (Resource)this.resourcesAbsolutePath.get(absolutePath);
    }

    public Resource getResourceByMappedPath(String mappedPath) {
        return (Resource)this.resourcesMappedPath.get(mappedPath);
    }

    public boolean existResource(String absolutePath) {
        return this.resourcesAbsolutePath.containsKey(absolutePath);
    }

    public void store(Resource resource, boolean clearDependingCombinedResources) {
        this.resourcesAbsolutePath.put(resource.getAbsolutePath(), resource);
        this.resourcesMappedPath.put(resource.getMappedPath(), resource);
        if (clearDependingCombinedResources) {
            this.clearDependingCombinedResources(resource);
        }
    }

    public void clearCache() {
        this.resourcesAbsolutePath.clear();
        this.resourcesMappedPath.clear();
    }

    public Set getAbsolutePathKeys() {
        return this.resourcesAbsolutePath.keySet();
    }

    public Set getMappedPathKeys() {
        return this.resourcesMappedPath.keySet();
    }

    public void removeAbsolutePath(String absolutePath) {
        this.resourcesAbsolutePath.remove(absolutePath);
    }

    public void removeMappedPath(String mappedPath) {
        this.resourcesMappedPath.remove(mappedPath);
    }
}

