/*
 * Decompiled with CFR 0.152.
 */
package net.sf.packtag.cache;

import java.io.Serializable;

public class Resource
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String absolutePath;
    private String mappedPath;
    private String minifedResource;
    private byte[] gzippedResource;
    private final int minifiedHashcode;
    private long fileTimestamp;
    private boolean combined;
    private String mimeType;
    private String wildcardAbsolutePath;

    public Resource(boolean combined, int minifiedHashcode) {
        this.setCombined(combined);
        this.minifiedHashcode = minifiedHashcode;
    }

    protected void setCombined(boolean combined) {
        this.combined = combined;
    }

    public boolean isCombined() {
        return this.combined;
    }

    public long getFileTimestamp() {
        if (this.isCombined()) {
            return -1L;
        }
        return this.fileTimestamp;
    }

    public void setFileTimestamp(long fileTimestamp) {
        this.fileTimestamp = fileTimestamp;
    }

    public String getMappedPath() {
        return this.mappedPath;
    }

    public void setMappedPath(String mappedPath) {
        this.mappedPath = mappedPath;
    }

    public byte[] getGzippedResource() {
        return this.gzippedResource;
    }

    public void setGzippedResource(byte[] gzippedResource) {
        this.gzippedResource = gzippedResource;
    }

    public String getMinifedResource() {
        return this.minifedResource;
    }

    public void setMinifedResource(String minifedResource) {
        this.minifedResource = minifedResource;
    }

    public int getMinifiedHashcode() {
        return this.minifiedHashcode;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String toString() {
        return this.getAbsolutePath() + "@" + this.getMinifiedHashcode();
    }

    public void setWildcardAbsolutePaths(String wildcardAbsolutePath) {
        this.wildcardAbsolutePath = wildcardAbsolutePath;
    }

    public String getWildcardAbsolutePaths() {
        return this.wildcardAbsolutePath;
    }

    public String[] getWildcardAbsolutePathsSplitted() {
        if (this.wildcardAbsolutePath != null) {
            return this.wildcardAbsolutePath.substring(1, this.wildcardAbsolutePath.length() - 1).split(", ");
        }
        return new String[0];
    }

    public Resource cloneObject() {
        try {
            return (Resource)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isWildcard() {
        return this.getWildcardAbsolutePaths() != null;
    }
}

