/*
 * Decompiled with CFR 0.152.
 */
package net.sf.packtag.cache;

import javax.servlet.ServletContext;
import net.sf.packtag.cache.CacheProvider;
import net.sf.packtag.cache.CacheProviderFactory;
import net.sf.packtag.cache.Resource;
import net.sf.packtag.util.ContextConfiguration;

public class PackCache {
    private static PackCache instance;
    private CacheProvider provider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PackCache getInstance() {
        if (instance == null) {
            Class clazz = PackCache.class;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new PackCache();
                }
            }
        }
        return instance;
    }

    private CacheProvider getResourceCache(ServletContext context) {
        if (this.provider == null) {
            Class providerClass = ContextConfiguration.getCacheProviderClass(context);
            this.provider = new CacheProviderFactory().build(providerClass);
            this.provider.init(context);
        }
        return this.provider;
    }

    public static Resource getResourceByAbsolutePath(ServletContext context, String absolutePath) {
        return PackCache.getInstance().getResourceCache(context).getResourceByAbsolutePath(absolutePath);
    }

    public static Resource getResourceByMappedPath(ServletContext context, String mappedPath) {
        return PackCache.getInstance().getResourceCache(context).getResourceByMappedPath(mappedPath);
    }

    public static boolean existResource(ServletContext context, String absolutePath) {
        return PackCache.getInstance().getResourceCache(context).existResource(absolutePath);
    }

    public static void store(ServletContext context, Resource resource, boolean clearDependingCombinedResources) {
        PackCache.getInstance().getResourceCache(context).store(resource, clearDependingCombinedResources);
    }

    public static void clearCache(ServletContext context) {
        PackCache.getInstance().getResourceCache(context).clearCache();
    }
}

