/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.cluster.api.async.AsyncExecutions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;

class AsyncExecutionsImpl<T>
implements AsyncExecutions<T> {
    private static final AtomicReferenceFieldUpdater<AsyncExecutionsImpl<?>, CompletionStage> UPDATER = AtomicReferenceFieldUpdater.newUpdater(AsyncExecutionsImpl.class, CompletionStage.class, "publicStage");
    private final Map<RedisClusterNode, CompletableFuture<T>> executions;
    private volatile CompletionStage<List<T>> publicStage;

    public AsyncExecutionsImpl(Map<RedisClusterNode, CompletionStage<? extends T>> executions) {
        HashMap<RedisClusterNode, CompletionStage<? extends T>> map = new HashMap<RedisClusterNode, CompletionStage<? extends T>>(executions);
        this.executions = Collections.unmodifiableMap(map);
    }

    @Override
    public Map<RedisClusterNode, CompletableFuture<T>> asMap() {
        return this.executions;
    }

    @Override
    public Iterator<CompletableFuture<T>> iterator() {
        return this.asMap().values().iterator();
    }

    @Override
    public Collection<RedisClusterNode> nodes() {
        return this.executions.keySet();
    }

    @Override
    public CompletableFuture<T> get(RedisClusterNode redisClusterNode) {
        return this.executions.get(redisClusterNode);
    }

    @Override
    public CompletableFuture<T>[] futures() {
        return this.executions.values().toArray(new CompletableFuture[0]);
    }

    @Override
    public <R, A> CompletionStage<R> thenCollect(Collector<? super T, A, R> collector) {
        return this.publicStage().thenApply((? super T items) -> {
            Object container = collector.supplier().get();
            BiConsumer accumulator = collector.accumulator();
            items.forEach(item -> accumulator.accept(container, item));
            if (collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
                return container;
            }
            return collector.finisher().apply(container);
        });
    }

    private CompletionStage<List<T>> publicStage() {
        CompletableFuture<List<T>> stage = UPDATER.get(this);
        if (stage == null) {
            stage = this.createPublicStage(this.executions);
            UPDATER.compareAndSet(this, null, stage);
        }
        return stage;
    }

    private CompletableFuture<List<T>> createPublicStage(Map<RedisClusterNode, CompletableFuture<T>> map) {
        return CompletableFuture.allOf(map.values().toArray(new CompletableFuture[0])).thenApply((T ignore) -> {
            ArrayList results = new ArrayList(map.size());
            for (CompletionStage value : map.values()) {
                results.add(value.toCompletableFuture().join());
            }
            return results;
        });
    }

    @Override
    public <U> CompletionStage<U> thenApply(Function<? super List<T>, ? extends U> fn) {
        return this.publicStage().thenApply(fn);
    }

    @Override
    public <U> CompletionStage<U> thenApplyAsync(Function<? super List<T>, ? extends U> fn) {
        return this.publicStage().thenApplyAsync(fn);
    }

    @Override
    public <U> CompletionStage<U> thenApplyAsync(Function<? super List<T>, ? extends U> fn, Executor executor) {
        return this.publicStage().thenApplyAsync(fn, executor);
    }

    @Override
    public CompletionStage<Void> thenAccept(Consumer<? super List<T>> action) {
        return this.publicStage().thenAccept(action);
    }

    @Override
    public CompletionStage<Void> thenAcceptAsync(Consumer<? super List<T>> action) {
        return this.publicStage().thenAcceptAsync(action);
    }

    @Override
    public CompletionStage<Void> thenAcceptAsync(Consumer<? super List<T>> action, Executor executor) {
        return this.publicStage().thenAcceptAsync(action, executor);
    }

    @Override
    public CompletionStage<Void> thenRun(Runnable action) {
        return this.publicStage().thenRun(action);
    }

    @Override
    public CompletionStage<Void> thenRunAsync(Runnable action) {
        return this.publicStage().thenRunAsync(action);
    }

    @Override
    public CompletionStage<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.publicStage().thenRunAsync(action, executor);
    }

    @Override
    public <U, V> CompletionStage<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super List<T>, ? super U, ? extends V> fn) {
        return this.publicStage().thenCombine(other, fn);
    }

    @Override
    public <U, V> CompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super List<T>, ? super U, ? extends V> fn) {
        return this.publicStage().thenCombineAsync(other, fn);
    }

    @Override
    public <U, V> CompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super List<T>, ? super U, ? extends V> fn, Executor executor) {
        return this.publicStage().thenCombineAsync(other, fn, executor);
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super List<T>, ? super U> action) {
        return this.publicStage().thenAcceptBoth(other, action);
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super List<T>, ? super U> action) {
        return this.publicStage().thenAcceptBothAsync(other, action);
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super List<T>, ? super U> action, Executor executor) {
        return this.publicStage().thenAcceptBothAsync(other, action, executor);
    }

    @Override
    public CompletionStage<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.publicStage().runAfterBoth(other, action);
    }

    @Override
    public CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.publicStage().runAfterBothAsync(other, action);
    }

    @Override
    public CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.publicStage().runAfterBothAsync(other, action, executor);
    }

    @Override
    public <U> CompletionStage<U> applyToEither(CompletionStage<? extends List<T>> other, Function<? super List<T>, U> fn) {
        return this.publicStage().applyToEither(other, fn);
    }

    @Override
    public <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends List<T>> other, Function<? super List<T>, U> fn) {
        return this.publicStage().applyToEitherAsync(other, fn);
    }

    @Override
    public <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends List<T>> other, Function<? super List<T>, U> fn, Executor executor) {
        return this.publicStage().applyToEitherAsync(other, fn, executor);
    }

    @Override
    public CompletionStage<Void> acceptEither(CompletionStage<? extends List<T>> other, Consumer<? super List<T>> action) {
        return this.publicStage().acceptEither(other, action);
    }

    @Override
    public CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends List<T>> other, Consumer<? super List<T>> action) {
        return this.publicStage().acceptEitherAsync(other, action);
    }

    @Override
    public CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends List<T>> other, Consumer<? super List<T>> action, Executor executor) {
        return this.publicStage().acceptEitherAsync(other, action, executor);
    }

    @Override
    public CompletionStage<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.publicStage().runAfterEither(other, action);
    }

    @Override
    public CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.publicStage().runAfterEitherAsync(other, action);
    }

    @Override
    public CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.publicStage().runAfterEitherAsync(other, action, executor);
    }

    @Override
    public <U> CompletionStage<U> thenCompose(Function<? super List<T>, ? extends CompletionStage<U>> fn) {
        return this.publicStage().thenCompose(fn);
    }

    @Override
    public <U> CompletionStage<U> thenComposeAsync(Function<? super List<T>, ? extends CompletionStage<U>> fn) {
        return this.publicStage().thenComposeAsync(fn);
    }

    @Override
    public <U> CompletionStage<U> thenComposeAsync(Function<? super List<T>, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.publicStage().thenComposeAsync(fn, executor);
    }

    @Override
    public CompletionStage<List<T>> exceptionally(Function<Throwable, ? extends List<T>> fn) {
        return this.publicStage().exceptionally(fn);
    }

    @Override
    public CompletionStage<List<T>> whenComplete(BiConsumer<? super List<T>, ? super Throwable> action) {
        return this.publicStage().whenComplete(action);
    }

    @Override
    public CompletionStage<List<T>> whenCompleteAsync(BiConsumer<? super List<T>, ? super Throwable> action) {
        return this.publicStage().whenCompleteAsync(action);
    }

    @Override
    public CompletionStage<List<T>> whenCompleteAsync(BiConsumer<? super List<T>, ? super Throwable> action, Executor executor) {
        return this.publicStage().whenCompleteAsync(action, executor);
    }

    @Override
    public <U> CompletionStage<U> handle(BiFunction<? super List<T>, Throwable, ? extends U> fn) {
        return this.publicStage().handle(fn);
    }

    @Override
    public <U> CompletionStage<U> handleAsync(BiFunction<? super List<T>, Throwable, ? extends U> fn) {
        return this.publicStage().handleAsync(fn);
    }

    @Override
    public <U> CompletionStage<U> handleAsync(BiFunction<? super List<T>, Throwable, ? extends U> fn, Executor executor) {
        return this.publicStage().handleAsync(fn, executor);
    }

    @Override
    public CompletableFuture<List<T>> toCompletableFuture() {
        return this.publicStage().toCompletableFuture();
    }
}

