/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.urlbuilder;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ocpsoft.urlbuilder.Address;
import org.ocpsoft.urlbuilder.AddressBuilderAnchor;
import org.ocpsoft.urlbuilder.AddressBuilderBase;
import org.ocpsoft.urlbuilder.AddressBuilderDomain;
import org.ocpsoft.urlbuilder.AddressBuilderPath;
import org.ocpsoft.urlbuilder.AddressBuilderPort;
import org.ocpsoft.urlbuilder.AddressBuilderQuery;
import org.ocpsoft.urlbuilder.AddressBuilderScheme;
import org.ocpsoft.urlbuilder.AddressBuilderSchemeSpecificPart;
import org.ocpsoft.urlbuilder.AddressResult;
import org.ocpsoft.urlbuilder.Parameter;
import org.ocpsoft.urlbuilder.ParameterizedAddressResult;
import org.ocpsoft.urlbuilder.util.Decoder;
import org.ocpsoft.urlbuilder.util.Encoder;

public class AddressBuilder {
    private volatile Address address;
    protected volatile CharSequence scheme;
    protected volatile CharSequence schemeSpecificPart;
    protected volatile CharSequence domain;
    protected volatile Integer port;
    protected volatile CharSequence path;
    protected Map<CharSequence, Parameter> parameters = new LinkedHashMap<CharSequence, Parameter>();
    protected Map<CharSequence, Parameter> queries = new LinkedHashMap<CharSequence, Parameter>();
    protected CharSequence anchor;

    protected AddressBuilder() {
    }

    public static AddressBuilderBase begin() {
        return new AddressBuilderBase(new AddressBuilder());
    }

    protected Address build() {
        if (this.address == null) {
            this.address = new ParameterizedAddressResult(this);
        }
        return this.address;
    }

    protected Address buildLiteral() {
        if (this.address == null) {
            this.address = new AddressResult(this);
        }
        return this.address;
    }

    public static Address create(String url) throws IllegalArgumentException {
        try {
            URI u = new URI(url);
            String scheme = u.getScheme();
            String host = u.getHost();
            if (scheme != null && host == null) {
                return AddressBuilder.begin().scheme(u.getScheme()).schemeSpecificPart(u.getRawSchemeSpecificPart()).buildLiteral();
            }
            return AddressBuilder.begin().scheme(scheme).domain(host).port(u.getPort()).path(u.getRawPath()).queryLiteral(u.getRawQuery()).anchor(u.getRawFragment()).buildLiteral();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("[" + url + "] is not a valid URL fragment. Consider encoding relevant portions of the URL with [" + Encoder.class + "], or use the provided builder pattern via this class to specify part encoding.", e);
        }
    }

    AddressBuilderScheme scheme(CharSequence scheme) {
        this.scheme = scheme;
        return new AddressBuilderScheme(this);
    }

    AddressBuilderSchemeSpecificPart schemeSpecificPart(CharSequence schemeSpecificPart) {
        this.schemeSpecificPart = schemeSpecificPart;
        return new AddressBuilderSchemeSpecificPart(this);
    }

    AddressBuilderDomain domain(CharSequence domain) {
        this.domain = domain;
        return new AddressBuilderDomain(this);
    }

    AddressBuilderPort port(int port) {
        if (port >= 0) {
            this.port = port;
        }
        return new AddressBuilderPort(this);
    }

    AddressBuilderPath path(CharSequence path) {
        this.path = path;
        return new AddressBuilderPath(this);
    }

    AddressBuilderPath pathDecoded(CharSequence path) {
        this.path = Decoder.path(path);
        return new AddressBuilderPath(this);
    }

    AddressBuilderPath pathEncoded(CharSequence path) {
        this.path = Encoder.path(path);
        return new AddressBuilderPath(this);
    }

    AddressBuilderQuery query(CharSequence name, Object ... values) {
        if (name != null && values != null) {
            this.queries.put(name.toString(), Parameter.create((CharSequence)name.toString(), values));
        }
        return new AddressBuilderQuery(this);
    }

    AddressBuilderQuery queryDecoded(CharSequence name, Object ... values) {
        if (name != null && values != null) {
            ArrayList<Object> encodedValues = new ArrayList<Object>(values.length);
            for (Object value : values) {
                if (value == null) {
                    encodedValues.add(value);
                    continue;
                }
                encodedValues.add(Decoder.query(value.toString()));
            }
            this.queries.put(Decoder.query(name.toString()), Parameter.create((CharSequence)name.toString(), encodedValues));
        }
        return new AddressBuilderQuery(this);
    }

    AddressBuilderQuery queryEncoded(CharSequence name, Object ... values) {
        if (name != null && values != null) {
            ArrayList<Object> encodedValues = new ArrayList<Object>(values.length);
            for (Object value : values) {
                if (value == null) {
                    encodedValues.add(value);
                    continue;
                }
                encodedValues.add(Encoder.query(value.toString()));
            }
            this.queries.put(Encoder.query(name.toString()), Parameter.create((CharSequence)name.toString(), encodedValues));
        }
        return new AddressBuilderQuery(this);
    }

    AddressBuilderQuery queryLiteral(String query) {
        if (query != null) {
            if (query.startsWith("?")) {
                query = query.substring(1);
            }
            LinkedHashMap<String, ArrayList<String>> params = new LinkedHashMap<String, ArrayList<String>>();
            query = this.decodeHTMLAmpersands(query);
            int index = 0;
            while ((index = query.indexOf(38)) >= 0 || !query.isEmpty()) {
                String value;
                String name;
                int pos;
                String pair = query;
                if (index >= 0) {
                    pair = query.substring(0, index);
                    if (!(query = query.substring(index)).isEmpty()) {
                        query = query.substring(1);
                    }
                } else {
                    query = "";
                }
                if ((pos = pair.indexOf(61)) == -1) {
                    name = pair;
                    value = null;
                } else {
                    name = pair.substring(0, pos);
                    value = pair.substring(pos + 1, pair.length());
                }
                ArrayList<String> list = (ArrayList<String>)params.get(name);
                if (list == null) {
                    list = new ArrayList<String>();
                    params.put(name, list);
                }
                list.add(value);
            }
            for (Map.Entry entry : params.entrySet()) {
                this.query((CharSequence)entry.getKey(), ((List)entry.getValue()).toArray());
            }
        }
        return new AddressBuilderQuery(this);
    }

    private String decodeHTMLAmpersands(String url) {
        if (url != null) {
            int index = 0;
            while ((index = url.indexOf("&amp;")) >= 0) {
                url = url.substring(0, index + 1) + url.substring(index + 5);
            }
        }
        return url;
    }

    AddressBuilderAnchor anchor(CharSequence anchor) {
        this.anchor = anchor;
        return new AddressBuilderAnchor(this);
    }

    void set(CharSequence name, Object ... values) {
        this.parameters.put(name.toString(), Parameter.create((CharSequence)name.toString(), values));
    }

    void setDecoded(CharSequence name, Object ... values) {
        if (name != null && values != null) {
            ArrayList<Object> encodedValues = new ArrayList<Object>(values.length);
            for (Object value : values) {
                if (value == null) {
                    encodedValues.add(value);
                    continue;
                }
                encodedValues.add(Decoder.path(value.toString()));
            }
            this.parameters.put(name.toString(), Parameter.create((CharSequence)name.toString(), encodedValues));
        }
    }

    void setEncoded(CharSequence name, Object ... values) {
        if (name != null && values != null) {
            ArrayList<Object> encodedValues = new ArrayList<Object>(values.length);
            for (Object value : values) {
                if (value == null) {
                    encodedValues.add(value);
                    continue;
                }
                encodedValues.add(Encoder.path(value.toString()));
            }
            this.parameters.put(name.toString(), Parameter.create((CharSequence)name.toString(), encodedValues));
        }
    }

    public String toString() {
        return this.buildLiteral().toString();
    }

    static StringBuilder toString(Address address) {
        StringBuilder result = new StringBuilder();
        if (address.isSchemeSet()) {
            result.append(address.getScheme()).append(":");
        }
        if (address.isSchemeSpecificPartSet()) {
            result.append(address.getSchemeSpecificPart());
        } else {
            if (address.isDomainSet()) {
                result.append("//").append(address.getDomain());
            }
            if (address.isPortSet()) {
                result.append(":").append(address.getPort());
            }
            if (address.isPathSet()) {
                result.append(address.getPath());
            }
            if (address.isQuerySet()) {
                if (address.isDomainSet() && !address.isPathSet()) {
                    result.append("/");
                }
                result.append('?').append(address.getQuery());
            }
            if (address.isAnchorSet()) {
                result.append('#').append(address.getAnchor());
            }
        }
        return result;
    }

    Map<String, List<Object>> getQueries() {
        LinkedHashMap<String, List<Object>> result = new LinkedHashMap<String, List<Object>>();
        for (Map.Entry<CharSequence, Parameter> entry : this.queries.entrySet()) {
            CharSequence key = entry.getKey();
            result.put(key == null ? null : key.toString(), entry.getValue().getValues());
        }
        return Collections.unmodifiableMap(result);
    }
}

