/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.annotation.config;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.servlet.ServletContext;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.annotation.ClassVisitorImpl;
import org.ocpsoft.rewrite.annotation.scan.AbstractClassFinder;
import org.ocpsoft.rewrite.annotation.scan.ByteCodeFilter;
import org.ocpsoft.rewrite.annotation.scan.PackageFilter;
import org.ocpsoft.rewrite.annotation.scan.WebClassesFinder;
import org.ocpsoft.rewrite.annotation.scan.WebLibFinder;
import org.ocpsoft.rewrite.annotation.spi.AnnotationHandler;
import org.ocpsoft.rewrite.annotation.spi.ClassFinder;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.servlet.config.HttpConfigurationProvider;

public class AnnotationConfigProvider
extends HttpConfigurationProvider {
    private final Logger log = Logger.getLogger(AnnotationConfigProvider.class);
    public static final String CONFIG_SCAN_CLASSES_DIR = "org.ocpsoft.rewrite.annotation.SCAN_CLASSES_DIRECTORY";
    public static final String CONFIG_SCAN_LIB_DIR = "org.ocpsoft.rewrite.annotation.SCAN_LIB_DIRECTORY";
    public static final String CONFIG_BASE_PACKAGES = "org.ocpsoft.rewrite.annotation.BASE_PACKAGES";

    @Override
    public int priority() {
        return 100;
    }

    @Override
    public Configuration getConfiguration(ServletContext servletContext) {
        String packageFilters = servletContext.getInitParameter(CONFIG_BASE_PACKAGES);
        boolean scanClassesDir = true;
        String classesConfig = servletContext.getInitParameter(CONFIG_SCAN_CLASSES_DIR);
        if (classesConfig != null && classesConfig.trim().equalsIgnoreCase("false")) {
            scanClassesDir = false;
        }
        boolean scanLibDir = false;
        String libConfig = servletContext.getInitParameter(CONFIG_SCAN_LIB_DIR);
        if (libConfig != null && libConfig.trim().equalsIgnoreCase("true")) {
            scanLibDir = true;
        }
        if (packageFilters != null && packageFilters.trim().equalsIgnoreCase("none")) {
            this.log.debug("Annotation scanning is disabled!");
            return null;
        }
        LinkedHashSet<Class<? extends Annotation>> annotationType = new LinkedHashSet<Class<? extends Annotation>>();
        ArrayList<AnnotationHandler<Annotation>> annotationHandlers = new ArrayList<AnnotationHandler<Annotation>>();
        for (AnnotationHandler handler : ServiceLoader.load(AnnotationHandler.class)) {
            annotationHandlers.add(handler);
            annotationType.add(handler.handles());
        }
        ByteCodeFilter byteCodeFilter = new ByteCodeFilter(annotationType);
        PackageFilter packageFilter = new PackageFilter(packageFilters);
        ClassVisitorImpl classVisitor = new ClassVisitorImpl(annotationHandlers, servletContext);
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        if (classloader == null) {
            classloader = this.getClass().getClassLoader();
        }
        ArrayList<AbstractClassFinder> classFinders = new ArrayList<AbstractClassFinder>();
        if (scanClassesDir) {
            classFinders.add(new WebClassesFinder(servletContext, classloader, packageFilter, byteCodeFilter));
        }
        if (scanLibDir) {
            classFinders.add(new WebLibFinder(servletContext, classloader, packageFilter, byteCodeFilter));
        }
        for (ClassFinder classFinder : classFinders) {
            classFinder.findClasses(classVisitor);
        }
        return classVisitor;
    }
}

