/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.inject;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractInjector {
    private final WeldManager manager;
    private final ComputingCache<Class<?>, InjectionTarget<?>> cache;

    protected AbstractInjector(WeldManager manager) {
        Preconditions.checkArgumentNotNull((Object)manager, (String)"manager");
        this.manager = manager;
        this.cache = ComputingCacheBuilder.newBuilder().setWeakValues().build(clazz -> {
            AnnotatedType type = manager.createAnnotatedType(clazz);
            return manager.createInjectionTargetBuilder(type).setResourceInjectionEnabled(false).setTargetClassLifecycleCallbacksEnabled(false).build();
        });
    }

    protected void inject(Object instance) {
        InjectionTarget it = (InjectionTarget)Reflections.cast((Object)this.cache.getValue(instance.getClass()));
        WeldCreationalContext cc = this.manager.createCreationalContext(null);
        it.inject(instance, (CreationalContext)cc);
    }

    public void destroy(Object instance) {
        if (instance != null) {
            InjectionTarget it = (InjectionTarget)Reflections.cast((Object)this.cache.getValue(instance.getClass()));
            it.dispose(instance);
        }
    }
}

