/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.annotations.PodamExclude;
import uk.co.jemos.podam.dto.ClassInfo;

public class PodamUtils {
    public static final Logger LOG = LoggerFactory.getLogger(PodamUtils.class);

    private PodamUtils() {
        throw new AssertionError();
    }

    public static ClassInfo getClassInfo(Class<?> clazz) {
        return PodamUtils.getClassInfo(clazz, null);
    }

    public static ClassInfo getClassInfo(Class<?> clazz, List<Class<? extends Annotation>> excludeFieldAnnotations) {
        Set<String> classFields = null;
        classFields = excludeFieldAnnotations != null && !excludeFieldAnnotations.isEmpty() ? PodamUtils.getDeclaredInstanceFields(clazz, excludeFieldAnnotations) : PodamUtils.getDeclaredInstanceFields(clazz);
        Set<Method> classSetters = PodamUtils.getPojoSetters(clazz, classFields);
        return new ClassInfo(clazz, classFields, classSetters);
    }

    public static Set<String> getDeclaredInstanceFields(Class<?> clazz) {
        ArrayList<Class<? extends Annotation>> excludedAnnotations = new ArrayList<Class<? extends Annotation>>();
        excludedAnnotations.add(PodamExclude.class);
        return PodamUtils.getDeclaredInstanceFields(clazz, excludedAnnotations);
    }

    public static Set<String> getDeclaredInstanceFields(Class<?> clazz, List<Class<? extends Annotation>> excludeAnnotations) {
        HashSet<String> classFields = new HashSet<String>();
        while (clazz != null) {
            Field[] declaredFields;
            Field[] fieldArray = declaredFields = clazz.getDeclaredFields();
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                int modifiers;
                Field field = fieldArray[n2];
                if (!PodamUtils.containsAnyAnnotation(field, excludeAnnotations) && !Modifier.isStatic(modifiers = field.getModifiers())) {
                    classFields.add(field.getName());
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return classFields;
    }

    public static boolean containsAnyAnnotation(Field field, List<Class<? extends Annotation>> annotations) {
        Method method = PodamUtils.getGetterFor(field);
        for (Class<? extends Annotation> annotation : annotations) {
            if (field.getAnnotation(annotation) != null) {
                return true;
            }
            if (method == null || method.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }

    public static Method getGetterFor(Field field) {
        String name = String.valueOf(field.getName().substring(0, 1).toUpperCase()) + field.getName().substring(1);
        try {
            return field.getDeclaringClass().getMethod("get" + name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Set<Method> getPojoSetters(Class<?> clazz, Set<String> classFields) {
        HashSet<Method> classSetters = new HashSet<Method>();
        while (clazz != null) {
            Method[] declaredMethods = clazz.getDeclaredMethods();
            String candidateField = null;
            Method[] methodArray = declaredMethods;
            int n = declaredMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().startsWith("set") && method.getReturnType().equals(Void.TYPE)) {
                    candidateField = PodamUtils.extractFieldNameFromSetterMethod(method);
                    boolean found = false;
                    for (String cf : classFields) {
                        if (!cf.toLowerCase().equals(candidateField.toLowerCase())) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        classSetters.add(method);
                    }
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return classSetters;
    }

    public static String extractFieldNameFromSetterMethod(Method method) {
        String candidateField = null;
        candidateField = method.getName().substring(3);
        if (!candidateField.equals("")) {
            candidateField = String.valueOf(Character.toLowerCase(candidateField.charAt(0))) + candidateField.substring(1);
        } else {
            LOG.warn("Encountered method set. This will be ignored.");
        }
        return candidateField;
    }
}

