/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.lang.annotation.Annotation;
import java.lang.constant.Constable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.annotations.PodamBooleanValue;
import uk.co.jemos.podam.annotations.PodamByteValue;
import uk.co.jemos.podam.annotations.PodamCharValue;
import uk.co.jemos.podam.annotations.PodamCollection;
import uk.co.jemos.podam.annotations.PodamDoubleValue;
import uk.co.jemos.podam.annotations.PodamFloatValue;
import uk.co.jemos.podam.annotations.PodamIntValue;
import uk.co.jemos.podam.annotations.PodamLongValue;
import uk.co.jemos.podam.annotations.PodamShortValue;
import uk.co.jemos.podam.annotations.PodamStrategyValue;
import uk.co.jemos.podam.annotations.PodamStringValue;
import uk.co.jemos.podam.annotations.strategies.ObjectStrategy;
import uk.co.jemos.podam.api.AttributeStrategy;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.PodamFactory;
import uk.co.jemos.podam.api.RandomDataProviderStrategy;
import uk.co.jemos.podam.dto.AttributeMetadata;
import uk.co.jemos.podam.dto.ClassInfo;
import uk.co.jemos.podam.exceptions.PodamMockeryException;
import uk.co.jemos.podam.utils.PodamUtils;

@ThreadSafe
@Immutable
public class PodamFactoryImpl
implements PodamFactory {
    private final Logger LOG = LoggerFactory.getLogger((String)PodamFactoryImpl.class.getName());
    private final DataProviderStrategy strategy;
    private List<Class<? extends Annotation>> excludeAnnotations;

    public PodamFactoryImpl() {
        this(RandomDataProviderStrategy.getInstance());
    }

    public PodamFactoryImpl(DataProviderStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public <T> T manufacturePojo(Class<T> pojoClass) {
        Type[] noTypes = new Type[]{};
        return this.manufacturePojo(pojoClass, noTypes);
    }

    @Override
    public <T> T manufacturePojo(Class<T> pojoClass, Type ... genericTypeArgs) {
        HashMap pojos = new HashMap();
        pojos.put(pojoClass, 0);
        return this.manufacturePojoInternal(pojoClass, pojos, genericTypeArgs);
    }

    @Override
    public DataProviderStrategy getStrategy() {
        return this.strategy;
    }

    private Type[] fillTypeArgMap(Map<String, Type> typeArgsMap, Class<?> pojoClass, Type[] genericTypeArgs) throws IllegalStateException {
        TypeVariable<Class<?>>[] typeParameters = pojoClass.getTypeParameters();
        if (typeParameters.length > genericTypeArgs.length) {
            String msg = String.valueOf(pojoClass.getCanonicalName()) + " is missing generic type arguments, expected " + typeParameters.length + " found " + genericTypeArgs.length + ". Returning null";
            throw new IllegalStateException(msg);
        }
        int i = 0;
        while (i < typeParameters.length) {
            typeArgsMap.put(typeParameters[i].getName(), genericTypeArgs[i]);
            ++i;
        }
        Type[] genericTypeArgsExtra = typeParameters.length < genericTypeArgs.length ? Arrays.copyOfRange(genericTypeArgs, i, genericTypeArgs.length) : null;
        Class<?> clazz = pojoClass;
        while (clazz != null) {
            Type superType = clazz.getGenericSuperclass();
            clazz = clazz.getSuperclass();
            if (!(superType instanceof ParameterizedType)) continue;
            ParameterizedType paramType = (ParameterizedType)superType;
            Type[] actualParamTypes = paramType.getActualTypeArguments();
            TypeVariable<Class<?>>[] paramTypes = clazz.getTypeParameters();
            i = 0;
            while (i < actualParamTypes.length && i < paramTypes.length) {
                if (actualParamTypes[i] instanceof Class) {
                    typeArgsMap.put(paramTypes[i].getName(), actualParamTypes[i]);
                }
                ++i;
            }
        }
        return genericTypeArgsExtra;
    }

    private Object createNewInstanceForClassWithoutConstructors(Class<?> pojoClass, Map<Class<?>, Integer> pojos, Class<?> clazz, Type ... genericTypeArgs) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object retValue = null;
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 0) {
            HashMap<String, Type> typeArgsMap = new HashMap<String, Type>();
            try {
                Type[] genericTypeArgsExtra = this.fillTypeArgMap(typeArgsMap, pojoClass, genericTypeArgs);
                if (genericTypeArgsExtra != null) {
                    this.LOG.warn(String.format("Lost %d generic type arguments", genericTypeArgsExtra.length));
                }
            }
            catch (IllegalStateException e) {
                this.LOG.error(e.getMessage());
                return null;
            }
            Method[] declaredMethods = clazz.getDeclaredMethods();
            Object[] parameterValues = null;
            Method[] methodArray = declaredMethods;
            int n = declaredMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method candidateConstructor = methodArray[n2];
                if (Modifier.isStatic(candidateConstructor.getModifiers()) && candidateConstructor.getReturnType().equals(clazz)) {
                    parameterValues = new Object[candidateConstructor.getParameterTypes().length];
                    Type[] parameterTypes = candidateConstructor.getGenericParameterTypes();
                    if (parameterTypes.length == 0) {
                        retValue = candidateConstructor.invoke(clazz, new Object[0]);
                    } else {
                        Annotation[][] parameterAnnotations = candidateConstructor.getParameterAnnotations();
                        int idx = 0;
                        Type[] typeArray = parameterTypes;
                        int n3 = parameterTypes.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Type paramType = typeArray[n4];
                            AtomicReference<Type[]> methodGenericTypeArgs = new AtomicReference<Type[]>();
                            Class<?> parameterType = this.resolveGenericParameter(paramType, typeArgsMap, methodGenericTypeArgs);
                            List<Annotation> annotations = Arrays.asList(parameterAnnotations[idx]);
                            String attributeName = null;
                            if (Collection.class.isAssignableFrom(parameterType)) {
                                Collection<? super Object> listType = this.resolveCollectionType(parameterType);
                                Class elementType = paramType instanceof ParameterizedType ? (Class)methodGenericTypeArgs.get()[0] : Object.class;
                                int nbrElements = this.strategy.getNumberOfCollectionElements(elementType);
                                for (Annotation annotation : annotations) {
                                    if (!annotation.annotationType().equals(PodamCollection.class)) continue;
                                    PodamCollection ann = (PodamCollection)annotation;
                                    nbrElements = ann.nbrElements();
                                }
                                int i = 0;
                                while (i < nbrElements) {
                                    Object attributeValue = this.manufactureAttributeValue(clazz, pojos, elementType, annotations, attributeName, new Type[0]);
                                    listType.add(attributeValue);
                                    ++i;
                                }
                                parameterValues[idx] = listType;
                            } else if (Map.class.isAssignableFrom(parameterType)) {
                                Class valueClass;
                                Class keyClass;
                                Map<? super Object, ? super Object> mapType = this.resolveMapType(parameterType);
                                if (paramType instanceof ParameterizedType) {
                                    keyClass = (Class)methodGenericTypeArgs.get()[0];
                                    valueClass = (Class)methodGenericTypeArgs.get()[1];
                                } else {
                                    keyClass = Object.class;
                                    valueClass = Object.class;
                                }
                                int nbrElements = this.strategy.getNumberOfCollectionElements(valueClass);
                                for (Annotation annotation : annotations) {
                                    if (!annotation.annotationType().equals(PodamCollection.class)) continue;
                                    PodamCollection ann = (PodamCollection)annotation;
                                    nbrElements = ann.nbrElements();
                                }
                                int i = 0;
                                while (i < nbrElements) {
                                    Object keyValue = this.manufactureAttributeValue(clazz, pojos, keyClass, annotations, attributeName, new Type[0]);
                                    Object elementValue = this.manufactureAttributeValue(clazz, pojos, valueClass, annotations, attributeName, new Type[0]);
                                    mapType.put(keyValue, elementValue);
                                    ++i;
                                }
                                parameterValues[idx] = mapType;
                            } else {
                                parameterValues[idx] = this.manufactureAttributeValue(clazz, pojos, parameterType, annotations, attributeName, typeArgsMap, genericTypeArgs);
                            }
                            ++idx;
                            ++n4;
                        }
                    }
                    try {
                        retValue = candidateConstructor.invoke(clazz, parameterValues);
                        this.LOG.info("Could create an instance using " + candidateConstructor);
                        break;
                    }
                    catch (Throwable t) {
                        this.LOG.warn("PODAM could not create an instance for constructor: " + candidateConstructor + ". Will try another one...");
                    }
                }
                ++n2;
            }
        } else {
            this.strategy.sort(constructors);
            Constructor<?>[] constructorArray = constructors;
            int n = constructors.length;
            int n5 = 0;
            while (n5 < n) {
                Constructor<?> constructor = constructorArray[n5];
                try {
                    Object[] constructorArgs = this.getParameterValuesForConstructor(constructor, pojoClass, pojos, genericTypeArgs);
                    retValue = constructor.newInstance(constructorArgs);
                    this.LOG.info("For class: " + clazz.getName() + " a valid constructor: " + constructor + " was found. PODAM will use it to create an instance.");
                    break;
                }
                catch (Throwable t) {
                    this.LOG.warn("Couldn't create attribute with constructor: " + constructor + ". Will check if other constructors are available");
                    ++n5;
                }
            }
        }
        if (retValue == null) {
            this.LOG.warn("For class: {} PODAM could not possibly create a value. This attribute will be returned as null.", clazz);
        }
        return retValue;
    }

    private Class<?> resolveGenericParameter(Type paramType, Map<String, Type> typeArgsMap, AtomicReference<Type[]> methodGenericTypeArgs) {
        Class<Object> parameterType;
        methodGenericTypeArgs.set(new Type[0]);
        if (paramType instanceof TypeVariable) {
            String typeName = ((TypeVariable)paramType).getName();
            Type type = typeArgsMap.get(typeName);
            parameterType = this.resolveGenericParameter(type, typeArgsMap, methodGenericTypeArgs);
        } else if (paramType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)paramType;
            parameterType = (Class<?>)pType.getRawType();
            methodGenericTypeArgs.set(pType.getActualTypeArguments());
        } else if (paramType instanceof WildcardType) {
            String msg;
            WildcardType wType = (WildcardType)paramType;
            Object[] bounds = wType.getLowerBounds();
            if (bounds != null && bounds.length > 0) {
                msg = "Lower bounds:";
            } else {
                bounds = wType.getUpperBounds();
                msg = "Upper bounds:";
            }
            if (bounds != null && bounds.length > 0) {
                this.LOG.debug(String.valueOf(msg) + Arrays.toString(bounds));
                parameterType = this.resolveGenericParameter((Type)bounds[0], typeArgsMap, methodGenericTypeArgs);
            } else {
                this.LOG.warn("Unrecognized argument type" + wType.toString() + ". Will use Object intead");
                parameterType = Object.class;
            }
        } else if (paramType instanceof Class) {
            parameterType = (Class)paramType;
        } else {
            this.LOG.warn("Unrecognized argument type" + paramType.getClass().getSimpleName() + ". Will use Object intead");
            parameterType = Object.class;
        }
        return parameterType;
    }

    private Object resolvePrimitiveValue(Class<?> primitiveClass, List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Constable retValue = null;
        if (primitiveClass.equals(Integer.TYPE)) {
            if (!annotations.isEmpty()) {
                retValue = this.getIntegerValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getInteger(attributeMetadata);
            }
        } else if (primitiveClass.equals(Long.TYPE)) {
            if (!annotations.isEmpty()) {
                retValue = this.getLongValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getLong(attributeMetadata);
            }
        } else if (primitiveClass.equals(Float.TYPE)) {
            if (!annotations.isEmpty()) {
                retValue = this.getFloatValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getFloat(attributeMetadata);
            }
        } else if (primitiveClass.equals(Double.TYPE)) {
            if (!annotations.isEmpty()) {
                retValue = this.getDoubleValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getDouble(attributeMetadata);
            }
        } else if (primitiveClass.equals(Boolean.TYPE)) {
            if (!annotations.isEmpty()) {
                retValue = this.getBooleanValueForAnnotation(annotations);
            }
            if (retValue == null) {
                retValue = this.strategy.getBoolean(attributeMetadata);
            }
        } else if (primitiveClass.equals(Byte.TYPE)) {
            if (!annotations.isEmpty()) {
                retValue = this.getByteValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getByte(attributeMetadata);
            }
        } else if (primitiveClass.equals(Short.TYPE)) {
            if (!annotations.isEmpty()) {
                retValue = this.getShortValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getShort(attributeMetadata);
            }
        } else if (primitiveClass.equals(Character.TYPE)) {
            if (!annotations.isEmpty()) {
                retValue = this.getCharacterValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getCharacter(attributeMetadata);
            }
        }
        return retValue;
    }

    private Boolean getBooleanValueForAnnotation(List<Annotation> annotations) {
        Boolean retValue = null;
        for (Annotation annotation : annotations) {
            if (!PodamBooleanValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamBooleanValue strategy = (PodamBooleanValue)annotation;
            retValue = strategy.boolValue();
            break;
        }
        return retValue;
    }

    private Byte getByteValueWithinRange(List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Byte retValue = null;
        for (Annotation annotation : annotations) {
            byte maxValue;
            if (!PodamByteValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamByteValue intStrategy = (PodamByteValue)annotation;
            String numValueStr = intStrategy.numValue();
            if (numValueStr != null && !"".equals(numValueStr)) {
                try {
                    retValue = Byte.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The precise value: " + numValueStr + " cannot be converted to a byte type. An exception will be thrown.";
                    this.LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            byte minValue = intStrategy.minValue();
            if (minValue > (maxValue = intStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getByteInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        return retValue;
    }

    private Short getShortValueWithinRange(List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Short retValue = null;
        for (Annotation annotation : annotations) {
            short maxValue;
            if (!PodamShortValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamShortValue shortStrategy = (PodamShortValue)annotation;
            String numValueStr = shortStrategy.numValue();
            if (numValueStr != null && !"".equals(numValueStr)) {
                try {
                    retValue = Short.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The precise value: " + numValueStr + " cannot be converted to a short type. An exception will be thrown.";
                    this.LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            short minValue = shortStrategy.minValue();
            if (minValue > (maxValue = shortStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getShortInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        return retValue;
    }

    private Character getCharacterValueWithinRange(List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Character retValue = null;
        for (Annotation annotation : annotations) {
            char maxValue;
            if (!PodamCharValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamCharValue annotationStrategy = (PodamCharValue)annotation;
            char charValue = annotationStrategy.charValue();
            if (charValue != ' ') {
                retValue = Character.valueOf(charValue);
                break;
            }
            char minValue = annotationStrategy.minValue();
            if (minValue > (maxValue = annotationStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getCharacterInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        return retValue;
    }

    private Integer getIntegerValueWithinRange(List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Integer retValue = null;
        for (Annotation annotation : annotations) {
            int maxValue;
            if (!PodamIntValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamIntValue intStrategy = (PodamIntValue)annotation;
            String numValueStr = intStrategy.numValue();
            if (numValueStr != null && !"".equals(numValueStr)) {
                try {
                    retValue = Integer.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The annotation value: " + numValueStr + " could not be converted to an Integer. An exception will be thrown.";
                    this.LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            int minValue = intStrategy.minValue();
            if (minValue > (maxValue = intStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getIntegerInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        return retValue;
    }

    private Float getFloatValueWithinRange(List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Float retValue = null;
        for (Annotation annotation : annotations) {
            float maxValue;
            if (!PodamFloatValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamFloatValue floatStrategy = (PodamFloatValue)annotation;
            String numValueStr = floatStrategy.numValue();
            if (numValueStr != null && !"".equals(numValueStr)) {
                try {
                    retValue = Float.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The annotation value: " + numValueStr + " could not be converted to a Float. An exception will be thrown.";
                    this.LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            float minValue = floatStrategy.minValue();
            if (minValue > (maxValue = floatStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getFloatInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        return retValue;
    }

    private Double getDoubleValueWithinRange(List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Double retValue = null;
        for (Annotation annotation : annotations) {
            double maxValue;
            if (!PodamDoubleValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamDoubleValue doubleStrategy = (PodamDoubleValue)annotation;
            String numValueStr = doubleStrategy.numValue();
            if (numValueStr != null && !"".equals(numValueStr)) {
                try {
                    retValue = Double.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The annotation value: " + numValueStr + " could not be converted to a Double. An exception will be thrown.";
                    this.LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            double minValue = doubleStrategy.minValue();
            if (minValue > (maxValue = doubleStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getDoubleInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        return retValue;
    }

    private Long getLongValueWithinRange(List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Long retValue = null;
        for (Annotation annotation : annotations) {
            long maxValue;
            if (!PodamLongValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamLongValue longStrategy = (PodamLongValue)annotation;
            String numValueStr = longStrategy.numValue();
            if (numValueStr != null && !"".equals(numValueStr)) {
                try {
                    retValue = Long.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The annotation value: " + numValueStr + " could not be converted to a Long. An exception will be thrown.";
                    this.LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            long minValue = longStrategy.minValue();
            if (minValue > (maxValue = longStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getLongInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        return retValue;
    }

    private Object resolveWrapperValue(Class<?> candidateWrapperClass, List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Constable retValue = null;
        if (candidateWrapperClass.equals(Integer.class)) {
            if (!annotations.isEmpty()) {
                retValue = this.getIntegerValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getInteger(attributeMetadata);
            }
        } else if (candidateWrapperClass.equals(Long.class)) {
            if (!annotations.isEmpty()) {
                retValue = this.getLongValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getLong(attributeMetadata);
            }
        } else if (candidateWrapperClass.equals(Float.class)) {
            if (!annotations.isEmpty()) {
                retValue = this.getFloatValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getFloat(attributeMetadata);
            }
        } else if (candidateWrapperClass.equals(Double.class)) {
            if (!annotations.isEmpty()) {
                retValue = this.getDoubleValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getDouble(attributeMetadata);
            }
        } else if (candidateWrapperClass.equals(Boolean.class)) {
            if (!annotations.isEmpty()) {
                retValue = this.getBooleanValueForAnnotation(annotations);
            }
            if (retValue == null) {
                retValue = this.strategy.getBoolean(attributeMetadata);
            }
        } else if (candidateWrapperClass.equals(Byte.class)) {
            if (!annotations.isEmpty()) {
                retValue = this.getByteValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getByte(attributeMetadata);
            }
        } else if (candidateWrapperClass.equals(Short.class)) {
            if (!annotations.isEmpty()) {
                retValue = this.getShortValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getShort(attributeMetadata);
            }
        } else if (candidateWrapperClass.equals(Character.class)) {
            if (!annotations.isEmpty()) {
                retValue = this.getCharacterValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getCharacter(attributeMetadata);
            }
        }
        return retValue;
    }

    private <T> T resolvePojoWithoutSetters(Class<T> pojoClass, Map<Class<?>, Integer> pojos, Type ... genericTypeArgs) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object retValue = null;
        Constructor<?>[] constructors = pojoClass.getConstructors();
        if (constructors.length == 0) {
            retValue = this.createNewInstanceForClassWithoutConstructors(pojoClass, pojos, pojoClass, new Type[0]);
        } else {
            this.strategy.sort(constructors);
            Constructor<?>[] constructorArray = constructors;
            int n = constructors.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    Constructor<?> constructor = constructorArray[n2];
                    Object[] parameterValues = this.getParameterValuesForConstructor(constructor, pojoClass, pojos, genericTypeArgs);
                    try {
                        if (!constructor.isAccessible()) {
                            constructor.setAccessible(true);
                        }
                        if ((retValue = constructor.newInstance(parameterValues)) instanceof Collection && ((Collection)retValue).size() == 0) {
                            this.LOG.info("We could create an instance with constructor: " + constructor + ", but collection is empty" + ". Will try with another one.");
                            break block9;
                        }
                        if (retValue instanceof Map && ((Map)retValue).size() == 0) {
                            this.LOG.info("We could create an instance with constructor: " + constructor + ", but map is empty" + ". Will try with another one.");
                            break block9;
                        }
                        this.LOG.info("We could create an instance with constructor: " + constructor);
                        break;
                    }
                    catch (Throwable t) {
                        this.LOG.warn("We couldn't create an instance for pojo: " + pojoClass + " for constructor: " + constructor + ". Will try with another one.");
                    }
                }
                ++n2;
            }
            if (retValue == null) {
                this.LOG.warn("For class: {} PODAM could not possibly create a value. This attribute will be returned as null.", pojoClass);
            }
        }
        return (T)retValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T manufacturePojoInternal(Class<T> pojoClass, Map<Class<?>, Integer> pojos, Type ... genericTypeArgs) {
        try {
            T retValue = null;
            if (pojoClass.isPrimitive()) {
                ArrayList<Annotation> annotations = new ArrayList<Annotation>();
                String noName = null;
                return (T)this.resolvePrimitiveValue(pojoClass, annotations, new AttributeMetadata(noName, pojoClass, annotations));
            }
            if (pojoClass.isInterface() || Modifier.isAbstract(pojoClass.getModifiers())) {
                Class<T> specificClass = this.strategy.getSpecificClass(pojoClass);
                if (specificClass != pojoClass) {
                    return this.manufacturePojoInternal(specificClass, pojos, genericTypeArgs);
                }
                this.LOG.warn("Cannot instantiate an interface or abstract class {}. Returning null.", pojoClass);
                return null;
            }
            ClassInfo classInfo = PodamUtils.getClassInfo(pojoClass, this.excludeAnnotations);
            try {
                Constructor<?>[] constructors = pojoClass.getConstructors();
                if (constructors == null || constructors.length == 0) {
                    this.LOG.warn("No public constructors were found. We'll look for a default, non-public constructor. ");
                    Constructor<T> defaultConstructor = pojoClass.getDeclaredConstructor(new Class[0]);
                    this.LOG.info("Will use: " + defaultConstructor);
                    defaultConstructor.setAccessible(true);
                    retValue = defaultConstructor.newInstance(new Object[0]);
                } else {
                    retValue = this.resolvePojoWithoutSetters(pojoClass, pojos, genericTypeArgs);
                }
            }
            catch (SecurityException e) {
                throw new PodamMockeryException("Security exception while applying introspection.", e);
            }
            catch (NoSuchMethodException e1) {
                this.LOG.warn("No default (public or non-public) constructors were found. Also no other public constructors were found. Your last hope is that we find a non-public, non-default constructor.");
                Constructor<?>[] constructors = pojoClass.getDeclaredConstructors();
                if (constructors == null || constructors.length == 0) {
                    throw new IllegalStateException("The POJO " + pojoClass + " appears without constructors. How is this possible? ");
                }
                this.LOG.info("Will use: " + constructors[0]);
                Object[] parameterValuesForConstructor = this.getParameterValuesForConstructor(constructors[0], pojoClass, pojos, genericTypeArgs);
                constructors[0].setAccessible(true);
                retValue = (T)constructors[0].newInstance(parameterValuesForConstructor);
            }
            if (retValue == null) {
                return null;
            }
            Class<?>[] parameterTypes = null;
            Class attributeType = null;
            Object setterArg = null;
            Iterator<Method> iterator = classInfo.getClassSetters().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return retValue;
                }
                Method setter = iterator.next();
                List<Annotation> pojoAttributeAnnotations = this.retrieveFieldAnnotations(pojoClass, setter);
                String attributeName = PodamUtils.extractFieldNameFromSetterMethod(setter);
                parameterTypes = setter.getParameterTypes();
                if (parameterTypes.length != 1) {
                    throw new IllegalStateException("A " + pojoClass.getSimpleName() + "." + setter.getName() + "() should have only one argument");
                }
                attributeType = parameterTypes[0];
                PodamStrategyValue attributeStrategyAnnotation = this.containsAttributeStrategyAnnotation(pojoAttributeAnnotations);
                if (attributeStrategyAnnotation != null) {
                    AttributeStrategy<?> attributeStrategy = attributeStrategyAnnotation.value().newInstance();
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug("The attribute: " + attributeName + " will be filled using the following strategy: " + attributeStrategy);
                    }
                    setterArg = this.returnAttributeDataStrategyValue(attributeType, attributeStrategy);
                } else {
                    HashMap<String, Type> typeArgsMap = new HashMap<String, Type>();
                    try {
                        Type[] genericTypeArgsExtra = this.fillTypeArgMap(typeArgsMap, pojoClass, genericTypeArgs);
                        if (genericTypeArgsExtra != null) {
                            this.LOG.warn(String.format("Lost %d generic type arguments", genericTypeArgsExtra.length));
                        }
                    }
                    catch (IllegalStateException e) {
                        this.LOG.error(e.getMessage());
                        return null;
                    }
                    Type[] typeArguments = new Type[]{};
                    if (setter.getGenericParameterTypes()[0] instanceof ParameterizedType) {
                        ParameterizedType attributeParameterizedType = (ParameterizedType)setter.getGenericParameterTypes()[0];
                        typeArguments = attributeParameterizedType.getActualTypeArguments();
                    } else if (setter.getGenericParameterTypes()[0] instanceof TypeVariable) {
                        TypeVariable typeVariable = (TypeVariable)setter.getGenericParameterTypes()[0];
                        Type type = (Type)typeArgsMap.get(typeVariable.getName());
                        if (type instanceof ParameterizedType) {
                            ParameterizedType attributeParameterizedType = (ParameterizedType)type;
                            typeArguments = attributeParameterizedType.getActualTypeArguments();
                            attributeType = (Class)attributeParameterizedType.getRawType();
                        } else {
                            attributeType = (Class)type;
                        }
                    }
                    setterArg = this.manufactureAttributeValue(pojoClass, pojos, attributeType, pojoAttributeAnnotations, attributeName, typeArgsMap, typeArguments);
                }
                if (setterArg != null) {
                    if (!setter.isAccessible()) {
                        this.LOG.warn("The setter: {} is not accessible.Setting it to accessible. However this is a security hack and your code should really adhere to Javabean standards.", (Object)setter.getName());
                        setter.setAccessible(true);
                    }
                    setter.invoke(retValue, setterArg);
                    continue;
                }
                this.LOG.warn("Couldn't find a suitable value for attribute: {}. This POJO attribute will be left to null.", attributeType);
            }
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException("An instantiation exception occurred", e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException("An illegal access occurred", e);
        }
        catch (IllegalArgumentException e) {
            throw new PodamMockeryException("An illegal argument was passed", e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException("Invocation Target Exception", e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException("ClassNotFoundException Exception", e);
        }
    }

    private Object manufactureAttributeValue(Class<?> pojoClass, Map<Class<?>, Integer> pojos, Class<?> attributeType, List<Annotation> annotations, String attributeName, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, IllegalArgumentException, ClassNotFoundException {
        HashMap<String, Type> nullTypeArgsMap = new HashMap<String, Type>();
        return this.manufactureAttributeValue(pojoClass, pojos, attributeType, annotations, attributeName, nullTypeArgsMap, genericTypeArgs);
    }

    private Object manufactureAttributeValue(Class<?> pojoClass, Map<Class<?>, Integer> pojos, Class<?> attributeType, List<Annotation> annotations, String attributeName, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, IllegalArgumentException, ClassNotFoundException {
        Object attributeValue = null;
        Class realAttributeType = genericTypeArgs.length > 0 && genericTypeArgs[0] instanceof Class && attributeType.isAssignableFrom((Class)genericTypeArgs[0]) ? (Class)genericTypeArgs[0] : attributeType;
        AttributeMetadata attributeMetadata = new AttributeMetadata(attributeName, realAttributeType, annotations);
        if (realAttributeType.isPrimitive()) {
            attributeValue = this.resolvePrimitiveValue(realAttributeType, annotations, attributeMetadata);
        } else if (this.isWrapper(realAttributeType)) {
            attributeValue = this.resolveWrapperValue(realAttributeType, annotations, attributeMetadata);
        } else if (realAttributeType.equals(String.class)) {
            attributeValue = this.resolveStringValue(annotations, attributeMetadata);
        } else if (realAttributeType.getName().startsWith("[")) {
            attributeValue = this.resolveArrayElementValue(realAttributeType, pojos, annotations, pojoClass, attributeName, typeArgsMap);
        } else if (Collection.class.isAssignableFrom(realAttributeType)) {
            attributeValue = this.resolveCollectionValueWhenCollectionIsPojoAttribute(pojoClass, pojos, realAttributeType, attributeName, annotations, typeArgsMap, genericTypeArgs);
        } else if (Map.class.isAssignableFrom(realAttributeType)) {
            attributeValue = this.resolveMapValueWhenMapIsPojoAttribute(pojoClass, pojos, realAttributeType, attributeName, annotations, typeArgsMap, genericTypeArgs);
        } else if (realAttributeType.isEnum()) {
            int enumConstantsLength = realAttributeType.getEnumConstants().length;
            if (enumConstantsLength > 0) {
                int enumIndex = this.strategy.getIntegerInRange(0, enumConstantsLength, attributeMetadata) % enumConstantsLength;
                attributeValue = realAttributeType.getEnumConstants()[enumIndex];
            }
        } else {
            Integer depth = pojos.get(realAttributeType);
            if (depth == null) {
                depth = -1;
            }
            if (depth <= this.strategy.getMaxDepth(pojoClass)) {
                pojos.put(realAttributeType, depth + 1);
                attributeValue = realAttributeType.getName().startsWith("java.") || realAttributeType.getName().startsWith("javax.") ? this.createNewInstanceForClassWithoutConstructors(pojoClass, pojos, realAttributeType, genericTypeArgs) : this.manufacturePojoInternal(realAttributeType, pojos, genericTypeArgs);
                pojos.put(realAttributeType, depth);
            } else {
                this.LOG.warn("Loop in {} production detected. Returning null.", (Object)realAttributeType);
                attributeValue = null;
            }
        }
        return attributeValue;
    }

    private String resolveStringValue(List<Annotation> annotations, AttributeMetadata attributeMetadata) throws InstantiationException, IllegalAccessException {
        String retValue = null;
        if (annotations == null || annotations.isEmpty()) {
            retValue = this.strategy.getStringValue(attributeMetadata);
        } else {
            for (Annotation annotation : annotations) {
                if (!PodamStringValue.class.isAssignableFrom(annotation.getClass())) continue;
                PodamStringValue podamAnnotation = (PodamStringValue)annotation;
                retValue = podamAnnotation.strValue() != null && podamAnnotation.strValue().length() > 0 ? podamAnnotation.strValue() : this.strategy.getStringOfLength(podamAnnotation.length(), attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getStringValue(attributeMetadata);
            }
        }
        return retValue;
    }

    private PodamStrategyValue containsAttributeStrategyAnnotation(List<Annotation> annotations) {
        PodamStrategyValue retValue = null;
        for (Annotation annotation : annotations) {
            if (!PodamStrategyValue.class.isAssignableFrom(annotation.getClass())) continue;
            retValue = (PodamStrategyValue)annotation;
            break;
        }
        return retValue;
    }

    private boolean isWrapper(Class<?> candidateWrapperClass) {
        return candidateWrapperClass.equals(Byte.class) ? true : (candidateWrapperClass.equals(Boolean.class) ? true : (candidateWrapperClass.equals(Character.class) ? true : (candidateWrapperClass.equals(Short.class) ? true : (candidateWrapperClass.equals(Integer.class) ? true : (candidateWrapperClass.equals(Long.class) ? true : (candidateWrapperClass.equals(Float.class) ? true : candidateWrapperClass.equals(Double.class)))))));
    }

    private List<Annotation> retrieveFieldAnnotations(Class<?> clazz, Method setter) {
        Annotation[] annotations;
        List<Annotation> retValue = new ArrayList<Annotation>();
        String attributeName = PodamUtils.extractFieldNameFromSetterMethod(setter);
        AccessibleObject setterField = null;
        while (clazz != null) {
            try {
                setterField = clazz.getDeclaredField(attributeName);
                break;
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
            catch (SecurityException e) {
                throw e;
            }
        }
        if (setterField != null && (annotations = setterField.getAnnotations()) != null && annotations.length != 0) {
            retValue = Arrays.asList(annotations);
        }
        return retValue;
    }

    private Collection<? super Object> resolveCollectionValueWhenCollectionIsPojoAttribute(Class<?> pojoClass, Map<Class<?>, Integer> pojos, Class<?> collectionType, String attributeName, List<Annotation> annotations, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) {
        Collection<? super Object> retValue = null;
        try {
            try {
                this.validateAttributeName(attributeName);
                Object newInstance = pojoClass.newInstance();
                Field field = null;
                for (Class<?> clazz = pojoClass; clazz != null; clazz = clazz.getSuperclass()) {
                    try {
                        field = clazz.getDeclaredField(attributeName);
                        break;
                    }
                    catch (NoSuchFieldException e) {
                        continue;
                    }
                    catch (SecurityException e) {
                        throw e;
                    }
                }
                if (field == null) {
                    throw new NoSuchFieldException();
                }
                field.setAccessible(true);
                Collection<? super Object> coll = (Collection<? super Object>)field.get(newInstance);
                retValue = coll != null ? coll : this.resolveCollectionType(collectionType);
            }
            catch (Exception e) {
                retValue = this.resolveCollectionType(collectionType);
            }
            Class<Object> typeClass = null;
            AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
            if (genericTypeArgs == null || genericTypeArgs.length == 0) {
                this.LOG.warn("The collection attribute: " + attributeName + " does not have a type. We will assume Object for you");
                typeClass = Object.class;
            } else {
                Type actualTypeArgument = genericTypeArgs[0];
                typeClass = this.resolveGenericParameter(actualTypeArgument, typeArgsMap, elementGenericTypeArgs);
            }
            this.fillCollection(pojoClass, pojos, attributeName, annotations, retValue, typeClass, elementGenericTypeArgs.get());
        }
        catch (SecurityException e) {
            throw new PodamMockeryException("An exception occurred while resolving the collection", e);
        }
        catch (IllegalArgumentException e) {
            throw new PodamMockeryException("An exception occurred while resolving the collection", e);
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException("An exception occurred while resolving the collection", e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException("An exception occurred while resolving the collection", e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException("An exception occurred while resolving the collection", e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException("An exception occurred while resolving the collection", e);
        }
        return retValue;
    }

    private void fillCollection(Class<?> pojoClass, Map<Class<?>, Integer> pojos, String attributeName, List<Annotation> annotations, Collection<? super Object> collection, Class<?> collectionElementType, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        PodamCollection collectionAnnotation = null;
        AttributeStrategy<?> elementStrategy = null;
        for (Annotation annotation : annotations) {
            if (!PodamCollection.class.isAssignableFrom(annotation.getClass())) continue;
            collectionAnnotation = (PodamCollection)annotation;
            break;
        }
        int nbrElements = this.strategy.getNumberOfCollectionElements(pojoClass);
        if (collectionAnnotation != null) {
            nbrElements = collectionAnnotation.nbrElements();
            elementStrategy = collectionAnnotation.collectionElementStrategy().newInstance();
        }
        int i = 0;
        while (i < nbrElements) {
            if (elementStrategy != null && ObjectStrategy.class.isAssignableFrom(elementStrategy.getClass()) && Object.class.equals(collectionElementType)) {
                this.LOG.debug("Element strategy is ObjectStrategy and collection element is of type Object: using the ObjectStrategy strategy");
                collection.add(elementStrategy.getValue());
            } else if (elementStrategy != null && !ObjectStrategy.class.isAssignableFrom(elementStrategy.getClass())) {
                this.LOG.debug("Collection elements will be filled using the following strategy: " + elementStrategy);
                Object strategyValue = this.returnAttributeDataStrategyValue(collectionElementType, elementStrategy);
                collection.add(strategyValue);
            } else {
                collection.add(this.manufactureAttributeValue(pojoClass, pojos, collectionElementType, annotations, attributeName, genericTypeArgs));
            }
            ++i;
        }
    }

    private Map<? super Object, ? super Object> resolveMapValueWhenMapIsPojoAttribute(Class<?> pojoClass, Map<Class<?>, Integer> pojos, Class<?> attributeType, String attributeName, List<Annotation> annotations, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) {
        Map<? super Object, ? super Object> retValue = null;
        try {
            try {
                this.validateAttributeName(attributeName);
                Class<?> workClass = pojoClass;
                Object newInstance = null;
                Field field = null;
                newInstance = pojoClass.newInstance();
                while (workClass != null) {
                    try {
                        field = workClass.getDeclaredField(attributeName);
                        break;
                    }
                    catch (NoSuchFieldException e) {
                        workClass = workClass.getSuperclass();
                    }
                }
                if (field == null) {
                    throw new IllegalStateException("It was not possible to retrieve field: " + attributeName);
                }
                field.setAccessible(true);
                Map<? super Object, ? super Object> coll = (Map<? super Object, ? super Object>)field.get(newInstance);
                retValue = coll != null ? coll : this.resolveMapType(attributeType);
            }
            catch (Exception e) {
                retValue = this.resolveMapType(attributeType);
            }
            Class keyClass = null;
            Class elementClass = null;
            AtomicReference<Type[]> keyGenericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
            AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
            if (genericTypeArgs == null || genericTypeArgs.length == 0) {
                this.LOG.warn("Map attribute: " + attributeName + " is non-generic. We will assume a Map<Object, Object> for you.");
                keyClass = Object.class;
                elementClass = Object.class;
            } else {
                if (genericTypeArgs.length != 2) {
                    throw new IllegalStateException("In a Map only key value generic type are expected.");
                }
                Type[] actualTypeArguments = genericTypeArgs;
                keyClass = this.resolveGenericParameter(actualTypeArguments[0], typeArgsMap, keyGenericTypeArgs);
                elementClass = this.resolveGenericParameter(actualTypeArguments[1], typeArgsMap, elementGenericTypeArgs);
            }
            this.fillMap(pojoClass, pojos, attributeName, annotations, retValue, keyClass, elementClass, keyGenericTypeArgs.get(), elementGenericTypeArgs.get());
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException("An exception occurred while creating a Map object", e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException("An exception occurred while creating a Map object", e);
        }
        catch (SecurityException e) {
            throw new PodamMockeryException("An exception occurred while creating a Map object", e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException("An exception occurred while creating a Map object", e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException("An exception occurred while creating a Map object", e);
        }
        return retValue;
    }

    private void fillMap(Class<?> pojoClass, Map<Class<?>, Integer> pojos, String attributeName, List<Annotation> annotations, Map<? super Object, ? super Object> mapToBeFilled, Class<?> keyClass, Class<?> elementClass, Type[] keyGenericTypeArgs, Type[] elementGenericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        PodamCollection collectionAnnotation = null;
        AttributeStrategy<?> keyStrategy = null;
        AttributeStrategy<?> elementStrategy = null;
        for (Annotation annotation : annotations) {
            if (!PodamCollection.class.isAssignableFrom(annotation.getClass())) continue;
            collectionAnnotation = (PodamCollection)annotation;
            break;
        }
        int nbrElements = this.strategy.getNumberOfCollectionElements(pojoClass);
        if (collectionAnnotation != null) {
            nbrElements = collectionAnnotation.nbrElements();
            keyStrategy = collectionAnnotation.mapKeyStrategy().newInstance();
            elementStrategy = collectionAnnotation.mapElementStrategy().newInstance();
        }
        int i = 0;
        while (i < nbrElements) {
            Object keyValue = null;
            Object elementValue = null;
            keyValue = this.getMapKeyOrElementValue(pojoClass, pojos, attributeName, annotations, keyClass, collectionAnnotation, keyStrategy, keyGenericTypeArgs);
            elementValue = this.getMapKeyOrElementValue(pojoClass, pojos, attributeName, annotations, elementClass, collectionAnnotation, elementStrategy, elementGenericTypeArgs);
            mapToBeFilled.put(keyValue, elementValue);
            ++i;
        }
    }

    private Object getMapKeyOrElementValue(Class<?> pojoClass, Map<Class<?>, Integer> pojos, String attributeName, List<Annotation> annotations, Class<?> keyOrValueType, PodamCollection collectionAnnotation, AttributeStrategy<?> elementStrategy, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object retValue = null;
        if (elementStrategy != null && ObjectStrategy.class.isAssignableFrom(elementStrategy.getClass()) && Object.class.equals(keyOrValueType)) {
            this.LOG.debug("Element strategy is ObjectStrategy and Map key or value type is of type Object: using the ObjectStrategy strategy");
            retValue = elementStrategy.getValue();
        } else if (elementStrategy != null && !ObjectStrategy.class.isAssignableFrom(elementStrategy.getClass())) {
            this.LOG.debug("Map key or value will be filled using the following strategy: " + elementStrategy);
            retValue = this.returnAttributeDataStrategyValue(keyOrValueType, elementStrategy);
        } else {
            retValue = this.manufactureAttributeValue(pojoClass, pojos, keyOrValueType, annotations, attributeName, genericTypeArgs);
        }
        return retValue;
    }

    private Object resolveArrayElementValue(Class<?> attributeType, Map<Class<?>, Integer> pojos, List<Annotation> annotations, Class<?> pojoClass, String attributeName, Map<String, Type> typeArgsMap) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        int nbrElements;
        Class<?> componentType = attributeType.getComponentType();
        AtomicReference<Type[]> genericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
        if (attributeName != null) {
            try {
                Type type;
                Type genericType = pojoClass.getDeclaredField(attributeName).getGenericType();
                if (genericType instanceof GenericArrayType && (type = ((GenericArrayType)genericType).getGenericComponentType()) instanceof TypeVariable) {
                    Type typeVarType = typeArgsMap.get(((TypeVariable)type).getName());
                    componentType = this.resolveGenericParameter(typeVarType, typeArgsMap, genericTypeArgs);
                }
            }
            catch (NoSuchFieldException e) {
                this.LOG.info("Cannot get the declared field type for field " + attributeName + " of class " + pojoClass.getName());
            }
        }
        PodamCollection collectionAnnotation = null;
        AttributeStrategy<?> elementStrategy = null;
        for (Annotation annotation : annotations) {
            if (!PodamCollection.class.isAssignableFrom(annotation.getClass())) continue;
            collectionAnnotation = (PodamCollection)annotation;
            break;
        }
        if (collectionAnnotation != null) {
            nbrElements = collectionAnnotation.nbrElements();
            elementStrategy = collectionAnnotation.collectionElementStrategy().newInstance();
        } else {
            nbrElements = this.strategy.getNumberOfCollectionElements(attributeType);
        }
        Object arrayElement = null;
        Object array = Array.newInstance(componentType, nbrElements);
        int i = 0;
        while (i < nbrElements) {
            if (elementStrategy != null && ObjectStrategy.class.isAssignableFrom(collectionAnnotation.collectionElementStrategy()) && Object.class.equals(componentType)) {
                this.LOG.debug("Element strategy is ObjectStrategy and array element is of type Object: using the ObjectStrategy strategy");
                arrayElement = elementStrategy.getValue();
            } else if (elementStrategy != null && !ObjectStrategy.class.isAssignableFrom(collectionAnnotation.collectionElementStrategy())) {
                this.LOG.debug("Array elements will be filled using the following strategy: " + elementStrategy);
                arrayElement = this.returnAttributeDataStrategyValue(componentType, elementStrategy);
            } else {
                arrayElement = this.manufactureAttributeValue(pojoClass, pojos, componentType, annotations, attributeName, typeArgsMap, genericTypeArgs.get());
            }
            Array.set(array, i, arrayElement);
            ++i;
        }
        return array;
    }

    private Collection<? super Object> resolveCollectionType(Class<?> collectionType) {
        AbstractCollection retValue = null;
        if (List.class.isAssignableFrom(collectionType) || collectionType.equals(Collection.class)) {
            retValue = new ArrayList();
        } else if (Queue.class.isAssignableFrom(collectionType)) {
            retValue = new LinkedList();
        } else if (Set.class.isAssignableFrom(collectionType)) {
            retValue = new HashSet();
        } else {
            throw new IllegalArgumentException("Collection type: " + collectionType + " not supported");
        }
        return retValue;
    }

    private Map<? super Object, ? super Object> resolveMapType(Class<?> attributeType) {
        AbstractMap retValue = null;
        retValue = SortedMap.class.isAssignableFrom(attributeType) ? new TreeMap() : (ConcurrentMap.class.isAssignableFrom(attributeType) ? new ConcurrentHashMap() : new HashMap());
        return retValue;
    }

    private void validateAttributeName(String attributeName) {
        if (attributeName == null || "".equals(attributeName)) {
            throw new IllegalArgumentException("The field name must not be null or empty!");
        }
    }

    private Object[] getParameterValuesForConstructor(Constructor<?> constructor, Class<?> pojoClass, Map<Class<?>, Integer> pojos, Type ... genericTypeArgs) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        HashMap<String, Type> typeArgsMap = new HashMap<String, Type>();
        Type[] genericTypeArgsExtra = null;
        try {
            genericTypeArgsExtra = this.fillTypeArgMap(typeArgsMap, pojoClass, genericTypeArgs);
        }
        catch (IllegalStateException e) {
            this.LOG.error(e.getMessage());
            return null;
        }
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        Object[] parameterValues = new Object[constructor.getParameterTypes().length];
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        int idx = 0;
        Class<?>[] classArray = parameterTypes;
        int n = parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type type;
            Class<?> parameterType = classArray[n2];
            List<Annotation> annotations = Arrays.asList(parameterAnnotations[idx]);
            String attributeName = null;
            if (Collection.class.isAssignableFrom(parameterType)) {
                Class collectionElementType;
                Collection<? super Object> collection = this.resolveCollectionType(parameterType);
                type = constructor.getGenericParameterTypes()[idx];
                AtomicReference<Type[]> collectionGenericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
                if (type instanceof ParameterizedType) {
                    ParameterizedType pType = (ParameterizedType)type;
                    Type actualTypeArgument = pType.getActualTypeArguments()[0];
                    collectionElementType = this.resolveGenericParameter(actualTypeArgument, typeArgsMap, collectionGenericTypeArgs);
                } else {
                    collectionElementType = Object.class;
                }
                Type[] genericTypeArgsAll = this.mergeTypeArrays(collectionGenericTypeArgs.get(), genericTypeArgsExtra);
                this.fillCollection(pojoClass, pojos, attributeName, annotations, collection, collectionElementType, genericTypeArgsAll);
                parameterValues[idx] = collection;
            } else if (Map.class.isAssignableFrom(parameterType)) {
                Class elementClass;
                Class keyClass;
                Map<? super Object, ? super Object> mapType = this.resolveMapType(parameterType);
                type = constructor.getGenericParameterTypes()[idx];
                AtomicReference<Type[]> keyGenericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
                AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
                if (type instanceof ParameterizedType) {
                    ParameterizedType pType = (ParameterizedType)type;
                    Type[] actualTypeArguments = pType.getActualTypeArguments();
                    keyClass = this.resolveGenericParameter(actualTypeArguments[0], typeArgsMap, keyGenericTypeArgs);
                    elementClass = this.resolveGenericParameter(actualTypeArguments[1], typeArgsMap, elementGenericTypeArgs);
                } else {
                    keyClass = Object.class;
                    elementClass = Object.class;
                }
                Type[] genericTypeArgsAll = this.mergeTypeArrays(elementGenericTypeArgs.get(), genericTypeArgsExtra);
                this.fillMap(pojoClass, pojos, attributeName, annotations, mapType, keyClass, elementClass, keyGenericTypeArgs.get(), genericTypeArgsAll);
                parameterValues[idx] = mapType;
            } else {
                parameterValues[idx] = this.manufactureAttributeValue(pojoClass, pojos, parameterType, annotations, attributeName, genericTypeArgs);
            }
            ++idx;
            ++n2;
        }
        return parameterValues;
    }

    private Type[] mergeTypeArrays(Type[] original, Type[] extra) {
        Type[] merged;
        if (extra != null) {
            merged = new Type[original.length + extra.length];
            System.arraycopy(original, 0, merged, 0, original.length);
            System.arraycopy(extra, 0, merged, original.length, extra.length);
        } else {
            merged = original;
        }
        return merged;
    }

    private Object returnAttributeDataStrategyValue(Class<?> attributeType, AttributeStrategy<?> attributeStrategy) throws InstantiationException, IllegalAccessException {
        Object retValue = null;
        Method attributeStrategyMethod = null;
        try {
            attributeStrategyMethod = attributeStrategy.getClass().getMethod("getValue", new Class[0]);
            if (!attributeType.isAssignableFrom(attributeStrategyMethod.getReturnType())) {
                String errMsg = "The type of the Podam Attribute Strategy is not " + attributeType.getName() + " but " + attributeStrategyMethod.getReturnType().getName() + ". An exception will be thrown.";
                this.LOG.error(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            retValue = attributeStrategy.getValue();
        }
        catch (SecurityException e) {
            throw new IllegalStateException("A security issue occurred while retrieving the Podam Attribute Strategy details", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("It seems the Podam Attribute Annotation is of the wrong type", e);
        }
        return retValue;
    }

    public List<Class<? extends Annotation>> getExcludeAnnotations() {
        return this.excludeAnnotations;
    }

    public void setExcludeAnnotations(List<Class<? extends Annotation>> excludeAnnotations) {
        this.excludeAnnotations = excludeAnnotations;
    }
}

