<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
	pageEncoding="ISO-8859-1"%>
<%@ page
	import="java.io.File, java.util.Map, java.util.HashMap, java.io.BufferedReader, java.io.FileReader,
	java.util.jar.JarFile, java.util.jar.Manifest, java.util.jar.Attributes" %>
<%@ page
	import="java.io.IOException, java.net.URL, java.net.URISyntaxException"%>
<%@ page
	import="org.apache.commons.lang3.StringEscapeUtils"%>

<%!
	public static boolean isNumeric(String str) {
		try {
			double d = Double.parseDouble(str);
		} catch (NumberFormatException nfe) {
			return false;
		}
		return true;
	}

	public String getFileContents(String filePath) {
		StringBuffer contents = new StringBuffer();
		BufferedReader br = null;
		String strLine = null;
		File f = null;
		try {
			String path = getServletContext().getRealPath(filePath);
			FileReader fr = new FileReader(path);
			br = new BufferedReader(fr);
			while ((strLine = br.readLine()) != null) {
				contents.append(strLine);
				contents.append("\n");
			}
		} catch (IOException ioe) {
			ioe.printStackTrace();
		} finally {
			try {
				if (br != null)
					br.close();
			} catch (IOException ex) {
				ex.printStackTrace();
			}
		}
		return contents.toString();
	}

	public Map<String, String> readProperties(String fileContent) {
		Map<String, String> propsMap = new HashMap<String, String>();
		String[] strArr = fileContent.split("\n");
		String[] arr = null;
		for (String str : strArr) {
			System.out.println(str);
			arr = str.split("=");
			if (arr.length == 2) {
				propsMap.put(arr[0].trim(), arr[1].trim());
			}
		}
		return propsMap;
	}

	public String replaceContent(String content, Map<String, String> props) {
		for (String key : props.keySet()) {
			String value = props.get(key);
			content = content.replace("${" + key + "}", (value == null) ? "" : value);
		}
		return content;
	}

	public static boolean isJarDownloadRequired(long versionFromClient, long fileLastVersion, long unixTimeFromClient, long fileLastModified) {
		if(versionFromClient == fileLastVersion && unixTimeFromClient == fileLastModified) {
		    return false; //if version & build time exact match, no need to download jars. Otherwise, we need to download jars.
		}
		return true;
	}
%>
<%
	HttpSession jnlpSession;
	String jnlpFile;
	String fileRedirect;
	String if_modified_since_string;
	long if_modified_since;
	boolean debug = false;
	String samlToken, versionString, forceDownload, userName;

	response.setHeader("X-Frame-Options", "SAMEORIGIN");

	jnlpSession = request.getSession();
	jnlpFile = StringEscapeUtils.escapeHtml4(request.getParameter("jnlp"));
	fileRedirect = StringEscapeUtils.escapeHtml4(request.getParameter("file"));
	if_modified_since_string = StringEscapeUtils.escapeHtml4(request.getParameter("if_modified_since"));
	samlToken = StringEscapeUtils.escapeHtml4(request.getParameter("SAMLResponse"));
	if(samlToken==null){
		samlToken = "";
	}
	userName = StringEscapeUtils.escapeHtml4(request.getParameter("username"));
	if(userName==null){
		userName = "";
	}
	versionString = StringEscapeUtils.escapeHtml4(request.getParameter("version"));
	forceDownload = StringEscapeUtils.escapeHtml4(request.getParameter("force"));

	File FSO;

	if (debug) {
		out.print("Session: " + jnlpSession + "</br>");
		out.print("JNLP: " + jnlpFile + "</br>");
		out.print("File: " + fileRedirect + "</br>");
		out.print("Modified-Since String: " + if_modified_since_string + "</br>");
		out.println("The value of context path is: " + request.getContextPath()+ "</br>");
		if(samlToken!=null && samlToken.trim().length()>0){
			out.println("saml token is present. Received token is:" + samlToken+ "</br>");
		}
		else {
			out.println("saml token is Not present"+ "</br>");
		}
		out.println(" username: " + userName + "</br>");
		out.println(" Version: " + versionString + "</br>");
		out.println("Force download: " + forceDownload + "</br>");
	}
	if (fileRedirect != null && fileRedirect.length() != 0) {
		String File;
		File fileObject;
		long unixTimeFromClient = -1, versionFromClient = -1;
		long fileLastModified = 0, fileLastVersion = 0;
		File = fileRedirect;
		boolean force = false;

		String reqHeader = request.getRequestURL().toString();
		String temp = reqHeader.toLowerCase();
		String baseUrl = temp.replace("index.jsp", "");
		String actualPath = getServletContext().getRealPath("/") + fileRedirect;

		if(debug) {
			out.println("The value of baseUrl is : " + baseUrl + "</br>");
		}

		//fileObject = new File(actualPath);
		//fileLastModified = fileObject.lastModified() / 1000;
		 JarFile jarFile = null;
        
         if(actualPath.contains(".jar")) {
            try {
              jarFile = new JarFile(actualPath, false);
              Manifest mf = jarFile.getManifest();
      		  if (mf != null) {
           		String guiVersion = mf.getMainAttributes().getValue("GUIVersion");//Reading GUI Version from Manifest file
           		if (guiVersion != null && guiVersion.length() > 0) {
                	if (isNumeric(guiVersion)) {
                    	 fileLastVersion = Long.parseLong(guiVersion);
               	    }
               		if (debug) {
                    	out.print("File Last Version: " + fileLastVersion + " </br>");
               		}
                 }

       		  String jarlastModified = mf.getMainAttributes().getValue("BuildDate");//Reading Build Date from Manifest file
         	  if (jarlastModified != null && jarlastModified.length() > 0) {
            	 //SimpleDateFormat sdf  = new SimpleDateFormat("mm/dd/yyyy kk:mm");
            	 //Date date = sdf.parse(jarlastModified);
            	 fileLastModified = jarlastModified.hashCode();//hashcode will be unique
       	 	  }
       	    }
   	 	   } catch (Exception exp) {
        	 throw new Exception("Access is denied");
       	   } 
     	}

		if (debug) {
			out.print("Last Modified: " + fileLastModified + "</br>");
			out.print("actualPath: " + actualPath + "</br>");
			out.print("fileLastVersion: " + fileLastVersion + "</br>");
		}
		if (if_modified_since_string != null
				&& if_modified_since_string.length() > 0) {
			if (isNumeric(if_modified_since_string)) {
				unixTimeFromClient = Long.parseLong(if_modified_since_string);
			} else {
				response.sendRedirect(baseUrl + fileRedirect);
			}
			if (debug) {
				out.print("Time from client: " + unixTimeFromClient + " </br>");
			}
		}

		if (versionString != null && versionString.length() > 0) {
			if (isNumeric(versionString)) {
				versionFromClient = Long.parseLong(versionString);
			}
			if (debug) {
				out.print("Version from Client: " + versionFromClient + " </br>");
			}
		}

		if (forceDownload != null && forceDownload.length() > 0) {
			force = Boolean.parseBoolean(forceDownload);
			if (debug) {
				out.print("Force Download: " + force + " </br>");
			}
		}


		if (force || isJarDownloadRequired(versionFromClient, fileLastVersion, unixTimeFromClient, fileLastModified)) {
			if (debug) {
				response.getWriter().write("Sending File " + fileRedirect + "</br>");
				out.print(" Jar Download Required </br>");
			} else {
			    response.sendRedirect(baseUrl + fileRedirect);
			}
		} else {
			if (debug) {
				response.getWriter().write("304 Not Modified </br>");
				out.print("304 Not Modified </br>");
			} else {
				response.reset();
				response.setStatus(304);
			}
		}
		
		if (jarFile != null) {
		    jarFile.close();
		}
	}
	// Determine if this is CommNet or Galaxy Console and direct to correct folder
	if (!debug) {
		String strWebFolder = "/Web/";
		Map<String, String> oemProps;

		String oemPath= "/OEM.properties";
		String path = getServletContext().getRealPath(oemPath);
		if (path==null){
			oemPath = "/OEM.properties";
		}
		oemProps = readProperties(getFileContents(oemPath));
		String oemId = oemProps.get("id");
		if (oemId == null || oemId.equalsIgnoreCase("%id%")) {
			oemId = "1";
		}

		String proxyHost = oemProps.get("consoleProxyHostName");
		String proxyPort = oemProps.get("consoleProxyPort");
		if (proxyHost == null || proxyHost.equalsIgnoreCase("%consoleProxyHostName%")) {
			proxyHost = "";
		}
		if (proxyPort == null || proxyPort.equalsIgnoreCase("%consoleProxyPort%")) {
			proxyPort = "";
		}

		String strOemWebImageFolder = strWebFolder + oemId + "/images/";
		String jnlpPropFile = strOemWebImageFolder + "../jnlp.properties";
		String jnlpContents = getFileContents(jnlpPropFile);
		if(debug) {
			out.println("jnlpPropFile is: "+jnlpPropFile);
			out.println("jnlpPropFile File COntents : "+jnlpContents);
			out.println("reading jnlp props");
		}
		Map<String, String> jnlpProps = readProperties(jnlpContents);
		if (jnlpFile != null && jnlpFile.length() > 0) {
			jnlpProps.put("jnlp_params", request.getQueryString());
		}
		if (jnlpSession != null) {
			jnlpProps.put("session", "-session=" + jnlpSession);
		}
		String protocol = request.getProtocol();
		if(debug) {
			out.println("value of protocol is: " + request.getProtocol());
			out.println("value of server name is: " + request.getServerName());
			out.println("value of port is: " + request.getServerPort());
			out.println("req url is : "+ request.getRequestURL().toString());
		}
		String reqHeader = request.getRequestURL().toString();
		String temp = reqHeader.toLowerCase();
		String base = temp.replace("index.jsp", "");

		if(base != null && base.length() > 0 && base.endsWith("/")) {
			base = base.substring(0, base.length()-1);
		}

		if(debug) {
			out.println("The value of base is : " + base);
			out.println("The value of server name is - " + oemProps.get("consoleServer"));
		}
		String serverName = StringEscapeUtils.escapeHtml4(request.getParameter("csName"));
		if (serverName != null && serverName.equalsIgnoreCase("")) {
			serverName = oemProps.get("consoleServer");
			if (serverName != null && serverName.equalsIgnoreCase("")) {
				serverName = request.getServerName();
			}
		}
		if (serverName != null && !serverName.equalsIgnoreCase("")) {
			oemProps.remove("consoleServer");
			oemProps.put("consoleServer", serverName);
		}
		jnlpProps.put("OEM_WEBSTART.HTML_LOCATION", base + strOemWebImageFolder);
		jnlpProps.put("OEM", oemId);
		jnlpProps.put("CODEBASE", base);
		jnlpProps.put("BASE_URL", "index.jsp");
		jnlpProps.put("SAML_RESPONSE", samlToken.trim());
		jnlpProps.put("username", userName);

		for (String key : oemProps.keySet()) {
			jnlpProps.put(key, oemProps.get(key));
		}

		String strAcceptLanguage;
		strAcceptLanguage = request.getLocale().getLanguage();
		String strCountry;
		strCountry = request.getLocale().getCountry();

		jnlpProps.put("USER_LANGUAGE", strAcceptLanguage);
		jnlpProps.put("USER_COUNTRY", strCountry);
		jnlpProps.put("PROXY_HOSTNAME", proxyHost);
		jnlpProps.put("PROXY_PORT", proxyPort);
		boolean fileFound = false;
		strAcceptLanguage = strAcceptLanguage.toLowerCase();
		if (jnlpFile != null && jnlpFile != "" && jnlpFile.equals(new File(jnlpFile).getName())) {
			response.addHeader("content-disposition", "filename=" + jnlpFile);
			response.setContentType("application/x-java-jnlp-file");
			String content = getFileContents(strWebFolder + "/jnlp-template/" + jnlpFile);
			String newContent = replaceContent(content, jnlpProps);
			response.getWriter().write(newContent);
		} else {
%>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<style type="text/css">
html {
	background: #e6e6e6;
}

img.center {
	position: absolute;
	top: 50%;
	left: 50%;
	transform: translate(-50%, -50%);
	display: block;
	margin-left: auto;
	margin-right: auto;
	box-shadow: 10px 10px 15px #C3C3C3;
	-moz-box-shadow: 10px 10px 15px #C3C3C3;
	-moz-border-radius: 8px;
}
</style>
<title><%=jnlpProps.get("OEM_WEBSTART.TITLE")%></title>
<link rel="shortcut icon" href="Web/<%=oemId%>/images/commcell16.png" />
</head>
<body onload="redirect()">
	<div class="main">
		<img class="center" src="Web/<%=oemId%>/images/splash.gif" />
	</div>
	<script>
		var currentUrl = window.location.href.split('?');
			
		function redirect() {
			window.open(currentUrl[0] + "?jnlp=galaxy.jnlp&"+currentUrl[1], "_self");
		}
	</script>
</body>
<%
		}
	}
%>
