/*
 * Decompiled with CFR 0.152.
 */
package workflow.types.data;

import commvault.cte.common.workflow.annotations.XmlField;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import workflow.types.data.MetaData;

public class DataRow
implements Iterable {
    private MetaData metaData;
    @XmlField(name="col")
    private List<Object> values = new ArrayList<Object>();

    public DataRow(MetaData metaData, Object[] objectArray) {
        this.metaData = metaData;
        this.values = Arrays.asList(objectArray);
    }

    public DataRow(MetaData metaData, List<Object> list) {
        this.metaData = metaData;
        this.values = list;
    }

    public DataRow(MetaData metaData, ResultSet resultSet) throws SQLException {
        this.metaData = metaData;
        for (int i = 0; i < resultSet.getMetaData().getColumnCount(); ++i) {
            Object object = resultSet.getObject(i + 1);
            if (object instanceof Clob) {
                try {
                    this.values.add(IOUtils.toString((InputStream)((Clob)object).getAsciiStream(), (String)"UTF-8"));
                    continue;
                }
                catch (IOException iOException) {
                    throw new SQLException(iOException);
                }
            }
            this.values.add(resultSet.getObject(i + 1));
        }
    }

    public int getColumnCount() {
        return this.values.size();
    }

    public String getColumnName(int n) {
        return this.metaData.getColumnName(n);
    }

    public void add(Object object) {
        this.values.add(object);
    }

    public Object get(int n) {
        return this.values.get(n);
    }

    public Object get(String string) {
        Integer n = this.metaData.getColumnIndex(string);
        if (n != null) {
            return this.values.get(n);
        }
        return null;
    }

    public List<Object> getColumns() {
        return this.values;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public Iterator iterator() {
        return this.values.iterator();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(String.valueOf(this.get(i)));
        }
        return stringBuffer.toString();
    }
}

