/*
 * Decompiled with CFR 0.152.
 */
package commvault.tools.python;

import commvault.tools.python.Generator;
import commvault.tools.python.PythonUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Generator {
    private static final String ACTIVITYSET_NAME = "Automation";
    private static final String ACTIVITY_BASE = "activity";
    private static final String OBJECT_BASE = "obj";
    private static final String tab = "    ";
    private static final String doubleTab = "        ";
    private static final String tripleTab = "            ";
    private static final String activityTag = "<activity name=\"%s\" displayName=\"%s\" group=\"%s\" className=\"%s\"></activity>";
    private static final String generateScript = "from AutomationUtils import WorkflowUtils\nfrom %s import %s\nxml = WorkflowUtils.describe(%s)\nf = open(__file__.replace('.py','.out'), 'w')\nf.write(xml)\nf.close()";
    private static final String propertyFormat = "public %s %s;\n";
    private static final List<String> reservedWords = Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while");
    private String basePackage;
    private String baseFolder;
    private File automationFolder;
    private File activityFolder;
    private File objectFolder;
    private String activityPackage;
    private String objectPackage;
    private final StringBuilder activityXml = new StringBuilder();
    private int count = 0;

    public void generate(String string, File file, File file2, File file3) throws Exception {
        this.basePackage = string;
        this.baseFolder = string.replaceAll("\\.", "/");
        this.automationFolder = file;
        this.activityPackage = this.basePackage + "." + ACTIVITY_BASE;
        this.activityFolder = new File(new File(file2, this.baseFolder), ACTIVITY_BASE);
        this.objectPackage = this.basePackage + "." + OBJECT_BASE;
        this.objectFolder = new File(new File(file2, this.baseFolder), OBJECT_BASE);
        if (this.activityFolder.exists()) {
            System.err.println("activity source directory already exists");
            System.exit(1);
        }
        if (this.objectFolder.exists()) {
            System.err.println("object source directory already exists");
            System.exit(1);
        }
        this.activityFolder.mkdirs();
        this.objectFolder.mkdirs();
        this.activityXml.append("<activities>\n\n");
        this.scanFolder(file);
        this.activityXml.append("<utility className=\"commvault.tools.python.PythonConstants\" />\n");
        this.activityXml.append("\n");
        this.activityXml.append("</activities>");
        File file4 = new File(file3, "activities.xml");
        FileWriter fileWriter = new FileWriter(file4);
        fileWriter.write(this.activityXml.toString());
        fileWriter.close();
        System.out.println("built " + this.count + " classes");
    }

    public File getActivityFolder() {
        return this.activityFolder;
    }

    public File getObjectFolder() {
        return this.objectFolder;
    }

    private void scanFolder(File file) throws Exception {
        File[] fileArray = file.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        if (fileArray != null && fileArray.length > 0) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    this.scanFolder(file2);
                    continue;
                }
                this.scanFile(file2);
            }
        }
    }

    private void scanFile(File file) {
        String string = file.getParent();
        if (!string.equals(this.automationFolder.getAbsolutePath())) {
            String string2 = file.getName().replaceAll("\\.py", "");
            String string3 = file.getParent().substring(this.automationFolder.getAbsolutePath().length() + 1).replaceAll("\\\\", "\\.");
            String string4 = String.format(generateScript, string3, string2, string2);
            try {
                Document document = PythonUtil.executeXml((File)this.automationFolder, (String)string4, (long)10000L);
                if (document != null) {
                    this.scanDOM(document);
                } else {
                    System.err.println("NULL DOM - [" + file + "]");
                }
            }
            catch (Exception exception) {
                System.err.println("Error inspecting [" + file + "], " + exception.getMessage());
            }
        }
    }

    private void scanDOM(Document document) {
        Element element = document.getDocumentElement();
        String string = element.getAttribute("name");
        List list = PythonUtil.getChildElements((Node)element);
        for (Element element2 : list) {
            String string2 = "";
            String string3 = "";
            String[] stringArray = string.split("\\.");
            if (stringArray.length > 1) {
                string2 = string.substring(0, string.lastIndexOf(46));
                string3 = stringArray[stringArray.length - 1];
            } else {
                string3 = string;
            }
            if (element2.getTagName().equals("function")) {
                this.buildPythonActivity(string2, string3, null, null, element2);
                continue;
            }
            if (element2.getTagName().equals("class")) {
                this.scanClass(string2, string3, element2);
                continue;
            }
            System.err.println("unknown root tag [" + element2.getTagName() + "], skipping");
        }
    }

    private void scanClass(String string, String string2, Element element) {
        String string3 = element.getAttribute("name");
        String string4 = string.length() > 0 ? string.replaceAll("\\.", "_") + "_" + string2 + "_" + string3 : string2 + "_" + string3;
        List list = PythonUtil.getChildElements((Node)element);
        boolean bl = false;
        for (Element element2 : list) {
            if (!element2.getTagName().equals("function")) continue;
            String string5 = element2.getAttribute("name");
            if (string5.equals("__init__")) {
                List list2 = this.buildArguments(PythonUtil.getChildElements((Node)element2, (String)"arg"));
                this.buildPythonClass(string, string2, string4, string3, list2);
                bl = true;
                continue;
            }
            this.buildPythonActivity(string, string2, string4, string3, element2);
        }
        if (!bl) {
            this.buildPythonClass(string, string2, string4, string3, new ArrayList());
        }
    }

    private void buildPythonClass(String string, String string2, String string3, String string4, List<Argument> list) {
        File file = new File(this.objectFolder, string3 + ".java");
        if (!file.exists()) {
            try {
                int n;
                ++this.count;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("package ").append(this.objectPackage).append(";\n");
                stringBuffer.append("\n");
                stringBuffer.append("import commvault.cte.workflow.python.*;\n");
                stringBuffer.append("import commvault.cte.workflow.annotations.*;\n");
                stringBuffer.append("\n");
                stringBuffer.append("public class ").append(string3).append(" extends PythonClass {\n");
                stringBuffer.append("\n");
                for (n = 0; n < list.size(); ++n) {
                    if (list.get((int)n).value != null && list.get((int)n).value.length() > 0) {
                        stringBuffer.append(tab).append(String.format("@Input(defaultValue=\"%s\")\n", PythonUtil.escapeString((String)list.get((int)n).value)));
                    } else {
                        stringBuffer.append(tab).append("@Input\n");
                    }
                    stringBuffer.append(tab).append(String.format(propertyFormat, list.get((int)n).type.getName(), list.get((int)n).name));
                }
                stringBuffer.append("\n");
                stringBuffer.append(tab).append("@Override\n");
                stringBuffer.append(tab).append("public PythonProperty[] getProperties() {\n");
                stringBuffer.append(doubleTab).append("return new PythonProperty[] {");
                for (n = 0; n < list.size(); ++n) {
                    if (n > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(String.format("new PythonProperty(\"%s\", %s)", list.get((int)n).name, list.get((int)n).name));
                }
                stringBuffer.append("};\n");
                stringBuffer.append(tab).append("};\n");
                stringBuffer.append("\n");
                stringBuffer.append(tab).append("@Override\n");
                stringBuffer.append(tab).append("public String getPythonModule() {\n");
                stringBuffer.append(doubleTab).append(String.format("return \"%s\";\n", string2));
                stringBuffer.append(tab).append("}\n");
                stringBuffer.append("\n");
                stringBuffer.append(tab).append("@Override\n");
                stringBuffer.append(tab).append("public String getClassName() {\n");
                stringBuffer.append(doubleTab).append(String.format("return \"%s\";\n", string4));
                stringBuffer.append(tab).append("}\n");
                stringBuffer.append("\n");
                stringBuffer.append(tab).append("@Override\n");
                stringBuffer.append(tab).append("public String getPythonPackage() {\n");
                stringBuffer.append(doubleTab).append(String.format("return \"%s\";\n", string));
                stringBuffer.append(tab).append("}\n");
                stringBuffer.append("\n");
                stringBuffer.append("}");
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(stringBuffer.toString());
                fileWriter.close();
            }
            catch (Exception exception) {
                System.err.println("error creating python class object [" + string3 + "], " + exception.getMessage());
            }
        } else {
            System.err.println("could not create java class [" + string3 + "], class already exists");
        }
    }

    private void buildPythonActivity(String string, String string2, String string3, String string4, Element element) {
        String string5 = element.getAttribute("name");
        String string6 = string3 != null ? string3 + "_" + string5 : (string.length() > 0 ? string.replaceAll("\\.", "_") + "_" + string2 + "_" + string5 : string2 + "_" + string5);
        File file = new File(this.activityFolder, string6 + ".java");
        if (!file.exists()) {
            try {
                int n;
                List list = this.buildArguments(PythonUtil.getChildElements((Node)element, (String)"arg"));
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("package ").append(this.activityPackage).append(";\n");
                stringBuffer.append("\n");
                stringBuffer.append("import commvault.cte.workflow.python.*;\n");
                stringBuffer.append("import commvault.cte.workflow.annotations.*;\n");
                if (string3 != null) {
                    stringBuffer.append("import ").append(this.objectPackage).append(".*;\n");
                }
                stringBuffer.append("\n");
                stringBuffer.append("public class ").append(string6).append(" extends PythonActivity {\n");
                stringBuffer.append("\n");
                if (string3 != null) {
                    stringBuffer.append(tab).append("@InputOutput\n");
                    stringBuffer.append(tab).append(String.format(propertyFormat, string3, string4));
                    stringBuffer.append("\n");
                }
                for (n = 0; n < list.size(); ++n) {
                    if (((Argument)list.get((int)n)).value != null && ((Argument)list.get((int)n)).value.length() > 0) {
                        stringBuffer.append(tab).append(String.format("@Input(defaultValue=\"%s\")\n", PythonUtil.escapeString((String)((Argument)list.get((int)n)).value)));
                    } else {
                        stringBuffer.append(tab).append("@Input\n");
                    }
                    stringBuffer.append(tab).append(String.format(propertyFormat, ((Argument)list.get((int)n)).type.getName(), ((Argument)list.get((int)n)).name));
                }
                stringBuffer.append("\n");
                stringBuffer.append(tab).append("@Override\n");
                stringBuffer.append(tab).append("public PythonProperty[] getProperties() {\n");
                stringBuffer.append(doubleTab).append("return new PythonProperty[] {");
                for (n = 0; n < list.size(); ++n) {
                    if (n > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(String.format("new PythonProperty(\"%s\", %s)", ((Argument)list.get((int)n)).name, ((Argument)list.get((int)n)).name));
                }
                stringBuffer.append("};\n");
                stringBuffer.append(tab).append("};\n");
                stringBuffer.append("\n");
                stringBuffer.append(tab).append("@Override\n");
                stringBuffer.append(tab).append("public PythonClass getPythonClass() {\n");
                if (string3 != null) {
                    stringBuffer.append(doubleTab).append("return ").append(string4).append(";\n");
                } else {
                    stringBuffer.append(doubleTab).append("return null;\n");
                }
                stringBuffer.append(tab).append("} \n\n");
                stringBuffer.append(tab).append("@Override\n");
                stringBuffer.append(tab).append("public String getPythonModule() {\n");
                stringBuffer.append(doubleTab).append(String.format("return \"%s\";\n", string2));
                stringBuffer.append(tab).append("}\n");
                stringBuffer.append("\n");
                stringBuffer.append(tab).append("@Override\n");
                stringBuffer.append(tab).append("public String getPythonMethod() {\n");
                stringBuffer.append(doubleTab).append(String.format("return \"%s\";\n", string5));
                stringBuffer.append(tab).append("}\n");
                stringBuffer.append("\n");
                stringBuffer.append(tab).append("@Override\n");
                stringBuffer.append(tab).append("public String getPythonPackage() {\n");
                stringBuffer.append(doubleTab).append(String.format("return \"%s\";\n", string));
                stringBuffer.append(tab).append("}\n");
                stringBuffer.append("\n");
                stringBuffer.append("}");
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(stringBuffer.toString());
                fileWriter.close();
                this.activityXml.append(String.format(activityTag, string6, string5, ACTIVITYSET_NAME, this.activityPackage + "." + string6));
                this.activityXml.append("\n\n");
                ++this.count;
            }
            catch (Exception exception) {
                System.err.println("error creating python activity [" + string6 + "], " + exception.getMessage());
            }
        } else {
            System.err.println("could not create java class [" + string6 + "], class already exists");
        }
    }

    private List<Argument> buildArguments(List<Element> list) {
        ArrayList<Argument> arrayList = new ArrayList<Argument>();
        for (Element element : list) {
            if (element.getAttribute("name").equals("self")) continue;
            Argument argument = new Argument(this, null);
            arrayList.add(argument);
            argument.name = element.getAttribute("name");
            if (reservedWords.contains(argument.name)) {
                argument.name = "_" + argument.name;
            }
            try {
                argument.type = PythonUtil.getJavaType((String)element.getAttribute("type"));
                if (argument.type == null) continue;
                if (argument.type.equals(Boolean.class) && element.getNodeValue() != null) {
                    argument.value = element.getNodeValue().toLowerCase();
                    continue;
                }
                argument.value = element.getNodeValue();
            }
            catch (Exception exception) {
                System.err.println(argument.name + ", type error: " + exception);
            }
        }
        return arrayList;
    }
}

