/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util.db;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class DBKeywordMasker {
    private static String prefix = "DFLT_";
    private static final Set<String> SQL_KEYWORDS = Arrays.asList("Add", "All", "Allocate", "Alter", "And", "Any", "Are", "Array", "As", "Asensitive", "Asymmetric", "At", "Atomic", "Authorization", "Begin", "Between", "Bigint", "Binary", "Blob", "Boolean", "Both", "By", "Call", "Called", "Cascaded", "Case", "Cast", "Char", "Character", "Check", "Clob", "Close", "Collate", "Column", "Commit", "Condition", "Connect", "Constraint", "Continue", "Corresponding", "Create", "Cross", "Cube", "Current", "Current_Date", "Current_Default_Transform_Group", "Current_Path", "Current_Role", "Current_Time", "Current_Timestamp", "Current_Transform_Group_For_Type", "Current_User", "Cursor", "Cycle", "Date", "Day", "Deallocate", "Dec", "Decimal", "Declare", "Default", "Delete", "Deref", "Describe", "Deterministic", "Disconnect", "Distinct", "Do", "Double", "Drop", "Dynamic", "Each", "Element", "Else", "Elseif", "End", "Escape", "Except", "Exec", "Execute", "Exists", "Exit", "External", "False", "Fetch", "Filter", "Float", "For", "Foreign", "Free", "From", "Full", "Function", "Get", "Global", "Grant", "Group", "Grouping", "Handler", "Having", "Hold", "Hour", "Identity", "If", "Immediate", "In", "Indicator", "Inner", "Inout", "Input", "Insensitive", "Insert", "Int", "Integer", "Intersect", "Interval", "Into", "Is", "Iterate", "Join", "Language", "Large", "Lateral", "Leading", "Leave", "Left", "Like", "Local", "Localtime", "Localtimestamp", "Loop", "Match", "Member", "Merge", "Method", "Minute", "Modifies", "Module", "Month", "Multiset", "National", "Natural", "Nchar", "Nclob", "New", "No", "None", "Not", "Null", "Numeric", "Of", "Old", "On", "Only", "Open", "Or", "Order", "Out", "Outer", "Output", "Over", "Overlaps", "Parameter", "Partition", "Precision", "Prepare", "Primary", "Procedure", "Range", "Reads", "Real", "Recursive", "Ref", "References", "Referencing", "Release", "Repeat", "Resignal", "Result", "Return", "Returns", "Revoke", "Right", "Rollback", "Rollup", "Row", "Rows", "Savepoint", "Scope", "Scroll", "Search", "Second", "Select", "Sensitive", "Session_User", "Set", "Signal", "Similar", "Smallint", "Some", "Specific", "Specifictype", "Sql", "Sqlexception", "Sqlstate", "Sqlwarning", "Start", "Static", "Submultiset", "Symmetric", "System", "System_User", "Table", "Tablesample", "Then", "Time", "Timestamp", "Timezone_Hour", "Timezone_Minute", "To", "Trailing", "Translation", "Treat", "Trigger", "True", "Undo", "Union", "Unique", "Unknown", "Unnest", "Until", "Update", "User", "Using", "Value", "Values", "Varchar", "Varying", "When", "Whenever", "Where", "While", "Window", "With", "Within", "Without", "Year").stream().map(String::toUpperCase).collect(Collectors.toSet());

    public static String getPrefix() {
        return prefix;
    }

    public static void setPrefix(String string) {
        prefix = string;
    }

    public static String maskKeyword(String string) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(string);
        if (SQL_KEYWORDS.contains(string.toUpperCase())) {
            return prefix + string;
        }
        return string;
    }

    public static String unmaskKeyword(String string) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(string);
        return string.toUpperCase().startsWith(prefix.toUpperCase()) ? string.substring(prefix.length()) : string;
    }

    public static void addMandatedKey(String string) {
        SQL_KEYWORDS.add(string.toUpperCase());
    }

    public static void addSkipKey(String string) {
        SQL_KEYWORDS.remove(string.toUpperCase());
    }
}

