/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import commvault.cte.util.CryptoPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.BlowfishEngine;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.generators.DESKeyGenerator;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.DESParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class SecureCryptor {
    private static final int IV_SIZE = 8;
    private static final String HASH_ALGO = "SHA1";
    static HashMap<Object, SecureCryptor> cryptors = new HashMap();
    private KeyParameter _sessionkey = null;
    private RSAKeyParameters _publickey = null;
    private SecureRandom _prng = new SecureRandom();
    private SymmeticAlgo algo;

    public static SecureCryptor instance() {
        return SecureCryptor.instance(SymmeticAlgo.DSA);
    }

    public static SecureCryptor instance(SymmeticAlgo symmeticAlgo) {
        if (!cryptors.containsKey((Object)symmeticAlgo)) {
            cryptors.put((Object)symmeticAlgo, new SecureCryptor(symmeticAlgo));
        }
        return cryptors.get((Object)symmeticAlgo);
    }

    private SecureCryptor(SymmeticAlgo symmeticAlgo) {
        this.algo = symmeticAlgo;
    }

    public void setCommServPublicKey(byte[] byArray) throws IOException {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        this._publickey = SecureCryptor.createRSAPublicKeyStructure(x509EncodedKeySpec);
    }

    public byte[] getEncryptedSessionKey() throws SecurityException {
        byte[] byArray = null;
        try {
            PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
            pKCS1Encoding.init(true, (CipherParameters)this._publickey);
            byte[] byArray2 = this.getSessionKey().getKey();
            byArray = pKCS1Encoding.processBlock(byArray2, 0, byArray2.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new SecurityException("Error: Unable to pad the input text.");
        }
        catch (DataLengthException dataLengthException) {
            throw new SecurityException("Error: Input data is not block size aligned.");
        }
        return this.reverseBytes(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSessionKey() {
        if (this._sessionkey != null) {
            SecureCryptor secureCryptor = this;
            synchronized (secureCryptor) {
                if (this._sessionkey != null) {
                    this._sessionkey = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyParameter getSessionKey() {
        if (this._sessionkey == null) {
            SecureCryptor secureCryptor = this;
            synchronized (secureCryptor) {
                if (this._sessionkey == null) {
                    DESKeyGenerator dESKeyGenerator = new DESKeyGenerator();
                    dESKeyGenerator.init(new KeyGenerationParameters(this._prng, 64));
                    this._sessionkey = new DESParameters(dESKeyGenerator.generateKey());
                }
            }
        }
        return this._sessionkey;
    }

    private byte[] reverseBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = byArray2.length - 1;
        int n2 = 0;
        while (n >= 0) {
            byArray2[n2] = byArray[n];
            --n;
            ++n2;
        }
        return byArray2;
    }

    public byte[] decrypt(byte[] byArray, byte[] byArray2) throws SecurityException {
        byte[] byArray3 = null;
        try {
            PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)(this.algo == SymmeticAlgo.BLOWFISH ? new BlowfishEngine() : new DESEngine())));
            paddedBufferedBlockCipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)this.getSessionKey(), byArray));
            byte[] byArray4 = new byte[paddedBufferedBlockCipher.getOutputSize(byArray2.length)];
            int n = paddedBufferedBlockCipher.processBytes(byArray2, 0, byArray2.length, byArray4, 0);
            n += paddedBufferedBlockCipher.doFinal(byArray4, n);
            byArray3 = new byte[n];
            System.arraycopy(byArray4, 0, byArray3, 0, n);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new SecurityException("Error: decrypted text is incorrectly padded.");
        }
        catch (DataLengthException dataLengthException) {
            throw new SecurityException("Error: Output array is too small.");
        }
        return byArray3;
    }

    public byte[] decrypt(byte[] byArray) throws SecurityException, IOException {
        return this.decrypt(CryptoPacket.getInstance(byArray));
    }

    public byte[] decrypt(CryptoPacket cryptoPacket) throws SecurityException {
        return this.decrypt(cryptoPacket.getIV(), cryptoPacket.getCipherData());
    }

    public CryptoPacket encrypt(byte[] byArray) throws SecurityException {
        CryptoPacket cryptoPacket = null;
        try {
            byte[] byArray2 = new byte[8];
            this._prng.nextBytes(byArray2);
            PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)(this.algo == SymmeticAlgo.DSA ? new DESEngine() : new BlowfishEngine())));
            paddedBufferedBlockCipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)this.getSessionKey(), byArray2));
            byte[] byArray3 = new byte[paddedBufferedBlockCipher.getOutputSize(byArray.length)];
            int n = paddedBufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
            n += paddedBufferedBlockCipher.doFinal(byArray3, n);
            byte[] byArray4 = new byte[n];
            System.arraycopy(byArray3, 0, byArray4, 0, n);
            cryptoPacket = new CryptoPacket(byArray2, byArray4);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new SecurityException("Error: Unable to pad the input text.");
        }
        catch (DataLengthException dataLengthException) {
            throw new SecurityException("Error: Input data is not block size aligned.");
        }
        return cryptoPacket;
    }

    public byte[] getRandomBytes(int n) {
        byte[] byArray = new byte[n];
        this._prng.nextBytes(byArray);
        return byArray;
    }

    public byte[] getEncodedPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws IOException, NoSuchAlgorithmException {
        byte[] byArray5 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(byArray3, 0, byArray3.length);
        byteArrayOutputStream.write(byArray4, 0, byArray4.length);
        byArray5 = MessageDigest.getInstance(HASH_ALGO).digest(byteArrayOutputStream.toByteArray());
        return byArray5;
    }

    private static RSAKeyParameters createRSAPublicKeyStructure(X509EncodedKeySpec x509EncodedKeySpec) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(x509EncodedKeySpec.getEncoded());
        DERInputStream dERInputStream = new DERInputStream((InputStream)byteArrayInputStream);
        DERConstructedSequence dERConstructedSequence = (DERConstructedSequence)dERInputStream.readObject();
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(dERConstructedSequence);
        RSAPublicKeyStructure rSAPublicKeyStructure = new RSAPublicKeyStructure((DERConstructedSequence)subjectPublicKeyInfo.getPublicKey());
        return new RSAKeyParameters(false, rSAPublicKeyStructure.getModulus(), rSAPublicKeyStructure.getPublicExponent());
    }

    public static enum SymmeticAlgo {
        DSA,
        BLOWFISH;

    }
}

