/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import commvault.cte.common.xml.CVEnum;
import commvault.cte.common.xml.EncoderUtil;
import commvault.cte.common.xml.Text;
import commvault.cte.component.Utilities;
import commvault.cte.util.Application;
import commvault.cte.util.ExceptionFileNotFoundInLangPack;
import commvault.cte.util.LangString;
import commvault.cte.util.Logger;
import commvault.cte.util.LookupInLangpack;
import commvault.cte.util.ObjectCache;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class EnumUtil {
    public static final String MSG_BUNDLE = "MSG_BUNDLE";

    public static String getFromResourceBundle(String string, String string2) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string2, Locale.ROOT);
            return resourceBundle.getString(string);
        }
        catch (Exception exception) {
            Logger.instance().println(Logger.FINER, "ResourceBundle not found in getFromResourceBundle-" + string2);
            throw exception;
        }
    }

    public static String getFromLangPack(String string, String string2, String string3) {
        try {
            if (string3.equals("") || string3.startsWith("en")) {
                string3 = "en_US";
            }
            if (string3.equals("en_US")) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(string2, Locale.ROOT);
                return resourceBundle.getString(string);
            }
            LookupInLangpack lookupInLangpack = LookupInLangpack.getInstance();
            if (lookupInLangpack == null) {
                throw new Exception("Langpack not found");
            }
            String string4 = string2;
            LangString langString = lookupInLangpack.lookupInFileInfo(string4, string3, string);
            if (langString.getCode() == 0) {
                return langString.getLanguageString();
            }
            if (langString.getCode() != 1) {
                if (string3.equals("fr_CA")) {
                    return EnumUtil.getFromLangPack(string, string2, "fr");
                }
                if (string3.equals("es_MX")) {
                    return EnumUtil.getFromLangPack(string, string2, "es");
                }
            }
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string2, Locale.ROOT);
            String string5 = resourceBundle.getString(string);
            if (langString.getCode() == 1) {
                langString = lookupInLangpack.lookupDuplicateInFileInfo(string4, string3, string, string5);
                if (langString.getCode() == 0) {
                    return langString.getLanguageString();
                }
                if (string3.equals("fr_CA")) {
                    return EnumUtil.getFromLangPack(string, string2, "fr");
                }
                if (string3.equals("es_MX")) {
                    return EnumUtil.getFromLangPack(string, string2, "es");
                }
            }
            return string5;
        }
        catch (ExceptionFileNotFoundInLangPack exceptionFileNotFoundInLangPack) {
            ExceptionFileNotFoundInLangPack exceptionFileNotFoundInLangPack2 = new ExceptionFileNotFoundInLangPack(string2);
            return EnumUtil.getFromResourceBundle(string, string2);
        }
        catch (Exception exception) {
            Logger.instance().println(Logger.FINER, "Error while getting from langpack - bundle:" + string2 + " key:" + string + " locale:" + string3);
            return EnumUtil.getFromResourceBundle(string, string2);
        }
    }

    public static String getLocaleString(String string, String string2) {
        return EnumUtil.getFromLangPack(string, string2, Locale.getDefault().toString());
    }

    public static String getI18n(Enum enum_) {
        return EnumUtil.getI18n(null, enum_);
    }

    public static String getI18n(ResourceBundle resourceBundle, Enum enum_) {
        if (enum_ == null) {
            return null;
        }
        if (!Application.noExternalise) {
            try {
                if (ObjectCache.get(MSG_BUNDLE) != null) {
                    String string = (String)ObjectCache.get(MSG_BUNDLE);
                    return EnumUtil.getLocaleString(enum_.toString(), string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (resourceBundle == null) {
                    if (enum_.getClass().getPackage().getName().startsWith("commvault.msgs")) {
                        String string = enum_.getClass().getPackage().getName() + ".MessageBundle";
                        return EnumUtil.getLocaleString(enum_.getClass().getSimpleName() + "." + enum_, string);
                    }
                    String string = enum_.getClass().getCanonicalName();
                    return EnumUtil.getLocaleString(enum_.toString(), string);
                }
                if (enum_.getClass().getPackage().getName().startsWith("commvault.msgs")) {
                    return EnumUtil.getLocaleString(enum_.getClass().getSimpleName() + "." + enum_, resourceBundle.getBaseBundleName());
                }
                return EnumUtil.getLocaleString(enum_.name(), resourceBundle.getBaseBundleName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Text text = enum_.getClass().getField(enum_.name()).getAnnotation(Text.class);
            return EnumUtil.checkExternalise(text.text().replace("_", " "));
        }
        catch (Exception exception) {
            return EnumUtil.checkExternalise(enum_.toString().replace("_", " "));
        }
    }

    public static String checkExternalise(String string) {
        if (Application.noExternalise) {
            return "$" + string;
        }
        return string;
    }

    public static <T> T getEnum(T[] TArray, int n) {
        for (T t : TArray) {
            if (((Enum)t).ordinal() != n) continue;
            return t;
        }
        return TArray[0];
    }

    public static int getEnumValue(Enum enum_) {
        if (enum_ instanceof CVEnum) {
            CVEnum cVEnum = (CVEnum)((Object)enum_);
            return cVEnum.getEnumValue();
        }
        try {
            Method method = enum_.getClass().getDeclaredMethod("getEnumValue", new Class[0]);
            return (Integer)method.invoke((Object)enum_, null);
        }
        catch (Exception exception) {
            return enum_.ordinal();
        }
    }

    public static <T extends Enum> T getEnum(Class<T> clazz, int n) {
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            if (enum_ instanceof CVEnum) {
                if (((CVEnum)((Object)enum_)).getEnumValue() != n) continue;
                return (T)enum_;
            }
            try {
                Method method = enum_.getClass().getDeclaredMethod("getEnumValue", new Class[0]);
                Integer n2 = (Integer)method.invoke((Object)enum_, null);
                if (!n2.equals(n)) continue;
                return (T)enum_;
            }
            catch (Exception exception) {
                if (enum_.ordinal() != n) continue;
                return (T)enum_;
            }
        }
        return null;
    }

    public static Vector getAllEnumValue(Object object) {
        Vector<String> vector = new Vector<String>();
        if (!(object instanceof Enum)) {
            return vector;
        }
        for (Object obj : object.getClass().getEnumConstants()) {
            vector.add(EnumUtil.getI18n((Enum)obj));
        }
        return vector;
    }

    public static String getLabel(ResourceBundle resourceBundle, String string, String string2) {
        if (Application.noExternalise) {
            try {
                return EnumUtil.getNonExternalisedString(Class.forName(string), string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
        }
        return EnumUtil.getExternalisedString(resourceBundle, string, string2);
    }

    public static String getLabel(ResourceBundle resourceBundle, Class clazz, String string) {
        if (Application.noExternalise) {
            return EnumUtil.getNonExternalisedString(clazz, string);
        }
        return EnumUtil.getExternalisedString(resourceBundle, clazz.getSimpleName(), string);
    }

    private static String getExternalisedString(ResourceBundle resourceBundle, String string, String string2) {
        String string3 = resourceBundle.getBaseBundleName();
        try {
            return EnumUtil.getLocaleString(string + "." + string2, string3);
        }
        catch (Exception exception) {
            if (Utilities.isRTMBuild()) {
                return EncoderUtil.getDisplayableText(string2, null);
            }
            return "$" + EncoderUtil.getDisplayableText(string2, null);
        }
    }

    private static String getNonExternalisedString(Class clazz, String string) {
        try {
            Text text = clazz.getDeclaredField(string).getAnnotation(Text.class);
            if (text.text().equals("")) {
                throw new Exception();
            }
            return text.text();
        }
        catch (Exception exception) {
            if (Utilities.isRTMBuild()) {
                return EncoderUtil.getDisplayableText(string, null);
            }
            return "$" + EncoderUtil.getDisplayableText(string, null);
        }
    }

    public static <T extends Enum<T>> T getEnumFromString(Class<T> clazz, String string) {
        if (clazz != null && string != null) {
            try {
                return Enum.valueOf(clazz, string.trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }
}

