/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import commvault.cte.component.Utilities;
import commvault.cte.util.RuntimeContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.prefs.Preferences;

class CurrentUserKeyReader {
    public static final int REG_SUCCESS = 0;
    public static final int REG_NOTFOUND = 2;
    public static final int REG_ACCESSDENIED = 5;
    private static final int KEY_READ = 131097;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static Preferences userRoot = Preferences.userRoot();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;

    CurrentUserKeyReader() {
    }

    public static final String getLocalMachineKeyValue(String string, String string2) {
        try {
            return CurrentUserKeyReader.readString(userRoot, -2147483646, string, string2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static final String getCurrentUserKeyValue(String string, String string2) {
        try {
            return CurrentUserKeyReader.readString(userRoot, -2147483647, string, string2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static String readString(Preferences preferences, int n, String string, String string2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (RuntimeContext.getJavaVersion() >= 11) {
            long[] lArray = (long[])regOpenKey.invoke((Object)preferences, new Long(n), CurrentUserKeyReader.toCstr(string), new Integer(131097));
            if (lArray[1] != 0L) {
                return null;
            }
            byte[] byArray = (byte[])regQueryValueEx.invoke((Object)preferences, new Long(lArray[0]), CurrentUserKeyReader.toCstr(string2));
            regCloseKey.invoke((Object)preferences, new Long(lArray[0]));
            return byArray != null ? new String(byArray).trim() : null;
        }
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, new Integer(n), CurrentUserKeyReader.toCstr(string), new Integer(131097));
        if (nArray[1] != 0) {
            return null;
        }
        byte[] byArray = (byte[])regQueryValueEx.invoke((Object)preferences, new Integer(nArray[0]), CurrentUserKeyReader.toCstr(string2));
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
        return byArray != null ? new String(byArray).trim() : null;
    }

    private static byte[] toCstr(String string) {
        byte[] byArray = new byte[string.length() + 1];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        byArray[string.length()] = 0;
        return byArray;
    }

    static {
        try {
            if (RuntimeContext.getJavaVersion() >= 11) {
                regOpenKey = userRoot.getClass().getDeclaredMethod("WindowsRegOpenKey", Long.TYPE, byte[].class, Integer.TYPE);
                Utilities.disableAccessWarnings();
                regCloseKey = userRoot.getClass().getDeclaredMethod("WindowsRegCloseKey", Long.TYPE);
                regQueryValueEx = userRoot.getClass().getDeclaredMethod("WindowsRegQueryValueEx", Long.TYPE, byte[].class);
            } else {
                regOpenKey = userRoot.getClass().getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
                regCloseKey = userRoot.getClass().getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
                regQueryValueEx = userRoot.getClass().getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            }
            regOpenKey.setAccessible(true);
            regCloseKey.setAccessible(true);
            regQueryValueEx.setAccessible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

