/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.ChartType;
import com.jidesoft.chart.Legend;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.CategoryAxis;
import com.jidesoft.chart.model.ChartCategory;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.render.Pie3DRenderer;
import com.jidesoft.chart.render.PieSegmentRenderer;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.range.Category;
import com.jidesoft.range.CategoryRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import commvault.cte.component.chart.ChartPointEx;
import commvault.cte.component.chart.PieChartSeriesData;
import commvault.cte.util.ReportUtilities;
import commvault.cte.util.RuntimeContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ChartUtilities {
    public static int X_AXIS = 1;
    public static int Y_AXIS = 2;
    private static final String pieLabelPattern = " {0} ({2,number,percent}) {1} ";
    private static final String pieLabelPattern2 = " {0} {1} ({2,number,percent}): {3} ";
    private static final String pieLabelPattern3 = " {0} {1} ({2,number,percent}) {3} ";
    private static final String pieLabelPattern4 = " ({2,number,percent}) {3} ";
    private static final String pieLabelPattern5 = " {4} {3} ({2,number,percent})";

    public static JPanel getPieChart(String string, Vector<PieChartSeriesData> vector, boolean bl) {
        return ChartUtilities.getPieChart(string, vector, bl, 100);
    }

    public static JPanel getPieChart(String string, Vector<PieChartSeriesData> vector, boolean bl, int n) {
        Highlight highlight;
        Object object;
        int n2;
        Chart chart = new Chart();
        chart.setOpaque(false);
        DefaultChartModel defaultChartModel = new DefaultChartModel((Object)string);
        CategoryRange categoryRange = new CategoryRange();
        NumberFormat numberFormat = NumberFormat.getInstance(RuntimeContext.instance().getLoggedInLocale());
        numberFormat.setMinimumFractionDigits(0);
        double d = 0.0;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object = vector.get(n2);
            d += ((PieChartSeriesData)object).getPieChartCounter().getValue();
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object = vector.get(n2);
            highlight = new Highlight(((PieChartSeriesData)object).getSeriesName());
            Object[] objectArray = new Object[]{numberFormat.format(((PieChartSeriesData)object).getPieChartCounter().getValue()), ((PieChartSeriesData)object).getPieChartCounter().getUnitString(), d > 0.0 ? (double)new Float(((PieChartSeriesData)object).getPieChartCounter().getValue() / d).floatValue() : d, ((PieChartSeriesData)object).getSeriesName()};
            String string2 = MessageFormat.format(pieLabelPattern3, objectArray);
            ChartCategory chartCategory = new ChartCategory((Object)string2);
            ChartPoint chartPoint = new ChartPoint((Positionable)chartCategory, ((PieChartSeriesData)object).getSeriesTotal());
            defaultChartModel.addPoint((Chartable)chartPoint);
            categoryRange.add((Category)chartCategory);
            chartPoint.setHighlight(highlight);
            ChartStyle chartStyle = new ChartStyle(((PieChartSeriesData)object).getSeriesColor());
            chartStyle.setBarsVisible(true);
            chartStyle.setBarWidth(Integer.valueOf(1));
            chart.setHighlightStyle(highlight, chartStyle);
        }
        chart.addModel((ChartModel)defaultChartModel);
        chart.setXAxis((Axis)new CategoryAxis(categoryRange));
        chart.setYAxis(new Axis((Range)new NumericRange(0.0, d)));
        chart.setChartType(ChartType.PIE);
        Pie3DRenderer pie3DRenderer = new Pie3DRenderer();
        pie3DRenderer.setThicknessRatio(0.1f);
        pie3DRenderer.setAlwaysShowOutlines(false);
        pie3DRenderer.setPieLabelRenderer(null);
        chart.setPieSegmentRenderer((PieSegmentRenderer)pie3DRenderer);
        chart.setPreferredSize(new Dimension(n, n));
        object = new JPanel(new BorderLayout());
        ((JComponent)object).setOpaque(false);
        ((Container)object).add((Component)chart, "Center");
        if (bl) {
            highlight = new Legend(chart, 1);
            highlight.setBorder(BorderFactory.createEmptyBorder());
            highlight.setOpaque(false);
            ((Container)object).add((Component)highlight, "East");
        }
        return object;
    }

    public static void updatePieChart(Chart chart, double[][] dArray, String[] stringArray, Color[] colorArray) {
        ChartUtilities.updatePieChart(chart, dArray, stringArray, colorArray, true);
    }

    public static void updatePieChart(Chart chart, double[][] dArray, String[] stringArray, Color[] colorArray, boolean bl, Dimension dimension) {
        int n;
        chart.removeModels();
        if (dArray == null || dArray.length == 0 || dArray[0].length == 0) {
            return;
        }
        DefaultChartModel defaultChartModel = new DefaultChartModel();
        CategoryRange categoryRange = new CategoryRange();
        double d = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d += dArray[n][0];
        }
        for (n = 0; n < dArray.length; ++n) {
            final String string = stringArray[n];
            double d2 = dArray[n][0];
            Highlight highlight = null;
            ChartCategory chartCategory = null;
            if (bl) {
                highlight = new Highlight(string);
                chartCategory = new ChartCategory((Object)string);
            } else {
                highlight = new Highlight("" + n);
                chartCategory = new ChartCategory<String>("" + n){

                    public String getName() {
                        return string;
                    }
                };
            }
            ChartPointEx chartPointEx = new ChartPointEx((Positionable)chartCategory, d2, n, 0);
            defaultChartModel.addPoint((Chartable)chartPointEx);
            categoryRange.add((Category)chartCategory);
            chartPointEx.setHighlight(highlight);
            ChartStyle chartStyle = new ChartStyle(colorArray[n]);
            chart.setHighlightStyle(highlight, chartStyle);
        }
        chart.addModel((ChartModel)defaultChartModel);
        chart.setXAxis((Axis)new CategoryAxis(categoryRange));
        chart.setYAxis(new Axis((Range)new NumericRange(0.0, d)));
        chart.setChartType(ChartType.PIE);
        Pie3DRenderer pie3DRenderer = new Pie3DRenderer();
        pie3DRenderer.setThicknessRatio(0.1f);
        pie3DRenderer.setAlwaysShowOutlines(false);
        pie3DRenderer.setPieLabelRenderer(null);
        chart.setPieSegmentRenderer((PieSegmentRenderer)pie3DRenderer);
        chart.setPreferredSize(dimension);
    }

    public static void updatePieChart(Chart chart, double[][] dArray, String[] stringArray, Color[] colorArray, boolean bl) {
        ChartUtilities.updatePieChart(chart, dArray, stringArray, colorArray, bl, new Dimension(200, 200));
    }

    public static long getNumberSpacing(double d, int n) {
        d = n == 5 ? (d *= 0.2) : (n == 10 ? (d *= 0.1) : (d /= (double)n));
        if (d < 1.0) {
            return 1L;
        }
        long l = 1L;
        while (d >= 10.0) {
            d /= 10.0;
            l *= 10L;
        }
        return Math.round(d) * l;
    }

    public static void applyShowGridLine(Chart chart, boolean bl) {
        if (chart == null) {
            return;
        }
        chart.setVerticalGridLinesVisible(bl);
        chart.setHorizontalGridLinesVisible(bl);
    }

    public static String exportDataForBarChart(String[] stringArray, String[] stringArray2, long[][] lArray) {
        int n;
        String string = "\n";
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            string2 = ReportUtilities.removeStringHtml(string2);
            string = n == 0 ? string + "\t" + string2 + "\t" : string + string2 + "\t";
        }
        for (n = 0; n < stringArray2.length; ++n) {
            string = string + "\n" + stringArray2[n] + "\t";
            for (int i = 0; i < lArray[0].length; ++i) {
                string = string + String.valueOf(lArray[n][i]) + "\t";
            }
        }
        string = string + "\n";
        return string;
    }
}

