/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

public final class Base64 {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final byte PAD = 61;
    private static final boolean fDebug = false;
    private static byte[] base64Alphabet;
    private static byte[] lookUpBase64Alphabet;

    protected static boolean isWhiteSpace(byte by) {
        return by == 32 || by == 13 || by == 10 || by == 9;
    }

    protected static boolean isPad(byte by) {
        return by == 61;
    }

    protected static boolean isData(byte by) {
        return base64Alphabet[by] != -1;
    }

    protected static boolean isBase64(byte by) {
        return Base64.isWhiteSpace(by) || Base64.isPad(by) || Base64.isData(by);
    }

    public static byte[] encode(byte[] byArray) {
        byte by;
        byte by2;
        if (byArray == null) {
            return null;
        }
        int n = byArray.length * 8;
        int n2 = n % 24;
        int n3 = n / 24;
        byte[] byArray2 = null;
        byArray2 = n2 != 0 ? new byte[(n3 + 1) * 4] : new byte[n3 * 4];
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n6 = 0; n6 < n3; ++n6) {
            n5 = n6 * 3;
            by5 = byArray[n5];
            by6 = byArray[n5 + 1];
            by7 = byArray[n5 + 2];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            n4 = n6 * 4;
            by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            by = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            byte by8 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 6) : (byte)(by7 >> 6 ^ 0xFC);
            byArray2[n4] = lookUpBase64Alphabet[by2];
            byArray2[n4 + 1] = lookUpBase64Alphabet[by | by3 << 4];
            byArray2[n4 + 2] = lookUpBase64Alphabet[by4 << 2 | by8];
            byArray2[n4 + 3] = lookUpBase64Alphabet[by7 & 0x3F];
        }
        n5 = n6 * 3;
        n4 = n6 * 4;
        if (n2 == 8) {
            by5 = byArray[n5];
            by3 = (byte)(by5 & 3);
            by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            byArray2[n4] = lookUpBase64Alphabet[by2];
            byArray2[n4 + 1] = lookUpBase64Alphabet[by3 << 4];
            byArray2[n4 + 2] = 61;
            byArray2[n4 + 3] = 61;
        } else if (n2 == 16) {
            by5 = byArray[n5];
            by6 = byArray[n5 + 1];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            by = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            byArray2[n4] = lookUpBase64Alphabet[by2];
            byArray2[n4 + 1] = lookUpBase64Alphabet[by | by3 << 4];
            byArray2[n4 + 2] = lookUpBase64Alphabet[by4 << 2];
            byArray2[n4 + 3] = 61;
        }
        return byArray2;
    }

    public static byte[] decode(byte[] byArray) {
        int n;
        if (byArray == null) {
            return null;
        }
        if ((byArray = Base64.removeWhiteSpace(byArray)).length % 4 != 0) {
            return null;
        }
        int n2 = byArray.length / 4;
        if (n2 == 0) {
            return new byte[0];
        }
        byte[] byArray2 = null;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        byte by8 = 0;
        int n3 = 0;
        int n4 = 0;
        byArray2 = new byte[n2 * 3];
        for (n = 0; n < n2 - 1; ++n) {
            if (!(Base64.isData(by5 = byArray[n4++]) && Base64.isData(by6 = byArray[n4++]) && Base64.isData(by7 = byArray[n4++]) && Base64.isData(by8 = byArray[n4++]))) {
                return null;
            }
            by = base64Alphabet[by5];
            by2 = base64Alphabet[by6];
            by3 = base64Alphabet[by7];
            by4 = base64Alphabet[by8];
            byArray2[n3++] = (byte)(by << 2 | by2 >> 4);
            byArray2[n3++] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
            byArray2[n3++] = (byte)(by3 << 6 | by4);
        }
        if (!Base64.isData(by5 = byArray[n4++]) || !Base64.isData(by6 = byArray[n4++])) {
            return null;
        }
        by = base64Alphabet[by5];
        by2 = base64Alphabet[by6];
        by7 = byArray[n4++];
        by8 = byArray[n4++];
        if (!Base64.isData(by7) || !Base64.isData(by8)) {
            if (Base64.isPad(by7) && Base64.isPad(by8)) {
                if ((by2 & 0xF) != 0) {
                    return null;
                }
                byte[] byArray3 = new byte[n * 3 + 1];
                System.arraycopy(byArray2, 0, byArray3, 0, n * 3);
                byArray3[n3] = (byte)(by << 2 | by2 >> 4);
                return byArray3;
            }
            if (!Base64.isPad(by7) && Base64.isPad(by8)) {
                by3 = base64Alphabet[by7];
                if ((by3 & 3) != 0) {
                    return null;
                }
                byte[] byArray4 = new byte[n * 3 + 2];
                System.arraycopy(byArray2, 0, byArray4, 0, n * 3);
                byArray4[n3++] = (byte)(by << 2 | by2 >> 4);
                byArray4[n3] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
                return byArray4;
            }
            return null;
        }
        by3 = base64Alphabet[by7];
        by4 = base64Alphabet[by8];
        byArray2[n3++] = (byte)(by << 2 | by2 >> 4);
        byArray2[n3++] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
        byArray2[n3++] = (byte)(by3 << 6 | by4);
        return byArray2;
    }

    protected static byte[] removeWhiteSpace(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = 0;
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            if (Base64.isWhiteSpace(byArray[i])) continue;
            ++n;
        }
        if (n == n2) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (Base64.isWhiteSpace(byArray[i])) continue;
            byArray2[n3++] = byArray[i];
        }
        return byArray2;
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        return new String(Base64.encode(string.getBytes()));
    }

    public static String decode(String string) {
        if (string == null) {
            return null;
        }
        return new String(Base64.decode(string.getBytes()));
    }

    public static String encodeToString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new String(Base64.encode(byArray));
    }

    public static String decodeToString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new String(Base64.decode(byArray));
    }

    public static byte[] decodeToBytes(String string) {
        if (string == null) {
            return null;
        }
        return Base64.decode(string.getBytes());
    }

    static {
        int n;
        base64Alphabet = new byte[255];
        lookUpBase64Alphabet = new byte[64];
        for (n = 0; n < 255; ++n) {
            Base64.base64Alphabet[n] = -1;
        }
        for (n = 90; n >= 65; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 65);
        }
        for (n = 122; n >= 97; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 97 + 26);
        }
        for (n = 57; n >= 48; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 48 + 52);
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        for (n = 0; n <= 25; ++n) {
            Base64.lookUpBase64Alphabet[n] = (byte)(65 + n);
        }
        n = 26;
        int n2 = 0;
        while (n <= 51) {
            Base64.lookUpBase64Alphabet[n] = (byte)(97 + n2);
            ++n;
            ++n2;
        }
        n = 52;
        n2 = 0;
        while (n <= 61) {
            Base64.lookUpBase64Alphabet[n] = (byte)(48 + n2);
            ++n;
            ++n2;
        }
        Base64.lookUpBase64Alphabet[62] = 43;
        Base64.lookUpBase64Alphabet[63] = 47;
    }
}

