/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.reports.components;

import commvault.cte.CteStringBank;
import commvault.cte.component.BasicJDialog;
import commvault.cte.component.CVFrame;
import commvault.cte.component.Utilities;
import commvault.cte.component.dialog.ExportFileChooser;
import commvault.cte.component.dialog.SaveDialog;
import commvault.cte.component.print.PrintDialog;
import commvault.cte.component.print.PrintOptions;
import commvault.cte.reports.components.ConversionType;
import commvault.cte.reports.components.ReportElementEnum;
import commvault.cte.reports.components.ReportFormatter;
import commvault.cte.reports.components.ReportItem;
import commvault.cte.reports.components.TableItem;
import commvault.cte.util.Logger;
import commvault.cte.util.RuntimeContext;
import commvault.msgs.App.ExportFile;
import java.awt.Container;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class ReportManager {
    public int pageOrientation = 2;
    public static int fileCount = 0;
    private ReportFormatter reportFormatter = null;
    private static boolean guiMode = true;
    private boolean hideZoom = false;
    private ConversionType saveDialogType = null;
    private String exportFileName = "";
    private boolean isPDF = false;

    public ReportManager(ReportFormatter reportFormatter) {
        this(reportFormatter, null);
    }

    public ReportManager(ReportFormatter reportFormatter, ConversionType conversionType) {
        this.reportFormatter = reportFormatter;
        String string = RuntimeContext.instance().getLoggedInLocale().getLanguage();
        this.saveDialogType = conversionType;
    }

    public void dispose() {
    }

    public void setPortraitDefault() {
        this.pageOrientation = 1;
    }

    public void setLandscapeDefault() {
        this.pageOrientation = 2;
    }

    public void setPageOrientation(int n) {
        this.pageOrientation = n;
    }

    public void setHideZoom(boolean bl) {
        this.hideZoom = bl;
    }

    public boolean isHideZoom() {
        return this.hideZoom;
    }

    public void print() {
        try {
            PrintDialog printDialog = new PrintDialog();
            PrintOptions printOptions = new PrintOptions();
            printOptions.setPageOrientation(0);
            printOptions.setPaperSize(CteStringBank.Letter.getI18n());
            printOptions.setTableOverflowMode(1);
            printOptions.setZoom(60);
            boolean bl = true;
        }
        catch (Exception exception) {
            Logger.write(Logger.ERROR, this, "print", exception);
            exception.printStackTrace();
            return;
        }
    }

    public void save() {
        this.save("report.pdf", false, null);
    }

    public boolean save(String string) {
        return this.save(string, false, null);
    }

    public boolean save(String string, String string2) {
        return this.save(string, false, string2);
    }

    public boolean getAttachment(String string, String string2) {
        if (string2.equals("pdf")) {
            return this.getAttachmentAsPDF(string);
        }
        return true;
    }

    public boolean getAttachmentAsPDF(String string) {
        return true;
    }

    public boolean saveToExcel(String string) {
        File file = new File(string);
        try {
            this.reportFormatter.buildReport(string, ConversionType.EXCEL);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
            bufferedWriter.write(this.reportFormatter.getExportData());
            bufferedWriter.flush();
            bufferedWriter.close();
            Utilities.showInfoMessage(CteStringBank.Successfully_saved_the_file.getI18n(), "");
            return true;
        }
        catch (Exception exception) {
            Utilities.showErrorMessage(CteStringBank.Unable_to_save_file.getI18n(), true);
            exception.printStackTrace();
            Logger.write(Logger.ERROR, this, "Save", exception);
            return false;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Utilities.showErrorMessage(CteStringBank.Out_Of_Memory_Error.getI18n(), true);
            outOfMemoryError.printStackTrace();
            Logger.write(Logger.ERROR, this, "Save", outOfMemoryError);
            return false;
        }
    }

    public boolean saveToHTML(String string) {
        try {
            if (!this.reportFormatter.createTempFolder()) {
                return false;
            }
            this.reportFormatter.buildReport(string, ConversionType.MHTML);
            Utilities.showInfoMessage(CteStringBank.Successfully_saved_the_file.getI18n(), "");
            return true;
        }
        catch (Exception exception) {
            Utilities.showErrorMessage(CteStringBank.Unable_to_save_file.getI18n(), true);
            exception.printStackTrace();
            Logger.write(Logger.ERROR, this, "Save", exception);
            return false;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Utilities.showErrorMessage(CteStringBank.Out_Of_Memory_Error.getI18n(), true);
            outOfMemoryError.printStackTrace();
            Logger.write(Logger.ERROR, this, "Save", outOfMemoryError);
            return false;
        }
    }

    public boolean save(String string, boolean bl, String string2) {
        return this.save(string, bl, string2, -1, -1, null, null);
    }

    public boolean save(String string, boolean bl, String string2, int n, int n2, ConversionType[] conversionTypeArray, ConversionType conversionType) {
        Logger.write(Logger.INFO, this, "save", "File Name: " + string);
        try {
            Container container;
            String string3 = "";
            if (string.lastIndexOf(46) != -1) {
                string3 = string.substring(string.lastIndexOf(46) + 1).toLowerCase();
            }
            if (!(string3.equals(ConversionType.PDF.getFileExtension()) || string3.equalsIgnoreCase(ConversionType.MHTML.getFileExtension()) || string3.equalsIgnoreCase(ConversionType.EXCEL.getFileExtension()) || string3.equalsIgnoreCase(ConversionType.CSV.getFileExtension()))) {
                string3 = ReportManager.getGUIMode() ? (this.saveDialogType != null ? this.saveDialogType.getFileExtension() : ConversionType.PDF.getFileExtension()) : this.reportFormatter.getConversionType().getFileExtension();
                string = string + "." + string3;
            }
            if (this.saveDialogType == null) {
                container = null;
                container = new SaveDialog(string, string2, this.saveDialogType);
                if (conversionTypeArray != null) {
                    ((SaveDialog)container).setConversionTypes(conversionTypeArray);
                }
                if (conversionType != null) {
                    ((SaveDialog)container).setConversionType(conversionType);
                }
                if (string3.equals(ConversionType.PDF.getFileExtension())) {
                    // empty if block
                }
                ((BasicJDialog)container).setVisible(true);
                if (!((SaveDialog)container).isOKSelected) {
                    container = null;
                    return false;
                }
                string = ((SaveDialog)container).getFileName();
                string3 = string.substring(string.lastIndexOf(46) + 1).toLowerCase();
                if (string.lastIndexOf(46) == -1 || string3 == null) {
                    string = string + "." + ((SaveDialog)container).getFileExtension();
                }
            } else {
                container = new ExportFileChooser(string, string2, this.saveDialogType);
                if (!((ExportFileChooser)container).isOKSelected()) {
                    container = null;
                    return false;
                }
                string = ((ExportFileChooser)container).getFileName();
                string3 = string.substring(string.lastIndexOf(46) + 1).toLowerCase();
                if (string.lastIndexOf(46) == -1 || string3 == null) {
                    string = string + "." + ((ExportFileChooser)container).getFileExtension();
                }
            }
            if (string3.equals(ConversionType.MHTML.getFileExtension())) {
                return this.saveToHTML(string);
            }
            if (string3.equals(ConversionType.EXCEL.getFileExtension()) || string3.equals(ConversionType.CSV.getFileExtension())) {
                return this.saveToExcel(string);
            }
            this.isPDF = true;
            if (!this.reportFormatter.createTempFolder()) {
                return false;
            }
            boolean bl2 = this.reportFormatter.buildReport(string, ConversionType.PDF);
            this.exportFileName = string;
            return bl2;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            CVFrame.instance().resetCursor();
            Utilities.showErrorMessage(CteStringBank.Out_Of_Memory_Error.getI18n(), true);
            outOfMemoryError.printStackTrace();
            return false;
        }
        catch (Exception exception) {
            CVFrame.instance().resetCursor();
            Utilities.showErrorMessage(CteStringBank.Unable_to_save_file.getI18n(), true);
            exception.printStackTrace();
            return false;
        }
    }

    public boolean isPDF() {
        return this.isPDF;
    }

    public String getExportFileName() {
        return this.exportFileName;
    }

    private boolean hasMoreColumnsInTable() {
        int n = 0;
        for (ReportItem reportItem : this.reportFormatter.getBuilder()) {
            TableItem tableItem;
            int n2;
            if (reportItem.getProperty() != ReportElementEnum.TABLE || (n2 = (tableItem = (TableItem)reportItem.getValue()).getTable().getColumnCount()) <= n) continue;
            n = n2;
        }
        return n > 15;
    }

    public static void setGUIMode(boolean bl) {
        guiMode = bl;
    }

    public static boolean getGUIMode() {
        return guiMode;
    }

    public List<ExportFile> getPDFpdfExportFiles() {
        if (this.reportFormatter != null) {
            return this.reportFormatter.getPDFpdfExportFiles();
        }
        return new ArrayList<ExportFile>();
    }
}

