/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.reports.components;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import commvault.cte.CteStringBank;
import commvault.cte.component.table.CVTreeTableModel;
import commvault.cte.component.table.CVTreeTableRow;
import commvault.cte.reports.components.ChartItem;
import commvault.cte.reports.components.ConversionType;
import commvault.cte.reports.components.HeaderItem;
import commvault.cte.reports.components.ReportElementEnum;
import commvault.cte.reports.components.ReportFormatter;
import commvault.cte.reports.components.ReportItem;
import commvault.cte.reports.components.TableItem;
import commvault.cte.reports.util.ReportConverterUtilities;
import java.awt.Component;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ExcelHelper {
    private static final String TSV_DELIMITER = "\t";
    private static final String CSV_DELIMITER = ",";
    private String DELIMITER = "\t";
    private boolean isWebReport = false;

    public ExcelHelper(ConversionType conversionType) {
        this.DELIMITER = conversionType == ConversionType.EXCEL ? TSV_DELIMITER : CSV_DELIMITER;
    }

    public void setWebReport(boolean bl) {
        this.isWebReport = bl;
    }

    public boolean isWebReport() {
        return this.isWebReport;
    }

    public String generateExportData(List<ReportItem> list) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!this.isWebReport) {
            for (ReportItem reportItem : list) {
                if (reportItem.getProperty() == ReportElementEnum.PIE_CHART || reportItem.getProperty() == ReportElementEnum.CHART) {
                    bl = true;
                }
                if (reportItem.getProperty() != ReportElementEnum.MULTIPLE_CHARTS || (string = this.exportDataForMultiplePieChart(reportItem.getValue())) == null || string == "") continue;
                bl = true;
                break;
            }
        }
        for (ReportItem reportItem : list) {
            switch (reportItem.getProperty()) {
                case CHART_BANNER_TITLE_LABEL: {
                    if (!bl) break;
                    stringBuilder.append(reportItem.getValue().toString()).append(ReportFormatter.LINE_SEPARATOR);
                    break;
                }
                case TEXT: 
                case BOLD_TEXT: 
                case LABEL_CENTER: 
                case LABEL_LEFT: 
                case BANNER_TITLE_LABEL: 
                case MESSAGE_PANEL: 
                case INDENTED_TEXT: {
                    string = ReportConverterUtilities.removeHTMLTagsFromString(reportItem.getValue().toString());
                    stringBuilder.append(string).append(ReportFormatter.LINE_SEPARATOR);
                    break;
                }
                case REPORT_TITLE: {
                    stringBuilder.append(this.exportHeaderData((HeaderItem)reportItem.getValue()));
                    break;
                }
                case NEW_LINE: {
                    stringBuilder.append(ReportFormatter.LINE_SEPARATOR);
                    break;
                }
                case TASK_SUMMARY: 
                case DATA_TABLE: {
                    stringBuilder.append(this.exportDataVector((Vector)reportItem.getValue()));
                    break;
                }
                case PIE_CHART: {
                    if (this.isWebReport) break;
                    stringBuilder.append(this.exportDataForPieChart(((ChartItem)reportItem.getValue()).getChart()));
                    break;
                }
                case MULTIPLE_CHARTS: {
                    if (this.isWebReport) break;
                    stringBuilder.append(this.exportDataForMultiplePieChart(reportItem.getValue()));
                    break;
                }
                case CHART: {
                    stringBuilder.append(this.exportDataForBarChart(((ChartItem)reportItem.getValue()).getChart()));
                    break;
                }
                case TABLE: {
                    stringBuilder.append(this.getExportTableData((TableItem)reportItem.getValue()));
                }
            }
        }
        return stringBuilder.toString();
    }

    public String exportHeaderData(HeaderItem headerItem) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(headerItem.getTitle()).append(ReportFormatter.LINE_SEPARATOR);
        if (headerItem.getTimeStamp() != null) {
            stringBuilder.append(headerItem.getTimeStamp()).append(ReportFormatter.LINE_SEPARATOR);
            if (headerItem.getExtraInfo() != null) {
                stringBuilder.append(headerItem.getExtraInfo()).append(ReportFormatter.LINE_SEPARATOR);
            }
        } else if (headerItem.getHeaderItem().size() == 1) {
            stringBuilder.append(headerItem.getHeaderItem().get(0).toString()).append(ReportFormatter.LINE_SEPARATOR);
        } else if (headerItem.getHeaderItem().size() > 1) {
            for (int i = 0; i < headerItem.getHeaderItem().size(); ++i) {
                stringBuilder.append(headerItem.getHeaderItem().get(i));
                if (i % 2 != 0) continue;
                stringBuilder.append(ReportFormatter.LINE_SEPARATOR);
            }
        }
        return stringBuilder.toString();
    }

    public String exportDataVector(Vector vector) {
        return this.exportDataVector(vector, null);
    }

    public String exportDataVector(Vector vector, Vector vector2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (vector.isEmpty()) {
            return stringBuffer.toString();
        }
        String string = "";
        if (vector2 != null) {
            for (n = 0; n < vector2.size(); ++n) {
                string = string + vector2.get(n) + this.DELIMITER;
            }
        }
        if (string.trim().length() != 0) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        for (n = 0; n < vector.size(); ++n) {
            Vector vector3 = (Vector)vector.get(n);
            for (int i = 0; i < vector3.size(); ++i) {
                if (vector3.get(i) != null) {
                    stringBuffer.append(vector3.get(i).toString());
                    if (vector3.get(i).equals("")) continue;
                    stringBuffer.append(this.DELIMITER);
                    continue;
                }
                stringBuffer.append(this.DELIMITER);
            }
            stringBuffer.append(ReportFormatter.LINE_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    public String exportDataForPieChart(JComponent jComponent) {
        Chart chart = null;
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            if (!(jComponent.getComponent(i) instanceof Chart)) continue;
            chart = (Chart)jComponent.getComponent(i);
            break;
        }
        if (chart == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        ChartModel chartModel = chart.getModel();
        int n = chartModel.getPointCount();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(chartModel.getPoint(i).toString()).append(ReportFormatter.LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public String exportDataForMultiplePieChart(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        List list = (List)object;
        ChartItem chartItem = (ChartItem)list.get(0);
        ChartItem chartItem2 = (ChartItem)list.get(1);
        if (!chartItem.isPieChart()) {
            return "";
        }
        if (chartItem.getTitle() != null && chartItem.getTitle().length() > 0) {
            stringBuilder.append(chartItem.getTitle()).append(ReportFormatter.LINE_SEPARATOR);
        }
        stringBuilder.append(this.exportDataForPieChart(chartItem.getChart())).append(ReportFormatter.LINE_SEPARATOR);
        if (chartItem2.getTitle() != null && chartItem2.getTitle().length() > 0) {
            stringBuilder.append(chartItem2.getTitle()).append(ReportFormatter.LINE_SEPARATOR);
        }
        if (chartItem2.getChart() != null) {
            stringBuilder.append(this.exportDataForPieChart(chartItem2.getChart())).append(ReportFormatter.LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public String exportDataForBarChart(JComponent jComponent) {
        Chart chart = null;
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            if (!(jComponent.getComponent(i) instanceof Chart)) continue;
            chart = (Chart)jComponent.getComponent(i);
            break;
        }
        if (chart == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        List list = chart.getModels();
        stringBuilder.append(this.DELIMITER);
        for (ChartModel chartModel : list) {
            stringBuilder.append(chartModel.getName());
        }
        stringBuilder.append(ReportFormatter.LINE_SEPARATOR);
        for (ChartModel chartModel : list) {
            for (int i = 0; i < chartModel.getPointCount(); ++i) {
                stringBuilder.append(chartModel.getPoint(i).getY().toString()).append(this.DELIMITER);
            }
            stringBuilder.append(ReportFormatter.LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public String getExportTableData(TableItem tableItem) {
        if (tableItem.isTreeTable()) {
            return this.exportTreeTable(tableItem);
        }
        return this.exportTable(tableItem);
    }

    public String exportTable(TableItem tableItem) {
        int n;
        JTable jTable = tableItem.getTable();
        StringBuilder stringBuilder = new StringBuilder();
        if (tableItem.getTablePanel() != null && jTable.getRowCount() < 1) {
            stringBuilder.append(tableItem.getTablePanel().getMessage()).append(ReportFormatter.LINE_SEPARATOR);
            return stringBuilder.toString();
        }
        for (n = 0; n < jTable.getColumnCount(); ++n) {
            String string = jTable.getColumnName(n);
            string = string.replaceAll(ReportFormatter.LINE_SEPARATOR, " ");
            stringBuilder.append(string);
            stringBuilder.append(this.DELIMITER);
        }
        stringBuilder.append(ReportFormatter.LINE_SEPARATOR);
        n = jTable.getRowCount();
        int n2 = jTable.getColumnCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                TableCellRenderer tableCellRenderer = jTable.getCellRenderer(i, j);
                String string = "";
                Object object = jTable.getValueAt(i, j);
                Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, i, j);
                if (component instanceof JProgressBar) {
                    string = Integer.toString(((JProgressBar)component).getValue()) + " %";
                } else if (object instanceof Iterable) {
                    Iterable iterable = (Iterable)object;
                    for (Object t : iterable) {
                        string = string + t.toString();
                        string = string + ", ";
                    }
                    string = string.substring(0, string.length() - 2);
                } else {
                    string = object instanceof Boolean ? ((Boolean)object == true ? ReportConverterUtilities.getLocalizedString(CteStringBank.Yes) : ReportConverterUtilities.getLocalizedString(CteStringBank.No)) : object.toString();
                }
                string = string.replace("\\n", "\n");
                stringBuilder.append("\"" + string + "\"");
                stringBuilder.append(this.DELIMITER);
            }
            stringBuilder.append(ReportFormatter.LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public String exportTreeTable(TableItem tableItem) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        JTable jTable = tableItem.getTable();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            stringBuffer.append(jTable.getColumnName(i).replaceAll(ReportFormatter.LINE_SEPARATOR, " ").replaceAll(this.DELIMITER, " "));
            stringBuffer.append(this.DELIMITER);
        }
        stringBuffer.append(ReportFormatter.LINE_SEPARATOR);
        CVTreeTableModel cVTreeTableModel = (CVTreeTableModel)((Object)TableModelWrapperUtils.getActualTableModel((TableModel)jTable.getModel()));
        int n = jTable.getModel().getColumnCount();
        for (CVTreeTableRow cVTreeTableRow : cVTreeTableModel.getRows()) {
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    string = cVTreeTableRow.getValueAt(i).toString();
                }
                if (i == 0) {
                    string = "";
                    CVTreeTableRow[] cVTreeTableRowArray = cVTreeTableRow.getPath();
                    if (cVTreeTableRowArray != null) {
                        for (int j = 0; j < cVTreeTableRowArray.length; ++j) {
                            CVTreeTableRow cVTreeTableRow2;
                            string = j != cVTreeTableRowArray.length - 1 ? string + "    " : ((cVTreeTableRow2 = cVTreeTableRowArray[j]).isUnregistered() ? string + "*" + cVTreeTableRow2.toString() : string + cVTreeTableRow2.toString());
                        }
                    }
                }
                string = string.replaceAll(this.DELIMITER, " ");
                string = ReportConverterUtilities.removeHTMLTagsFromString(string);
                stringBuffer.append(string);
                stringBuffer.append(this.DELIMITER);
            }
            stringBuffer.append(ReportFormatter.LINE_SEPARATOR);
        }
        stringBuffer.append(ReportFormatter.LINE_SEPARATOR);
        return stringBuffer.toString();
    }
}

