/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.registry;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Properties;
import java.util.TreeSet;

public class UnixRegistryProperties
extends Properties {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public UnixRegistryProperties() {
    }

    public UnixRegistryProperties(Properties properties) {
        super(properties);
    }

    private static char toHex(int n) {
        return hexDigit[n & 0xF];
    }

    private static void writeComments(BufferedWriter bufferedWriter, String string) throws IOException {
        int n;
        bufferedWriter.write("#");
        int n2 = string.length();
        int n3 = 0;
        char[] cArray = new char[6];
        cArray[0] = 92;
        cArray[1] = 117;
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (c <= '\u00ff' && c != '\n' && c != '\r') continue;
            if (n3 != n) {
                bufferedWriter.write(string.substring(n3, n));
            }
            if (c > '\u00ff') {
                cArray[2] = UnixRegistryProperties.toHex(c >> 12 & 0xF);
                cArray[3] = UnixRegistryProperties.toHex(c >> 8 & 0xF);
                cArray[4] = UnixRegistryProperties.toHex(c >> 4 & 0xF);
                cArray[5] = UnixRegistryProperties.toHex(c & 0xF);
                bufferedWriter.write(new String(cArray));
            } else {
                bufferedWriter.newLine();
                if (c == '\r' && n != n2 - 1 && string.charAt(n + 1) == '\n') {
                    ++n;
                }
                if (n == n2 - 1 || string.charAt(n + 1) != '#' && string.charAt(n + 1) != '!') {
                    bufferedWriter.write("#");
                }
            }
            n3 = n + 1;
        }
        if (n3 != n) {
            bufferedWriter.write(string.substring(n3, n));
        }
        bufferedWriter.newLine();
    }

    @Override
    public void store(Writer writer, String string) throws IOException {
        this.store0(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer), string, false);
    }

    @Override
    public void store(OutputStream outputStream, String string) throws IOException {
        this.store0(new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1")), string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store0(BufferedWriter bufferedWriter, String string, boolean bl) throws IOException {
        if (string != null) {
            UnixRegistryProperties.writeComments(bufferedWriter, string);
        }
        bufferedWriter.write("#" + new Date().toString());
        bufferedWriter.newLine();
        UnixRegistryProperties unixRegistryProperties = this;
        synchronized (unixRegistryProperties) {
            TreeSet<Object> treeSet = new TreeSet<Object>();
            treeSet.addAll(this.keySet());
            for (Object e : treeSet) {
                String string2 = (String)e;
                String string3 = (String)this.get(string2);
                string2 = this.saveConvert(string2, true, bl);
                string3 = this.saveConvert(string3, false, bl);
                bufferedWriter.write(string2 + " " + string3);
                bufferedWriter.newLine();
            }
        }
        bufferedWriter.flush();
    }

    private String saveConvert(String string, boolean bl, boolean bl2) {
        int n = string.length();
        int n2 = n * 2;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '=' && c < '\u007f') {
                if (c == '\\') {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            switch (c) {
                case ' ': {
                    if (i == 0 || bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    continue block7;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block7;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block7;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block7;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block7;
                }
                default: {
                    if ((c < ' ' || c > '~') & bl2) {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(UnixRegistryProperties.toHex(c >> 12 & 0xF));
                        stringBuffer.append(UnixRegistryProperties.toHex(c >> 8 & 0xF));
                        stringBuffer.append(UnixRegistryProperties.toHex(c >> 4 & 0xF));
                        stringBuffer.append(UnixRegistryProperties.toHex(c & 0xF));
                        continue block7;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

