/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.net;

import commvault.cte.net.MD5;
import commvault.cte.util.UTF8String;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.rmi.RemoteException;

public class ProxyConnect {
    public static final int CVFW_CMD_BEGIN_SIG = 234;
    public static final int CVFW_CMD_END_SIG = 235;
    public static final int CVFW_CMD_VERSION = 8;
    public static final int CVFW_CMD_MIN_VERSION = 3;
    public static final int CVFW_CMD_VERSION_NAT = 4;
    public static final int CVFW_CMD_VERSION_AFT = 5;
    public static final int CVFW_CMD_VERSION_EXPECT_KEEP_ALIVE = 6;
    public static final int CVFW_CMD_VERSION_CNAME = 7;
    public static final int CVFW_CMD_VERSION_90 = 8;
    static final int[] secret = new int[]{181, 142, 22, 138, 106, 205, 202, 12, 177, 140, 0, 221, 116, 248, 148, 160};

    private static void authenticate(DataOutputStream dataOutputStream, DataInputStream dataInputStream) throws Exception {
        CvFwCommand cvFwCommand = ProxyConnect.receiveCmd(dataInputStream);
        if (cvFwCommand.cmd != CVFW_COMMAND.AUTH_CHALLENGE) {
            throw new IOException("Expecting AUTH_CHALLENGE, but found" + (Object)((Object)cvFwCommand.cmd));
        }
        cvFwCommand.cmd = CVFW_COMMAND.AUTH_RESPONSE;
        if (cvFwCommand.data.auth_response == null) {
            cvFwCommand.data.auth_response = new CvFwAuthResponse();
        }
        ProxyConnect.printHex("auth_challenge received:", cvFwCommand.data.auth_challenge.data);
        ProxyConnect.computeAuthResponse(cvFwCommand.data.auth_challenge.data, cvFwCommand.data.auth_response.data);
        ProxyConnect.printHex("auth_response send:", cvFwCommand.data.auth_response.data);
        ProxyConnect.encodeCommand(dataOutputStream, cvFwCommand);
        cvFwCommand = ProxyConnect.receiveCmd(dataInputStream);
        if (cvFwCommand.cmd != CVFW_COMMAND.AUTH_CONFIRM) {
            throw new Exception("Didn't get expected AUTH_CONFIRM command from CVFWD.");
        }
    }

    private static void printHex(String string, byte[] byArray) {
        System.out.print(string + ": ");
        for (int i = 0; i < byArray.length; ++i) {
            System.out.printf("0x%02X, ", byArray[i]);
        }
        System.out.println();
    }

    private static void computeAuthResponse(byte[] byArray, byte[] byArray2) throws Exception {
        for (int i = 0; i < 16; ++i) {
            byArray[i] = (byte)(byArray[i] ^ secret[i]);
        }
        ProxyConnect.printHex("data befor md5:", byArray);
        ProxyConnect.cvfw_md5_compute(byArray, byArray2);
    }

    private static void cvfw_md5_compute(byte[] byArray, byte[] byArray2) throws Exception {
        MD5 mD5 = new MD5();
        mD5.Update(byArray);
        byte[] byArray3 = mD5.Final();
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = byArray3[i];
        }
    }

    private static void shakeHands(DataOutputStream dataOutputStream, DataInputStream dataInputStream) throws Exception {
        CvFwCommand cvFwCommand = new CvFwCommand();
        cvFwCommand.cmd = CVFW_COMMAND.HELLO;
        cvFwCommand.data.hello.version = 8;
        ProxyConnect.encodeCommand(dataOutputStream, cvFwCommand);
        cvFwCommand = ProxyConnect.receiveCmd(dataInputStream);
        if (cvFwCommand.data.hello.version != 8) {
            throw new IOException("version did not match");
        }
    }

    private static CvFwCommand receiveCmd(DataInputStream dataInputStream) throws Exception {
        int n = ProxyConnect.decode_uchar(dataInputStream);
        if (n != 234) {
            throw new Exception("data corrupt:does not match start");
        }
        int n2 = ProxyConnect.decode_uint16(dataInputStream);
        CvFwCommand cvFwCommand = new CvFwCommand();
        cvFwCommand.cmd = CVFW_COMMAND.get(ProxyConnect.decode_int16(dataInputStream));
        ProxyConnect.decodeCommand(cvFwCommand, n2 -= 6, dataInputStream);
        int n3 = ProxyConnect.decode_uchar(dataInputStream);
        if (n3 != 235) {
            throw new Exception("data corrupt:does not match end");
        }
        return cvFwCommand;
    }

    private static void decodeCommand(CvFwCommand cvFwCommand, int n, DataInputStream dataInputStream) throws Exception {
        switch (cvFwCommand.cmd) {
            case WELCOME: {
                cvFwCommand.data.hello.version = ProxyConnect.decode_uchar(dataInputStream);
                break;
            }
            case AUTH_CHALLENGE: {
                if (cvFwCommand.data.auth_challenge == null) {
                    cvFwCommand.data.auth_challenge = new CvFwAuthChallenge();
                }
                for (int i = 0; i < 16; ++i) {
                    cvFwCommand.data.auth_challenge.data[i] = (byte)ProxyConnect.decode_uchar(dataInputStream);
                }
                break;
            }
            case CLNT_FAILED: {
                cvFwCommand.data.clnt_failed = new CvFwConnectFailed();
                cvFwCommand.data.clnt_failed.error_code = ProxyConnect.decode_uint32(dataInputStream);
                cvFwCommand.data.clnt_failed.error_mesg = ProxyConnect.decode_string(dataInputStream);
                break;
            }
        }
    }

    private static int decode_uchar(DataInputStream dataInputStream) throws Exception {
        return dataInputStream.readByte() & 0xFF;
    }

    private static int decode_int16(DataInputStream dataInputStream) throws Exception {
        return dataInputStream.readShort();
    }

    private static int decode_uint16(DataInputStream dataInputStream) throws Exception {
        return dataInputStream.readShort();
    }

    static void encodeCommand(DataOutputStream dataOutputStream, CvFwCommand cvFwCommand) throws Exception {
        ProxyConnect.encode_uchar(234, dataOutputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = dataOutputStream;
        dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        ProxyConnect.encode_int16(cvFwCommand.cmd.id, dataOutputStream);
        switch (cvFwCommand.cmd) {
            case HELLO: {
                ProxyConnect.encode_uchar(cvFwCommand.data.hello.version, dataOutputStream);
                break;
            }
            case CLNT_CONNECT: {
                ProxyConnect.write(cvFwCommand.data.clnt_connect, dataOutputStream);
                break;
            }
            case AUTH_RESPONSE: {
                for (byte by : cvFwCommand.data.auth_response.data) {
                    ProxyConnect.encode_uchar(by & 0xFF, dataOutputStream);
                }
                break;
            }
        }
        ProxyConnect.encode_uchar(235, dataOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dataOutputStream = dataOutputStream2;
        ProxyConnect.encode_uint16(byArray.length + 2 + 1, dataOutputStream);
        dataOutputStream.write(byArray);
    }

    private static void encode_int16(int n, DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeShort(n);
    }

    private static void encode_uint16(int n, DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeShort(n);
    }

    private static void encode_uchar(int n, DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeByte(n);
    }

    private static void connect(DataOutputStream dataOutputStream, DataInputStream dataInputStream, String string, int n) throws Exception {
        CvFwCommand cvFwCommand = new CvFwCommand();
        cvFwCommand.cmd = CVFW_COMMAND.CLNT_CONNECT;
        cvFwCommand.data.clnt_connect.cname = string;
        cvFwCommand.data.clnt_connect.host = string;
        cvFwCommand.data.clnt_connect.port4 = n;
        cvFwCommand.data.clnt_connect.port6 = -1;
        ProxyConnect.encodeCommand(dataOutputStream, cvFwCommand);
        cvFwCommand = ProxyConnect.receiveCmd(dataInputStream);
        if (cvFwCommand.cmd == CVFW_COMMAND.CLNT_FAILED) {
            throw new RemoteException(cvFwCommand.data.clnt_failed.error_mesg);
        }
    }

    private static void write(CvFwClntConnect cvFwClntConnect, DataOutputStream dataOutputStream) throws Exception {
        ProxyConnect.encode_string(dataOutputStream, cvFwClntConnect.cname);
        ProxyConnect.encode_string(dataOutputStream, cvFwClntConnect.host);
        ProxyConnect.encode_int32(dataOutputStream, cvFwClntConnect.port4);
        ProxyConnect.encode_int32(dataOutputStream, cvFwClntConnect.port6);
    }

    private static String decode_string(DataInputStream dataInputStream) throws Exception {
        short s = dataInputStream.readShort();
        byte[] byArray = new byte[s];
        dataInputStream.read(byArray);
        dataInputStream.readByte();
        return UTF8String.newString(byArray);
    }

    private static int decode_uint32(DataInputStream dataInputStream) throws Exception {
        return dataInputStream.readInt();
    }

    private static void encode_int32(DataOutputStream dataOutputStream, int n) throws Exception {
        dataOutputStream.writeInt(n);
    }

    private static void encode_string(DataOutputStream dataOutputStream, String string) throws Exception {
        byte[] byArray = string.getBytes("utf-8");
        dataOutputStream.writeShort(byArray.length);
        dataOutputStream.write(byArray);
        dataOutputStream.writeByte(0);
    }

    public static void main(String[] stringArray) throws Exception {
        ProxyConnect.createSocket("fries", 49966, "canon05", 8403);
    }

    public static Socket createSocket(String string, int n, String string2, int n2) throws IOException {
        try {
            Socket socket = new Socket(string, n);
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            ProxyConnect.shakeHands(dataOutputStream, dataInputStream);
            ProxyConnect.authenticate(dataOutputStream, dataInputStream);
            ProxyConnect.connect(dataOutputStream, dataInputStream, string2, n2);
            return socket;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    static class Data {
        CvFwClntConnect clnt_connect = new CvFwClntConnect();
        CvFwHello hello = new CvFwHello();
        CvFwAuthResponse auth_response;
        CvFwAuthChallenge auth_challenge = null;
        CvFwConnectFailed clnt_failed = null;

        Data() {
        }
    }

    public static class CvFwCommand {
        public CVFW_COMMAND cmd;
        public Data data = new Data();
    }

    public static class CvFwAuthChallenge {
        public byte[] data = new byte[16];
    }

    public static class CvFwAuthResponse {
        public byte[] data = new byte[16];
    }

    static class CvFwConnectFailed {
        int id;
        int error_code;
        String error_mesg;

        CvFwConnectFailed() {
        }
    }

    static class CvFwClntConnect {
        String cname;
        String host;
        int port4;
        int port6;

        CvFwClntConnect() {
        }
    }

    static class CvFwHello {
        int version;

        CvFwHello() {
        }
    }

    static enum CVFW_COMMAND {
        INVALID_CMD(0),
        HELLO(1),
        WELCOME(2),
        AUTH_CHALLENGE(3),
        AUTH_RESPONSE(4),
        AUTH_CONFIRM(5),
        KEEP_ALIVE(6),
        SEND_CLIENT_ID(7),
        RECV_CLIENT_ID(8),
        CREATE_CLIENT(9),
        CLIENT_CREATED(10),
        CONNECT_CLIENT(11),
        CLIENT_CONNECTED(12),
        CONNECT_FAILED(13),
        DELETE_CLIENT(14),
        SUSPEND_CLIENT(15),
        RESUME_CLIENT(16),
        TUNNEL_DATA(17),
        STOP_TUNNEL(18),
        NAT_ICU_AS(19),
        EXPECT_KEEP_ALIVE(21),
        RECV_CNAME(22),
        CONNECT_CLIENT_LOCAL(23),
        CONNECT_CLIENT90(24),
        ACK_DATA90(25),
        IS_REACHABLE_REQ(26),
        IS_REACHABLE_RESP(27),
        CLNT_CONNECT(100),
        CLNT_SUCCESS(101),
        CLNT_FAILED(102),
        CLNT_VM_UP_DOWN(105),
        CLNT_IS_REACHABLE_REQ(106),
        CLNT_IS_REACHABLE_RESP(107);

        int id;

        private CVFW_COMMAND(int n2) {
            this.id = n2;
        }

        public int getId() {
            return this.id;
        }

        static CVFW_COMMAND get(int n) {
            for (CVFW_COMMAND cVFW_COMMAND : CVFW_COMMAND.values()) {
                if (cVFW_COMMAND.getId() != n) continue;
                return cVFW_COMMAND;
            }
            return null;
        }
    }
}

