/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.db;

import commvault.cte.db.CTEDBException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class CTEDBColumn {
    private final String colName;
    private int colIndex = -1;
    private final boolean identity;
    private final boolean primaryKey;
    private boolean modified = false;
    private volatile Object value;

    protected CTEDBColumn(String string, int n, boolean bl, boolean bl2) {
        this.colName = string;
        this.primaryKey = bl;
        this.identity = bl2;
        this.colIndex = n;
    }

    protected CTEDBColumn(String string, boolean bl, boolean bl2) {
        this.colName = string;
        this.primaryKey = bl;
        this.identity = bl2;
    }

    protected boolean isSelectable() {
        return true;
    }

    protected void set(ResultSet resultSet) throws CTEDBException {
        Object object;
        try {
            object = resultSet.getObject(this.getColumnName());
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error retrieving column [" + this.getColumnName() + "] from result set", sQLException);
        }
        if (object == null) {
            this.setValue(null);
        } else {
            this.fromResult(resultSet);
        }
        this.modified = false;
    }

    protected void set(ResultSet resultSet, int n) throws CTEDBException {
        Object object;
        try {
            object = resultSet.getObject(n);
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error retrieving column [" + this.getColumnName() + "] from result set", sQLException);
        }
        if (object == null) {
            this.setValue(null);
        } else {
            this.fromResult(resultSet, n);
        }
        this.modified = false;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public void setNull() {
        this.setValue(null);
    }

    public synchronized Object getValue() {
        return this.value;
    }

    protected synchronized void setValue(Object object) {
        this.value = object;
        this.modified = true;
    }

    public String toString() {
        return this.colName;
    }

    public String getColumnName() {
        return this.colName;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public int getIndex() {
        return this.colIndex;
    }

    public boolean isModified() {
        return this.modified;
    }

    protected void resetModifiedFlag() {
        this.modified = false;
    }

    protected abstract void fromResult(ResultSet var1) throws CTEDBException;

    protected abstract void fromResult(ResultSet var1, int var2) throws CTEDBException;

    protected abstract void setParameter(PreparedStatement var1, int var2) throws CTEDBException;

    protected abstract void zero();
}

