/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.tree;

import com.jgoodies.binding.beans.BeanAdapter;
import commvault.cte.component.tree.CommNetBrowseBaseNode;
import commvault.cte.component.tree.Entity;
import commvault.cte.component.tree.EntityContext;
import commvault.cte.component.tree.EntityImpl;
import commvault.cte.component.tree.MultiStateTreeNode;
import commvault.cte.component.tree.NodeType;
import commvault.cte.component.tree.UnselectedChildrenHidable;
import commvault.msgs.CvEntities.EntityType;
import commvault.msgs.CvEntities.GenericEntity;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class EntityTreeNode
extends CommNetBrowseBaseNode {
    protected Entity nodeData;
    private EntityContext context;
    private String key;
    protected int childSelectionCount = 0;
    private Vector<EntityTreeNode> childNodes = null;

    public EntityTreeNode(Entity entity, EntityContext entityContext, boolean bl) {
        super(entity.getId(), "");
        this.context = entityContext;
        this.setUserObject(entity);
        this.nodeData = entity;
        this.setAllowsChildren(!this.isLeafNode());
        if (!entityContext.getEntityLoader().isSystemDefinedNodeType(this.nodeData.getNodeType()) && bl) {
            this.populate();
        }
        if (this.nodeData.isRestricted() && (this.getTriState() == 0 || this.getTriState() == -1)) {
            this.setTreeIcon(EMPTY_DISABLED_ICON);
        } else if (this.nodeData.isRestricted() && this.getTriState() == 1) {
            this.setTreeIcon(HALF_DISABLED_ICON);
        } else if (this.nodeData.isRestricted() && this.getTriState() == 2) {
            this.setTreeIcon(FULL_DISABLED_ICON);
        }
        if (this.nodeData.isRestricted() && this.nodeData.isSelected()) {
            this.setTreeIcon(PART_DISABLED_ICON);
        }
        this.createKey();
    }

    public EntityTreeNode(Entity entity, EntityContext entityContext) {
        this(entity, entityContext, true);
    }

    @Override
    public boolean isLeafNode() {
        if (this.nodeData == null || this.nodeData.getNodeType() == null) {
            return false;
        }
        return this.nodeData.getNodeType().getChildNodeTypes().size() == 0;
    }

    public Entity getEntity() {
        return this.nodeData;
    }

    private void createKey() {
        UUID uUID = UUID.randomUUID();
        this.key = uUID.toString();
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public void loadChildren() {
        boolean bl = this.context.isVisibilitySupported();
        Iterator<NodeType> iterator = this.nodeData.getNodeType().getChildNodeTypes().iterator();
        int n = this.getChildCount();
        while (iterator.hasNext()) {
            NodeType nodeType = iterator.next();
            List<EntityTreeNode> list = this.context.getEntityNodes(nodeType, this.nodeData);
            for (EntityTreeNode entityTreeNode : list) {
                if (n <= 0 || this.isChildExists(entityTreeNode.getId())) {
                    this.addChild(entityTreeNode);
                } else {
                    --n;
                }
                entityTreeNode.updateNodeState();
            }
        }
        if (bl) {
            this.populateNodeAccordingToVisibility();
        }
    }

    public void populateNodeAccordingToVisibility() {
        this.childNodes = null;
        if (this.children == null) {
            return;
        }
        for (Object e : this.children) {
            EntityTreeNode entityTreeNode = (EntityTreeNode)e;
            if (!entityTreeNode.isVisible()) {
                if (this.childNodes == null) {
                    this.childNodes = new Vector();
                    this.childNodes.addAll(new Vector(this.children));
                }
                this.childNodes.remove(e);
            }
            entityTreeNode.populateNodeAccordingToVisibility();
        }
    }

    public void updateNodeState() {
        if (this.getEntity().isRestricted()) {
            return;
        }
        if (this.getEntity().isSelected()) {
            this.setSelected(true);
        } else if (this.isChildEntitySelected(this.getEntity())) {
            this.applyState(1);
        } else {
            this.applyStateFromParent((CommNetBrowseBaseNode)this.getParent());
        }
    }

    protected boolean isChildEntitySelected(Entity entity) {
        if (entity.isSelected()) {
            return true;
        }
        if (entity.getChildren() == null) {
            return false;
        }
        Iterator<Entity> iterator = entity.getChildren().iterator();
        while (iterator.hasNext()) {
            boolean bl = this.isChildEntitySelected(iterator.next());
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public boolean getSelectedEntityState() {
        if (!this.nodeData.isSelected()) {
            EntityTreeNode entityTreeNode = (EntityTreeNode)this.getChildAt(0);
            return entityTreeNode.getSelectedEntityState();
        }
        return this.nodeData.isSelected();
    }

    public void updateEntityState() {
        this.nodeData.setSelected(this.isSelected() && this.context.isSelectable(this.nodeData));
        for (int i = 0; i < this.getChildCount(); ++i) {
            EntityTreeNode entityTreeNode = (EntityTreeNode)this.getChildAt(i);
            entityTreeNode.updateEntityState();
        }
    }

    @Override
    public void toggleSelection() {
        if (this.getEntity().isRestricted()) {
            return;
        }
        super.toggleSelection();
        this.nodeData.setSelected(this.isSelected() && this.context.isSelectable(this.nodeData));
        this.deselectAllitsChild(this.nodeData);
        if (this.getParent() instanceof UnselectedChildrenHidable) {
            ((UnselectedChildrenHidable)((Object)this.getParent())).resetSelectedIndex();
        }
    }

    private void deselectAllitsChild(Entity entity) {
        if (entity.getChildren() == null) {
            return;
        }
        for (Entity entity2 : entity.getChildren()) {
            entity2.setSelected(false);
            this.deselectAllitsChild(entity2);
        }
    }

    @Override
    public boolean isEnabled() {
        return (this.nodeData.getNodeType().getFlag() & 0x10) == 0;
    }

    public void expandNode() {
        this.populate();
    }

    public boolean isVisible() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int n) {
        if (this.childNodes != null) {
            return this.childNodes.get(n);
        }
        return super.getChildAt(n);
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        if (this.childNodes != null) {
            return this.childNodes.indexOf(treeNode);
        }
        return super.getIndex(treeNode);
    }

    @Override
    public int getChildCount() {
        if (this.childNodes == null) {
            return super.getChildCount();
        }
        return this.childNodes.size();
    }

    public Enumeration children() {
        if (this.childNodes == null) {
            return super.children();
        }
        return this.childNodes.elements();
    }

    @Override
    protected void notificationFromChild() {
        if (this.getEntity().isRestricted() && !this.getEntity().isVisible()) {
            return;
        }
        super.notificationFromChild();
    }

    protected Vector<EntityTreeNode> getChildren() {
        return this.childNodes;
    }

    public boolean isSelectionState() {
        if (this.nodeData.getNodeType().getNodeType() == EntityType.ROOT_ENTITY.getEnumValue() && this.children != null) {
            for (Object e : this.children) {
                if (!(e instanceof EntityTreeNode) || ((EntityTreeNode)e).getTriState() == 0 || ((EntityTreeNode)e).getTriState() == -1) continue;
                return true;
            }
        }
        return this.getTriState() != 0 && this.getTriState() != -1;
    }

    public EntityContext getEntityContext() {
        return this.context;
    }

    private void loadEntity(Entity entity, boolean bl) {
        for (NodeType nodeType : entity.getNodeType().getChildNodeTypes()) {
            List<EntityTreeNode> list = this.getEntityContext().getEntityNodes(nodeType, entity);
            for (EntityTreeNode entityTreeNode : list) {
                entity.getChildren().add(entityTreeNode.nodeData);
            }
        }
    }

    public boolean isAnyChildExcluded(Entity entity) {
        List<GenericEntity> list = this.getEntityContext().getExcludedEntities();
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (this.isEntityExcluded(entity)) {
            ((EntityImpl)entity).setExcluded(true);
            return true;
        }
        if (this.isEntityParentOfAnyExcludedEntity(entity, list)) {
            return true;
        }
        if (entity.getChildren() == null) {
            return false;
        }
        for (Entity entity2 : entity.getChildren()) {
            if (!this.isAnyChildExcluded(entity2)) continue;
            return true;
        }
        return false;
    }

    protected boolean isEntityParentOfAnyExcludedEntity(Entity entity, List<GenericEntity> list) {
        NodeType nodeType = entity.getNodeType();
        String string = nodeType.getIdDef();
        String string2 = nodeType.getNodeName();
        for (GenericEntity genericEntity : list) {
            boolean bl;
            if (!this.hasRelation(entity, genericEntity)) continue;
            BeanAdapter beanAdapter = new BeanAdapter((Object)genericEntity);
            if (string == null || string2 == null) continue;
            Object object = beanAdapter.getValue(string);
            Object object2 = beanAdapter.getValue(string2);
            if (object == null || object2 == null || !(entity instanceof EntityImpl) || !(bl = (bl = object.equals(entity.getId())) && genericEntity.get_type_().getEnumValue() != entity.getNodeType().getNodeType())) continue;
            if (entity.getNodeType().getNodeType() == EntityType.APPTYPE_ENTITY.getEnumValue()) {
                if (!genericEntity.getClientName().equals(((EntityImpl)entity.getParentEntity()).getNodeName())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    protected boolean isEntityExcluded(Entity entity) {
        List<GenericEntity> list = this.getEntityContext().getExcludedEntities();
        NodeType nodeType = entity.getNodeType();
        if (list == null) {
            return false;
        }
        for (GenericEntity genericEntity : list) {
            Object object;
            Object object2;
            if (!this.hasRelation(entity, genericEntity)) continue;
            BeanAdapter beanAdapter = new BeanAdapter((Object)genericEntity);
            Object object3 = object2 = nodeType.getIdDef() == null ? new Integer(-nodeType.getNodeType()) : beanAdapter.getValue(nodeType.getIdDef());
            Object object4 = nodeType.getIdDef() == null ? (nodeType.getNodeName() == null ? null : nodeType.getNodeName()) : (object = beanAdapter.getValue(nodeType.getNodeName()));
            if (!object2.equals(entity.getId()) || nodeType.getNodeType() != genericEntity.get_type_().getEnumValue() || !this.doesParentGroupMatch(entity, (BeanAdapter<GenericEntity>)beanAdapter)) continue;
            if (entity.getNodeType().getNodeType() == EntityType.APPTYPE_ENTITY.getEnumValue()) {
                if (!genericEntity.getClientName().equals(((EntityImpl)entity.getParentEntity()).getNodeName())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean doesParentGroupMatch(Entity entity, BeanAdapter<GenericEntity> beanAdapter) {
        if (entity.getNodeType().getNodeType() != EntityType.CLIENT_ENTITY.getEnumValue() && entity.getNodeType().getNodeType() != EntityType.USER_ENTITY.getEnumValue()) {
            return true;
        }
        Entity entity2 = entity.getParentEntity();
        if (entity2 == null || entity2.getNodeType().getNodeType() != EntityType.CLIENT_GROUP_ENTITY.getEnumValue() && entity2.getNodeType().getNodeType() != EntityType.USERGROUP_ENTITY.getEnumValue()) {
            return true;
        }
        GenericEntity genericEntity = (GenericEntity)beanAdapter.getBean();
        if (entity2.getNodeType().getNodeType() == EntityType.CLIENT_GROUP_ENTITY.getEnumValue()) {
            int n = genericEntity.getClientGroupId();
            if (entity2.getId() == n) {
                return true;
            }
        } else if (entity2.getNodeType().getNodeType() == EntityType.USERGROUP_ENTITY.getEnumValue()) {
            int n = genericEntity.getUserGroupId();
            if (entity2.getId() == n) {
                return true;
            }
        }
        return false;
    }

    private boolean hasRelation(Entity entity, GenericEntity genericEntity) {
        Entity entity2 = entity;
        Entity entity3 = entity2.getParentEntity();
        int n = 0;
        while (!((EntityImpl)entity3).getNodeName().equals("Root")) {
            if (entity2.getNodeType().getNodeType() == EntityType.CLIENT_GROUP_ENTITY.getEnumValue()) {
                n = entity2.getId();
            }
            entity2 = entity3;
            entity3 = entity3.getParentEntity();
        }
        return genericEntity.getClientGroupId() != 0 && entity2.getNodeType().getNodeType() == EntityType.ALL_CLIENT_GROUPS_ENTITY.getEnumValue() && (genericEntity.getClientGroupId() == n || n == 0) || genericEntity.getUserGroupId() != 0 && entity2.getNodeType().getNodeType() == EntityType.USERGROUPS_ENTITY.getEnumValue() || genericEntity.getClientGroupId() == 0 && entity2.getNodeType().getNodeType() != EntityType.ALL_CLIENT_GROUPS_ENTITY.getEnumValue() && genericEntity.getUserGroupId() == 0 && entity2.getNodeType().getNodeType() != EntityType.USERGROUPS_ENTITY.getEnumValue();
    }

    public List<GenericEntity> getExcludedChild(Entity entity) {
        List<GenericEntity> list = this.getEntityContext().getExcludedEntities();
        ArrayList<GenericEntity> arrayList = new ArrayList<GenericEntity>();
        NodeType nodeType = entity.getNodeType();
        String string = nodeType.getIdDef();
        String string2 = nodeType.getNodeName();
        for (GenericEntity genericEntity : list) {
            boolean bl;
            if (!this.hasRelation(entity, genericEntity)) continue;
            BeanAdapter beanAdapter = new BeanAdapter((Object)genericEntity);
            if (string == null || string2 == null) continue;
            Object object = beanAdapter.getValue(string);
            Object object2 = beanAdapter.getValue(string2);
            if (object == null || object2 == null || !(entity instanceof EntityImpl) || !(bl = (bl = object.equals(entity.getId())) && genericEntity.get_type_().getEnumValue() != entity.getNodeType().getNodeType())) continue;
            if (entity.getNodeType().getNodeType() == EntityType.APPTYPE_ENTITY.getEnumValue()) {
                if (!genericEntity.getClientName().equals(((EntityImpl)entity.getParentEntity()).getNodeName())) continue;
                arrayList.add(genericEntity);
                continue;
            }
            arrayList.add(genericEntity);
        }
        return arrayList;
    }

    @Override
    protected void reconstructSelectedIndex() {
        this.selectedChildIndex = new ArrayList();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            TreeNode treeNode = this.getChildAt(i);
            if (treeNode instanceof MultiStateTreeNode) {
                if (!((MultiStateTreeNode)treeNode).isNodeSelectionState()) continue;
                this.selectedChildIndex.add(i);
                continue;
            }
            if (!(treeNode instanceof CommNetBrowseBaseNode) || ((CommNetBrowseBaseNode)treeNode).getTriState() != 1 && ((CommNetBrowseBaseNode)treeNode).getTriState() != 2) continue;
            this.selectedChildIndex.add(i);
        }
    }

    public void setChildSelectionCount(int n) {
        this.childSelectionCount = n;
    }

    public int getChildSelectionCount() {
        return this.childSelectionCount;
    }
}

