/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.tooolbar;

import commvault.cte.component.tooolbar.CustomizedToolbar;
import commvault.cte.component.tooolbar.MacToolbarSeparatorUI;
import commvault.cte.component.tooolbar.MockComponent;
import commvault.cte.component.tooolbar.MockComponentTransferable;
import commvault.cte.component.tooolbar.MockDefaultToolbar;
import commvault.cte.component.tooolbar.SpaceComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

class CustomizedToolbarOptions
extends JPanel {
    private static final boolean isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    private static final long serialVersionUID = 1L;
    MockComponent[] componentList;
    JPanel componentPanel = new JPanel(new GridBagLayout());
    CustomizedToolbar toolbar;
    JButton done = new JButton("Done");
    private static DragSource dragSource = DragSource.getDefaultDragSource();
    private DragSourceListener dragSourceListener = new DragSourceAdapter(){

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            CustomizedToolbarOptions.this.toolbar.endDrag(dragSourceDropEvent);
        }
    };
    DragGestureListener dragGestureListener = new DragGestureListener(){

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Point point = dragGestureEvent.getDragOrigin();
            MockComponent mockComponent = (MockComponent)dragGestureEvent.getComponent();
            MockComponentTransferable mockComponentTransferable = new MockComponentTransferable(mockComponent);
            BufferedImage bufferedImage = mockComponent.getBufferedImage();
            CustomizedToolbarOptions.this.toolbar.draggingComponent = mockComponent instanceof MockDefaultToolbar ? "" : (mockComponent.getName().equals("-") ? CustomizedToolbarOptions.this.toolbar.getNewSeparatorName() : (mockComponent.getName().equals(" ") ? CustomizedToolbarOptions.this.toolbar.getNewSpaceName() : (mockComponent.getName().equals("\t") ? CustomizedToolbarOptions.this.toolbar.getNewFlexibleSpaceName() : mockComponent.getName())));
            CustomizedToolbarOptions.this.toolbar.draggingDefaults = mockComponent instanceof MockDefaultToolbar;
            CustomizedToolbarOptions.this.toolbar.draggingFromToolbar = false;
            dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, bufferedImage, new Point(-point.x, -point.y), mockComponentTransferable, CustomizedToolbarOptions.this.dragSourceListener);
        }
    };
    JLabel label1 = new JLabel("Drag your favorite items into the toolbar\u2026");
    JLabel label2 = new JLabel("\u2026 or drag the default set into the toolbar.");

    public CustomizedToolbarOptions(CustomizedToolbar customizedToolbar, int n) {
        JComponent jComponent;
        this.toolbar = customizedToolbar;
        JComponent[] jComponentArray = customizedToolbar.getPossibleComponents();
        this.componentList = new MockComponent[jComponentArray.length + 3];
        for (int i = 0; i < jComponentArray.length; ++i) {
            this.componentList[i] = new MockComponent(jComponentArray[i]);
        }
        JSeparator jSeparator = new JSeparator(1);
        jSeparator.setUI(new MacToolbarSeparatorUI());
        jSeparator.setName("-");
        Dimension dimension = jSeparator.getPreferredSize();
        dimension.height = this.toolbar.minimumHeight;
        jSeparator.setSize(dimension);
        jSeparator.setPreferredSize(dimension);
        this.componentList[this.componentList.length - 3] = new MockComponent(jSeparator);
        SpaceComponent spaceComponent = new SpaceComponent(this.toolbar, false);
        spaceComponent.setName(" ");
        this.componentList[this.componentList.length - 2] = new MockComponent(spaceComponent);
        SpaceComponent spaceComponent2 = new SpaceComponent(this.toolbar, true);
        spaceComponent2.setName("\t");
        this.componentList[this.componentList.length - 1] = new MockComponent(spaceComponent2);
        for (int i = 0; i < this.componentList.length; ++i) {
            dragSource.createDefaultDragGestureRecognizer(this.componentList[i], 2, this.dragGestureListener);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 0;
        block2: while (n2 < this.componentList.length) {
            Dimension dimension2;
            jComponent = new JPanel(new GridBagLayout());
            gridBagConstraints.gridy = this.componentPanel.getComponentCount();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.componentPanel.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            for (int i = 0; i < n && n2 < this.componentList.length; i += dimension2.width + gridBagConstraints.insets.left + gridBagConstraints.insets.right, ++n2) {
                dimension2 = this.componentList[n2].getPreferredSize();
                if (dimension2.width + 6 > n) continue block2;
                jComponent.add((Component)this.componentList[n2], gridBagConstraints);
                ++gridBagConstraints.gridx;
            }
        }
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)new Shadow(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 20, 15, 20);
        this.add((Component)this.label1, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 20, 20, 20);
        this.add((Component)this.componentPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 20, 5, 20);
        this.add((Component)this.label2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 20, 10, 20);
        jComponent = new MockDefaultToolbar(this.toolbar);
        this.add((Component)jComponent, gridBagConstraints);
        dragSource.createDefaultDragGestureRecognizer(jComponent, 2, this.dragGestureListener);
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        this.add((Component)this.done, gridBagConstraints);
        this.label1.setFont(this.label1.getFont().deriveFont(1));
        this.label2.setFont(this.label2.getFont().deriveFont(1));
        this.setOpaque(true);
        CustomizedToolbarOptions.setBackground(this, Color.white);
    }

    private static void setBackground(Component component, Color color) {
        component.setBackground(color);
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                CustomizedToolbarOptions.setBackground(container.getComponent(i), color);
            }
        }
    }

    class Shadow
    extends JComponent {
        public Shadow() {
            this.setPreferredSize(new Dimension(5, 10));
            this.setMinimumSize(new Dimension(5, 10));
            this.setOpaque(false);
        }

        protected boolean isDark() {
            if (!isMac) {
                return false;
            }
            for (Window window = SwingUtilities.getWindowAncestor(this); window != null; window = window.getOwner()) {
                if (!(window instanceof RootPaneContainer)) continue;
                JRootPane jRootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                Object object = jRootPane.getClientProperty("apple.awt.brushMetalLook");
                if (object == null) {
                    object = Boolean.FALSE;
                }
                if (!object.toString().equals("true")) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            boolean bl = this.isDark();
            for (int i = 0; i < this.getHeight(); ++i) {
                float f = bl ? (float)(this.getHeight() - i - 1) / (float)this.getHeight() * 0.35f : (float)(this.getHeight() - i - 1) / (float)this.getHeight() * 0.15f;
                Color color = new Color(0.0f, 0.0f, 0.0f, f);
                graphics.setColor(color);
                graphics.drawLine(0, i, this.getWidth(), i);
            }
        }
    }
}

