/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table.filter;

import com.jidesoft.filter.AbstractFilter;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.FilterFactory;
import com.jidesoft.filter.FilterFactoryManager;
import com.jidesoft.filter.NotFilter;
import com.jidesoft.filter.WildcardFilter;
import commvault.cte.component.table.filter.FilterColumnType;
import commvault.cte.component.table.filter.IFilterColumnType;
import java.lang.reflect.Constructor;
import java.util.Locale;

public class FilterUtils {
    public static void customizeFilterFactories(Class clazz, FilterFactoryManager filterFactoryManager) {
        if (!FilterUtils.isComparableFilterFactoriesApplicable(clazz)) {
            FilterUtils.unregisterComparableFilterFactories(clazz, filterFactoryManager);
        }
        if (FilterUtils.isStringFilterFactoriesApplicable(clazz)) {
            FilterUtils.registerStringFilterFactories(clazz, filterFactoryManager);
            FilterUtils.registerStringFilterFactories(clazz, FilterFactoryManager.getDefaultInstance());
        }
    }

    public static void unregisterComparableFilterFactories(Class clazz, FilterFactoryManager filterFactoryManager) {
        for (FilterFactory filterFactory : filterFactoryManager.getFilterFactories(clazz)) {
            if (!filterFactory.getName().equals("between") && !filterFactory.getName().equals("greater") && !filterFactory.getName().equals("less") && !filterFactory.getName().equals("lessOrEqual") && !filterFactory.getName().equals("not.between") && !filterFactory.getName().equals("greaterOrEqual")) continue;
            filterFactoryManager.unregisterFilterFactory(clazz, filterFactory);
        }
    }

    public static void registerStringFilterFactories(final Class clazz, FilterFactoryManager filterFactoryManager) {
        filterFactoryManager.registerFilterFactory(clazz, new FilterFactory(){

            public Filter createFilter(Object ... objectArray) {
                WildcardFilter wildcardFilter = new WildcardFilter(objectArray[0].toString());
                wildcardFilter.setBeginWith(false);
                wildcardFilter.setEndWith(false);
                return wildcardFilter;
            }

            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            public String getName() {
                return "contain";
            }

            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString((Locale)locale, (String)"string", (String)this.getName());
            }
        });
        filterFactoryManager.registerFilterFactory(clazz, new FilterFactory(){

            public Filter createFilter(Object ... objectArray) {
                WildcardFilter wildcardFilter = new WildcardFilter(objectArray[0].toString());
                wildcardFilter.setBeginWith(false);
                wildcardFilter.setEndWith(false);
                return new NotFilter((Filter)wildcardFilter);
            }

            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            public String getName() {
                return "not.contain";
            }

            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString((Locale)locale, (String)"string", (String)this.getName());
            }
        });
        filterFactoryManager.registerFilterFactory(clazz, new FilterFactory(){

            public Filter createFilter(Object ... objectArray) {
                WildcardFilter wildcardFilter = new WildcardFilter(objectArray[0].toString());
                wildcardFilter.setBeginWith(true);
                wildcardFilter.setEndWith(false);
                return wildcardFilter;
            }

            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            public String getName() {
                return "beginWith";
            }

            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString((Locale)locale, (String)"string", (String)this.getName());
            }
        });
        filterFactoryManager.registerFilterFactory(clazz, new FilterFactory(){

            public Filter createFilter(Object ... objectArray) {
                WildcardFilter wildcardFilter = new WildcardFilter(objectArray[0].toString());
                wildcardFilter.setBeginWith(false);
                wildcardFilter.setEndWith(true);
                return wildcardFilter;
            }

            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            public String getName() {
                return "endWith";
            }

            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString((Locale)locale, (String)"string", (String)this.getName());
            }
        });
    }

    public static boolean isCustomPossibleValuesApplicable(Class<?> clazz) {
        return FilterColumnType.class.isAssignableFrom(clazz) || IFilterColumnType.class.isAssignableFrom(clazz);
    }

    public static boolean isComparableFilterFactoriesApplicable(Class<?> clazz) {
        return false;
    }

    private static boolean isStringFilterFactoriesApplicable(Class clazz) {
        switch (clazz.getSimpleName()) {
            case "ClientGroupType": 
            case "SchedulePolicyAgentType": 
            case "JobOperationType": 
            case "BackupLevelType": 
            case "StoragePolicyType": 
            case "UserType": 
            case "JobInitiationType": 
            case "JobPhaseType": 
            case "MediaAgentType": 
            case "JobStatusType": 
            case "ClientType": 
            case "IdNameItem": 
            case "AgentType": 
            case "LongIdNameItem": {
                return true;
            }
        }
        return false;
    }

    public static Object getValidValueForCustomClass(Class clazz, Object object) {
        try {
            Class<?> clazz2 = Class.forName(clazz.getName());
            Constructor<?> constructor = clazz2.getConstructor(String.class);
            Object obj = constructor.newInstance(object);
            return obj;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

