/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table.decorator;

import commvault.cte.CteStringBank;
import commvault.cte.component.table.filter.FilterColumnType;
import java.text.NumberFormat;

public final class ProgressValue
extends FilterColumnType<ProgressValue> {
    private static final long serialVersionUID = 1L;
    Double value = 0.0;
    private boolean isDouble = false;
    private boolean valueNotApplicable = false;
    protected static final int CALCULATING = -999;
    NumberFormat formatter = NumberFormat.getInstance();

    public ProgressValue() {
    }

    public ProgressValue(boolean bl) {
        this.valueNotApplicable = bl;
    }

    public ProgressValue(int n) {
        this.value = n;
    }

    public ProgressValue(double d) {
        this.value = d;
        this.isDouble = true;
    }

    public int getIntValue() {
        return this.value.intValue();
    }

    public Double getDoubleValue() {
        return this.value;
    }

    public boolean isNotApplicable() {
        return this.valueNotApplicable;
    }

    @Override
    public String toString() {
        if (this.valueNotApplicable) {
            return CteStringBank.N_SLASH_A.getI18n();
        }
        if (this.getIntValue() == -999) {
            return CteStringBank.CALCULATING.getI18n();
        }
        if (!this.isDouble) {
            char[] cArray = new char[]{'0', '0', '0'};
            String string = String.valueOf(this.getIntValue());
            for (int i = 0; i < string.length(); ++i) {
                cArray[3 - string.length() + i] = string.charAt(i);
            }
            return new String(cArray);
        }
        this.formatter.setMaximumFractionDigits(2);
        return this.formatter.format(this.value);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProgressValue)) {
            return false;
        }
        ProgressValue progressValue = (ProgressValue)object;
        return this.value.equals(progressValue.value);
    }

    @Override
    public int hashCode() {
        return this.value.intValue();
    }

    public boolean isDouble() {
        return this.isDouble;
    }

    @Override
    public int compareTo(ProgressValue progressValue) {
        if (this.value - progressValue.value < 0.0) {
            return -1;
        }
        if (this.value - progressValue.value > 0.0) {
            return 1;
        }
        return 0;
    }
}

