/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table;

import com.jidesoft.action.CommandBar;
import com.jidesoft.combobox.ListChooserPanel;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.Filter;
import com.jidesoft.grid.AbstractTableFilter;
import com.jidesoft.grid.AutoFilterBox;
import com.jidesoft.grid.AutoFilterTableHeader;
import com.jidesoft.grid.AutoFilterTableHeaderEditor;
import com.jidesoft.grid.DefaultGroupRow;
import com.jidesoft.grid.DefaultGroupTableModel;
import com.jidesoft.grid.FilterableTreeTableModel;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.RowStripeTableStyleProvider;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableColumnChooser;
import com.jidesoft.grid.TableHeaderPopupMenuInstaller;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableStyleProvider;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.grid.TreeTableUtils;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableBar;
import com.jidesoft.swing.SearchableProvider;
import com.jidesoft.swing.TableSearchable;
import com.jidesoft.swing.event.SearchableListener;
import commvault.cte.CteStringBank;
import commvault.cte.common.ActionType;
import commvault.cte.common.DesktopBrowserLauncher;
import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.component.CVJScrollpane;
import commvault.cte.component.CVJViewPort;
import commvault.cte.component.StickyButton;
import commvault.cte.component.events.CTEAction;
import commvault.cte.component.table.ActionButtonFactory;
import commvault.cte.component.table.CVTreeTableModel;
import commvault.cte.component.table.DateNameItemCommonComparartor;
import commvault.cte.component.table.FindAnimatedImage;
import commvault.cte.component.table.ITableEventHandler;
import commvault.cte.component.table.IdNameItemCommonNameComparartor;
import commvault.cte.component.table.MyPopupMenu;
import commvault.cte.component.table.NTableHeaderPopupMenuInstaller;
import commvault.cte.component.table.NTableSetting;
import commvault.cte.component.table.PagedDataLoader;
import commvault.cte.component.table.ParagraphText;
import commvault.cte.component.table.ShowPopupInterface;
import commvault.cte.component.table.StringCommonComparartor;
import commvault.cte.component.table.TableUtils;
import commvault.cte.component.table.link.LinkAction;
import commvault.cte.component.table.link.LinkController;
import commvault.cte.component.table.link.LinkModel;
import commvault.cte.component.table.link.LinkRenderer;
import commvault.cte.component.table.link.LinkVisitor;
import commvault.cte.net.DateNameItem;
import commvault.cte.net.IdNameItem;
import commvault.cte.net.NamedObject;
import commvault.cte.util.Application;
import commvault.cte.util.Logger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PrinterException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.RolloverProducer;

public class TreeTablePanel
extends JPanel
implements TableModelListener,
AdjustmentListener,
ActionButtonFactory.ActionButtonActionListener {
    private static Hashtable<Integer, TablePreference> preferences = new Hashtable();
    private boolean allowCustomFilter = true;
    public static final String TABLE_PARENT = "table.parent";
    public static final int TABLE_DATA_CHANGED_ONLY = -1000;
    protected TreeTable table;
    private JCheckBox showMatchedOnly = new JCheckBox(CteStringBank.Show_Matched_Only.getI18n());
    private JCheckBox wholeWord = new JCheckBox(CteStringBank.Whole_Word.getI18n());
    private AbstractButton createMatchCaseButton;
    private JideButton btnColumnChooser = new JideButton((Icon)Application.instance().getIconSource().getIcon("buttonColumnChooser"));
    NTableHeaderPopupMenuInstaller installer;
    private CVJScrollpane scroll;
    protected CVJScrollpane scrollPane;
    protected TableModel _model;
    private TableToolbar toolBarPanel = new TableToolbar();
    private JMenuItem filterMenu;
    private boolean disableUnselectedPopup;
    private Set<String> rightJustifiedColumnNames = new HashSet<String>();
    protected boolean bClearSelection = false;
    private boolean shiftSelectedEnabled;
    private boolean isSortOnTableChanged;
    private CVJViewPort viewPort;
    protected MyPopupMenu popup;
    protected Vector<JMenuItem> menuItems = new Vector();
    protected ShowPopupInterface showPopupInterface;
    private boolean groupingEnabled;
    private boolean enableCellTooltip;
    private boolean paragraphInTooltip;
    private ParagraphText paragraphTextSource;
    private ActionButtonFactory buttonFactory;
    private Map<ActionType, Action> actionMap = new HashMap<ActionType, Action>();
    private PopupAdapter popupAdapter;
    private int[] preSelectedRows;
    private LinkRenderer linkRenderer;
    private LinkVisitor linkVisitor;
    private JLabel paragraphRende = new JLabel();
    private int oldAutoResizeMode;
    private SearchableBar _searchableBar;
    public CVTreeTableModel treeTableModel;
    public FilterableTreeTableModel filterTreeModel;
    private Integer tableKey;
    private boolean updateParagraphView = true;
    boolean searchOpen = false;
    private TablePreference pref;
    private PagedDataLoader pageLoader = null;
    private FindAnimatedImage glassPane;
    private boolean adjustingRowHeight;
    private DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
    private boolean groupSupported = true;

    public TreeTablePanel(CVTreeTableModel cVTreeTableModel) {
        super(new BorderLayout());
        this.buttonFactory = new ActionButtonFactory(this, this);
        this.setBackground(Color.WHITE);
        this.initObjectConverter();
        this.showMatchedOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeTablePanel.this.applyFilterFromSearch();
            }
        });
        this.table = new TreeTable((TableModel)this.createModel((TableModel)((Object)cVTreeTableModel)));
        final Action action = this.table.getActionMap().get("copy");
        this.table.getActionMap().put("copy", new CTEAction("copy"){

            @Override
            public void actionPerformed(final ActionEvent actionEvent) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        action.actionPerformed(actionEvent);
                        return null;
                    }
                });
            }
        });
        System.out.println("here");
        this.table.setShowGrid(false);
        this.table.putClientProperty((Object)TABLE_PARENT, (Object)this);
        this.table.setSelectionMode(0);
        this.table.setCellRendererManagerEnabled(true);
        this.table.setCellEditorManagerEnabled(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionBackground(new Color(161, 174, 255));
        this.table.setBackground(Color.WHITE);
        this.table.setRowHeight(18);
        this.table.setOptimized(true);
        this.table.setSortable(true);
        this.table.setTableStyleProvider((TableStyleProvider)new RowStripeTableStyleProvider(new Color[]{Color.WHITE, new Color(231, 231, 231)}));
        InputMap inputMap = this.table.getInputMap(1);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeTablePanel.this.dispatchEvent(new MouseEvent(TreeTablePanel.this, 500, 0L, 16, 0, 0, 2, false));
                TreeTablePanel.this.dispatchEvent(new MouseEvent(TreeTablePanel.this, 502, 0L, 16, 0, 0, 2, false));
            }
        };
        this.table.getActionMap().remove("selectNextRowCell");
        this.table.getActionMap().put("doubleClick", abstractAction);
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "doubleClick");
        this.scrollPane = this.scroll = new CVJScrollpane((JTable)this.table, 22, 30);
        this.scroll.setBackground(Color.WHITE);
        this.viewPort = this.scrollPane.getCVJViewPort();
        this.popupAdapter = new PopupAdapter();
        this.addMouseListener(this.popupAdapter);
        this.scroll.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && TreeTablePanel.this.popup != null) {
                    TreeTablePanel.this.popupAction1(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && TreeTablePanel.this.popup != null) {
                    TreeTablePanel.this.popupAction1(mouseEvent);
                }
            }
        });
        this.table.addMouseListener((MouseListener)this.popupAdapter);
        this.makeFilterable();
        this.installChooser();
        this.add((Component)((Object)this.toolBarPanel), "North");
        this.toolBarPanel.setVisible(false);
        this.add((Component)((Object)this.scroll));
        this.initDefLinkVisitor();
        this.linkRenderer = new LinkRenderer(new LinkAction<LinkModel>(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TreeTablePanel.this.linkVisitor != null) {
                    TreeTablePanel.this.linkVisitor.visitLink((LinkModel)this.getTarget());
                }
            }
        });
        this.table.setDefaultRenderer(LinkModel.class, (TableCellRenderer)this.linkRenderer);
        this.table.setDefaultEditor(LinkModel.class, (TableCellEditor)this.linkRenderer);
        RolloverProducer rolloverProducer = this.createRolloverProducer();
        this.table.addMouseListener((MouseListener)rolloverProducer);
        this.table.addMouseMotionListener((MouseMotionListener)rolloverProducer);
        new LinkController().install((JTable)this.table);
        this.table.setColumnResizable(true);
        cVTreeTableModel.addTableModelListener(this);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (TreeTablePanel.this.showPopupInterface != null) {
                    TreeTablePanel.this.showPopupInterface.tableRowSelect();
                }
            }
        });
        this.table.getTableHeader().setReorderingAllowed(true);
        this.table.getTableHeader().setResizingAllowed(true);
        this.table.setDefaultRenderer(Date.class, (TableCellRenderer)new DateRenderer());
        this.installSearchable();
        this.table.setColumnAutoResizable(true);
        TableSearchable tableSearchable = new TableSearchable((JTable)this.table){
            {
                this.setSearchableProvider(this.createSearchProvider());
            }

            private SearchableProvider createSearchProvider() {
                return new SearchableProvider(){
                    StringBuffer buf = new StringBuffer();
                    long lastKeyTime = 0L;
                    Timer timer = new Timer(500, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            buf.setLength(0);
                        }
                    });

                    public boolean isPassive() {
                        return true;
                    }

                    public String getSearchingText() {
                        return this.buf.toString();
                    }

                    public void processKeyEvent(KeyEvent keyEvent) {
                        if (keyEvent.getID() != 400) {
                            return;
                        }
                        this.timer.stop();
                        this.timer.start();
                        this.buf.append(keyEvent.getKeyChar());
                        int n = this.findNext(this.getSearchingText());
                        this.setSelectedIndex(n, true);
                    }
                };
            }
        };
        tableSearchable.setRepeats(true);
        tableSearchable.setMainIndex(-1);
        this.setParagraphSupoorted(false);
    }

    private FilterableTreeTableModel createModel(TableModel tableModel) {
        this.filterTreeModel = new FilterableTreeTableModel(tableModel){

            public Row getRowAt(int n) {
                return TreeTablePanel.this.treeTableModel.getRowAt(TreeTablePanel.this.getUnsortedRow(n));
            }
        };
        this.treeTableModel = (CVTreeTableModel)((Object)tableModel);
        this.showMatchedOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeTablePanel.this.filterTreeModel.setFiltersApplied(TreeTablePanel.this.showMatchedOnly.isSelected());
                TreeTablePanel.this.filterTreeModel.refresh();
            }
        });
        return this.filterTreeModel;
    }

    public void fitToData() {
        this.setHorizontalScrollEnabled(true);
        com.jidesoft.grid.TableUtils.autoResizeAllColumns((JTable)this.table, (boolean)true);
    }

    private void installSearchable() {
        if (this.table.getColumnCount() <= 0) {
            return;
        }
        final MyTableSearchable myTableSearchable = new MyTableSearchable(this.table);
        myTableSearchable.setMainIndex(-1);
        this._searchableBar = new SearchableBar((Searchable)myTableSearchable){

            protected void select(int n, String string, boolean bl) {
                try {
                    if (TreeTablePanel.this.searchOpen) {
                        super.select(n, string, bl);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public String getSearchingText() {
                if (!TreeTablePanel.this.searchOpen) {
                    return super.getSearchingText();
                }
                String string = super.getSearchingText();
                if (!TreeTablePanel.this.wholeWord.isSelected()) {
                    string = "*" + super.getSearchingText() + "*";
                }
                if (TreeTablePanel.this.showMatchedOnly.isSelected()) {
                    SearchableListener[] searchableListenerArray;
                    TreeTablePanel.this.filterTreeModel.clearFilters();
                    final String string2 = string;
                    TreeTablePanel.this.filterTreeModel.addFilter((Filter)new AbstractTableFilter<Object>(){

                        public boolean isValueFiltered(Object object) {
                            return !myTableSearchable.compare(object, string2);
                        }
                    });
                    for (SearchableListener searchableListener : searchableListenerArray = myTableSearchable.getSearchableListeners()) {
                        myTableSearchable.removeSearchableListener(searchableListener);
                    }
                    TreeTablePanel.this.filterTreeModel.refresh();
                    for (SearchableListener searchableListener : searchableListenerArray) {
                        myTableSearchable.addSearchableListener(searchableListener);
                    }
                    return null;
                }
                return string;
            }

            public boolean isPassive() {
                if (!TreeTablePanel.this.searchOpen) {
                    return super.isPassive();
                }
                return !TreeTablePanel.this.showMatchedOnly.isSelected();
            }

            protected AbstractButton createMatchCaseButton() {
                ItemListener[] itemListenerArray;
                TreeTablePanel.this.createMatchCaseButton = super.createMatchCaseButton();
                for (ItemListener itemListener : itemListenerArray = TreeTablePanel.this.createMatchCaseButton.getItemListeners()) {
                    TreeTablePanel.this.createMatchCaseButton.removeItemListener(itemListener);
                }
                for (ItemListener itemListener : itemListenerArray) {
                    TreeTablePanel.this.createMatchCaseButton.addItemListener(itemListener);
                }
                return TreeTablePanel.this.createMatchCaseButton;
            }
        };
        this._searchableBar.setInstaller(new SearchableBar.Installer(){

            public void openSearchBar(SearchableBar searchableBar) {
                TreeTablePanel treeTablePanel = TreeTablePanel.this;
                treeTablePanel.add((Component)searchableBar, "Last");
                treeTablePanel.invalidate();
                treeTablePanel.revalidate();
                TreeTablePanel.this.searchOpen = true;
            }

            public void closeSearchBar(SearchableBar searchableBar) {
                TreeTablePanel treeTablePanel = TreeTablePanel.this;
                treeTablePanel.remove((Component)searchableBar);
                treeTablePanel.invalidate();
                treeTablePanel.revalidate();
                JTable jTable = TreeTablePanel.this.getTable();
                if (jTable != null) {
                    jTable.grabFocus();
                }
            }
        });
        ((JComponent)myTableSearchable.getComponent()).registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeTablePanel.this._searchableBar.getInstaller().openSearchBar(TreeTablePanel.this._searchableBar);
                TreeTablePanel.this._searchableBar.focusSearchField();
            }
        }, KeyStroke.getKeyStroke(70, 128), 1);
        this._searchableBar.setCompact(true);
        int n = this._searchableBar.getComponentCount() - 3;
        this._searchableBar.add((Component)this.wholeWord, n);
        this._searchableBar.add((Component)this.showMatchedOnly, n++);
        this._searchableBar.getSearchingText();
        this.showMatchedOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeTablePanel.this.filterTreeModel.setFiltersApplied(TreeTablePanel.this.showMatchedOnly.isSelected());
                TreeTablePanel.this.filterTreeModel.refresh();
                TreeTablePanel.this._searchableBar.getSearchingText();
            }
        });
        this.tableKey = TableUtils.createTableId((TableModel)((Object)this.treeTableModel));
        TablePreference tablePreference = preferences.get(this.tableKey);
        if (tablePreference != null && tablePreference.isTableSearchPanelOpened()) {
            this.showMatchedOnly.setSelected(tablePreference.isFindShowMatched());
            this.wholeWord.setSelected(tablePreference.isFindMatchWholeWord());
            if (this.createMatchCaseButton != null) {
                this.createMatchCaseButton.setSelected(tablePreference.getFindMatchCase());
            }
            if (tablePreference.getTableSettings() != null) {
                com.jidesoft.grid.TableUtils.setTablePreferenceByName((JTable)this.table, (String)tablePreference.getTableSettings());
            }
            if (this.table instanceof SortableTable && tablePreference.getTableSortSettings() != null) {
                com.jidesoft.grid.TableUtils.setSortableTablePreference((SortableTable)this.table, (String)tablePreference.getTableSortSettings());
            }
            if (tablePreference.getFilterString() != null) {
                try {
                    this.applyFilter(tablePreference.getFilterString());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this._searchableBar.getInstaller().openSearchBar(this._searchableBar);
        } else {
            this.saveTablePreference();
        }
    }

    public FilterableTreeTableModel getFilterModel() {
        return this.filterTreeModel;
    }

    public boolean isSearchBarHasFocus() {
        if (this._searchableBar != null) {
            return this.componentHasFocus(this._searchableBar.getComponents());
        }
        return false;
    }

    private boolean componentHasFocus(Component[] componentArray) {
        for (Component component : componentArray) {
            if (component instanceof JTextField && component.hasFocus()) {
                return true;
            }
            if (!(component instanceof JPanel)) continue;
            return this.componentHasFocus(((JPanel)component).getComponents());
        }
        return false;
    }

    private void initDefLinkVisitor() {
        this.linkVisitor = new LinkVisitor(){

            @Override
            public void visitLink(LinkModel linkModel) {
                final String string = linkModel.getURL().toString();
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            DesktopBrowserLauncher.openURL(string);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    privilegedActionException.printStackTrace();
                }
            }
        };
    }

    public TableModel getModelObject() {
        return this.treeTableModel;
    }

    protected void linkAction(LinkModel linkModel) {
        if (linkModel.getURL() != null) {
            try {
                DesktopBrowserLauncher.openURL(linkModel.getURL().toString());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected RolloverProducer createRolloverProducer() {
        RolloverProducer rolloverProducer = new RolloverProducer(){

            protected void updateRolloverPoint(JComponent jComponent, Point point) {
                JTable jTable = (JTable)jComponent;
                int n = jTable.columnAtPoint(point);
                int n2 = jTable.rowAtPoint(point);
                if (n < 0 || n2 < 0) {
                    n2 = -1;
                    n = -1;
                }
                this.rollover.x = n;
                this.rollover.y = n2;
            }
        };
        return rolloverProducer;
    }

    public void setParagraphSupoorted(boolean bl) {
        this.buttonFactory.getActionMenuItem(ActionType.Paragraph).setVisible(bl);
    }

    public TreeTable getTreeTable() {
        return this.table;
    }

    private void installChooser() {
        NTableHeaderPopupMenuInstaller nTableHeaderPopupMenuInstaller = new NTableHeaderPopupMenuInstaller(this, this.buttonFactory);
        this.btnColumnChooser.setBorder(BorderFactory.createRaisedBevelBorder());
        this.btnColumnChooser.setOpaque(true);
        this.btnColumnChooser.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreeTablePanel.this.showHeaderPopup(mouseEvent.getModifiers());
            }
        });
        this.btnColumnChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeTablePanel.this.showHeaderPopup(0);
            }
        });
        this.installer = nTableHeaderPopupMenuInstaller;
        this.scroll.setCorner("UPPER_RIGHT_CORNER", (Component)this.btnColumnChooser);
    }

    public void setParagraphViewEnabled(boolean bl) {
        this.buttonFactory.getActionMenuItem(ActionType.Paragraph).setEnabled(bl);
    }

    public void setHorizontalScrollEnabled(boolean bl) {
        if (bl == this.isHorizontalScrollEnabled()) {
            return;
        }
        if (bl) {
            this.oldAutoResizeMode = this.table.getAutoResizeMode();
            this.setAutoResizeMode(0);
        } else {
            this.setAutoResizeMode(this.oldAutoResizeMode);
        }
    }

    public boolean isHorizontalScrollEnabled() {
        return this.table.getAutoResizeMode() == 0;
    }

    protected JMenuItem getFilterMenu() {
        if (this.filterMenu == null) {
            this.filterMenu = new JCheckBoxMenuItem(CteStringBank.No_grouping.getI18n(), false);
            this.filterMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreeTablePanel.this.setAutoFilter(TreeTablePanel.this.filterMenu.isSelected());
                }
            });
        }
        return this.filterMenu;
    }

    public void setAutoFilter(boolean bl) {
        AutoFilterTableHeader autoFilterTableHeader = (AutoFilterTableHeader)this.table.getTableHeader();
        IFilterableTableModel iFilterableTableModel = autoFilterTableHeader.getFilterableTableModel();
        if (iFilterableTableModel != null) {
            iFilterableTableModel.clearFilters();
            iFilterableTableModel.refresh();
        }
        autoFilterTableHeader.setAutoFilterEnabled(bl);
    }

    private void showHeaderPopup(int n) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        Rectangle rectangle = jTableHeader.getVisibleRect();
        int n2 = rectangle.x + rectangle.width + this.btnColumnChooser.getWidth();
        MouseEvent mouseEvent = new MouseEvent(this.table.getTableHeader(), 0, System.currentTimeMillis(), n, n2, this.btnColumnChooser.getHeight(), 1, true);
        this.installer.mousePressed(mouseEvent);
        mouseEvent.consume();
    }

    private void makeFilterable() {
        AutoFilterTableHeader autoFilterTableHeader = this.createFilterableHeader();
        autoFilterTableHeader.setShowFilterName(true);
        autoFilterTableHeader.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    TreeTablePanel.this.showHeaderPopup(mouseEvent.getModifiers());
                }
            }
        });
        this.table.setTableHeader((JTableHeader)autoFilterTableHeader);
        if (this.table.getParent() != null) {
            ((JScrollPane)this.table.getParent().getParent()).setColumnHeaderView((Component)autoFilterTableHeader);
        }
    }

    protected AutoFilterTableHeader createFilterableHeader() {
        return new AutoFilterTableHeader((JTable)this.table){

            protected TableCellEditor createDefaultEditor() {
                if (this.isAutoFilterEnabled()) {
                    return new AutoFilterTableHeaderEditor(){

                        protected AutoFilterBox createAutoFilterBox() {
                            return new AutoFilterBox(){

                                public boolean isAllowCustomFilter() {
                                    return TreeTablePanel.this.allowCustomFilter;
                                }

                                protected PopupPanel createPopupPanel(TableModel tableModel, int n, Object[] objectArray) {
                                    PopupPanel popupPanel = super.createPopupPanel(tableModel, n, objectArray);
                                    if (!TreeTablePanel.this.allowCustomFilter) {
                                        return popupPanel;
                                    }
                                    if (popupPanel instanceof ListChooserPanel) {
                                        ListChooserPanel listChooserPanel = (ListChooserPanel)popupPanel;
                                        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)listChooserPanel.getList().getModel();
                                        if (tableModel.getColumnClass(n) == Object.class || tableModel.getColumnClass(n) == Date.class) {
                                            defaultComboBoxModel.removeElementAt(1);
                                        }
                                    }
                                    return popupPanel;
                                }
                            };
                        }
                    };
                }
                return null;
            }
        };
    }

    public JTable getActualTable() {
        return this.table;
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public JScrollPane getScroller() {
        return this.scroll;
    }

    private void initObjectConverter() {
        ObjectConverterManager.initDefaultConverter();
        ObjectConverterManager.registerConverter(DefaultGroupRow.class, (ObjectConverter)new ObjectConverter(){

            public String toString(Object object, ConverterContext converterContext) {
                if (object instanceof DefaultGroupRow) {
                    int n;
                    DefaultGroupRow defaultGroupRow = (DefaultGroupRow)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    DefaultGroupTableModel defaultGroupTableModel = (DefaultGroupTableModel)defaultGroupRow.getTreeTableModel();
                    for (n = 0; n < defaultGroupRow.getNumberOfConditions(); ++n) {
                        stringBuffer.append(" ");
                        if (!defaultGroupTableModel.isSingleLevelGrouping() && n != defaultGroupRow.getNumberOfConditions() - 1) continue;
                        stringBuffer.append(defaultGroupTableModel.getActualModel().getColumnName(defaultGroupRow.getConditionColumn(n)));
                        stringBuffer.append(": ");
                        stringBuffer.append(defaultGroupRow.getConditionValue(n));
                    }
                    n = TreeTableUtils.getDescendantCount((TableModel)defaultGroupTableModel, (Row)defaultGroupRow, (boolean)false, (boolean)false);
                    stringBuffer.append(" (").append(n).append(" items)");
                    return stringBuffer.toString();
                }
                return null;
            }

            public boolean supportToString(Object object, ConverterContext converterContext) {
                return true;
            }

            public Object fromString(String string, ConverterContext converterContext) {
                return null;
            }

            public boolean supportFromString(String string, ConverterContext converterContext) {
                return false;
            }
        });
    }

    public void add(JMenuItem jMenuItem) {
        if (this.popup == null) {
            this.popup = new MyPopupMenu();
        }
        this.menuItems.addElement(jMenuItem);
        this.popup.add(jMenuItem);
    }

    public void add(JMenu jMenu) {
        if (this.popup == null) {
            this.popup = new MyPopupMenu();
        }
        this.menuItems.addElement(jMenu);
        this.popup.add(jMenu);
    }

    public void addJTableMouseListener(MouseListener mouseListener) {
        this.table.addMouseListener(mouseListener);
    }

    @Override
    public synchronized void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void addSeparator() {
        if (this.popup == null) {
            this.popup = new MyPopupMenu();
        }
        this.popup.addSeparator();
    }

    public void clearSelection() {
        this.table.clearSelection();
    }

    public void clearup() {
        if (this.table != null) {
            int n;
            MouseListener[] mouseListenerArray = this.table.getMouseListeners();
            for (int i = mouseListenerArray.length - 1; i >= 0; --i) {
                this.table.removeMouseListener(mouseListenerArray[i]);
            }
            MouseMotionListener[] mouseMotionListenerArray = this.table.getMouseMotionListeners();
            for (n = mouseMotionListenerArray.length - 1; n >= 0; --n) {
                this.table.removeMouseMotionListener(mouseMotionListenerArray[n]);
            }
            mouseListenerArray = this.getMouseListeners();
            for (n = mouseListenerArray.length - 1; n >= 0; --n) {
                this.removeMouseListener(mouseListenerArray[n]);
            }
            mouseMotionListenerArray = this.table.getMouseMotionListeners();
            for (n = mouseMotionListenerArray.length - 1; n >= 0; --n) {
                this.removeMouseMotionListener(mouseMotionListenerArray[n]);
            }
            TableModelListener[] tableModelListenerArray = this.treeTableModel.getTableModelListeners();
            for (int i = tableModelListenerArray.length - 1; i >= 0; --i) {
                this.treeTableModel.removeTableModelListener(tableModelListenerArray[i]);
            }
            this.table.removeAll();
            this.wholeWord = null;
            this.createMatchCaseButton = null;
            this.showMatchedOnly = null;
            this.table.setDefaultRenderer(Object.class, null);
            this.table.putClientProperty((Object)TABLE_PARENT, null);
            TableHeaderPopupMenuInstaller.getTableHeaderPopupMenuInstaller((JTable)this.table).uninstallListeners();
            this.installer.clearup();
            this.installer = null;
            this.treeTableModel = null;
            this.table = null;
            this.showPopupInterface = null;
            this.pageLoader = null;
        }
    }

    public void saveTablePreference() {
        this.pref = new TablePreference();
        this.pref.setFindMatchWholeWord(this.wholeWord.isSelected());
        if (this.createMatchCaseButton != null) {
            this.pref.setFindMatchCase(this.createMatchCaseButton.isSelected());
        }
        this.pref.setFindShowMatched(this.showMatchedOnly.isSelected());
        this.pref.setTableSettings(com.jidesoft.grid.TableUtils.getTablePreferenceByName((JTable)this.table));
        this.pref.setTableSortSettings(com.jidesoft.grid.TableUtils.getSortableTablePreference((SortableTable)this.table));
        if (this.table.getClientProperty((Object)TABLE_PARENT) != null) {
            this.table.getClientProperty((Object)TABLE_PARENT);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            this.pref.setTableGroupingColumns(arrayList);
        }
        this.pref.setTableSearchPanelOpened(this.searchOpen);
        try {
            this.pref.setFilterString(this.getFilterString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        preferences.put(this.tableKey, this.pref);
    }

    public void defaultPopupAction() {
        if (this.showPopupInterface != null) {
            this.showPopupInterface.defaultPopupAction();
        } else {
            this.popup.defaultAction();
        }
    }

    public void disableUnselectedPopup(boolean bl) {
        this.disableUnselectedPopup = bl;
    }

    public void enablePopupOnScrollPane() {
    }

    public void fireTableRowsUpdated() {
        if (this.treeTableModel instanceof AbstractTableModel) {
            CVTreeTableModel cVTreeTableModel = this.treeTableModel;
            ((AbstractTableModel)((Object)cVTreeTableModel)).fireTableRowsUpdated(0, this.table.getModel().getRowCount() - 1);
        }
        this.filterTreeModel.refresh();
    }

    public void fireTableDataChanged() {
        if (this.treeTableModel instanceof AbstractTableModel) {
            CVTreeTableModel cVTreeTableModel = this.treeTableModel;
            ((AbstractTableModel)((Object)cVTreeTableModel)).fireTableDataChanged();
        }
    }

    public CVJViewPort getCVJViewPort() {
        return this.viewPort;
    }

    public int getColumnCount() {
        return this.table.getColumnCount();
    }

    public boolean[] getColumnVisibitlity() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = TableColumnChooser.isVisibleColumn((TableColumnModel)tableColumnModel, (int)i);
        }
        return blArray;
    }

    public boolean[] getInit(int n) {
        return this.getColumnVisibitlity();
    }

    public TableModel getModel() {
        return this._model;
    }

    public TableModel getTopLevelModel() {
        return this.treeTableModel;
    }

    public int getRowAtPoint(Point point) {
        return this.table.rowAtPoint(point);
    }

    public CVJScrollpane getScrollPane() {
        return this.scroll;
    }

    public int getSelectedRowCount() {
        return this.table.getSelectedRowCount();
    }

    public int getSelectedRowIndexFromView() {
        return this.table.getActualRowAt(this.table.getSelectedRow());
    }

    public int[] getSelectedRowIndexesFromView() {
        return this.table.getSelectedRows();
    }

    public ListSelectionModel getSelectionModel() {
        return this.table.getSelectionModel();
    }

    public ShowPopupInterface getShowPopupInterface() {
        return this.showPopupInterface;
    }

    public boolean getSortAscending() {
        List list;
        Iterator iterator;
        if (this.table.isSortable() && (iterator = (list = ((ISortableTableModel)this.treeTableModel).getSortingColumns()).iterator()).hasNext()) {
            ISortableTableModel.SortItem sortItem = (ISortableTableModel.SortItem)iterator.next();
            return sortItem.isAscending();
        }
        return false;
    }

    public List<Integer> getSortingColumns() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.table.isSortable() && this.table.isSortingEnabled() && this.treeTableModel instanceof ISortableTableModel) {
            List list = ((ISortableTableModel)this.treeTableModel).getSortingColumns();
            for (ISortableTableModel.SortItem sortItem : list) {
                arrayList.add(sortItem.getColumn());
            }
        }
        return arrayList;
    }

    public JTable getTable() {
        return this.table;
    }

    public TableModel getTableModel() {
        return this.treeTableModel;
    }

    public NTableSetting getTableSettings(int n) {
        NTableSetting nTableSetting = new NTableSetting();
        nTableSetting.setInit(this.getInit(n));
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        TableColumnModel tableColumnModel = this.getTable().getColumnModel();
        TableColumn tableColumn = null;
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            tableColumn = tableColumnModel.getColumn(i);
            String string = tableColumn.getHeaderValue().toString();
            hashMap.put(string, new Integer(tableColumn.getWidth()));
        }
        nTableSetting.setMap(hashMap);
        return nTableSetting;
    }

    public int getUnsortedColumn(int n) {
        return this.table.convertColumnIndexToModel(n);
    }

    public int getUnsortedRow(int n) {
        return TableModelWrapperUtils.getActualRowAt((TableModel)this.table.getModel(), (int)n);
    }

    public int getUnsortedSelectedRow() {
        return TableModelWrapperUtils.getActualRowAt((TableModel)this.table.getModel(), (int)this.table.getSelectedRow());
    }

    public int[] getUnsortedSelectedRows() {
        int[] nArray = this.getSelectedRowIndexesFromView();
        int[] nArray2 = new int[nArray.length];
        for (int i = nArray.length - 1; i >= 0; --i) {
            nArray2[i] = TableModelWrapperUtils.getActualRowAt((TableModel)this.table.getModel(), (int)nArray[i]);
        }
        return nArray2;
    }

    public boolean isRowSelected(int n) {
        return this.table.isRowSelected(n);
    }

    public void markColumnRightJustified(String string) {
        this.rightJustifiedColumnNames.add(string);
    }

    private void popupAction1(MouseEvent mouseEvent) {
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        if (n >= 0 && !this.table.isRowSelected(n)) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
        }
        this.popupAction(mouseEvent);
    }

    public void popupAction(MouseEvent mouseEvent) {
        if (this.getUnsortedSelectedRow() < 0 && this.disableUnselectedPopup) {
            return;
        }
        if (this.showPopupInterface != null) {
            this.showPopupInterface.popupAction(mouseEvent);
        } else {
            if (this.popup.getComponentCount() == 0) {
                return;
            }
            this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void prePrintSetup() {
    }

    public void remove(JMenuItem jMenuItem) {
        if (this.popup == null) {
            return;
        }
        this.menuItems.removeElement(jMenuItem);
        this.popup.remove(jMenuItem);
    }

    public void setAutoResizeMode(int n) {
        this.table.setAutoResizeMode(n);
    }

    public void setCaseInsensitiveSort(boolean bl) {
    }

    public void setClearSelection(boolean bl) {
        this.bClearSelection = bl;
    }

    public void setColumnPreferredWidth(int n, int n2) {
        int n3 = this.table.convertColumnIndexToModel(n);
        if (n3 < this.table.getColumnModel().getColumnCount()) {
            this.table.getColumnModel().getColumn(n3).setPreferredWidth(n2);
        }
    }

    public void setColumnRenderer(String string, TableCellRenderer tableCellRenderer) {
        if (this.table.getColumn((Object)string) != null) {
            this.table.getColumn((Object)string).setCellRenderer(tableCellRenderer);
        }
    }

    public void setColumnWidth(String string, int n) {
        try {
            this.table.getColumn((Object)string).setPreferredWidth(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setColumnsVisibility(boolean[] blArray) {
        if (blArray == null) {
            return;
        }
        this.table.getColumnCount();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            arrayList.add(i);
        }
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            nArray[n++] = n2;
        }
        TableColumnChooser.showColumns((JTable)this.table, (int[])nArray);
    }

    public void setColumnsVisible(boolean bl, int ... nArray) {
        for (int n : nArray) {
            if (bl) {
                TableColumnChooser.showColumn((JTable)this.table, (int)n, (int)n);
                continue;
            }
            TableColumnChooser.hideColumn((JTable)this.table, (int)n);
        }
    }

    public void setDefaultItem(JMenuItem jMenuItem) {
        this.popup.setDefaultItem(jMenuItem);
    }

    public void setModel(TableModel tableModel) {
        this.setModel(tableModel, null);
    }

    public void setModel(TableModel tableModel, boolean[] blArray) {
        if (this._model != null) {
            this._model.removeTableModelListener(this);
        }
        if (this.treeTableModel != null) {
            this.treeTableModel.removeTableModelListener(this);
        }
        this.table.setModel((TableModel)this.createModel(tableModel));
        this.makeFilterable();
        this.setColumnsVisibility(blArray);
        this.treeTableModel.addTableModelListener(this);
        this.table.getTableHeader().setReorderingAllowed(true);
        this.table.getTableHeader().setResizingAllowed(true);
        this.installSearchable();
    }

    public void setNoItemsToDisplayStringOnViewport(String string) {
        this.scrollPane.setDisplayString(string);
    }

    public void setNumberOfRowsVisible(int n) {
        Dimension dimension = this.scroll.getPreferredSize();
        dimension.height = this.table.getRowHeight() * (n + 2);
        this.scroll.setPreferredSize(dimension);
    }

    public void setPopupEnabled(int n, boolean bl) {
        this.menuItems.elementAt(n).setEnabled(bl);
    }

    public void setPopupVisible(boolean bl) {
        this.popup.setVisible(bl);
    }

    public void setPopupVisible(Component component, int n, int n2) {
        if (this.popup.getComponentCount() == 0) {
            return;
        }
        this.popup.show(component, n, n2);
    }

    public void setRowSelectionInterval(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.table.getRowCount()) {
            n2 = this.table.getRowCount() - 1;
        }
        this.table.setRowSelectionInterval(n, n2);
    }

    public void setScrollTooltipEnable(boolean bl) {
        if (bl) {
            this.table.putClientProperty((Object)"tooltipRenderer", (Object)new DefaultScrollTooltipRenderer());
        } else {
            this.table.putClientProperty((Object)"tooltipRenderer", null);
        }
    }

    public void setSelectionMode(int n) {
        this.table.getSelectionModel().setSelectionMode(n);
    }

    public void setShiftSelectedEnabled(boolean bl) {
        this.shiftSelectedEnabled = bl;
    }

    public void setShowPopupInterface(ShowPopupInterface showPopupInterface) {
        this.showPopupInterface = showPopupInterface;
        this.popup = new MyPopupMenu();
    }

    public void setSortOnTableChange(boolean bl) {
        this.isSortOnTableChanged = bl;
    }

    public void setState(boolean bl) {
    }

    public void setTableTitle(String string) {
        this.toolBarPanel.setTitle(string);
    }

    public void setViewPort(JViewport jViewport) {
        this.scroll.setViewport(jViewport);
        this.scroll.repaint();
    }

    public void showAllColumnsWithoutScroll() {
        Serializable serializable;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            n += ((TableColumn)serializable).getPreferredWidth();
        }
        serializable = this.scroll.getPreferredSize();
        ((Dimension)serializable).width = n;
        this.scroll.setPreferredSize((Dimension)serializable);
    }

    public void showNoItemsToDisplayOnViewport(boolean bl) {
        this.scrollPane.setNoItemDisplay(bl);
    }

    public void showPagePageScrollButtons() {
        CVJScrollpane cVJScrollpane = this.getScrollPane();
        final StickyButton stickyButton = new StickyButton(1);
        stickyButton.addActionListener(new ActionListener((JScrollPane)((Object)cVJScrollpane)){
            final /* synthetic */ JScrollPane val$scroll;
            {
                this.val$scroll = jScrollPane;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rectangle rectangle = TreeTablePanel.this.table.getVisibleRect();
                rectangle.y = rectangle.y - this.val$scroll.getViewport().getHeight() < 0 ? 0 : (rectangle.y -= this.val$scroll.getViewport().getHeight());
                TreeTablePanel.this.table.scrollRectToVisible(rectangle);
            }
        });
        final StickyButton stickyButton2 = new StickyButton(5);
        stickyButton2.addActionListener(new ActionListener((JScrollPane)((Object)cVJScrollpane)){
            final /* synthetic */ JScrollPane val$scroll;
            {
                this.val$scroll = jScrollPane;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rectangle rectangle = TreeTablePanel.this.table.getVisibleRect();
                rectangle.y = rectangle.y + rectangle.height > TreeTablePanel.this.table.getHeight() - rectangle.height ? TreeTablePanel.this.table.getHeight() - rectangle.height : (rectangle.y += this.val$scroll.getViewport().getHeight());
                TreeTablePanel.this.table.scrollRectToVisible(rectangle);
            }
        });
        ((Container)((Object)cVJScrollpane)).add(stickyButton);
        ((Container)((Object)cVJScrollpane)).add(stickyButton2);
        ScrollPaneLayout scrollPaneLayout = new ScrollPaneLayout(){

            @Override
            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                Rectangle rectangle = this.getVerticalScrollBar().getBounds();
                int n = stickyButton.getPreferredSize().height;
                rectangle.height -= 2 * n;
                this.getVerticalScrollBar().setBounds(rectangle);
                rectangle.y += rectangle.height;
                rectangle.height = n;
                stickyButton.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                rectangle.y += rectangle.height;
                stickyButton2.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        };
        ((JScrollPane)((Object)cVJScrollpane)).setLayout(scrollPaneLayout);
    }

    public void sizeColumnsToFit(int n) {
        this.table.sizeColumnsToFit(n);
    }

    public void sortByColumn(int n, boolean bl) {
        if (this.table.isSortable() && this.table.isSortingEnabled()) {
            if (this.treeTableModel instanceof ISortableTableModel) {
                ((ISortableTableModel)this.treeTableModel).sortColumn(n, true, bl);
            } else if (this.table.getModel() instanceof ISortableTableModel) {
                ((ISortableTableModel)this.table.getModel()).sortColumn(n, true, bl);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.table == null || this.treeTableModel == tableModelEvent.getSource()) {
            return;
        }
        TableModel tableModel = this.table.getModel();
        int n = tableModelEvent.getType();
        if (n == -1000 || n == 0) {
            if (tableModel instanceof AbstractTableModel) {
                AbstractTableModel abstractTableModel = (AbstractTableModel)tableModel;
                abstractTableModel.fireTableDataChanged();
            } else if (tableModel instanceof ITableEventHandler) {
                ITableEventHandler iTableEventHandler = (ITableEventHandler)((Object)tableModel);
                iTableEventHandler.fireTableChanged(tableModelEvent);
            }
        } else if (n == 1) {
            if (tableModel instanceof AbstractTableModel) {
                AbstractTableModel abstractTableModel = (AbstractTableModel)tableModel;
                abstractTableModel.fireTableRowsInserted(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
            } else if (tableModel instanceof ITableEventHandler) {
                ITableEventHandler iTableEventHandler = (ITableEventHandler)((Object)tableModel);
                iTableEventHandler.fireTableRowsInserted(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
            }
        } else if (n == -1) {
            if (tableModel instanceof AbstractTableModel) {
                AbstractTableModel abstractTableModel = (AbstractTableModel)tableModel;
                int n2 = this.getUnsortedRow(tableModelEvent.getFirstRow());
                int n3 = this.getUnsortedRow(tableModelEvent.getLastRow());
                abstractTableModel.fireTableRowsDeleted(n2, n3);
            } else if (tableModel instanceof ITableEventHandler) {
                ITableEventHandler iTableEventHandler = (ITableEventHandler)((Object)tableModel);
                int n4 = this.getUnsortedRow(tableModelEvent.getFirstRow());
                int n5 = this.getUnsortedRow(tableModelEvent.getLastRow());
                iTableEventHandler.fireTableRowsDeleted(n4, n5);
            }
        } else if (tableModel instanceof AbstractTableModel) {
            AbstractTableModel abstractTableModel = (AbstractTableModel)tableModel;
            abstractTableModel.fireTableChanged(tableModelEvent);
        } else if (tableModel instanceof ITableEventHandler) {
            ITableEventHandler iTableEventHandler = (ITableEventHandler)((Object)tableModel);
            iTableEventHandler.fireTableChanged(tableModelEvent);
        }
        if (this.table != null) {
            this.table.sizeColumnsToFit(-1);
        }
        if (this.isSortOnTableChanged) {
            this.table.setSortable(true);
            this.isSortOnTableChanged = false;
        }
        if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
            return;
        }
        if (this.searchOpen && this.showMatchedOnly.isSelected() && n != -1000 && n != 0) {
            this.applyFilterFromSearch();
        }
    }

    public void updateTableContents() {
        if (this.treeTableModel instanceof AbstractTableModel) {
            CVTreeTableModel cVTreeTableModel = this.treeTableModel;
            ((AbstractTableModel)((Object)cVTreeTableModel)).fireTableDataChanged();
        }
    }

    public void updateTableMenu() {
    }

    public void setShowParagraphTextInTooltop(boolean bl) {
        this.paragraphInTooltip = bl;
    }

    public void setParagraphRenderer(ParagraphText paragraphText) {
        this.setParagraphSupoorted(paragraphText != null);
        this.paragraphTextSource = paragraphText;
    }

    public void setDefaultLinkVisitor(ActionListener actionListener) {
    }

    public void resetSorter() {
    }

    public boolean getAscending() {
        return false;
    }

    public Icon createDragIcon() {
        return null;
    }

    public void setAction(Action action, ActionType actionType) {
        this.setAction(action, actionType, false);
    }

    public void setAction(Action action, ActionType actionType, boolean bl) {
        this.actionMap.put(actionType, action);
        this.buttonFactory.updateAction(actionType, action);
        action.putValue("SwingSelectedKey", bl);
    }

    public void setParagraphViewSelected(boolean bl) {
        this.buttonFactory.getActionMenuItem(ActionType.Paragraph).setSelected(bl);
        this.table.repaint();
    }

    public void setActionBarVisible(boolean bl) {
        this.toolBarPanel.setVisible(bl);
    }

    public JComponent getActionBar() {
        return this.toolBarPanel;
    }

    public void addToToolbar(JComponent jComponent) {
        this.toolBarPanel.getActionBar().add((Component)jComponent);
    }

    public void setActions(ActionType ... actionTypeArray) {
        for (ActionType actionType : actionTypeArray) {
            if (actionType == ActionType.Separator) {
                this.toolBarPanel.getActionBar().add((Component)new JSeparator());
                continue;
            }
            if (actionType == ActionType.Separator_Vertical) {
                this.toolBarPanel.getActionBar().add((Component)new JSeparator(1));
                continue;
            }
            this.toolBarPanel.getActionBar().add((Component)this.buttonFactory.getActionButton(actionType));
        }
    }

    public void setColumnMargin(int n) {
        this.table.getColumnModel().setColumnMargin(n);
    }

    public void setCellTooltipEnabled(boolean bl) {
        this.enableCellTooltip = bl;
    }

    public void setPreferredWithOfColumns() {
        int n;
        this.getTable().setAutoResizeMode(0);
        com.jidesoft.grid.TableUtils.autoResizeAllColumns((JTable)this.getTable());
        for (n = 0; n < this.getTable().getColumnCount(); ++n) {
            DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)this.getTable().getColumnModel();
            TableColumn tableColumn = defaultTableColumnModel.getColumn(n);
            int n2 = 0;
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = this.getTable().getTableHeader().getDefaultRenderer();
            }
            Component component = tableCellRenderer.getTableCellRendererComponent(this.getTable(), tableColumn.getHeaderValue(), false, false, 0, 0);
            n2 = component.getPreferredSize().width;
            if (tableColumn.getPreferredWidth() >= n2) continue;
            tableColumn.setPreferredWidth(n2 + 2);
        }
        if (this._model.getRowCount() > 0) {
            int n3;
            n = this.getTable().getTableHeader().getPreferredSize().height + 5;
            for (n3 = 0; n3 < this.getTable().getRowCount(); ++n3) {
                n += this.getTable().getRowHeight(n3);
            }
            n3 = this.getTable().getPreferredSize().width + 12;
            this.setMinimumSize(new Dimension(n3 + 12, n += 25));
            this.setPreferredSize(new Dimension(n3 + 12, n));
        }
    }

    public void loadPrefs() {
    }

    public List<TableColumn> getColumns(boolean bl) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            arrayList.add(tableColumn);
        }
        return arrayList;
    }

    public void setSorting(boolean bl) {
        this.table.setSortable(bl);
    }

    public void removeNTableMouseListener() {
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        for (int i = mouseListenerArray.length - 1; i >= mouseListenerArray.length; --i) {
            this.removeMouseListener(mouseListenerArray[i]);
        }
    }

    public boolean isGroupingEnabled() {
        return this.groupingEnabled;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.enableCellTooltip) {
            int n = this.getUnsortedRow(this.table.rowAtPoint(mouseEvent.getPoint()));
            TableModel tableModel = this.getModel();
            StringBuffer stringBuffer = new StringBuffer("<html><table>");
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                Object object = tableModel.getValueAt(n, i);
                if (object == null || object.toString().equals("")) continue;
                stringBuffer.append("<tr VALIGN=\"top\"><td><b>").append(tableModel.getColumnName(i)).append("</td><td width='200' >").append(object.toString());
                stringBuffer.append("</td></tr>");
            }
            if (this.paragraphInTooltip && this.paragraphTextSource != null && this.paragraphTextSource.getParagraphText(n) != null) {
                stringBuffer.append("<tr VALIGN=\"top\"><td COLSPAN=\"2\" width='200'><FONT COLOR='#cc6600'>").append(this.paragraphTextSource.getParagraphText(n));
                stringBuffer.append("</font></td></tr>");
            }
            stringBuffer.append("</table>");
            stringBuffer.append("</html>");
            return stringBuffer.toString();
        }
        return super.getToolTipText(mouseEvent);
    }

    @Override
    public void buttonActionPerformed(ActionType actionType, Object ... objectArray) {
        Boolean bl = Boolean.FALSE;
        if (objectArray != null && objectArray.length > 0 && objectArray[0] instanceof Boolean) {
            bl = (Boolean)objectArray[0];
        }
        if (actionType == ActionType.Paragraph) {
            this.setParagraphViewSelected(bl);
        } else if (actionType == ActionType.Filter) {
            this.setAutoFilter(bl);
        } else if (actionType == ActionType.Find) {
            if (this._searchableBar == null) {
                this.installSearchable();
            }
            if (this._searchableBar != null) {
                if (bl.booleanValue()) {
                    this._searchableBar.getInstaller().openSearchBar(this._searchableBar);
                } else {
                    this._searchableBar.getInstaller().closeSearchBar(this._searchableBar);
                }
            }
        }
    }

    public void setSelectedRow(int n) {
        if (this.table.getRowCount() >= n) {
            this.table.setSelectedRow(this.table.getRowAt(n));
        }
    }

    public LinkVisitor getLinkVisitor() {
        return this.linkVisitor;
    }

    public void setLinkVisitor(LinkVisitor linkVisitor) {
        this.linkVisitor = linkVisitor;
    }

    public boolean isColumnVisible(int n) {
        return TableColumnChooser.isVisibleColumn((TableColumnModel)this.table.getColumnModel(), (int)n);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        try {
            this.ensurePageLoaded();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized void ensurePageLoaded() {
        if (this.pageLoader == null) {
            return;
        }
        Rectangle rectangle = this.getScrollPane().getViewport().getViewRect();
        if (rectangle == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        try {
            n = this.getTable().rowAtPoint(new Point(rectangle.x + 1, rectangle.y + 1));
            n2 = this.getTable().rowAtPoint(new Point(rectangle.x + 1, rectangle.y + rectangle.height - 5));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        final int n3 = n;
        final int n4 = n2;
        new Thread(){

            @Override
            public void run() {
                try {
                    TreeTablePanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    TreeTablePanel.this.makeGlasspaneVisible();
                    TreeTablePanel.this.pageLoader.setDataAvailable(n3, n4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (exception.getMessage() != null && !exception.getMessage().equals("")) {
                        JOptionPane.showMessageDialog(TreeTablePanel.this, exception.getMessage());
                    }
                }
                finally {
                    TreeTablePanel.this.makeGlasspaneInvisible();
                    TreeTablePanel.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }.start();
    }

    protected void makeGlasspaneInvisible() {
        if (this.glassPane == null) {
            return;
        }
        this.glassPane.stop();
        this.glassPane.setVisible(false);
        this.glassPane = null;
    }

    protected void makeGlasspaneVisible() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (!(window instanceof JFrame)) {
            return;
        }
        Component component = ((JFrame)window).getGlassPane();
        component.setVisible(true);
        if (component instanceof FindAnimatedImage) {
            this.glassPane = (FindAnimatedImage)component;
            this.glassPane.start();
        }
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void printTable() {
        try {
            MessageFormat messageFormat = new MessageFormat("");
            MessageFormat messageFormat2 = new MessageFormat("- {0} -");
            this.table.print(JTable.PrintMode.FIT_WIDTH, messageFormat, messageFormat2);
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
            System.err.println("Error printing: " + printerException.getMessage());
        }
    }

    protected void removePopupAdapterSinceItConflictsWithAdapterAddedFromSubclass() {
        this.table.removeMouseListener((MouseListener)this.popupAdapter);
    }

    public void setGroupingSupported(boolean bl) {
        this.groupSupported = bl;
    }

    public boolean isGroupSupported() {
        return this.groupSupported;
    }

    public AbstractButton getActionSource(ActionType actionType) {
        return this.buttonFactory.getActionButton(actionType);
    }

    public String getFilterString() throws Exception {
        FilterDef filterDef = new FilterDef();
        for (int i = 0; i < this.getFilterModel().getColumnCount(); ++i) {
            Filter[] filterArray = this.getFilterModel().getFilters(i);
            if (filterArray == null || filterArray.length == 0) continue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(filterArray);
            ColumnFilter columnFilter = new ColumnFilter();
            if (this.getFilterModel().getColumnIdentifier(i) == null) continue;
            if (filterArray.length > 0) {
                System.out.println("filters  :" + filterArray[0]);
                System.out.println("column Name :" + this.getFilterModel().getColumnIdentifier(i).toString());
            }
            columnFilter.columnName = this.getFilterModel().getColumnIdentifier(i).toString();
            columnFilter.filters = byteArrayOutputStream.toByteArray();
            filterDef.filters.add(columnFilter);
        }
        return XMLEncoder.encode(filterDef);
    }

    public void applyFilter(final String string) throws Exception {
        if (SwingUtilities.isEventDispatchThread()) {
            this.applyFilter1(string);
        } else {
            final NamedObject<Object> namedObject = new NamedObject<Object>(null, null);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        TreeTablePanel.this.applyFilter1(string);
                    }
                    catch (Exception exception) {
                        namedObject.setObject(exception);
                    }
                }
            });
            if (namedObject.getObject() != null) {
                throw (Exception)namedObject.getObject();
            }
        }
    }

    private void applyFilter1(String string) throws Exception {
        this.getFilterModel().clearFilters();
        if (string != null && !string.equals("")) {
            FilterDef filterDef = new FilterDef();
            XMLDecoder.decode(string, (Object)filterDef);
            boolean bl = false;
            for (ColumnFilter columnFilter : filterDef.filters) {
                String string2 = columnFilter.columnName;
                try {
                    Filter[] filterArray;
                    ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(columnFilter.filters));
                    for (Filter filter : filterArray = (Filter[])objectInputStream.readObject()) {
                        if (!bl && filter.getName() != null && filter.getName().length() > 0) {
                            bl = true;
                            this.setAutoFilter(bl);
                        }
                        this.getFilterModel().addFilter(this.table.getColumnModel().getColumnIndex(string2), filter);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logger.instance().println("Column " + string2 + " not found. Filter will not be applied");
                }
            }
            if (bl) {
                AutoFilterTableHeader autoFilterTableHeader = (AutoFilterTableHeader)this.table.getTableHeader();
                autoFilterTableHeader.getFilterableTableModel().refresh();
            }
        }
        this.getFilterModel().setFiltersApplied(true);
    }

    private void applyFilterFromSearch() {
        this.treeTableModel.setFiltersApplied(this.showMatchedOnly.isSelected());
        this._searchableBar.getSearchingText();
        this.treeTableModel.refresh();
    }

    public boolean isAllowCustomFilter() {
        return this.allowCustomFilter;
    }

    public void setAllowCustomFilter(boolean bl) {
        this.allowCustomFilter = bl;
    }

    static {
        ObjectComparatorManager.registerComparator(String.class, (Comparator)new StringCommonComparartor());
        ObjectComparatorManager.registerComparator(IdNameItem.class, (Comparator)new IdNameItemCommonNameComparartor());
        ObjectComparatorManager.registerComparator(DateNameItem.class, (Comparator)new DateNameItemCommonComparartor());
    }

    public static class TablePreference {
        private boolean findMatchCase;
        private boolean findShowMatched;
        private boolean findMatchWholeWord;
        private String tableSettings;
        private String tableSortSettings;
        private ArrayList<Integer> tableGroupingColumns;
        private boolean tableSearchPanelOpened;
        private String filterString;

        public boolean getFindMatchCase() {
            return this.findMatchCase;
        }

        public String getFilterString() {
            return this.filterString;
        }

        public void setFilterString(String string) {
            this.filterString = string;
        }

        public void setTableSearchPanelOpened(boolean bl) {
            this.tableSearchPanelOpened = bl;
        }

        public void setTableGroupingColumns(ArrayList<Integer> arrayList) {
            this.tableGroupingColumns = arrayList;
        }

        public boolean isTableSearchPanelOpened() {
            return this.tableSearchPanelOpened;
        }

        public ArrayList<Integer> getTableGroupingColumns() {
            return this.tableGroupingColumns;
        }

        public void setTableSettings(String string) {
            this.tableSettings = string;
        }

        public void setTableSortSettings(String string) {
            this.tableSortSettings = string;
        }

        public String getTableSortSettings() {
            return this.tableSortSettings;
        }

        public String getTableSettings() {
            return this.tableSettings;
        }

        public void setFindMatchCase(boolean bl) {
            this.findMatchCase = bl;
        }

        public boolean isFindShowMatched() {
            return this.findShowMatched;
        }

        public void setFindShowMatched(boolean bl) {
            this.findShowMatched = bl;
        }

        public boolean isFindMatchWholeWord() {
            return this.findMatchWholeWord;
        }

        public void setFindMatchWholeWord(boolean bl) {
            this.findMatchWholeWord = bl;
        }
    }

    public static class ColumnFilter {
        String columnName;
        byte[] filters;
    }

    public static class FilterDef {
        List<ColumnFilter> filters = new ArrayList<ColumnFilter>();
    }

    public static class TableToolbar
    extends CommandBar {
        JLabel title = new JLabel();
        CommandBar commands = new CommandBar();

        public TableToolbar() {
            this.setLayout(new BorderLayout(0, 0));
            this.add(this.title);
            this.commands.setStretch(true);
            this.commands.setOpaque(false);
            this.setStretch(true);
            this.setFloatable(false);
            this.setTitle("");
            this.setRearrangable(false);
            this.add((Component)this.commands, "East");
        }

        public void setTitle(String string) {
            super.setTitle(string);
            if (this.title != null) {
                this.title.setText(string);
            }
        }

        public CommandBar getActionBar() {
            return this.commands;
        }
    }

    private class DateRenderer
    extends DefaultTableCellRenderer {
        private DateRenderer() {
        }

        @Override
        protected void setValue(Object object) {
            String string = "";
            try {
                string = TreeTablePanel.this.dateFormat.format((Date)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.setValue(string);
        }
    }

    public class PopupAdapter
    extends MouseAdapter {
        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && TreeTablePanel.this.popup != null) {
                TreeTablePanel.this.popupAction1(mouseEvent);
            }
            if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 2 && TreeTablePanel.this.popup != null) {
                TreeTablePanel.this.defaultPopupAction();
            }
            if (TreeTablePanel.this.bClearSelection && TreeTablePanel.this.getRowAtPoint(mouseEvent.getPoint()) == -1) {
                TreeTablePanel.this.table.clearSelection();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (TreeTablePanel.this.treeTableModel.getRowCount() == 0) {
                return;
            }
            if (mouseEvent.isPopupTrigger() && TreeTablePanel.this.popup != null) {
                TreeTablePanel.this.popupAction1(mouseEvent);
            }
        }
    }

    static class ActionFactory {
        ActionFactory() {
        }

        public static void getSaveAction() {
        }
    }

    public class DefaultScrollTooltipRenderer
    implements ScrollTooltipRenderer {
        @Override
        public String getTooltipText(int n, JTable jTable) {
            int n2 = jTable.getColumnCount();
            String string = "<html><body><table><tr>";
            for (int i = 0; i < n2; ++i) {
                string = string + "<td>" + jTable.getValueAt(n, i) + "</td>";
            }
            string = string + "</tr></table></body></html>";
            return string;
        }
    }

    public static interface ScrollTooltipRenderer {
        public String getTooltipText(int var1, JTable var2);
    }

    public static enum OptionalFeatures {
        Filterable;

    }

    public static enum DefaultFeatures {
        Sortable,
        ActionsInstalled,
        Searchable;

    }

    public static class MyTableSearchable
    extends TableSearchable {
        public MyTableSearchable(TreeTable treeTable) {
            super((JTable)treeTable);
            treeTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    this.setCursor(-1);
                }
            });
        }

        public int findFromCursor(String string) {
            try {
                return super.findFromCursor(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return -1;
            }
        }

        public boolean compare(Object object, String string) {
            return super.compare(object, string);
        }

        protected void setSelectedIndex(int n, boolean bl) {
            if (n < 0) {
                return;
            }
            super.setSelectedIndex(n, bl);
        }
    }
}

