/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table;

import commvault.cte.CteStringBank;
import commvault.cte.component.Utilities;
import commvault.cte.component.events.CTEAction;
import commvault.cte.component.table.CVFileChooser;
import commvault.cte.component.table.SupportedFileFilter;
import commvault.cte.component.table.TableUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;

public class SaveAction
extends CTEAction {
    public static final String DEFAULT_FILE_NAME = "table.saveAction";
    private JComponent source;

    public SaveAction(JComponent jComponent) {
        super(CteStringBank.Save_to_File.getI18n(), (ActionListener)null);
        this.source = jComponent;
    }

    protected JComponent getSource() {
        return this.source;
    }

    public boolean isPagingBased() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        new Thread(){

            @Override
            public void run() {
                JComponent jComponent = SaveAction.this.getSource();
                try {
                    jComponent.setCursor(Cursor.getPredefinedCursor(3));
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            SaveAction.this.save();
                            return null;
                        }
                    });
                    jComponent.setCursor(Cursor.getDefaultCursor());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    jComponent.setCursor(Cursor.getDefaultCursor());
                    Utilities.showErrorMessage(exception.getMessage());
                }
            }
        }.start();
    }

    public String getText(char c) {
        String string = ((JTextComponent)this.getSource()).getText();
        return string;
    }

    public String getNextPageText(char c) {
        return null;
    }

    protected SupportedFileFilter[] getFileFilters() {
        SupportedFileFilter supportedFileFilter = new SupportedFileFilter(CteStringBank.Text_file.getI18n(), ".txt", ' ');
        return new SupportedFileFilter[]{supportedFileFilter, supportedFileFilter};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void save() throws Exception {
        void var6_9;
        String string;
        Object object;
        Object object2;
        CVFileChooser cVFileChooser = new CVFileChooser();
        cVFileChooser.setFileSelectionMode(0);
        cVFileChooser.removeChoosableFileFilter(cVFileChooser.getAcceptAllFileFilter());
        String string2 = (String)this.source.getClientProperty(DEFAULT_FILE_NAME);
        if (string2 == null || string2 == "") {
            string2 = "";
            for (object2 = this.source.getParent(); object2 != null; object2 = object2.getParent()) {
                if (object2 instanceof Dialog) {
                    string2 = ((Dialog)object2).getTitle();
                    break;
                }
                if (object2 instanceof Frame) {
                    string2 = ((Frame)object2).getTitle();
                    break;
                }
                if (!(object2 instanceof JInternalFrame)) continue;
                string2 = ((JInternalFrame)object2).getTitle();
                break;
            }
        }
        string2 = this.escapeDisallowedChars(string2);
        object2 = this.getFileFilters();
        SupportedFileFilter supportedFileFilter = null;
        Object object3 = null;
        for (SupportedFileFilter supportedFileFilter2 : object2) {
            cVFileChooser.addChoosableFileFilter(supportedFileFilter2);
            try {
                object = null;
                if (TableUtils.getIPathHadler() != null) {
                    string = string2 + supportedFileFilter2.getExtension();
                    object = new File(TableUtils.getIPathHadler().getlastSavedPath(), string);
                } else {
                    object = new File(new File(string2 + supportedFileFilter2.getExtension()).getCanonicalPath());
                }
                if (supportedFileFilter == null) {
                    supportedFileFilter = supportedFileFilter2;
                    object3 = object;
                }
                cVFileChooser.addChoosableFileFilterType(supportedFileFilter2, (File)object);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        cVFileChooser.setFileFilter(supportedFileFilter);
        cVFileChooser.setSelectedFile((File)object3);
        JComponent jComponent = this.source;
        if (this.source instanceof JTable && this.source.getParent() != null) {
            Container container = this.source.getParent();
        }
        int n = cVFileChooser.showSaveDialog((Component)var6_9);
        while (n == 0) {
            String string3;
            String string4;
            SupportedFileFilter supportedFileFilter2;
            File file = cVFileChooser.getSelectedFile();
            supportedFileFilter2 = (SupportedFileFilter)cVFileChooser.getFileFilter();
            object = supportedFileFilter2.getExtension();
            string = file.getName();
            String string5 = file.getParent();
            string = this.escapeDisallowedChars(string);
            String string6 = string5 + File.separator + string;
            file = new File(string6);
            if (TableUtils.getIPathHadler() != null) {
                block25: {
                    string4 = "";
                    try {
                        string3 = file.getAbsolutePath();
                        if (string3 == null || string3.trim().length() <= 0) break block25;
                        string4 = string3.substring(0, string3.lastIndexOf(File.separator));
                    }
                    catch (Exception exception) {
                        try {
                            string4 = "";
                        }
                        catch (Throwable throwable) {
                            TableUtils.getIPathHadler().setLastSavedPath(string4 == null || string4.trim().length() == 0 ? file.getParent() : string4);
                            throw throwable;
                        }
                        TableUtils.getIPathHadler().setLastSavedPath(string4 == null || string4.trim().length() == 0 ? file.getParent() : string4);
                    }
                }
                TableUtils.getIPathHadler().setLastSavedPath(string4 == null || string4.trim().length() == 0 ? file.getParent() : string4);
            }
            if (!file.getName().endsWith((String)object)) {
                file = new File((file.getAbsolutePath() + (String)object).replaceAll(",", "_"));
            }
            string4 = null;
            try {
                if (!file.createNewFile() && JOptionPane.showConfirmDialog((Component)var6_9, CteStringBank.File_already_exists6_.getI18n() + CteStringBank.Do_you_want_to_override_the_content9.getI18n()) != 0) {
                    n = cVFileChooser.showSaveDialog((Component)var6_9);
                    continue;
                }
                string3 = file.getName();
                if (string3.indexOf(".") > 0) {
                    string3 = string3.substring(0, string3.lastIndexOf("."));
                }
                this.writeToFile(supportedFileFilter2, new FileOutputStream(file), file.getAbsolutePath(), string3);
                break;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Utilities.showErrorMessage(iOException.getMessage());
                if (string4 != null) {
                    try {
                        ((BufferedWriter)((Object)string4)).close();
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                }
                n = cVFileChooser.showSaveDialog((Component)var6_9);
            }
        }
    }

    protected void writeToFile(SupportedFileFilter supportedFileFilter, OutputStream outputStream, String string, String string2) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF8"));
        char c = supportedFileFilter.getDelim();
        if (!this.isPagingBased()) {
            bufferedWriter.write(this.getText(c));
        } else {
            String string3 = null;
            while ((string3 = this.getNextPageText(c)) != null) {
                bufferedWriter.write(string3);
                bufferedWriter.flush();
            }
        }
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    protected String escapeDisallowedChars(String string) {
        char[] cArray;
        for (char c : cArray = new char[]{':', '\\', '?', '*', '|', '<', '>', '\"'}) {
            if (string.indexOf(c) < 0) continue;
            string = c == '\\' ? string.replaceAll("\\" + c, "_") : string.replaceAll("" + c, "_");
        }
        return string;
    }
}

