/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table;

import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideToggleButton;
import commvault.cte.CteStringBank;
import commvault.cte.common.ActionType;
import commvault.cte.component.events.CTEAction;
import commvault.cte.component.table.DeleteTableLayoutAction;
import commvault.cte.component.table.EmailTableAction;
import commvault.cte.component.table.NTable;
import commvault.cte.component.table.SaveTableAction;
import commvault.cte.component.table.SaveTableLayoutAction;
import commvault.cte.util.Application;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;

public class ActionButtonFactory {
    private Component component;
    private ActionButtonActionListener listener;
    private JideButton btnSave;
    private JideButton btnPdf;
    private JideButton btnSearch;
    private JideButton btnEmail;
    private JideButton btnPrint;
    private JideToggleButton btnParagraph;
    private JideToggleButton btnFilter;
    private JideButton btnPreview;
    private JideButton btnSaveTableLayout;
    private JideButton btnDeleteTableLayout;
    private JideButton btnProperties;
    private JideButton btnBack;
    private JideButton btnFwd;
    private JideToggleButton btnPin;
    private JMenuItem mnSave;
    private JMenuItem mnSearch;
    private JMenuItem mnEmail;
    private JMenuItem mnPrint;
    private JMenuItem mnPreview;
    private JMenuItem mSaveTableLayout;
    private JMenuItem mDeleteTbleLayout;
    private JCheckBoxMenuItem mnParagraph;
    private JCheckBoxMenuItem mnFilter;
    private static Map<ActionType, String> toolTips = new HashMap<ActionType, String>();
    private static Map<ActionType, Icon> icons = new HashMap<ActionType, Icon>();
    private Map<ActionType, Action> customActionsMap = new HashMap<ActionType, Action>();
    private Map<Integer, ButtonGroup> buttonGroups = new HashMap<Integer, ButtonGroup>();

    public ActionButtonFactory(Component component, ActionButtonActionListener actionButtonActionListener) {
        this.component = component;
        this.listener = actionButtonActionListener;
        this.initButtons();
    }

    public void registerAction() {
    }

    public JMenuItem getActionMenuItem(ActionType actionType) {
        if (actionType == ActionType.Find) {
            return this.mnSearch;
        }
        if (actionType == ActionType.Save) {
            return this.mnSave;
        }
        if (actionType == ActionType.Save_Table_Layout) {
            return this.mSaveTableLayout;
        }
        if (actionType == ActionType.Delete_Table_Layout) {
            return this.mDeleteTbleLayout;
        }
        if (actionType == ActionType.Email) {
            return this.mnEmail;
        }
        if (actionType == ActionType.Filter) {
            return this.mnFilter;
        }
        if (actionType == ActionType.Print) {
            return this.mnPrint;
        }
        if (actionType == ActionType.Paragraph) {
            return this.mnParagraph;
        }
        if (actionType == ActionType.Preview) {
            return this.mnPreview;
        }
        return null;
    }

    public AbstractButton getActionButton(ActionType actionType) {
        if (actionType == ActionType.Find) {
            return this.btnSearch;
        }
        if (actionType == ActionType.Save) {
            return this.btnSave;
        }
        if (actionType == ActionType.Save_Table_Layout) {
            return this.btnSaveTableLayout;
        }
        if (actionType == ActionType.Delete_Table_Layout) {
            return this.btnDeleteTableLayout;
        }
        if (actionType == ActionType.Email) {
            return this.btnEmail;
        }
        if (actionType == ActionType.Filter) {
            return this.btnFilter;
        }
        if (actionType == ActionType.Print) {
            return this.btnPrint;
        }
        if (actionType == ActionType.Paragraph) {
            return this.btnParagraph;
        }
        if (actionType == ActionType.Properties) {
            return this.btnProperties;
        }
        if (actionType == ActionType.Pin) {
            return this.btnPin;
        }
        if (actionType == ActionType.Back) {
            return this.btnBack;
        }
        if (actionType == ActionType.Forward) {
            return this.btnFwd;
        }
        if (actionType == ActionType.Preview) {
            return this.btnPreview;
        }
        final Action action = this.customActionsMap.get((Object)actionType);
        if (action == null) {
            return null;
        }
        if (actionType.isToggle()) {
            JideToggleButton jideToggleButton = new JideToggleButton(action);
            jideToggleButton.setFocusable(false);
            jideToggleButton.setBorderPainted(false);
            if (actionType.getGroup() > 0) {
                ButtonGroup buttonGroup = this.buttonGroups.get(actionType.getGroup());
                if (buttonGroup == null) {
                    buttonGroup = new ButtonGroup();
                    this.buttonGroups.put(actionType.getGroup(), buttonGroup);
                }
                buttonGroup.add((AbstractButton)jideToggleButton);
            }
            return jideToggleButton;
        }
        if (actionType.isChoiceButton()) {
            JideSplitButton jideSplitButton = new JideSplitButton(actionType.toString());
            jideSplitButton.setFocusable(false);
            jideSplitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            for (ActionType actionType2 : actionType.getSubActionTypes()) {
                jideSplitButton.add((Action)new CTEAction(actionType2.toString(), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        action.actionPerformed(actionEvent);
                    }
                }));
            }
            return jideSplitButton;
        }
        return new JideButton(action);
    }

    private void initButtons() {
        this.btnSave = new ActionButton(ActionType.Save, CteStringBank.Save.getI18n());
        this.btnEmail = new ActionButton(ActionType.Email, CteStringBank.Email.getI18n());
        this.btnParagraph = new ActionToggleButton(ActionType.Paragraph, CteStringBank.Paragraph.getI18n());
        this.btnFilter = new ActionToggleButton(ActionType.Filter, CteStringBank.Filter.getI18n());
        this.btnPrint = new ActionButton(ActionType.Print, CteStringBank.Print.getI18n());
        this.btnSearch = new ActionToggleButton(ActionType.Find, CteStringBank.Find.getI18n());
        this.btnPreview = new ActionButton(ActionType.Preview, CteStringBank.Preview.getI18n());
        this.btnProperties = new ActionButton(ActionType.Properties, CteStringBank.Properties.getI18n());
        this.btnPin = new ActionToggleButton(ActionType.Pin, CteStringBank.Pin.getI18n());
        this.btnBack = new ActionButton(ActionType.Back, CteStringBank.Back.getI18n());
        this.btnFwd = new ActionButton(ActionType.Forward, CteStringBank.Forward.getI18n());
        this.btnSaveTableLayout = new ActionButton(ActionType.Save_Table_Layout, CteStringBank.SaveTableLayout.getI18n());
        this.btnDeleteTableLayout = new ActionButton(ActionType.Delete_Table_Layout, CteStringBank.DeletTableLayout.getI18n());
        this.mnSave = new ActionMenuItem(ActionType.Save, CteStringBank.Save.getI18n());
        this.mnEmail = new ActionMenuItem(ActionType.Email, CteStringBank.Email.getI18n());
        this.mnParagraph = new ActionCheckboxMenuItem(ActionType.Paragraph, CteStringBank.Paragraph.getI18n());
        this.mnFilter = new ActionCheckboxMenuItem(ActionType.Filter, CteStringBank.Filter.getI18n());
        this.mnPrint = new ActionMenuItem(ActionType.Print, CteStringBank.Print.getI18n());
        this.mnSearch = new ActionCheckboxMenuItem(ActionType.Find, CteStringBank.Find.getI18n());
        this.mnPreview = new ActionCheckboxMenuItem(ActionType.Preview, CteStringBank.Preview.getI18n());
        this.mSaveTableLayout = new ActionMenuItem(ActionType.Save_Table_Layout, CteStringBank.SaveTableLayout.getI18n());
        this.mDeleteTbleLayout = new ActionMenuItem(ActionType.Delete_Table_Layout, CteStringBank.DeletTableLayout.getI18n());
    }

    private void actionPerformed(ActionTypeHolder actionTypeHolder, ActionEvent actionEvent) {
        this.actionPerformed(actionTypeHolder, false, actionEvent);
    }

    private void actionPerformed(ActionTypeHolder actionTypeHolder, boolean bl, ActionEvent actionEvent) {
        ActionType actionType = actionTypeHolder.getActionType();
        if (this.customActionsMap.containsKey((Object)actionType)) {
            this.customActionsMap.get((Object)actionType).actionPerformed(actionEvent);
            return;
        }
        if (actionType == ActionType.Find) {
            this.listener.buttonActionPerformed(actionType, bl);
        } else if (actionType == ActionType.Save) {
            new SaveTableAction(((NTable)this.component).getTable()).actionPerformed(actionEvent);
        } else if (actionType == ActionType.Save_Table_Layout) {
            new SaveTableLayoutAction((NTable)this.component, ((NTable)this.component).getITableLayoutSaveHandler()).actionPerformed(actionEvent);
        } else if (actionType == ActionType.Delete_Table_Layout) {
            new DeleteTableLayoutAction((NTable)this.component, ((NTable)this.component).getITableLayoutSaveHandler()).actionPerformed(actionEvent);
        } else if (actionType == ActionType.Email) {
            new EmailTableAction(((NTable)this.component).getTable()).actionPerformed(actionEvent);
        } else if (actionType == ActionType.Filter) {
            this.listener.buttonActionPerformed(actionType, bl);
        } else if (actionType == ActionType.Print) {
            ((NTable)this.component).printTable();
        } else if (actionType == ActionType.Paragraph) {
            this.listener.buttonActionPerformed(actionType, bl);
        } else if (actionType == ActionType.Back) {
            this.listener.buttonActionPerformed(actionType, new Object[0]);
        } else if (actionType == ActionType.Forward) {
            this.listener.buttonActionPerformed(actionType, new Object[0]);
        } else if (actionType == ActionType.Pin) {
            this.listener.buttonActionPerformed(actionType, bl);
        } else if (actionType == ActionType.Properties) {
            this.listener.buttonActionPerformed(actionType, new Object[0]);
        } else {
            this.listener.buttonActionPerformed(actionType, new Object[0]);
        }
    }

    public void updateAction(ActionType actionType, Action action) {
        this.customActionsMap.put(actionType, action);
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    static {
        toolTips.put(ActionType.Email, CteStringBank.Send_as_Email.getI18n());
        toolTips.put(ActionType.Save, CteStringBank.Save_as_CSV.getI18n());
        toolTips.put(ActionType.Print, CteStringBank.Print.getI18n());
        toolTips.put(ActionType.Paragraph, CteStringBank.Toggle_Paragraph_View.getI18n());
        toolTips.put(ActionType.Filter, CteStringBank.Toggle_Auto15Filter.getI18n());
        toolTips.put(ActionType.Find, CteStringBank.Find.getI18n());
        toolTips.put(ActionType.Pin, CteStringBank.Pin_this_window.getI18n());
        toolTips.put(ActionType.Properties, CteStringBank.Properties.getI18n());
        toolTips.put(ActionType.Back, CteStringBank.Back.getI18n());
        toolTips.put(ActionType.Forward, CteStringBank.Forward.getI18n());
        toolTips.put(ActionType.Save_Table_Layout, CteStringBank.SaveTableLayout.getI18n());
        toolTips.put(ActionType.Delete_Table_Layout, CteStringBank.DeletTableLayout.getI18n());
        icons.put(ActionType.Email, Application.instance().getIconSource().getIcon("emailIcon"));
        icons.put(ActionType.Save, Application.instance().getIconSource().getIcon("saveIcon"));
        icons.put(ActionType.Print, Application.instance().getIconSource().getIcon("print12"));
        icons.put(ActionType.Paragraph, Application.instance().getIconSource().getIcon("paragraph"));
        icons.put(ActionType.Filter, Application.instance().getIconSource().getIcon("filters"));
        icons.put(ActionType.Find, Application.instance().getIconSource().getIcon("searchIcon"));
        icons.put(ActionType.Pin, Application.instance().getIconSource().getIcon("pinOff"));
        icons.put(ActionType.Properties, Application.instance().getIconSource().getIcon("policiesSmallIcon"));
        icons.put(ActionType.Back, Application.instance().getIconSource().getIcon("backIcon12"));
        icons.put(ActionType.Forward, Application.instance().getIconSource().getIcon("forwardIcon12"));
        icons.put(ActionType.Save_Table_Layout, Application.instance().getIconSource().getIcon("saveIcon"));
        icons.put(ActionType.Delete_Table_Layout, Application.instance().getIconSource().getIcon("Delete"));
    }

    public static interface ActionButtonActionListener {
        public void buttonActionPerformed(ActionType var1, Object ... var2);
    }

    class ActionToggleButton
    extends JideToggleButton
    implements ActionTypeHolder,
    ActionListener {
        private ActionType actionType;

        ActionToggleButton(ActionType actionType) {
            this((Icon)icons.get((Object)actionType), actionType);
        }

        ActionToggleButton(ActionType actionType, String string) {
            this((Icon)icons.get((Object)actionType), actionType);
        }

        ActionToggleButton(Icon icon, ActionType actionType) {
            super(icon);
            this.actionType = actionType;
            this.addActionListener(this);
            if (toolTips.containsKey((Object)actionType)) {
                this.setToolTipText((String)toolTips.get((Object)actionType));
            }
        }

        ActionToggleButton(Icon icon, ActionType actionType, String string) {
            super(string, icon);
            this.actionType = actionType;
            this.addActionListener(this);
            if (toolTips.containsKey((Object)actionType)) {
                this.setToolTipText((String)toolTips.get((Object)actionType));
            }
        }

        @Override
        public ActionType getActionType() {
            return this.actionType;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionButtonFactory.this.actionPerformed(this, this.isSelected(), actionEvent);
        }
    }

    class ActionButton
    extends JideButton
    implements ActionTypeHolder,
    ActionListener {
        private ActionType actionType;

        ActionButton(ActionType actionType) {
            this((Icon)icons.get((Object)actionType), actionType);
        }

        ActionButton(ActionType actionType, String string) {
            this((Icon)icons.get((Object)actionType), actionType, string);
        }

        ActionButton(Icon icon, ActionType actionType) {
            super(icon);
            this.actionType = actionType;
            this.addActionListener(this);
            if (toolTips.containsKey((Object)actionType)) {
                this.setToolTipText((String)toolTips.get((Object)actionType));
            }
            this.setButtonStyle(0);
        }

        ActionButton(Icon icon, ActionType actionType, String string) {
            super(string, icon);
            this.actionType = actionType;
            this.addActionListener(this);
            if (toolTips.containsKey((Object)actionType)) {
                this.setToolTipText((String)toolTips.get((Object)actionType));
            }
            this.setButtonStyle(0);
        }

        @Override
        public ActionType getActionType() {
            return this.actionType;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionButtonFactory.this.actionPerformed(this, actionEvent);
        }
    }

    class ActionMenuItem
    extends JMenuItem
    implements ActionTypeHolder,
    ActionListener {
        private ActionType actionType;

        ActionMenuItem(ActionType actionType) {
            this((Icon)icons.get((Object)actionType), actionType.name(), actionType);
        }

        ActionMenuItem(ActionType actionType, String string) {
            this((Icon)icons.get((Object)actionType), string, actionType);
        }

        ActionMenuItem(Icon icon, String string, ActionType actionType) {
            super(string, icon);
            this.actionType = actionType;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionButtonFactory.this.actionPerformed(this, actionEvent);
        }

        @Override
        public ActionType getActionType() {
            return this.actionType;
        }
    }

    class ActionCheckboxMenuItem
    extends JCheckBoxMenuItem
    implements ActionTypeHolder,
    ActionListener {
        private ActionType actionType;

        ActionCheckboxMenuItem(ActionType actionType) {
            this((Icon)icons.get((Object)actionType), actionType.name(), actionType);
        }

        ActionCheckboxMenuItem(ActionType actionType, String string) {
            this((Icon)icons.get((Object)actionType), string, actionType);
        }

        ActionCheckboxMenuItem(Icon icon, String string, ActionType actionType) {
            super(string, icon);
            this.actionType = actionType;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionButtonFactory.this.actionPerformed(this, this.isSelected(), actionEvent);
        }

        @Override
        public ActionType getActionType() {
            return this.actionType;
        }
    }

    static interface ActionTypeHolder {
        public ActionType getActionType();
    }
}

