/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.search;

import commvault.cte.CteStringBank;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Position;

public abstract class FindAction
extends AbstractAction
implements DocumentListener,
KeyListener,
PopupMenuListener {
    private JPanel searchPanel = new JPanel(new FlowLayout(0, 0, 0));
    private JPopupMenu popup = new JPopupMenu();
    protected JTextField searchField = new JTextField();
    protected boolean ignoreCase;
    protected JComponent comp = null;
    protected boolean shiftDown = false;
    protected boolean controlDown = false;

    public FindAction(boolean bl) {
        super("incremantal-search-case" + (bl ? "in" : "") + "sensitive");
        this.ignoreCase = bl;
        int n = 2;
        if (bl) {
            n |= 1;
        }
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, n));
        this.createSearchPanel();
    }

    private void createSearchPanel() {
        this.searchPanel.setBackground(Color.WHITE);
        this.searchField.setOpaque(false);
        JLabel jLabel = new JLabel(CteStringBank.Search_for7.getI18n());
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        this.searchField.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.searchPanel.add(jLabel);
        this.searchPanel.add(this.searchField);
        this.searchPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
        this.popup.add(this.searchPanel);
        this.popup.addPopupMenuListener(this);
        this.searchField.setFont(new Font("DialogInput", 0, 12));
        this.searchField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindAction.this.popup.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.searchField) {
            this.popup.setVisible(false);
            this.comp = null;
        } else {
            this.comp = (JComponent)actionEvent.getSource();
            this.searchField.removeActionListener(this);
            this.searchField.removeKeyListener(this);
            this.searchField.getDocument().removeDocumentListener(this);
            this.initSearch(actionEvent);
            this.searchField.addActionListener(this);
            this.searchField.addKeyListener(this);
            this.searchField.getDocument().addDocumentListener(this);
            Rectangle rectangle = this.comp.getVisibleRect();
            this.popup.show(this.comp, rectangle.x, rectangle.y - this.popup.getPreferredSize().height - 5);
            this.searchField.requestFocus();
        }
    }

    protected void initSearch(ActionEvent actionEvent) {
        this.searchField.setText("");
        this.searchField.setForeground(Color.black);
    }

    private void changed(Position.Bias bias) {
        this.popup.setVisible(false);
        this.popup.setVisible(true);
        this.searchField.requestFocus();
        this.searchField.setForeground(this.changed(this.comp, this.searchField.getText(), bias) ? Color.black : Color.red);
    }

    protected abstract boolean changed(JComponent var1, String var2, Position.Bias var3);

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changed(null);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changed(null);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.shiftDown = keyEvent.isShiftDown();
        this.controlDown = keyEvent.isControlDown();
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this.changed(Position.Bias.Backward);
                break;
            }
            case 40: {
                this.changed(Position.Bias.Forward);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.comp.requestFocus();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public static void install(JComponent jComponent, Action[] actionArray) {
        ActionMap actionMap = jComponent.getActionMap();
        jComponent.addKeyListener(new IncrementalSearchKeyListener((FindAction)actionArray[0]));
        InputMap inputMap = jComponent.getInputMap(0);
        for (int i = 0; i < actionArray.length; ++i) {
            String string = (String)actionArray[i].getValue("Name");
            actionMap.put(string, actionArray[i]);
            inputMap.put((KeyStroke)actionArray[i].getValue("AcceleratorKey"), string);
        }
    }

    public static class IncrementalSearchKeyListener
    extends KeyAdapter {
        private boolean armed = false;
        private FindAction findAction;

        public IncrementalSearchKeyListener(FindAction findAction) {
            this.findAction = findAction;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getModifiers();
            int n2 = keyEvent.getKeyCode();
            if (n2 == 521 || n2 == 45 || n2 == 107 || n2 == 109) {
                return;
            }
            if (n > 0 && n != 1 || keyEvent.isActionKey()) {
                return;
            }
            char c = keyEvent.getKeyChar();
            if (!Character.isISOControl(c) && n2 != 16 && n2 != 27) {
                this.armed = true;
                keyEvent.consume();
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (this.armed) {
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                this.findAction.actionPerformed(new ActionEvent(keyEvent.getSource(), 1001, null));
                this.findAction.searchField.setText(String.valueOf(keyStroke.getKeyChar()));
                keyEvent.consume();
                this.armed = false;
            }
        }
    }
}

