/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.ribbon.api.svg;

import commvault.cte.component.ribbon.api.svg.TranscoderListener;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.StrokeShapePainter;

abstract class SvgBaseTranscoder {
    protected TranscoderListener listener;
    protected PrintWriter externalPrintWriter;
    protected PrintWriter printWriter;
    protected String javaClassName;
    protected String javaPackageName;
    protected boolean javaToImplementResizableIconInterface;
    protected static final String TOKEN_PACKAGE = "TOKEN_PACKAGE";
    protected static final String TOKEN_CLASSNAME = "TOKEN_CLASSNAME";
    protected static final String TOKEN_PAINTING_CODE = "TOKEN_PAINTING_CODE";
    protected static final String TOKEN_ORIG_X = "TOKEN_ORIG_X";
    protected static final String TOKEN_ORIG_Y = "TOKEN_ORIG_Y";
    protected static final String TOKEN_ORIG_WIDTH = "TOKEN_ORIG_WIDTH";
    protected static final String TOKEN_ORIG_HEIGHT = "TOKEN_ORIG_HEIGHT";

    public SvgBaseTranscoder(String string) {
        this.javaClassName = string;
        this.javaToImplementResizableIconInterface = false;
    }

    public void setJavaToImplementResizableIconInterface(boolean bl) {
        this.javaToImplementResizableIconInterface = bl;
    }

    public void setJavaPackageName(String string) {
        this.javaPackageName = string;
    }

    public void setListener(TranscoderListener transcoderListener) {
        this.listener = transcoderListener;
        this.setPrintWriter(new PrintWriter(this.listener.getWriter()));
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.externalPrintWriter = printWriter;
    }

    public void transcode(GraphicsNode graphicsNode) {
        String string;
        String string2 = this.javaToImplementResizableIconInterface ? "SvgTranscoderTemplateResizable.templ" : "SvgTranscoderTemplatePlain.templ";
        InputStream inputStream = SvgBaseTranscoder.class.getResourceAsStream(string2);
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string + "\n");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        string = stringBuffer.toString();
        string = this.javaPackageName != null ? string.replaceAll(TOKEN_PACKAGE, "package " + this.javaPackageName + ";") : string.replaceAll(TOKEN_PACKAGE, "");
        string = string.replaceAll(TOKEN_CLASSNAME, this.javaClassName);
        string = string.replaceAll(TOKEN_CLASSNAME, this.javaClassName);
        string = string.replaceAll(TOKEN_CLASSNAME, this.javaClassName);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.printWriter = new PrintWriter(byteArrayOutputStream);
        this.transcodeGraphicsNode(graphicsNode, "");
        this.printWriter.close();
        String string3 = new String(byteArrayOutputStream.toByteArray());
        string = string.replaceAll(TOKEN_PAINTING_CODE, string3);
        Rectangle2D rectangle2D = graphicsNode.getBounds();
        string = string.replaceAll(TOKEN_ORIG_X, "" + (int)Math.ceil(rectangle2D.getX()));
        string = string.replaceAll(TOKEN_ORIG_Y, "" + (int)Math.ceil(rectangle2D.getY()));
        string = string.replaceAll(TOKEN_ORIG_WIDTH, "" + (int)Math.ceil(rectangle2D.getWidth()));
        string = string.replaceAll(TOKEN_ORIG_HEIGHT, "" + (int)Math.ceil(rectangle2D.getHeight()));
        this.externalPrintWriter.println(string);
        this.externalPrintWriter.close();
        if (this.listener != null) {
            this.listener.finished();
        }
    }

    private void transcodePathIterator(PathIterator pathIterator) {
        float[] fArray = new float[6];
        this.printWriter.println("shape = new GeneralPath();");
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 3: {
                    this.printWriter.println("((GeneralPath)shape).curveTo(" + fArray[0] + ", " + fArray[1] + ", " + fArray[2] + ", " + fArray[3] + ", " + fArray[4] + ", " + fArray[5] + ");");
                    break;
                }
                case 2: {
                    this.printWriter.println("((GeneralPath)shape).quadTo(" + fArray[0] + ", " + fArray[1] + ", " + fArray[2] + ", " + fArray[3] + ");");
                    break;
                }
                case 0: {
                    this.printWriter.println("((GeneralPath)shape).moveTo(" + fArray[0] + ", " + fArray[1] + ");");
                    break;
                }
                case 1: {
                    this.printWriter.println("((GeneralPath)shape).lineTo(" + fArray[0] + ", " + fArray[1] + ");");
                    break;
                }
                case 4: {
                    this.printWriter.println("((GeneralPath)shape).closePath();");
                }
            }
            pathIterator.next();
        }
    }

    private void transcodeShape(Shape shape) throws UnsupportedOperationException {
        if (shape instanceof ExtendedGeneralPath) {
            this.transcodePathIterator(((ExtendedGeneralPath)shape).getPathIterator(null));
            return;
        }
        if (shape instanceof GeneralPath) {
            this.transcodePathIterator(((GeneralPath)shape).getPathIterator(null));
            return;
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.printWriter.println("shape = new Rectangle2D.Double(" + rectangle2D.getX() + ", " + rectangle2D.getY() + ", " + rectangle2D.getWidth() + ", " + rectangle2D.getHeight() + ");");
            return;
        }
        if (shape instanceof RoundRectangle2D) {
            RoundRectangle2D roundRectangle2D = (RoundRectangle2D)shape;
            this.printWriter.println("shape = new RoundRectangle2D.Double(" + roundRectangle2D.getX() + ", " + roundRectangle2D.getY() + ", " + roundRectangle2D.getWidth() + ", " + roundRectangle2D.getHeight() + ", " + roundRectangle2D.getArcWidth() + ", " + roundRectangle2D.getArcHeight() + ");");
            return;
        }
        if (shape instanceof Ellipse2D) {
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            this.printWriter.println("shape = new Ellipse2D.Double(" + ellipse2D.getX() + ", " + ellipse2D.getY() + ", " + ellipse2D.getWidth() + ", " + ellipse2D.getHeight() + ");");
            return;
        }
        if (shape instanceof Line2D.Float) {
            Line2D.Float float_ = (Line2D.Float)shape;
            this.printWriter.format("shape = new Line2D.Float(%ff,%ff,%ff,%ff);\n", Float.valueOf(float_.x1), Float.valueOf(float_.y1), Float.valueOf(float_.x2), Float.valueOf(float_.y2));
            return;
        }
        throw new UnsupportedOperationException(shape.getClass().getCanonicalName());
    }

    private void transcodeLinearGradientPaint(LinearGradientPaint linearGradientPaint) throws IllegalArgumentException {
        Point2D point2D = linearGradientPaint.getStartPoint();
        Point2D point2D2 = linearGradientPaint.getEndPoint();
        float[] fArray = linearGradientPaint.getFractions();
        Color[] colorArray = linearGradientPaint.getColors();
        MultipleGradientPaint.CycleMethodEnum cycleMethodEnum = linearGradientPaint.getCycleMethod();
        MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum = linearGradientPaint.getColorSpace();
        AffineTransform affineTransform = linearGradientPaint.getTransform();
        float f = -1.0f;
        for (float f2 : fArray) {
            if (f2 < 0.0f || f2 > 1.0f) {
                throw new IllegalArgumentException("Fraction values must be in the range 0 to 1: " + f2);
            }
            if (f2 < f) {
                throw new IllegalArgumentException("Keyframe fractions must be non-decreasing: " + f2);
            }
            f = f2;
        }
        Object object = new StringBuffer();
        if (fArray == null) {
            ((StringBuffer)object).append("null");
        } else {
            String string = "";
            ((StringBuffer)object).append("new float[] {");
            f = -1.0f;
            for (float f3 : fArray) {
                ((StringBuffer)object).append(string);
                if (f3 == f) {
                    f3 += 1.0E-9f;
                }
                ((StringBuffer)object).append(f3 + "f");
                string = ",";
                f = f3;
            }
            ((StringBuffer)object).append("}");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (fArray == null) {
            stringBuffer.append("null");
        } else {
            String string = "";
            stringBuffer.append("new Color[] {");
            for (Color color : colorArray) {
                stringBuffer.append(string);
                stringBuffer.append("new Color(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + color.getAlpha() + ")");
                string = ",";
            }
            stringBuffer.append("}");
        }
        String string = null;
        if (cycleMethodEnum == MultipleGradientPaint.NO_CYCLE) {
            string = "MultipleGradientPaint.CycleMethod.NO_CYCLE";
        }
        if (cycleMethodEnum == MultipleGradientPaint.REFLECT) {
            string = "MultipleGradientPaint.CycleMethod.REFLECT";
        }
        if (cycleMethodEnum == MultipleGradientPaint.REPEAT) {
            string = "MultipleGradientPaint.CycleMethod.REPEAT";
        }
        String string2 = null;
        if (colorSpaceEnum == MultipleGradientPaint.SRGB) {
            string2 = "MultipleGradientPaint.ColorSpaceType.SRGB";
        }
        if (colorSpaceEnum == MultipleGradientPaint.LINEAR_RGB) {
            string2 = "MultipleGradientPaint.ColorSpaceType.LINEAR_RGB";
        }
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        this.printWriter.println("paint = new LinearGradientPaint(new Point2D.Double(" + point2D.getX() + ", " + point2D.getY() + "), new Point2D.Double(" + point2D2.getX() + ", " + point2D2.getY() + "), " + ((StringBuffer)object).toString() + ", " + stringBuffer.toString() + ", " + string + ", " + string2 + ", new AffineTransform(" + dArray[0] + "f, " + dArray[1] + "f, " + dArray[2] + "f, " + dArray[3] + "f, " + dArray[4] + "f, " + dArray[5] + "f));");
    }

    private void transcodeRadialGradientPaint(RadialGradientPaint radialGradientPaint) throws IllegalArgumentException {
        Point2D point2D = radialGradientPaint.getCenterPoint();
        float f = radialGradientPaint.getRadius();
        Point2D point2D2 = radialGradientPaint.getFocusPoint();
        float[] fArray = radialGradientPaint.getFractions();
        Color[] colorArray = radialGradientPaint.getColors();
        MultipleGradientPaint.CycleMethodEnum cycleMethodEnum = radialGradientPaint.getCycleMethod();
        MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum = radialGradientPaint.getColorSpace();
        AffineTransform affineTransform = radialGradientPaint.getTransform();
        float f2 = -1.0f;
        for (float f3 : fArray) {
            if (f3 < 0.0f || f3 > 1.0f) {
                throw new IllegalArgumentException("Fraction values must be in the range 0 to 1: " + f3);
            }
            if (f3 < f2) {
                throw new IllegalArgumentException("Keyframe fractions must be non-decreasing: " + f3);
            }
            f2 = f3;
        }
        Object object = new StringBuffer();
        if (fArray == null) {
            ((StringBuffer)object).append("null");
        } else {
            String string = "";
            ((StringBuffer)object).append("new float[] {");
            f2 = -1.0f;
            for (float f4 : fArray) {
                ((StringBuffer)object).append(string);
                if (f4 == f2) {
                    f4 += 1.0E-9f;
                }
                ((StringBuffer)object).append(f4 + "f");
                string = ",";
                f2 = f4;
            }
            ((StringBuffer)object).append("}");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (fArray == null) {
            stringBuffer.append("null");
        } else {
            String string = "";
            stringBuffer.append("new Color[] {");
            for (Color color : colorArray) {
                stringBuffer.append(string);
                stringBuffer.append("new Color(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + color.getAlpha() + ")");
                string = ",";
            }
            stringBuffer.append("}");
        }
        String string = null;
        if (cycleMethodEnum == MultipleGradientPaint.NO_CYCLE) {
            string = "MultipleGradientPaint.CycleMethod.NO_CYCLE";
        }
        if (cycleMethodEnum == MultipleGradientPaint.REFLECT) {
            string = "MultipleGradientPaint.CycleMethod.REFLECT";
        }
        if (cycleMethodEnum == MultipleGradientPaint.REPEAT) {
            string = "MultipleGradientPaint.CycleMethod.REPEAT";
        }
        String string2 = null;
        if (colorSpaceEnum == MultipleGradientPaint.SRGB) {
            string2 = "MultipleGradientPaint.ColorSpaceType.SRGB";
        }
        if (colorSpaceEnum == MultipleGradientPaint.LINEAR_RGB) {
            string2 = "MultipleGradientPaint.ColorSpaceType.LINEAR_RGB";
        }
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        this.printWriter.println("paint = new RadialGradientPaint(new Point2D.Double(" + point2D.getX() + ", " + point2D.getY() + "), " + f + "f, new Point2D.Double(" + point2D2.getX() + ", " + point2D2.getY() + "), " + ((StringBuffer)object).toString() + ", " + stringBuffer.toString() + ", " + string + ", " + string2 + ", new AffineTransform(" + dArray[0] + "f, " + dArray[1] + "f, " + dArray[2] + "f, " + dArray[3] + "f, " + dArray[4] + "f, " + dArray[5] + "f));");
    }

    private void transcodePaint(Paint paint) throws UnsupportedOperationException {
        if (paint instanceof RadialGradientPaint) {
            this.transcodeRadialGradientPaint((RadialGradientPaint)paint);
            return;
        }
        if (paint instanceof LinearGradientPaint) {
            this.transcodeLinearGradientPaint((LinearGradientPaint)paint);
            return;
        }
        if (paint instanceof Color) {
            Color color = (Color)paint;
            this.printWriter.println("paint = new Color(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + color.getAlpha() + ");");
            return;
        }
        if (paint == null) {
            this.printWriter.println("No paint");
            return;
        }
        throw new UnsupportedOperationException(paint.getClass().getCanonicalName());
    }

    private void transcodeShapePainter(ShapePainter shapePainter) throws UnsupportedOperationException {
        if (shapePainter == null) {
            return;
        }
        if (shapePainter instanceof CompositeShapePainter) {
            this.transcodeCompositeShapePainter((CompositeShapePainter)shapePainter);
            return;
        }
        if (shapePainter instanceof FillShapePainter) {
            this.transcodeFillShapePainter((FillShapePainter)shapePainter);
            return;
        }
        if (shapePainter instanceof StrokeShapePainter) {
            this.transcodeStrokeShapePainter((StrokeShapePainter)shapePainter);
            return;
        }
        throw new UnsupportedOperationException(shapePainter.getClass().getCanonicalName());
    }

    private void transcodeCompositeShapePainter(CompositeShapePainter compositeShapePainter) {
        for (int i = 0; i < compositeShapePainter.getShapePainterCount(); ++i) {
            this.transcodeShapePainter(compositeShapePainter.getShapePainter(i));
        }
    }

    private void transcodeFillShapePainter(FillShapePainter fillShapePainter) {
        Object object;
        try {
            object = FillShapePainter.class.getDeclaredField("paint");
            ((Field)object).setAccessible(true);
            Paint paint = (Paint)((Field)object).get(fillShapePainter);
            if (paint == null) {
                return;
            }
            this.transcodePaint(paint);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = fillShapePainter.getShape();
        this.transcodeShape((Shape)object);
        this.printWriter.println("g.setPaint(paint);");
        this.printWriter.println("g.fill(shape);");
    }

    private void transcodeStrokeShapePainter(StrokeShapePainter strokeShapePainter) {
        Object object;
        Field field;
        Shape shape = strokeShapePainter.getShape();
        try {
            field = StrokeShapePainter.class.getDeclaredField("paint");
            field.setAccessible(true);
            object = (Paint)field.get(strokeShapePainter);
            if (object == null) {
                return;
            }
            this.transcodePaint((Paint)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            field = StrokeShapePainter.class.getDeclaredField("stroke");
            field.setAccessible(true);
            object = (Stroke)field.get(strokeShapePainter);
            BasicStroke basicStroke = (BasicStroke)object;
            float f = basicStroke.getLineWidth();
            int n = basicStroke.getEndCap();
            int n2 = basicStroke.getLineJoin();
            float f2 = basicStroke.getMiterLimit();
            float[] fArray = basicStroke.getDashArray();
            float f3 = basicStroke.getDashPhase();
            StringBuffer stringBuffer = new StringBuffer();
            if (fArray == null) {
                stringBuffer.append("null");
            } else {
                String string = "";
                stringBuffer.append("new float[] {");
                for (float f4 : fArray) {
                    stringBuffer.append(string);
                    stringBuffer.append(f4 + "f");
                    string = ",";
                }
                stringBuffer.append("}");
            }
            this.printWriter.println("stroke = new BasicStroke(" + f + "f," + n + "," + n2 + "," + f2 + "f," + stringBuffer + "," + f3 + "f);");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.transcodeShape(shape);
        this.printWriter.println("g.setPaint(paint);");
        this.printWriter.println("g.setStroke(stroke);");
        this.printWriter.println("g.draw(shape);");
    }

    private void transcodeShapeNode(ShapeNode shapeNode, String string) {
        this.printWriter.println("// " + string);
        ShapePainter shapePainter = shapeNode.getShapePainter();
        this.transcodeShapePainter(shapePainter);
    }

    private void transcodeCompositeGraphicsNode(CompositeGraphicsNode compositeGraphicsNode, String string) {
        this.printWriter.println("// " + string);
        int n = 0;
        for (Object e : compositeGraphicsNode.getChildren()) {
            this.transcodeGraphicsNode((GraphicsNode)e, string + "_" + n);
            ++n;
        }
    }

    private void transcodeGraphicsNode(GraphicsNode graphicsNode, String string) throws UnsupportedOperationException {
        AlphaComposite alphaComposite = (AlphaComposite)graphicsNode.getComposite();
        if (alphaComposite != null) {
            int n = alphaComposite.getRule();
            float f = alphaComposite.getAlpha();
            this.printWriter.println("g.setComposite(AlphaComposite.getInstance(" + n + ", " + f + "f * origAlpha));");
        }
        AffineTransform affineTransform = graphicsNode.getTransform();
        this.printWriter.println("AffineTransform defaultTransform_" + string + " = g.getTransform();");
        if (affineTransform != null) {
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            this.printWriter.println("g.transform(new AffineTransform(" + dArray[0] + "f, " + dArray[1] + "f, " + dArray[2] + "f, " + dArray[3] + "f, " + dArray[4] + "f, " + dArray[5] + "f));");
        }
        try {
            if (graphicsNode instanceof ShapeNode) {
                this.transcodeShapeNode((ShapeNode)graphicsNode, string);
                return;
            }
            if (graphicsNode instanceof CompositeGraphicsNode) {
                this.transcodeCompositeGraphicsNode((CompositeGraphicsNode)graphicsNode, string);
                return;
            }
            throw new UnsupportedOperationException(graphicsNode.getClass().getCanonicalName());
        }
        finally {
            this.printWriter.println("g.setTransform(defaultTransform_" + string + ");");
        }
    }
}

